/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.vercompare;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.ISupportInitialize;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.exception.SerializationException;
import kd.bos.dataentity.metadata.DataEntityTypeFlag;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IComplexProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcAction;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.ISetJsonValueAction;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.vercompare.DcTreeNode;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.converters.DateConverter;

class DcTreeSerializerReadImplement {
    private static final Log logger = LogFactory.getLog(DcTreeSerializerReadImplement.class);
    private static final String BOS_METADATA = "bos-metadata";
    private static final String STRING = "??????";
    private static final String ZH_CN = "zh-CN";
    private DcBinder binder;
    private boolean localeValueFull;
    private boolean collIgnorePKValue;
    private boolean onlyLocaleValue;
    private List<?> lastList;
    private ICollectionProperty lastColProperty;
    private Object lastColEntity;
    private Stack<ISupportInitialize> supportInitializeObjects;
    private HashMap<Class<?>, ISetJsonValueAction> setValueActionsCache;
    private RefObject<Object> tempRef_findItem = new RefObject();

    public DcTreeSerializerReadImplement(DcBinder binder, boolean localeValueFull) {
        if (binder == null) {
            throw new IllegalArgumentException("binder");
        }
        this.binder = binder;
        this.localeValueFull = localeValueFull;
        this.supportInitializeObjects = new Stack();
    }

    public DcTreeSerializerReadImplement(DcBinder binder, boolean collIgnorePKValue, boolean localeValueFull) {
        this(binder, localeValueFull);
        this.setValueActionsCache = new HashMap(10);
        this.collIgnorePKValue = collIgnorePKValue;
    }

    public boolean isOnlyLocaleValue() {
        return this.onlyLocaleValue;
    }

    public void setOnlyLocaleValue(boolean onlyLocaleValue) {
        this.onlyLocaleValue = onlyLocaleValue;
    }

    public Object diffMerge(DcTreeNode dcTreeNode, IDataEntityType dt, Object entity) {
        String currentElementName = dcTreeNode.getName();
        if (!dcTreeNode.isComplexNode()) {
            return entity;
        }
        if (entity == null) {
            if (currentElementName != null) {
                dt = this.bindToType(dcTreeNode, currentElementName, dt);
            }
            if (dt.getFlag() != DataEntityTypeFlag.Primitive) {
                entity = this.binder.createInstance(dt);
            }
        } else {
            dt = this.getDataEntityType(entity);
        }
        this.push(entity);
        if (dt.getFlag() != DataEntityTypeFlag.Primitive && dcTreeNode.isComplexNode()) {
            this.readPropertys(dcTreeNode, dt, entity);
        }
        return entity;
    }

    private void readPropertys(DcTreeNode entityNode, IDataEntityType dt, Object entity) {
        IDataEntityProperty property = null;
        if (!entityNode.isChildNodesEmpty()) {
            for (DcTreeNode propNode : entityNode.getChildNodes()) {
                property = (IDataEntityProperty)dt.getProperties().get((Object)propNode.getName());
                if (property == null || this.readSimpleProperty((ISimpleProperty)(property instanceof ISimpleProperty ? property : null), propNode, entity) || this.readComplexProperty((IComplexProperty)(property instanceof IComplexProperty ? property : null), propNode, entity) || this.readCollectionProperty((ICollectionProperty)(property instanceof ICollectionProperty ? property : null), propNode, entity)) continue;
                SerializationException.SerializationExceptionData tempVar2 = new SerializationException.SerializationExceptionData();
                tempVar2.setCanIgnore(true);
                this.throwXmlException(STRING, String.format(ResManager.loadKDString((String)"\u8282\u70b9\u4e2d\u51fa\u73b0\u7684\u5c5e\u6027%s\uff0c\u5fc5\u987b\u662f\u7b80\u5355\u5c5e\u6027\u3001\u590d\u6742\u6216\u96c6\u5408\u5c5e\u6027\u7684\u4e00\u79cd\u3002", (String)"DcTreeSerializerReadImplement_9", (String)BOS_METADATA, (Object[])new Object[0]), property.getName()), tempVar2, null);
            }
        }
        if (entityNode.getCustProps() != null) {
            for (Map.Entry<String, Object> entry : entityNode.getCustProps().entrySet()) {
                this.binder.readCustomJsonProperty(entry, entity);
            }
        }
    }

    private void push(Object entity) {
        ISupportInitialize obj = (ISupportInitialize)(entity instanceof ISupportInitialize ? entity : null);
        if (obj != null) {
            obj.beginInit();
            this.supportInitializeObjects.push(obj);
        }
    }

    private boolean readSimpleProperty(ISimpleProperty property, DcTreeNode propNode, Object entity) {
        if (property == null || !propNode.isSimpleNode()) {
            return false;
        }
        String action = propNode.getCurrValue().getAction();
        if (StringUtils.isBlank((CharSequence)action)) {
            action = "setvalue";
        }
        this.doSimplePropertyAction(property, propNode, action, entity);
        return true;
    }

    private void doSimplePropertyAction(ISimpleProperty property, DcTreeNode propNode, String action, Object entity) {
        if ("setvalue".equals(action)) {
            try {
                ISetJsonValueAction setValueAction = this.getSetValueAction(property.getPropertyType());
                setValueAction.apply(property, (Object)propNode, entity);
            }
            catch (RuntimeException ex) {
                SerializationException.SerializationExceptionData tempVar = new SerializationException.SerializationExceptionData();
                this.throwXmlException(STRING, String.format(ResManager.loadKDString((String)"\u5728\u8d4b\u503c%1$s:%2$s\u7684\u503c'%3$s'\u65f6\u5931\u8d25\uff0c%4$s", (String)"DcTreeSerializerReadImplement_1", (String)BOS_METADATA, (Object[])new Object[0]), property.getName(), property.getPropertyType().getName(), propNode.getCurrValue(), ex.getMessage()), tempVar, ex);
            }
        } else if ("reset".equals(action)) {
            property.resetValue(entity);
        } else if ("setnull".equals(action)) {
            try {
                property.setValue(entity, null);
            }
            catch (RuntimeException ex) {
                SerializationException.SerializationExceptionData tempVar2 = new SerializationException.SerializationExceptionData();
                this.throwXmlException(STRING, String.format(ResManager.loadKDString((String)"\u5728\u8d4b\u503c%1$s:%2$s\u7684\u503c Null \u65f6\u5931\u8d25\uff0c%3$s", (String)"DcTreeSerializerReadImplement_2", (String)BOS_METADATA, (Object[])new Object[0]), property.getName(), property.getPropertyType().getName(), ex.getMessage()), tempVar2, ex);
            }
        } else {
            SerializationException.SerializationExceptionData tempVar3 = new SerializationException.SerializationExceptionData();
            this.throwXmlException(STRING, String.format(ResManager.loadKDString((String)"\u4e0d\u80fd\u8bc6\u522b\u7684\u5c5e\u6027\u64cd\u4f5c\u7b26%s\u3002", (String)"DcTreeSerializerReadImplement_3", (String)BOS_METADATA, (Object[])new Object[0]), action), tempVar3, null);
        }
    }

    private boolean readComplexProperty(IComplexProperty property, DcTreeNode propNode, Object entity) {
        if (property == null || !propNode.isComplexNode()) {
            return false;
        }
        String action = propNode.getAction();
        if (StringUtils.isBlank((CharSequence)action)) {
            action = "edit";
        }
        this.doComplexPropertyAction(property, propNode, action, entity);
        return true;
    }

    private void doComplexPropertyAction(IComplexProperty property, DcTreeNode propNode, String action, Object entity) {
        if ("edit".equals(action)) {
            if (propNode.isChildNodesEmpty()) {
                if (!property.getReadOnly()) {
                    property.setValue(entity, null);
                }
            } else {
                Object currentValue = property.getValue(entity);
                Object newValue = this.diffMerge(propNode.getChildNodes().get(0), property.getComplexType(), currentValue);
                if (!property.getReadOnly() && !ObjectUtils.nullSafeEquals((Object)currentValue, (Object)newValue)) {
                    property.setValue(entity, newValue);
                }
            }
        } else if ("setnull".equals(action)) {
            property.setValue(entity, null);
        } else {
            SerializationException.SerializationExceptionData tempVar = new SerializationException.SerializationExceptionData();
            this.throwXmlException(STRING, String.format(ResManager.loadKDString((String)"\u4e0d\u80fd\u8bc6\u522b\u7684\u5c5e\u6027\u64cd\u4f5c\u7b26%s\u3002", (String)"DcTreeSerializerReadImplement_3", (String)BOS_METADATA, (Object[])new Object[0]), action), tempVar, null);
        }
    }

    private boolean readCollectionProperty(ICollectionProperty property, DcTreeNode propNode, Object entity) {
        if (property == null || !propNode.isCollectionNode()) {
            return false;
        }
        String action = propNode.getAction();
        if (StringUtils.isBlank((CharSequence)action)) {
            action = "add";
        }
        if (DcAction.PropertyAction_SetNull.getActionName().equalsIgnoreCase(action)) {
            property.setValue(entity, null);
            return true;
        }
        if (DcAction.ListAction_Clear.getActionName().equals(action)) {
            Object tempVar = property.getValue(entity);
            List lst = (List)(tempVar instanceof List ? tempVar : null);
            if (lst != null) {
                lst.clear();
            }
            return true;
        }
        if (!propNode.isChildNodesEmpty()) {
            for (DcTreeNode itemNode : propNode.getChildNodes()) {
                action = itemNode.getAction();
                if (StringUtils.isBlank((CharSequence)action)) {
                    action = "add";
                }
                this.doCollectionPropertyAction(property, itemNode, action, entity);
            }
        }
        return true;
    }

    private void doCollectionPropertyAction(ICollectionProperty property, DcTreeNode itemNode, String action, Object entity) {
        if ("add".equals(action)) {
            Object newItem = this.diffMerge(itemNode, property.getItemType(), null);
            List<?> list = this.safeGetList(property, itemNode.getName(), entity);
            if (list != null) {
                if (this.collIgnorePKValue) {
                    list.add(newItem);
                } else {
                    int index = this.findItemIndex(property, itemNode, entity, newItem);
                    if (index < 0) {
                        list.add(newItem);
                    }
                }
            }
        } else if ("edit".equals(action)) {
            Object findItem = null;
            int index = this.findItemByOid(property, itemNode, entity, this.tempRef_findItem);
            findItem = this.tempRef_findItem.argvalue;
            if (index >= 0) {
                this.diffMerge(itemNode, property.getItemType(), findItem);
            } else if (index == -1) {
                SerializationException.SerializationExceptionData tempVar = new SerializationException.SerializationExceptionData();
                tempVar.setCanIgnore(true);
                this.throwXmlException("DoCollectionPropertyAction.378", ResManager.loadKDString((String)"\u8bd5\u56fe\u7f16\u8f91\u7684\u8282\u70b9\u5728\u73b0\u6709\u96c6\u5408\u4e2d\u6ca1\u6709\u627e\u5230\u3002", (String)"DcTreeSerializerReadImplement_7", (String)BOS_METADATA, (Object[])new Object[0]), tempVar, null);
            }
        } else if ("remove".equals(action)) {
            if (!this.isOnlyLocaleValue()) {
                int index = this.findItemByOid(property, itemNode, entity, this.tempRef_findItem);
                if (index >= 0) {
                    List<?> list = this.safeGetList(property, itemNode.getName(), entity);
                    if (list != null) {
                        list.remove(index);
                    }
                } else if (index == -1) {
                    SerializationException.SerializationExceptionData tempVar2 = new SerializationException.SerializationExceptionData();
                    tempVar2.setCanIgnore(true);
                    this.throwXmlException(STRING, ResManager.loadKDString((String)"\u8bd5\u56fe\u5220\u9664\u7684\u8282\u70b9\u5728\u73b0\u6709\u96c6\u5408\u4e2d\u6ca1\u6709\u627e\u5230\u3002", (String)"DcTreeSerializerReadImplement_8", (String)BOS_METADATA, (Object[])new Object[0]), tempVar2, null);
                }
            }
        } else {
            SerializationException.SerializationExceptionData tempVar3 = new SerializationException.SerializationExceptionData();
            tempVar3.setCanIgnore(true);
            this.throwXmlException(STRING, String.format(ResManager.loadKDString((String)"\u4e0d\u80fd\u8bc6\u522b\u7684\u96c6\u5408\u64cd\u4f5c\u7b26%s\u3002", (String)"DcTreeSerializerReadImplement_4", (String)BOS_METADATA, (Object[])new Object[0]), action), tempVar3, null);
        }
    }

    public void endInitialize() {
        while (this.supportInitializeObjects.size() > 0) {
            ISupportInitialize initObj = this.supportInitializeObjects.pop();
            initObj.endInit();
        }
    }

    private int findItemIndex(ICollectionProperty property, DcTreeNode itemNode, Object entity, Object item) {
        ISimpleProperty pk = this.binder.getDataEntityType(item).getPrimaryKey();
        if (pk == null) {
            return -1;
        }
        Object tempOid = pk.getValue(item);
        String id = tempOid == null ? "" : tempOid.toString();
        int tempVar = this.findItemByOid(property, itemNode, entity, id, this.tempRef_findItem);
        return tempVar;
    }

    private int findItemByOid(ICollectionProperty property, DcTreeNode itemNode, Object entity, RefObject<Object> item) {
        String id = itemNode.getItemId();
        return this.findItemByOid(property, itemNode, entity, id, item);
    }

    private int findItemByOid(ICollectionProperty property, DcTreeNode itemNode, Object entity, String id, RefObject<Object> item) {
        if (StringUtils.isEmpty((CharSequence)id)) {
            SerializationException.SerializationExceptionData tempVar = new SerializationException.SerializationExceptionData();
            tempVar.setCanIgnore(true);
            this.throwXmlException(STRING, String.format(ResManager.loadKDString((String)"\u8bd5\u56fe\u5904\u7406\u8282\u70b9%s\u6ca1\u6709\u6307\u5b9aid\u3002", (String)"DcTreeSerializerReadImplement_5", (String)BOS_METADATA, (Object[])new Object[0]), itemNode.getName()), tempVar, null);
            item.argvalue = null;
            return -2;
        }
        ISimpleProperty pk = property.getItemType().getPrimaryKey();
        if (pk == null) {
            SerializationException.SerializationExceptionData tempVar2 = new SerializationException.SerializationExceptionData();
            tempVar2.setCanIgnore(false);
            this.throwXmlException(STRING, String.format(ResManager.loadKDString((String)"\u9700\u8981\u5904\u7406\u7684\u96c6\u5408%1$s\u5176\u5143\u7d20\u7c7b\u578b%2$s\u6ca1\u6709\u5b9a\u4e49\u4e3b\u952e\u3002", (String)"DcTreeSerializerReadImplement_6", (String)BOS_METADATA, (Object[])new Object[0]), property.getName(), property.getItemType().getName()), tempVar2, null);
            item.argvalue = null;
            return -2;
        }
        Object id2 = this.convertFromString(pk, entity, id);
        List<?> list = this.safeGetList(property, itemNode.getName(), entity);
        if (list == null) {
            item.argvalue = null;
            return -2;
        }
        for (int i = 0; i < list.size(); ++i) {
            Object tempOid;
            item.argvalue = list.get(i);
            if (item.argvalue == null || !(tempOid = (pk = this.binder.getDataEntityType(item.argvalue).getPrimaryKey()).getValue(item.argvalue)).equals(id2)) continue;
            return i;
        }
        item.argvalue = null;
        return -1;
    }

    private IDataEntityType bindToType(DcTreeNode dcTreeNode, String name, IDataEntityType canUseType) {
        IDataEntityType dt;
        HashMap<String, String> attributes = new HashMap<String, String>(0);
        if (dcTreeNode.getAttributes() != null) {
            attributes.putAll(dcTreeNode.getAttributes());
        }
        if ((dt = this.binder.bindToType(name, attributes)) == null && canUseType != null) {
            String canUseTypeName = this.binder.bindToName(canUseType);
            boolean isEquals = false;
            isEquals = this.binder.isIgnoreCase() ? name.equalsIgnoreCase(canUseTypeName) : name.equals(canUseTypeName);
            if (isEquals || canUseType instanceof DynamicObjectType) {
                dt = canUseType;
            }
        }
        if (dt == null) {
            throw new KDException(new ErrorCode("DcTreeSerializerReadImplement.bindToType", String.format(ResManager.loadKDString((String)"\u672a\u80fd\u627e\u5230%s\u5bf9\u5e94\u7684\u6570\u636e\u7c7b\u578b\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u7c7b\u578b\u7ed1\u5b9a\u5668\u662f\u5426\u6709\u8bef\u3002", (String)"DcTreeSerializerReadImplement_10", (String)BOS_METADATA, (Object[])new Object[0]), name)), new Object[0]);
        }
        return dt;
    }

    private IDataEntityType getDataEntityType(Object entity) {
        return this.binder.getDataEntityType(entity);
    }

    private void throwXmlException(String code, String message, SerializationException.SerializationExceptionData data, RuntimeException innerException) {
        this.binder.ThrowException(new SerializationException(code, message, data, innerException));
    }

    private ISetJsonValueAction getSetValueAction(Class<?> propertyType) {
        ISetJsonValueAction result = null;
        result = this.setValueActionsCache.get(propertyType);
        if (result == null) {
            result = this.createSetValueAction(propertyType);
            this.setValueActionsCache.put(propertyType, result);
        }
        return result;
    }

    private ISetJsonValueAction createSetValueAction(final Class<?> propertyType) {
        Object setValueFunc = null;
        setValueFunc = String.class.isAssignableFrom(propertyType) ? new ISetJsonValueAction(){

            public void apply(ISimpleProperty sp, Object propNode, Object obj) {
                String strXmlValue = ((DcTreeNode)propNode).getCurrValue().getValue();
                sp.setValue(obj, (Object)strXmlValue);
            }
        } : (LocaleString.class.isAssignableFrom(propertyType) && !this.localeValueFull ? new ISetJsonValueAction(){

            public void apply(ISimpleProperty sp, Object propNode, Object obj) {
                String strXmlValue = ((DcTreeNode)propNode).getCurrValue().getValue();
                LocaleString lv = (LocaleString)sp.getValue(obj);
                if (lv == null) {
                    lv = new LocaleString();
                    sp.setValue(obj, (Object)lv);
                }
                lv.setItem(DcTreeSerializerReadImplement.this.binder.getLCId(), (Object)strXmlValue);
            }
        } : (LocaleString.class.isAssignableFrom(propertyType) ? new ISetJsonValueAction(){

            public void apply(ISimpleProperty sp, Object propNode, Object obj) {
                String strXmlValue = ((DcTreeNode)propNode).getCurrValue().getValue();
                Map values = null;
                if (StringUtils.isNotBlank((CharSequence)strXmlValue)) {
                    values = (Map)SerializationUtils.fromJsonString((String)strXmlValue, Map.class);
                }
                if (values != null) {
                    LocaleString val = (LocaleString)sp.getValue(obj);
                    if (val == null) {
                        val = new LocaleString();
                        sp.setValue(obj, (Object)val);
                    }
                    for (Map.Entry o : values.entrySet()) {
                        val.setItem((String)o.getKey(), o.getValue());
                    }
                }
            }
        } : (List.class.isAssignableFrom(propertyType) ? new ISetJsonValueAction(){

            public void apply(ISimpleProperty property, Object propNode, Object entity) {
                String strXmlValue = ((DcTreeNode)propNode).getCurrValue().getValue();
                List values = null;
                if (StringUtils.isNotBlank((CharSequence)strXmlValue)) {
                    values = (List)SerializationUtils.fromJsonString((String)strXmlValue, List.class);
                    property.setValue(entity, (Object)values);
                }
            }
        } : (Map.class.isAssignableFrom(propertyType) ? new ISetJsonValueAction(){

            public void apply(ISimpleProperty property, Object propNode, Object entity) {
                String strXmlValue = ((DcTreeNode)propNode).getCurrValue().getValue();
                Map values = null;
                if (StringUtils.isNotBlank((CharSequence)strXmlValue)) {
                    values = (Map)SerializationUtils.fromJsonString((String)strXmlValue, Map.class);
                    property.setValue(entity, (Object)values);
                }
            }
        } : (Enum.class.isAssignableFrom(propertyType) ? new ISetJsonValueAction(){

            public void apply(ISimpleProperty property, Object propNode, Object obj) {
                String strXmlValue = ((DcTreeNode)propNode).getCurrValue().getValue();
                Object v = Enum.valueOf(propertyType, strXmlValue);
                property.setValue(obj, v);
            }
        } : new ISetJsonValueAction(){

            public void apply(ISimpleProperty property, Object propNode, Object obj) {
                String strXmlValue = ((DcTreeNode)propNode).getCurrValue().getValue();
                Object value = DcTreeSerializerReadImplement.this.convertFromString(property, obj, strXmlValue);
                property.setValue(obj, value);
            }
        })))));
        if ((setValueFunc = this.binder.bindJSONReadAction(propertyType, setValueFunc)) == null) {
            throw new IllegalArgumentException("BindReadDataAction");
        }
        return setValueFunc;
    }

    private Object convertFromString(ISimpleProperty property, Object dataEntity, String str) {
        if (property.getPropertyType() == String.class) {
            return str;
        }
        if (property.getPropertyType() == Boolean.TYPE) {
            return Boolean.parseBoolean(str);
        }
        if (property.getPropertyType() == Integer.TYPE) {
            return Integer.parseInt(str);
        }
        if (property.getPropertyType() == Date.class) {
            try {
                Long v = Long.valueOf(str);
                return new Date(v);
            }
            catch (Exception e) {
                DateConverter dateConverter = new DateConverter();
                dateConverter.setPatterns(new String[]{"yyyy-MM-dd", "yyyy-MM-dd HH:mm:ss"});
                ConvertUtils.register((Converter)dateConverter, Date.class);
            }
        }
        return ConvertUtils.convert((String)str, (Class)property.getPropertyType());
    }

    private List<?> safeGetList(ICollectionProperty property, String itemElementName, Object entity) {
        List list;
        if (this.lastColProperty == property && this.lastColEntity == entity) {
            return this.lastList;
        }
        Object temp = property.getValue(entity);
        if (temp == null) {
            if (property.getReadOnly()) {
                SerializationException.SerializationExceptionData tempVar = new SerializationException.SerializationExceptionData();
                tempVar.setCanIgnore(true);
                this.throwXmlException(STRING, String.format(ResManager.loadKDString((String)"\u96c6\u5408\u5c5e\u6027%s\u662f\u53ea\u8bfb\u4e14\u672a\u521d\u59cb\u5316\u503c\uff0c\u8bf7\u521d\u59cb\u5316\u7684\u503c\u6216\u63d0\u4f9bSet\u529f\u80fd\u3002", (String)"DcTreeSerializerReadImplement_11", (String)BOS_METADATA, (Object[])new Object[0]), property.getName()), tempVar, null);
            }
            try {
                temp = TypesContainer.createInstance((Class)property.getPropertyType());
                property.setValue(entity, temp);
            }
            catch (RuntimeException ex) {
                SerializationException.SerializationExceptionData tempVar2 = new SerializationException.SerializationExceptionData();
                tempVar2.setCanIgnore(true);
                this.throwXmlException(STRING, String.format(ResManager.loadKDString((String)"\u81ea\u52a8\u521b\u5efa\u96c6\u5408\u5c5e\u6027%1$s\u7684\u503c\u5931\u8d25\uff0c%2$s\u3002", (String)"DcTreeSerializerReadImplement_12", (String)BOS_METADATA, (Object[])new Object[0]), property.getName(), ex.getMessage()), tempVar2, ex);
            }
        }
        if ((list = (List)(temp instanceof List ? temp : null)) == null) {
            SerializationException.SerializationExceptionData tempVar3 = new SerializationException.SerializationExceptionData();
            tempVar3.setCanIgnore(true);
            this.throwXmlException(STRING, String.format(ResManager.loadKDString((String)"\u96c6\u5408\u5c5e\u6027%s\u5fc5\u987b\u652f\u6301IList\u63a5\u53e3\u3002", (String)"DcTreeSerializerReadImplement_13", (String)BOS_METADATA, (Object[])new Object[0]), property.getName()), tempVar3, null);
        }
        this.lastColProperty = property;
        this.lastColEntity = entity;
        this.lastList = list;
        return list;
    }
}

