/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.util;

import java.io.UnsupportedEncodingException;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.lang.HZPinyin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class PinYinUtil {
    private static final Log logger = LogFactory.getLog(PinYinUtil.class);

    public static String getFullSpellByName(String name) {
        String fullPinyin = "";
        try {
            fullPinyin = HZPinyin.getFullSpell((String)name, (String)"");
            fullPinyin = PinYinUtil.formatNameSpell(fullPinyin);
            if (fullPinyin.length() > 100) {
                fullPinyin = fullPinyin.substring(0, 100);
            }
        }
        catch (UnsupportedEncodingException var3) {
            logger.info("\u5168\u62fc\u5931\u8d25\uff1a" + var3.getMessage(), (Object)var3);
        }
        return fullPinyin;
    }

    public static String getFirstSpellByName(String name) {
        String firstSpell = "";
        try {
            firstSpell = HZPinyin.getFirstSpell((String)name);
            firstSpell = PinYinUtil.formatNameSpell(firstSpell);
            if (firstSpell.length() > 30) {
                firstSpell = firstSpell.substring(0, 30);
            }
        }
        catch (UnsupportedEncodingException var3) {
            logger.info("\u7b80\u62fc\u5931\u8d25\uff1a" + var3.getMessage(), (Object)var3);
        }
        return firstSpell;
    }

    public static String formatNameSpell(String fullPingyin) {
        if (StringUtils.isBlank((CharSequence)fullPingyin)) {
            return "";
        }
        fullPingyin = fullPingyin.replace("^", "");
        return fullPingyin.replaceAll("[^a-z^A-Z^0-9]", "");
    }
}

