/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMenuInfo;
import kd.bos.entity.CtLinkSetElement;
import kd.bos.entity.EntityItemTypes;
import kd.bos.entity.IEntityMetaDataProvider;
import kd.bos.entity.LinkSetElement;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.PermissionControlType;
import kd.bos.entity.RefEntityType;
import kd.bos.entity.RuntimeMetaType;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.operate.Operations;
import kd.bos.entity.property.org.OrgRelationConfig;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.runmode.RunModeService;
import kd.bos.org.utils.Utils;
import kd.bos.product.ICoreProductSettingService;
import kd.bos.service.ServiceFactory;
import kd.bos.service.metadata.MetadataService;
import kd.bos.service.metadata.RuntimeMetadataShareService;

public class EntityMetadataShareProvider
implements IEntityMetaDataProvider {
    private static final String BOS_SHAREMETADATA_PROVIDER = "bos-sharemetadata-provider";
    private static final String MASTER = "Master";
    private Log logger = LogFactory.getLog(this.getClass());
    private RuntimeMetadataShareService runtimeMetadataShareService;
    private MetadataService metadataService;

    public EntityMetadataShareProvider() {
        this((RuntimeMetadataShareService)ServiceFactory.getService(RuntimeMetadataShareService.class), (MetadataService)ServiceFactory.getService(MetadataService.class));
    }

    public EntityMetadataShareProvider(RuntimeMetadataShareService runtimeMetadataShareService, MetadataService metadataService) {
        this.runtimeMetadataShareService = runtimeMetadataShareService;
        this.metadataService = metadataService;
    }

    public List<String> getFeatureEnabledEntity(String entityNumber, String featureName) {
        String str = this.runtimeMetadataShareService.loadEntityRuntimeMeta(entityNumber, (int)RuntimeMetaType.Features.getValue(), featureName);
        if (StringUtils.isBlank((CharSequence)str)) {
            return new ArrayList<String>();
        }
        return SerializationUtils.fromJsonStringToList((String)str, String.class);
    }

    public MainEntityType getDataEntityType(String number) {
        String str = this.runtimeMetadataShareService.loadEntityRuntimeMeta(number, (int)RuntimeMetaType.Entity.getValue(), number);
        if (str == null || str.length() == 0) {
            throw new KDException(BosErrorCode.entityMetaDataNotExist, new Object[]{number});
        }
        MainEntityType dt = (MainEntityType)EntityItemTypes.fromJsonString((String)str);
        return dt;
    }

    public String getRuntimeMetadataVersion(String number) {
        return this.runtimeMetadataShareService.getRuntimeMetadataVersion(number);
    }

    public Map<String, String> batchLoadRuntmeMetadataVersion(Collection<String> numbers) {
        return this.runtimeMetadataShareService.batchLoadRuntimeMetadataVersion(numbers);
    }

    public RefEntityType getRefEntityType(String number) {
        String str = this.runtimeMetadataShareService.loadEntityRuntimeMeta(number, (int)RuntimeMetaType.Entity.getValue(), number);
        if (str == null || str.length() == 0) {
            throw new KDException(BosErrorCode.entityMetaDataNotExist, new Object[]{number});
        }
        Map jsonMap = (Map)SerializationUtils.fromJsonString((String)str, Map.class);
        jsonMap.put("_Type_", "RefEntityType");
        List refPropTypes = (List)jsonMap.get("RefPropTypes");
        if (refPropTypes != null) {
            for (Map refPropType : refPropTypes) {
                if (refPropType.containsKey(MASTER) && refPropType.get(MASTER) != null && ((Boolean)refPropType.get(MASTER)).booleanValue()) continue;
                refPropType.remove("Props");
            }
        }
        return (RefEntityType)EntityItemTypes.fromMap((Map)jsonMap);
    }

    public Map<String, RefEntityType> getRefEntityTypes(Collection<String> numbers) {
        HashMap<String, RefEntityType> resultMap = new HashMap<String, RefEntityType>(numbers.size());
        for (String number : numbers) {
            RefEntityType refEntityType = this.getRefEntityType(number);
            resultMap.put(number, refEntityType);
        }
        return resultMap;
    }

    public String getEntityNumberById(String entityId) {
        return this.runtimeMetadataShareService.getEntityNumberById(entityId);
    }

    public Map<String, Object> getDataEntityOperate(String entityNumber, String operKey) {
        String str = this.runtimeMetadataShareService.loadEntityRuntimeMeta(entityNumber, (int)RuntimeMetaType.Operate.getValue(), operKey);
        this.logger.debug(String.format("entityNumber:%s, operKey:%s, str:%s", entityNumber, operKey, str));
        if (StringUtils.isBlank((CharSequence)str)) {
            throw new RuntimeException(String.format(ResManager.loadKDString((String)"\u5b9e\u4f53%1$s\u4e0a\u6ca1\u6709\u6ca1\u6709\u7f16\u7801\u4e3a%2$s\u7684\u64cd\u4f5c ", (String)"EntityMetadataShareProvider_0", (String)BOS_SHAREMETADATA_PROVIDER, (Object[])new Object[0]), entityNumber, operKey));
        }
        return (Map)SerializationUtils.fromJsonString((String)str, Map.class);
    }

    public List<Map<String, Object>> getDataEntityOperate(String entityNumber) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(10);
        List listOperate = this.runtimeMetadataShareService.loadEntityAllOperationMeta(entityNumber);
        for (String operate : listOperate) {
            Map operateMap = (Map)SerializationUtils.fromJsonString((String)operate, Map.class);
            list.add(operateMap);
        }
        return list;
    }

    public Map<String, List<String>> getDataEntityOperationKeys(Collection<String> entityNumbers) {
        if (this.metadataService != null) {
            return this.metadataService.getDataEntityOperationKeys(entityNumbers);
        }
        return super.getDataEntityOperationKeys(entityNumbers);
    }

    public Map<String, List<Map<String, Object>>> getDataEntityNetCtrlOperate(String entityNumber) {
        List strlist = this.runtimeMetadataShareService.loadEntityNetCtrlOperationMeta(entityNumber);
        this.logger.debug(entityNumber);
        if (strlist == null || strlist.isEmpty()) {
            return null;
        }
        HashMap<String, List<Map<String, Object>>> netCtrl = new HashMap<String, List<Map<String, Object>>>();
        for (String str : strlist) {
            Map map = (Map)SerializationUtils.fromJsonString((String)str, Map.class);
            String groupId = (String)map.get("groupId");
            ArrayList<Map> list = (ArrayList<Map>)netCtrl.get(groupId);
            if (list == null) {
                list = new ArrayList<Map>();
                netCtrl.put(groupId, list);
            }
            list.add(map);
        }
        return netCtrl;
    }

    public Map<String, OrgRelationConfig> getDataEntityPrincipalRelation(String entityNumber) {
        HashMap<String, OrgRelationConfig> mapPrincipalRelation = null;
        String str = this.runtimeMetadataShareService.loadEntityRuntimeMeta(entityNumber, (int)RuntimeMetaType.PrincipalRelation.getValue(), entityNumber);
        if (StringUtils.isNotBlank((CharSequence)str)) {
            List lstRelation = SerializationUtils.fromJsonStringToList((String)str, OrgRelationConfig.class);
            mapPrincipalRelation = new HashMap<String, OrgRelationConfig>(16);
            for (OrgRelationConfig relation : lstRelation) {
                String key = relation.getTrustee().getNumber();
                mapPrincipalRelation.put(key, relation);
            }
        }
        return mapPrincipalRelation;
    }

    public DynamicObjectType getSubDataEntityType(String entityNumber, Collection<String> properties) {
        return this.getDataEntityType(entityNumber).getSubEntityType(properties);
    }

    public FilterCondition getBaseDataFieldFilterMeta(String entityNumber, String operKey) {
        String filter = this.runtimeMetadataShareService.loadEntityRuntimeMeta(entityNumber, (int)RuntimeMetaType.BaseDataFieldFilter.getValue(), operKey);
        if (!StringUtils.isBlank((CharSequence)filter)) {
            return (FilterCondition)SerializationUtils.fromJsonString((String)filter, FilterCondition.class);
        }
        return null;
    }

    public LinkSetElement getLinkSet(String entityNumber) {
        String str = this.runtimeMetadataShareService.loadEntityRuntimeMeta(entityNumber, (int)RuntimeMetaType.LinkSet.getValue(), entityNumber);
        if (!StringUtils.isBlank((CharSequence)str)) {
            return (LinkSetElement)SerializationUtils.fromJsonString((String)str, LinkSetElement.class);
        }
        return null;
    }

    public CtLinkSetElement getCtLinkSet(String entityNumber) {
        String str = this.runtimeMetadataShareService.loadEntityRuntimeMeta(entityNumber, (int)RuntimeMetaType.CtLinkSet.getValue(), entityNumber);
        if (!StringUtils.isBlank((CharSequence)str)) {
            return (CtLinkSetElement)SerializationUtils.fromJsonString((String)str, CtLinkSetElement.class);
        }
        return null;
    }

    public String getPluginScripts(String scriptName) {
        return this.runtimeMetadataShareService.loadFormPluginScriptMeta("", scriptName);
    }

    public TableDefine loadTableDefine(String entityNumber, String entityKey) {
        String str = this.runtimeMetadataShareService.loadTableDefine(entityNumber, entityKey);
        if (StringUtils.isBlank((CharSequence)str)) {
            return null;
        }
        return (TableDefine)SerializationUtils.fromJsonString((String)str, TableDefine.class);
    }

    public TableDefine loadTableDefine(Long tableId) {
        String str = this.runtimeMetadataShareService.loadTableDefine(tableId);
        if (StringUtils.isBlank((CharSequence)str)) {
            return null;
        }
        return (TableDefine)SerializationUtils.fromJsonString((String)str, TableDefine.class);
    }

    public Operations getDataEntityOperations(String entityNumber) {
        String str = this.runtimeMetadataShareService.loadEntityRuntimeMeta(entityNumber, (int)RuntimeMetaType.Operations.getValue(), entityNumber);
        if (StringUtils.isBlank((CharSequence)str)) {
            return new Operations();
        }
        return (Operations)SerializationUtils.fromJsonString((String)str, Operations.class);
    }

    public PermissionControlType getPermissionControlType(String entityNumber) {
        String str = this.runtimeMetadataShareService.loadEntityRuntimeMeta(entityNumber, (int)RuntimeMetaType.PermissionControlType.getValue(), "CtrlType");
        if (StringUtils.isBlank((CharSequence)str)) {
            return null;
        }
        return (PermissionControlType)SerializationUtils.fromJsonString((String)str, PermissionControlType.class);
    }

    public Set<String> getPermissionItems(String entityNumber) {
        return this.metadataService.loadPermissionItems(entityNumber);
    }

    public AppInfo getAppInfo(String number) {
        String infoStr = this.runtimeMetadataShareService.loadAppInfo(number);
        if (StringUtils.isBlank((CharSequence)infoStr)) {
            ErrorCode errorCode = new ErrorCode("bos.appMetaDataNotExist", ResManager.loadKDString((String)"\u5e94\u7528%s\u8fd0\u884c\u671f\u5143\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"EntityMetadataShareProvider_1", (String)BOS_SHAREMETADATA_PROVIDER, (Object[])new Object[0]));
            throw new KDException(errorCode, new Object[]{number});
        }
        AppInfo info = (AppInfo)SerializationUtils.fromJsonString((String)infoStr, AppInfo.class);
        if (StringUtils.isBlank((CharSequence)info.getNumber())) {
            info = null;
        }
        return info;
    }

    public List<AppMenuInfo> getAppMenusInfoByAppId(String number) {
        String infoStr = this.runtimeMetadataShareService.getAppMenusInfoByAppId(number);
        ArrayList<AppMenuInfo> menus = new ArrayList(10);
        if (StringUtils.isBlank((CharSequence)infoStr)) {
            this.logger.info("\u5e94\u7528\u3010" + number + "\u3011\u8fd0\u884c\u671f\u83dc\u5355\u5143\u6570\u636e\u4e0d\u5b58\u5728\u3002");
        } else {
            menus = SerializationUtils.fromJsonStringToList((String)infoStr, AppMenuInfo.class);
        }
        this.removeByBlacklist(number, menus);
        return menus;
    }

    private void removeByBlacklist(String appNumber, List<AppMenuInfo> menus) {
        try {
            AppMenuInfo menu;
            Iterator<AppMenuInfo> it;
            if (Utils.isListEmpty(menus)) {
                return;
            }
            RunModeService runModeService = (RunModeService)ServiceFactory.getService(RunModeService.class);
            int product = runModeService.getRunModeCode();
            List formBlacklist = runModeService.loadEntityBlacklistByAppNumber(product, appNumber);
            ICoreProductSettingService productService = (ICoreProductSettingService)ServiceFactory.getService(ICoreProductSettingService.class);
            List blackForms = productService.getFormBlackListByAppId(appNumber);
            List blackMenuIds = productService.getAppMenuBlackList(appNumber);
            if (Utils.isListNotEmpty((List)formBlacklist)) {
                it = menus.iterator();
                while (it.hasNext()) {
                    menu = it.next();
                    if (!formBlacklist.contains(menu.getFormId())) continue;
                    it.remove();
                }
            }
            if (Utils.isListNotEmpty((List)blackForms) || Utils.isListNotEmpty((List)blackMenuIds)) {
                it = menus.iterator();
                while (it.hasNext()) {
                    menu = it.next();
                    if (!formBlacklist.contains(menu.getFormId()) && !blackForms.contains(menu.getFormId()) && !blackMenuIds.contains(menu.getId())) continue;
                    it.remove();
                }
            }
        }
        catch (Exception e) {
            this.logger.error(String.format("\u6839\u636e\u8fd0\u884c\u6a21\u5f0f\u5e94\u7528{%s}\u8868\u5355\u9ed1\u540d\u5355\u53bb\u6389\u83dc\u5355\u51fa\u9519", appNumber), (Throwable)e);
        }
    }

    public AppMenuInfo getAppMenuInfo(String appNumber, String menuId) {
        List<AppMenuInfo> menus = this.getAppMenusInfoByAppId(appNumber);
        if (menus == null) {
            ErrorCode errorCode = new ErrorCode("bos.appMetaDataNotExist", ResManager.loadKDString((String)"\u5e94\u7528%1$s\u7684\u8fd0\u884c\u671f\u83dc\u5355%2$s\u4e0d\u5b58\u5728\u3002", (String)"EntityMetadataShareProvider_2", (String)BOS_SHAREMETADATA_PROVIDER, (Object[])new Object[0]));
            throw new KDException(errorCode, new Object[]{appNumber, menuId});
        }
        AppMenuInfo menu = null;
        for (AppMenuInfo menuInfo : menus) {
            if (!menuInfo.getId().equals(menuId)) continue;
            menu = menuInfo;
            break;
        }
        return menu;
    }

    public String getAppNumberById(String id) {
        return this.metadataService.getAppNumberById(id);
    }
}

