/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.dao;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.MetaBuildContext;
import kd.bos.metadata.RuntimeMeta;
import kd.bos.metadata.ShareMetaBuildContext;
import kd.bos.metadata.ShareMetaBuildContextHolder;
import kd.bos.metadata.dao.ExtMetadataNode;
import kd.bos.metadata.dao.FormmetaDaoPlugin;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataReader;
import kd.bos.metadata.dao.MetadataTree;
import kd.bos.metadata.dao.ShareMetaCacheUtils;
import kd.bos.metadata.dao.ShareMetadataBuilder;
import kd.bos.metadata.entity.DesignEntityMeta;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.RuntimeEntityMetaFork;
import kd.bos.metadata.form.DesignFormMeta;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.RuntimeFormMeta;
import kd.bos.metadata.form.RuntimeFormMetaFork;

public class ShareFormmetaDaoPlugin
extends FormmetaDaoPlugin {
    private static final String DELETE_FROM = "delete from ";
    private ShareMetaBuildContextHolder shareFormMetaBuildContextHolder;
    private ShareMetaBuildContextHolder shareEntityMetaBuildContextHolder;

    public void saveRuntimeMeta(AbstractMetadata[] metadatas) {
        this.saveRuntimeMeta(false, metadatas);
    }

    public void saveRuntimeMeta(boolean isDraft, AbstractMetadata[] metadatas) {
        MetaBuildContext context = new MetaBuildContext();
        if (StringUtils.isNotBlank((CharSequence)this.getAppGroup())) {
            context.setRebuildAppGroup(this.getAppGroup());
        }
        FormMetadata formMeta = this.getFormMetadata(metadatas);
        super.setFormMetaData(formMeta);
        if (formMeta == null) {
            return;
        }
        formMeta.setBuildContext(context);
        this.beforeSaveRuntimemeta(formMeta);
        String masterId = formMeta.getId();
        if (this.isExtendMeta(formMeta)) {
            masterId = formMeta.getMasterId();
        }
        this.shareFormMetaBuildContextHolder = this.buildRuntimeMetaList(masterId, formMeta.getId(), MetaCategory.Form);
        if (this.shareFormMetaBuildContextHolder.getMetaDataList().isEmpty()) {
            return;
        }
        HashMap mapEntity = new HashMap();
        this.shareEntityMetaBuildContextHolder = this.buildRuntimeMetaList(masterId, formMeta.getEntityId(), MetaCategory.Entity);
        this.shareEntityMetaBuildContextHolder.getMetaDataList().forEach(o -> mapEntity.put(this.shareEntityMetaBuildContextHolder.get((AbstractMetadata)o).getId(), o));
        for (AbstractMetadata r : this.shareFormMetaBuildContextHolder.getMetaDataList()) {
            FormMetadata runtimeMeta = (FormMetadata)r;
            String entityId = runtimeMeta.getEntityId();
            if (!StringUtils.isEmpty((CharSequence)entityId) && mapEntity.containsKey(entityId)) {
                EntityMetadata entityRuntimeMeta = (EntityMetadata)mapEntity.get(entityId);
                String oldKey = this.readOldMainEntityNumber(entityRuntimeMeta);
                if (StringUtils.isBlank((CharSequence)oldKey)) {
                    oldKey = entityRuntimeMeta.getKey();
                }
                entityRuntimeMeta.setOldKey(oldKey);
                runtimeMeta.bindEntityMetadata(entityRuntimeMeta);
                entityRuntimeMeta.setBuildContext(context);
            }
            super.buildAndSaveRuntimeMeta(isDraft, runtimeMeta, masterId, runtimeMeta.getEntityMetadata());
        }
    }

    private void deleteRuntimeMetaFork(IDataEntityType runtimeMetaType, String bizAppId, String id) {
        ArrayList sqlParams = new ArrayList();
        DBRoute dbRoute = new DBRoute(runtimeMetaType.getDBRouteKey());
        String readSql = "select fnumber, fkey, ftype from " + runtimeMetaType.getAlias() + " where fid = ? and FBIZAPPID = ? ";
        SqlParameter idParam = new SqlParameter(":FID", 12, (Object)id);
        SqlParameter isvParam = new SqlParameter(":FBIZAPPID", 12, (Object)bizAppId);
        ResultSetHandler action = rs -> {
            while (rs.next()) {
                String number = rs.getString(1);
                String key = rs.getString(2);
                int type = rs.getInt(3);
                SqlParameter[] params = new SqlParameter[]{new SqlParameter("FNUMBER", 12, (Object)number), new SqlParameter("FKEY", 12, (Object)key), new SqlParameter("FTYPE", 4, (Object)type), new SqlParameter("FBIZAPPID", 12, (Object)bizAppId)};
                sqlParams.add(params);
            }
            return true;
        };
        DB.query((DBRoute)dbRoute, (String)readSql, (Object[])new SqlParameter[]{idParam, isvParam}, (ResultSetHandler)action);
        if (!sqlParams.isEmpty()) {
            String deleteSql = DELETE_FROM + runtimeMetaType.getAlias() + " where fnumber = ? and fkey = ? and ftype = ? and FBIZAPPID = ?";
            DB.executeBatch((DBRoute)dbRoute, (String)deleteSql, sqlParams);
        }
    }

    private ShareMetaBuildContext getShareMetaBuildContext(AbstractMetadata metadata) {
        if (metadata instanceof FormMetadata) {
            return this.shareFormMetaBuildContextHolder.get(metadata);
        }
        return this.shareEntityMetaBuildContextHolder.get(metadata);
    }

    protected void saveRuntimeMetaToDB(AbstractMetadata metadata, Object[] runtimeMetas, Class<?> clazz) {
        if (this.getShareMetaBuildContext(metadata).isFork()) {
            this.saveRuntimeMetaForkToDB(metadata, runtimeMetas, clazz);
            return;
        }
        super.saveRuntimeMetaToDB(metadata, runtimeMetas, clazz);
    }

    private void saveRuntimeMetaForkToDB(AbstractMetadata metadata, Object[] runtimeMetas, Class<?> clazz) {
        Class clazz2 = clazz = clazz.equals(RuntimeFormMeta.class) ? RuntimeFormMetaFork.class : RuntimeEntityMetaFork.class;
        if (runtimeMetas.length > 0) {
            Object[] shareRuntimeMetas = new Object[runtimeMetas.length];
            for (int i = 0; i < runtimeMetas.length; ++i) {
                RuntimeMeta runtimeMeta = (RuntimeMeta)runtimeMetas[i];
                shareRuntimeMetas[i] = clazz.equals(RuntimeFormMetaFork.class) ? new RuntimeFormMetaFork().create(this.getShareMetaBuildContext(metadata).getExtAppId(), runtimeMeta) : new RuntimeEntityMetaFork().create(this.getShareMetaBuildContext(metadata).getExtAppId(), runtimeMeta);
            }
            runtimeMetas = shareRuntimeMetas;
        }
        IDataEntityType runtimeMetaType = this.getGrayDataEntityType(OrmUtils.getDataEntityType(clazz));
        this.deleteRuntimeMetaFork(runtimeMetaType, this.getShareMetaBuildContext(metadata).getExtAppId(), metadata.getId());
        BusinessDataWriter.save((IDataEntityType)runtimeMetaType, (Object[])runtimeMetas);
    }

    private boolean isKingdee(String isv) {
        return "kingdee".equals(isv) || StringUtils.isEmpty((CharSequence)isv);
    }

    protected ShareMetaBuildContextHolder buildRuntimeMetaList(String masterId, String currentMetaId, MetaCategory category) {
        ShareMetadataBuilder builder = category == MetaCategory.Form ? new FormShareMetadataBuilder() : new EntityShareMetadataBuilder();
        builder.setAppGroup(this.getAppGroup());
        return builder.buildRuntimeMetaList(masterId, currentMetaId);
    }

    private boolean isExtendMeta(FormMetadata formMeta) {
        return this.isExtendMeta(formMeta.getDevType());
    }

    private boolean isExtendMeta(String type) {
        return "2".equals(type);
    }

    private FormMetadata getFormMetadata(AbstractMetadata[] metadatas) {
        for (AbstractMetadata metadata : metadatas) {
            if (!(metadata instanceof FormMetadata)) continue;
            return (FormMetadata)metadata;
        }
        return null;
    }

    public List<ExtMetadataNode> loadExtendNode(IDataEntityType designerMetaType, MetadataTree tree, Set<String> withoutIds) {
        HashSet<String> inTreeIds = new HashSet<String>(tree.getNodeIds());
        String tableName = designerMetaType.getAlias();
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("SELECT FID, FMasterId, FParentId, FData, FENABLED, FVERSION,FBizAppId,FISV from ", new Object[0]).append(tableName, new Object[0]).append(" WHERE ", new Object[0]).appendIn("FMasterId", tree.getNodeIds().toArray()).append(" and FType = '2' order by FInheritPath", new Object[0]);
        ResultSetHandler action = rs -> {
            ArrayList<DesignFormMeta> list = new ArrayList<DesignFormMeta>(rs.getRow());
            while (rs.next()) {
                String id = rs.getString("FId");
                String masterId = rs.getString("FMasterId");
                String parentId = rs.getString("FParentID");
                String enabled = rs.getString("FENABLED");
                long version = rs.getLong("FVERSION");
                DesignFormMeta designFormMeta = new DesignFormMeta();
                designFormMeta.setId(id);
                designFormMeta.setMasterId(masterId);
                designFormMeta.setParentId(parentId);
                designFormMeta.setEnabled("1".equals(enabled));
                designFormMeta.setVersion(version);
                designFormMeta.setDataXml(rs.getString("FData"));
                designFormMeta.setBizappId(rs.getString("FBizAppId"));
                designFormMeta.setIsv(rs.getString("FISV"));
                list.add(designFormMeta);
            }
            return list;
        };
        List formMetaList = (List)DB.query((DBRoute)this.getDbRouteByDefault(designerMetaType), (SqlBuilder)sqlBuilder, (ResultSetHandler)action);
        HashSet<String> parentIds = new HashSet<String>();
        String bizAppId = ShareMetadataBuilder.getMetaBizAppId(tree.getRootNode().getId());
        for (int i = formMetaList.size() - 1; i >= 0; --i) {
            DesignFormMeta designFormMeta = (DesignFormMeta)formMetaList.get(i);
            if (parentIds.contains(designFormMeta.getId())) {
                parentIds.add(designFormMeta.getParentId());
                continue;
            }
            if (this.isKingdee(designFormMeta.getIsv())) continue;
            if (bizAppId != null) {
                if (bizAppId.equals(designFormMeta.getBizappId())) {
                    parentIds.add(designFormMeta.getParentId());
                    continue;
                }
                withoutIds.add(designFormMeta.getId());
                continue;
            }
            withoutIds.add(designFormMeta.getId());
        }
        ArrayList<ExtMetadataNode> list = new ArrayList<ExtMetadataNode>();
        for (DesignFormMeta designFormMeta : formMetaList) {
            if (withoutIds.contains(designFormMeta.getId()) || inTreeIds.contains(designFormMeta.getId())) continue;
            if (withoutIds.contains(designFormMeta.getParentId())) {
                withoutIds.add(designFormMeta.getId());
                continue;
            }
            if (!designFormMeta.isEnabled()) {
                withoutIds.add(designFormMeta.getId());
                continue;
            }
            inTreeIds.add(designFormMeta.getId());
            ExtMetadataNode node = new ExtMetadataNode(designFormMeta.getMasterId(), designFormMeta.getId(), designFormMeta.getParentId(), designFormMeta.getDataXml());
            node.setVersion(String.format("%s", designFormMeta.getVersion()));
            list.add(node);
        }
        return list;
    }

    protected void clearCache(AbstractMetadata metadata) {
        super.clearCache(metadata);
        if (metadata instanceof EntityMetadata) {
            EntityMetadata entityMetadata = (EntityMetadata)metadata;
            ShareMetaCacheUtils.removeDistributeCache(entityMetadata.getOldKey());
            ShareMetaCacheUtils.removeDistributeCache(entityMetadata.getKey());
            ShareMetaCacheUtils.removeDistributeCache(metadata.getId(), "entitynumber", 0);
        } else if (metadata instanceof FormMetadata) {
            String key = ((FormMetadata)metadata).getKey();
            String mobKey = String.format("%s_mob", key);
            String filterKey = String.format("%s_filter", key);
            ShareMetaCacheUtils.removeDistributeCache(key, mobKey, filterKey);
            ShareMetaCacheUtils.removeDistributeCache(metadata.getId(), "formnumber", 0);
        }
    }

    private DBRoute getDbRouteByDefault(IDataEntityType metaType) {
        String dbRouteKey = metaType.getDBRouteKey();
        return StringUtils.isBlank((CharSequence)dbRouteKey) ? DBRoute.meta : DBRoute.of((String)dbRouteKey);
    }

    static class EntityShareMetadataBuilder
    extends ShareMetadataBuilder {
        MetadataReader reader = new MetadataReader();

        private EntityShareMetadataBuilder() {
            this.reader.setAppGroup(this.getAppGroup());
        }

        @Override
        protected String getAllMetaSql() {
            return "select  FID,FISV,FBizAppId,FParentId,FData,FMasterId,FType from T_META_ENTITYDESIGN where (FMasterId = ? and FType = '2') or FID = ? order by FInheritPath ";
        }

        @Override
        protected AbstractMetadata readBaseMeta(String currentMetaId) {
            AbstractMetadata meta = this.reader.readMeta(currentMetaId, OrmUtils.getDataEntityType(DesignEntityMeta.class), false, false);
            if (meta == null && this.isGrayDeploy()) {
                this.reader = new MetadataReader();
                meta = this.reader.readMeta(currentMetaId, OrmUtils.getDataEntityType(DesignEntityMeta.class), false, false);
            }
            return meta;
        }

        @Override
        protected String getNumberById(String metaId) {
            MetadataReader reader = new MetadataReader();
            reader.setAppGroup(this.getAppGroup());
            return reader.getNumberById(metaId);
        }

        @Override
        protected void setShareMetaBuildContext(String metaNumber, AbstractMetadata formAllMeta, ShareMetaBuildContext context) {
            if (formAllMeta instanceof EntityMetadata) {
                ((EntityMetadata)formAllMeta).getRootEntity().setKey(metaNumber);
            }
        }

        @Override
        protected IDataEntityType getDesignerMetaType() {
            return OrmUtils.getDataEntityType(DesignEntityMeta.class);
        }
    }

    static class FormShareMetadataBuilder
    extends ShareMetadataBuilder {
        MetadataReader reader = new MetadataReader();

        private FormShareMetadataBuilder() {
            this.reader.setAppGroup(this.getAppGroup());
        }

        @Override
        protected String getAllMetaSql() {
            return "select  FID,FISV,FBizAppId,FParentId,FData,FMasterId,FType from T_META_FORMDESIGN where (FMasterId = ? and FType = '2') or FID = ? order by FInheritPath ";
        }

        @Override
        protected AbstractMetadata readBaseMeta(String currentMetaId) {
            MetadataReader reader = new MetadataReader();
            reader.setAppGroup(this.getAppGroup());
            AbstractMetadata meta = reader.readMeta(currentMetaId, OrmUtils.getDataEntityType(DesignFormMeta.class), false, false);
            if (meta == null && this.isGrayDeploy()) {
                reader = new MetadataReader();
                meta = reader.readMeta(currentMetaId, OrmUtils.getDataEntityType(DesignFormMeta.class), false, false);
            }
            return meta;
        }

        @Override
        protected String getNumberById(String metaId) {
            return this.reader.getNumberById(metaId);
        }

        @Override
        protected IDataEntityType getDesignerMetaType() {
            return OrmUtils.getDataEntityType(DesignFormMeta.class);
        }

        @Override
        protected void setShareMetaBuildContext(String metaNumber, AbstractMetadata formAllMeta, ShareMetaBuildContext context) {
            if (formAllMeta instanceof FormMetadata) {
                FormMetadata formMetadata = (FormMetadata)formAllMeta;
                formMetadata.setKey(metaNumber);
            }
        }
    }
}

