/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.dao;

import java.util.List;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.entity.gray.AppGroupUtils;
import kd.bos.service.ServiceFactory;
import kd.bos.service.metadata.RuntimeMetadataShareService;
import kd.bos.service.metadata.ShareMetaAppConfigService;

public class ShareMetaCacheUtils {
    private static final String STR_META_STR = "%s_meta_%s_%s";
    private static final String STR_APPMETA_STR = "%s_appmeta_%s_%s";
    private static final String STR_METAVERSION_STR = "%s_metaversion_%s_%s";
    static String CacheType_Meta = "meta";
    static String CacheType_AppMeta = "appmeta";

    private static DistributeSessionlessCache getCache() {
        return CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("sharemeta", new DistributeCacheHAPolicy());
    }

    private static String getMetaISV(String number) {
        RuntimeMetadataShareService service = (RuntimeMetadataShareService)ServiceFactory.getService(RuntimeMetadataShareService.class);
        return service.getMetaISV(number);
    }

    private static String getExtAppId(String appId) {
        ShareMetaAppConfigService service = (ShareMetaAppConfigService)ServiceFactory.getService(ShareMetaAppConfigService.class);
        return service.getExtAppId(appId);
    }

    private static List<String> getExtAppIds(String number) {
        RuntimeMetadataShareService service = (RuntimeMetadataShareService)ServiceFactory.getService(RuntimeMetadataShareService.class);
        return service.getExtAppIds(number);
    }

    public static String getDistributeCache(String number, String key, int metaType) {
        DistributeSessionlessCache cache = ShareMetaCacheUtils.getCache();
        String extAppId = ShareMetaCacheUtils.getMetaISV(number);
        return (String)cache.get(ShareMetaCacheUtils.getCacheType(number), ShareMetaCacheUtils.getCacheKey(extAppId, key, metaType));
    }

    public static void putDistributeCache(String number, String key, int metaType, String val) {
        if (val == null) {
            return;
        }
        DistributeSessionlessCache cache = ShareMetaCacheUtils.getCache();
        String extAppId = ShareMetaCacheUtils.getMetaISV(number);
        cache.put(ShareMetaCacheUtils.getCacheType(number), ShareMetaCacheUtils.getCacheKey(extAppId, key, metaType), (Object)val);
    }

    public static String getAppmetaDistributeCache(String appNumber, String key, int metaType) {
        DistributeSessionlessCache cache = ShareMetaCacheUtils.getCache();
        String extAppId = ShareMetaCacheUtils.getExtAppId(appNumber);
        return (String)cache.get(ShareMetaCacheUtils.getAppCacheType(appNumber), ShareMetaCacheUtils.getCacheKey(extAppId, key, metaType));
    }

    public static void putAppmetaDistributeCache(String appNumber, String key, int metaType, String val) {
        if (val == null) {
            return;
        }
        DistributeSessionlessCache cache = ShareMetaCacheUtils.getCache();
        String extAppId = ShareMetaCacheUtils.getExtAppId(appNumber);
        cache.put(ShareMetaCacheUtils.getAppCacheType(appNumber), ShareMetaCacheUtils.getCacheKey(extAppId, key, metaType), (Object)val);
    }

    public static void removeAppmetaDistributeCache(String appNumber) {
        DistributeSessionlessCache cache = ShareMetaCacheUtils.getCache();
        cache.removeType(ShareMetaCacheUtils.getAppCacheType(appNumber));
    }

    public static void setFormMetaVersion(String number, String version) {
        DistributeSessionlessCache cache = ShareMetaCacheUtils.getCache();
        String cacheKey = ShareMetaCacheUtils.getVerCacheType(number);
        cache.put(cacheKey, (Object)version, 5000);
    }

    public static String getFormMetaVersion(String number) {
        DistributeSessionlessCache cache = ShareMetaCacheUtils.getCache();
        String cacheKey = ShareMetaCacheUtils.getVerCacheType(number);
        return (String)cache.get(cacheKey);
    }

    public static void removeDistributeCache(String type, String key, int metaType) {
        DistributeSessionlessCache cache = ShareMetaCacheUtils.getCache();
        String cacheKey = ShareMetaCacheUtils.getCacheType(type);
        List<String> extAppIds = ShareMetaCacheUtils.getExtAppIds(type);
        if (extAppIds == null) {
            cache.remove(cacheKey, ShareMetaCacheUtils.getCacheKey(null, key, metaType));
        } else {
            extAppIds.forEach(extAppId -> cache.remove(cacheKey, ShareMetaCacheUtils.getCacheKey(extAppId, key, metaType)));
        }
    }

    public static void removeDistributeCache(String ... numbers) {
        DistributeSessionlessCache cache = ShareMetaCacheUtils.getCache();
        String[] cacheKeys = new String[2 * numbers.length];
        for (int i = 0; i < numbers.length; ++i) {
            cacheKeys[i * 2] = ShareMetaCacheUtils.getCacheType(numbers[i]);
            cacheKeys[i * 2 + 1] = ShareMetaCacheUtils.getVerCacheType(numbers[i]);
        }
        cache.remove(cacheKeys);
    }

    private static String getCacheKey(String extAppId, String key, int metaType) {
        if (extAppId == null) {
            return String.format("_%s_%s", metaType, key);
        }
        return String.format("_%s_%s_%s", extAppId, metaType, key);
    }

    private static String getCacheType(String number) {
        String appGroup = AppGroupUtils.getCurrentAppGroup();
        return ShareMetaCacheUtils.getCacheType(appGroup, number);
    }

    private static String getCacheType(String appGroup, String number) {
        String accountId = CacheKeyUtil.getAcctId();
        return String.format(STR_META_STR, accountId, appGroup, number);
    }

    private static String getAppCacheType(String appNumber) {
        String appGroup = AppGroupUtils.getCurrentAppGroup();
        return ShareMetaCacheUtils.getAppCacheType(appGroup, appNumber);
    }

    private static String getAppCacheType(String appGroup, String appNumber) {
        String accountId = CacheKeyUtil.getAcctId();
        return String.format(STR_APPMETA_STR, accountId, appGroup, appNumber);
    }

    private static String getVerCacheType(String number) {
        String accountId = CacheKeyUtil.getAcctId();
        String appGroup = AppGroupUtils.getCurrentAppGroup();
        return String.format(STR_METAVERSION_STR, accountId, appGroup, number);
    }
}

