/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.devportal;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.ShareMetaBuildContext;
import kd.bos.metadata.ShareMetaBuildContextHolder;
import kd.bos.metadata.dao.ShareMetadataBuilder;
import kd.bos.metadata.devportal.AppDesignMetaReader;
import kd.bos.metadata.devportal.AppMetaDaoPlugin;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.metadata.devportal.AppRuntimeMeta;
import kd.bos.metadata.devportal.AppRuntimeMetaFork;
import kd.bos.metadata.devportal.AppRuntimeMetaForkL;
import kd.bos.metadata.devportal.AppRuntimeMetaL;
import kd.bos.metadata.devportal.DesignAppMeta;
import kd.bos.metadata.devportal.MenuRuntimeMeta;
import kd.bos.metadata.devportal.MenuRuntimeMetaFork;
import kd.bos.metadata.devportal.MenuRuntimeMetaForkL;
import kd.bos.metadata.devportal.MenuRuntimeMetaL;

public class ShareAppMetaDaoPlugin
extends AppMetaDaoPlugin {
    private static final String SQL_AppRuntime = "SELECT FID,FAppId from %s_Fork where FExtAppid = ? and FAppId = ? ";
    private ShareMetaBuildContextHolder shareMetaBuildContextHolder;
    private Map<String, String> menuIdMap = new HashMap<String, String>();

    protected List<AbstractMetadata> buildRuntimeMetaList(AppDesignMetaReader reader, String appMasterId, String currentMetaId) {
        AppMetaShareMetadataBuilder shareMetadataReader = new AppMetaShareMetadataBuilder(reader);
        this.shareMetaBuildContextHolder = shareMetadataReader.buildRuntimeMetaList(appMasterId, currentMetaId);
        return this.shareMetaBuildContextHolder.getMetaDataList();
    }

    protected AppRuntimeMeta getAppRuntimeMeta(AppMetadata appRuntimeMetadata, String id) {
        AppRuntimeMeta runtimeMeta = super.getAppRuntimeMeta(appRuntimeMetadata, id);
        if (!this.shareMetaBuildContextHolder.get((AbstractMetadata)appRuntimeMetadata).isFork()) {
            return runtimeMeta;
        }
        if (runtimeMeta != null) {
            String extAppId = ShareMetadataBuilder.getMetaBizAppId(id);
            if (extAppId != null) {
                String sql = String.format(SQL_AppRuntime, "T_META_APPRUNTIME");
                Object[] parameters = new SqlParameter[]{new SqlParameter("FExtAppId", 12, (Object)extAppId), new SqlParameter("FAppId", 12, (Object)runtimeMeta.getAppid())};
                return (AppRuntimeMeta)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])parameters, rs -> {
                    if (rs.next()) {
                        AppRuntimeMetaFork fork = new AppRuntimeMetaFork();
                        fork.setId(rs.getString("FID"));
                        fork.setAppid(rs.getString("FAppID"));
                        return fork;
                    }
                    return null;
                });
            }
            return null;
        }
        return null;
    }

    protected void deleteAppRuntimeMeta(AppMetadata appRuntimeMetadata, String ... numbers) {
        if (!this.shareMetaBuildContextHolder.get((AbstractMetadata)appRuntimeMetadata).isFork()) {
            super.deleteAppRuntimeMeta(appRuntimeMetadata, numbers);
        } else {
            SqlBuilder deleteLangSql = new SqlBuilder();
            deleteLangSql.append(String.format("DELETE FROM %s ", this.getTableName("T_META_APPRUNTIME_Fork_L")), new Object[0]).appendIn("WHERE FAPPID", (Object[])numbers).append(" and FBizAppId = ? ", new Object[]{this.shareMetaBuildContextHolder.get((AbstractMetadata)appRuntimeMetadata).getExtAppId()});
            DB.execute((DBRoute)DBRoute.meta, (SqlBuilder)deleteLangSql);
            SqlBuilder deleteSql = new SqlBuilder();
            deleteSql.append(String.format("DELETE FROM %s ", this.getTableName("T_META_APPRUNTIME_Fork")), new Object[0]).appendIn(" WHERE FAPPID ", (Object[])numbers).append(" and FBizAppId = ? ", new Object[]{this.shareMetaBuildContextHolder.get((AbstractMetadata)appRuntimeMetadata).getExtAppId()});
            DB.execute((DBRoute)DBRoute.meta, (SqlBuilder)deleteSql);
        }
    }

    protected void deleteMenuRuntimeMeta(AppMetadata appRuntimeMetadata, String ... numbers) {
        if (!this.shareMetaBuildContextHolder.get((AbstractMetadata)appRuntimeMetadata).isFork()) {
            super.deleteMenuRuntimeMeta(appRuntimeMetadata, numbers);
        } else {
            SqlBuilder selectMenuLangFIDSql = new SqlBuilder();
            selectMenuLangFIDSql.appendIn(String.format("SELECT FID FROM %s WHERE FAPPID ", this.getTableName("T_META_MENURUNTIME_Fork")), (Object[])numbers).append(" and FBizAppId = ? ", new Object[]{this.shareMetaBuildContextHolder.get((AbstractMetadata)appRuntimeMetadata).getExtAppId()});
            ResultSetHandler callBackLangHanlder = rs -> {
                ArrayList<Object> menuIds = new ArrayList<Object>();
                try {
                    while (rs.next()) {
                        Object menuId = rs.getObject("FID");
                        menuIds.add(menuId);
                    }
                }
                catch (SQLException e) {
                    throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format("Error:%s", e.getMessage())});
                }
                return menuIds;
            };
            List menuIds = (List)DB.query((DBRoute)DBRoute.meta, (SqlBuilder)selectMenuLangFIDSql, (ResultSetHandler)callBackLangHanlder);
            if (!menuIds.isEmpty()) {
                SqlBuilder deleteMenuLangSql = new SqlBuilder();
                deleteMenuLangSql.appendIn(String.format("DELETE FROM %s ", this.getTableName("T_META_MENURUNTIME_Fork_L")) + " WHERE FID ", menuIds);
                DB.execute((DBRoute)DBRoute.meta, (SqlBuilder)deleteMenuLangSql);
                SqlBuilder deleteMenuSql = new SqlBuilder();
                deleteMenuSql.appendIn(String.format("DELETE FROM %s ", this.getTableName("T_META_MENURUNTIME_Fork")) + " WHERE FAPPID ", (Object[])numbers).append(" and FBizAppId = ? ", new Object[]{this.shareMetaBuildContextHolder.get((AbstractMetadata)appRuntimeMetadata).getExtAppId()});
                DB.execute((DBRoute)DBRoute.meta, (SqlBuilder)deleteMenuSql);
            }
        }
    }

    protected void saveRuntimeMetaToDb(AbstractMetadata appRuntimeMetadata, Object[] runtimeMetas) {
        if (runtimeMetas.length == 0) {
            return;
        }
        if (!this.shareMetaBuildContextHolder.get(appRuntimeMetadata).isFork()) {
            super.saveRuntimeMetaToDb(appRuntimeMetadata, runtimeMetas);
        } else {
            Object[] shareRuntimeMetas = new Object[runtimeMetas.length];
            Class<?> clazz = runtimeMetas[0].getClass();
            if (clazz.equals(MenuRuntimeMeta.class)) {
                this.menuIdMap.clear();
            }
            for (int i = 0; i < runtimeMetas.length; ++i) {
                AppRuntimeMeta runtimeMeta;
                if (clazz.equals(AppRuntimeMeta.class)) {
                    runtimeMeta = (AppRuntimeMeta)runtimeMetas[i];
                    shareRuntimeMetas[i] = AppRuntimeMetaFork.create(this.shareMetaBuildContextHolder.get(appRuntimeMetadata).getExtAppId(), runtimeMeta);
                    continue;
                }
                if (clazz.equals(AppRuntimeMetaL.class)) {
                    runtimeMeta = (AppRuntimeMetaL)runtimeMetas[i];
                    shareRuntimeMetas[i] = AppRuntimeMetaForkL.create(this.shareMetaBuildContextHolder.get(appRuntimeMetadata).getExtAppId(), (AppRuntimeMetaL)runtimeMeta);
                    continue;
                }
                if (clazz.equals(MenuRuntimeMeta.class)) {
                    runtimeMeta = (MenuRuntimeMeta)runtimeMetas[i];
                    MenuRuntimeMetaFork menuRuntimeMetaFork = MenuRuntimeMetaFork.create(this.shareMetaBuildContextHolder.get(appRuntimeMetadata).getExtAppId(), (MenuRuntimeMeta)runtimeMeta);
                    this.menuIdMap.put(runtimeMeta.getId(), menuRuntimeMetaFork.getId());
                    shareRuntimeMetas[i] = menuRuntimeMetaFork;
                    continue;
                }
                if (!clazz.equals(MenuRuntimeMetaL.class)) continue;
                runtimeMeta = (MenuRuntimeMetaL)runtimeMetas[i];
                MenuRuntimeMetaForkL menuRuntimeMetaForkL = MenuRuntimeMetaForkL.create(this.shareMetaBuildContextHolder.get(appRuntimeMetadata).getExtAppId(), (MenuRuntimeMetaL)runtimeMeta);
                menuRuntimeMetaForkL.setId(this.menuIdMap.get(runtimeMeta.getId()));
                shareRuntimeMetas[i] = menuRuntimeMetaForkL;
            }
            super.saveRuntimeMetaToDb(appRuntimeMetadata, shareRuntimeMetas);
        }
    }

    static class AppMetaShareMetadataBuilder
    extends ShareMetadataBuilder {
        private final AppDesignMetaReader reader;

        public AppMetaShareMetadataBuilder(AppDesignMetaReader reader) {
            this.reader = reader;
        }

        @Override
        protected String getAllMetaSql() {
            return "select  FID,FISV,FID as FBizAppId,FParentId,FData,FMasterId,FType from T_META_BizApp where (FMasterId = ? and FType = '2') or FID = ? order by FInheritPath ";
        }

        @Override
        protected AbstractMetadata readBaseMeta(String currentMetaId) {
            return this.reader.loadMeta(currentMetaId, false);
        }

        @Override
        protected String getNumberById(String metaId) {
            return this.reader.getAppNumberById(metaId);
        }

        @Override
        protected void setShareMetaBuildContext(String metaNumber, AbstractMetadata formAllMeta, ShareMetaBuildContext context) {
            if (formAllMeta instanceof AppMetadata) {
                ((AppMetadata)formAllMeta).setNumber(metaNumber);
            }
        }

        @Override
        protected IDataEntityType getDesignerMetaType() {
            return OrmUtils.getDataEntityType(DesignAppMeta.class);
        }
    }
}

