/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.sharemeta;

import com.alibaba.fastjson.JSONObject;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.devportal.api.BizAppService;
import kd.bos.entity.RuntimeMetaType;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.entity.gray.AppGroupUtils;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaRebuilder;
import kd.bos.metadata.dao.ShareMetaCacheUtils;
import kd.bos.metadata.devportal.AppReader;
import kd.bos.service.ServiceFactory;
import kd.bos.service.metadata.ShareMetaAppConfigService;
import kd.bos.service.sharemeta.IMetaShareDBQuery;

class MetadataShareServiceReader {
    private static final String FAPPID = ":FAPPID";
    private static final String ERROR_S = "Error:%s";
    private static final String DESCRIPTION = "description";
    private static final String FKEY = ":FKEY";
    private static final String FNUMBER = ":FNUMBER";
    private static final String FTYPE = ":FTYPE";
    private static final String T_META_FORM = "T_META_FORM";
    private static final String T_META_FORMDESIGN = "T_META_FORMDESIGN";
    private static final String T_META_ENTITY = "T_META_ENTITY";
    private static final String T_META_ENTITYDESIGN = "t_meta_entitydesign";
    private static final Log log = LogFactory.getLog(MetadataShareServiceReader.class);
    private static final String SQL_METABIZAPPID = "select meta.FBizAppId from %s meta where meta.FNumber = ?";
    private static final String SQL_SELECT_FLOCALEID = "SELECT FLOCALEID,FNAME,FDESCRIPTION FROM %s WHERE FAPPID = ?";
    private static final String SQL_SELECT_FLOCALEID_FID = "SELECT FID,FLOCALEID,FNAME,FDESCRIPTION,FFORMNAME FROM %s WHERE FID in (%s)";
    protected IMetaShareDBQuery dbQuery = DB::query;

    MetadataShareServiceReader() {
    }

    public String loadFormRuntimeMeta(String number, short type, String key) {
        String meta = this.queryMeta(number, key, RuntimeMetaType.valueOf((short)type), T_META_FORM);
        if (StringUtils.isBlank((CharSequence)meta) && (RuntimeMetaType.List.getValue() == type || RuntimeMetaType.Config.getValue() == type || RuntimeMetaType.Form.getValue() == type || RuntimeMetaType.MobList.getValue() == type || RuntimeMetaType.Client.getValue() == type)) {
            this.rebuildRuntimeMeta(number);
            meta = this.queryMeta(number, key, RuntimeMetaType.valueOf((short)type), T_META_FORM);
        }
        return meta;
    }

    public String loadEntityRuntimeMeta(String entityNumber, int entityMetaType, String key) {
        String metaStr = this.queryMeta(entityNumber, key, RuntimeMetaType.valueOf((int)entityMetaType), T_META_ENTITY);
        if (StringUtils.isBlank((CharSequence)metaStr) && entityMetaType == RuntimeMetaType.Entity.getValue()) {
            this.rebuildRuntimeMeta(entityNumber);
            metaStr = this.queryMeta(entityNumber, key, RuntimeMetaType.valueOf((int)entityMetaType), T_META_ENTITY);
        }
        return metaStr;
    }

    public String getRuntimeFormMetaVersion(String number) {
        return (String)ThreadCache.get((Object)("FV." + number), () -> {
            String redisMetaVer = ShareMetaCacheUtils.getFormMetaVersion(number);
            if (StringUtils.isBlank((CharSequence)redisMetaVer)) {
                redisMetaVer = this.queryMeta(number, number, RuntimeMetaType.Version, T_META_FORM);
                if (StringUtils.isBlank((CharSequence)redisMetaVer)) {
                    this.rebuildRuntimeMeta(number);
                    redisMetaVer = this.queryMeta(number, number, RuntimeMetaType.Version, T_META_FORM);
                }
                ShareMetaCacheUtils.setFormMetaVersion(number, redisMetaVer);
            }
            return redisMetaVer == null ? "" : redisMetaVer;
        });
    }

    public Map<String, String> batchLoadRuntimeFormMetaVersion(Collection<String> numbers) {
        if (numbers == null || numbers.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, String> result = new HashMap<String, String>(numbers.size());
        HashSet<String> notFounds = new HashSet<String>(10);
        for (String number : numbers) {
            Object ver = ThreadCache.get((Object)("DBMETA.FV." + number));
            if (ver == null) {
                notFounds.add(number);
                continue;
            }
            result.put(number, ver.toString());
        }
        if (!notFounds.isEmpty()) {
            Map<String, String> datas = this.doQueryRuntimeFormMetaVersion(numbers);
            for (Map.Entry<String, String> it : datas.entrySet()) {
                ThreadCache.put((Object)("DBMETA.FV." + it.getKey()), (Object)it.getValue());
            }
            result.putAll(datas);
        }
        return result;
    }

    private Map<String, String> doQueryRuntimeFormMetaVersion(Collection<String> numbers) {
        SqlBuilder builder = new SqlBuilder();
        builder.append("SELECT FNUMBER,FDATA FROM T_META_FORM WHERE ", new Object[0]).append(" FTYPE = ?", (Object[])new SqlParameter[]{new SqlParameter(FTYPE, 5, (Object)RuntimeMetaType.Version.getValue())}).append(" AND ", new Object[0]).appendIn("FNUMBER", numbers.toArray());
        return (Map)DB.query((DBRoute)DBRoute.meta, (SqlBuilder)builder, rs -> {
            HashMap<String, String> vers = new HashMap<String, String>(10);
            while (rs.next()) {
                vers.put(rs.getString("FNUMBER"), rs.getString("FDATA"));
            }
            return vers;
        });
    }

    private String queryMeta(String number, String key, RuntimeMetaType type, String tableName) {
        String val = ShareMetaCacheUtils.getDistributeCache(number, key, type.getValue());
        if (StringUtils.isBlank((CharSequence)val)) {
            val = this.doQueryMetaData(number, key, type, this.getGrayTableName(tableName));
            if (StringUtils.isBlank((CharSequence)val) && this.isGrayGroup()) {
                val = this.doQueryMetaData(number, key, type, tableName);
            }
            ShareMetaCacheUtils.putDistributeCache(number, key, type.getValue(), val);
        }
        return val;
    }

    public List<String> loadEntityAllOperationMeta(String number) {
        return this.doQueryMetaDatas(number, RuntimeMetaType.Operate);
    }

    public List<String> loadEntityNetCtrlOperationMeta(String number) {
        String val = ShareMetaCacheUtils.getDistributeCache(number, "netCtrl", RuntimeMetaType.NetCtrlOperate.getValue());
        List netCtrlOperationMeta = null;
        if (StringUtils.isBlank((CharSequence)val)) {
            netCtrlOperationMeta = this.doQueryMetaDatas(number, RuntimeMetaType.NetCtrlOperate);
            val = SerializationUtils.toJsonString((Object)netCtrlOperationMeta);
            ShareMetaCacheUtils.putDistributeCache(number, "netCtrl", RuntimeMetaType.NetCtrlOperate.getValue(), val);
        } else {
            netCtrlOperationMeta = (List)SerializationUtils.fromJsonString((String)val, List.class);
        }
        return netCtrlOperationMeta;
    }

    private List<String> doQueryMetaDatas(String number, RuntimeMetaType type) {
        String tableName = this.getGrayTableName(T_META_ENTITY);
        String sql = String.format("select FDATA from %s where FNUMBER = ? and FTYPE = ?", tableName);
        SqlParameter[] params = new SqlParameter[]{new SqlParameter(FNUMBER, 12, (Object)number), new SqlParameter(FTYPE, 5, (Object)type.getValue())};
        ResultSetHandler callBackHanlder = rs -> {
            ArrayList<String> list = new ArrayList<String>();
            try {
                while (rs.next()) {
                    list.add(rs.getString(1));
                }
                if (list.isEmpty()) {
                    return null;
                }
            }
            catch (SQLException e) {
                throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format(ERROR_S, e.getMessage())});
            }
            return list;
        };
        ArrayList list = (ArrayList)this.getShareMetaData(number, tableName, sql, params, callBackHanlder);
        if (list == null) {
            list = new ArrayList();
        }
        return list;
    }

    private String getDesginTable(String runTimeTableName, boolean canNull) {
        if (runTimeTableName.equals(T_META_ENTITY)) {
            return T_META_ENTITYDESIGN;
        }
        if (runTimeTableName.equals(T_META_FORM)) {
            return T_META_FORMDESIGN;
        }
        if (!canNull) {
            throw new KDException(BosErrorCode.bOS, new Object[]{String.format(ResManager.loadKDString((String)"\u8868\u540d\u9519\u8bef%s", (String)"MetadataShareServiceReader_0", (String)"bos-sharemetadata-provider", (Object[])new Object[0]), runTimeTableName)});
        }
        return "";
    }

    private <T> T getShareMetaData(String number, String tableName, String sql, SqlParameter[] parameters, ResultSetHandler<T> callBackHandler) {
        T data;
        DBRoute route = DBRoute.meta;
        String extAppId = this.getMetaAppId(number, this.getDesginTable(tableName, true));
        if (extAppId == null) {
            data = this.dbQuery.query(route, sql, parameters, callBackHandler);
        } else {
            String forkSql = sql.replace(tableName, tableName + "_fork");
            forkSql = forkSql + " and FBizAppId = ? ";
            SqlParameter[] newParams = new SqlParameter[parameters.length + 1];
            System.arraycopy(parameters, 0, newParams, 0, parameters.length);
            newParams[parameters.length] = new SqlParameter(":FBizAppId", 12, (Object)extAppId);
            data = this.dbQuery.query(route, forkSql, newParams, callBackHandler);
            if (data == null) {
                data = this.dbQuery.query(route, sql, parameters, callBackHandler);
            }
        }
        return data;
    }

    protected void rebuildRuntimeMeta(String number) {
        String appGroup = AppGroupUtils.getCurrentAppGroup();
        MetaRebuilder mr = new MetaRebuilder(appGroup);
        try {
            mr.rebuildRuntimeMetaByNumber(number);
        }
        catch (KDException e) {
            if (e.getErrorCode().getCode().equals(BosErrorCode.metaNotFound.getCode()) && this.isGrayGroup()) {
                mr = new MetaRebuilder("defaultGroup");
                mr.rebuildRuntimeMetaByNumber(number);
            }
            throw e;
        }
    }

    private String doQueryMetaData(String number, String ctlKey, RuntimeMetaType type, String table) {
        SqlParameter[] params;
        String sql;
        if (StringUtils.isNotEmpty((CharSequence)ctlKey)) {
            sql = String.format("select FDATA from %s where FNUMBER = ? and FKEY = ? and FTYPE = ?", table);
            params = new SqlParameter[]{new SqlParameter(FNUMBER, 12, (Object)number), new SqlParameter("FKEY", 12, (Object)ctlKey), new SqlParameter(FTYPE, 5, (Object)type.getValue())};
        } else {
            sql = String.format("select FDATA from %s where FNUMBER = ? and FTYPE = ?", table);
            params = new SqlParameter[]{new SqlParameter(FNUMBER, 12, (Object)number), new SqlParameter(FTYPE, 5, (Object)type.getValue())};
        }
        ResultSetHandler callBackHandler = rs -> {
            String sFdata = null;
            try {
                if (rs.next()) {
                    sFdata = rs.getString(1);
                }
            }
            catch (SQLException e) {
                throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format(ERROR_S, e.getMessage())});
            }
            return sFdata;
        };
        String sRet = (String)this.getShareMetaData(number, table, sql, params, callBackHandler);
        if (StringUtils.isBlank((CharSequence)sRet)) {
            sRet = "";
        }
        return sRet;
    }

    private String getMetaAppId(String number, String table) {
        String bizAppId;
        if (StringUtils.isNotBlank((CharSequence)table)) {
            String sql = String.format(SQL_METABIZAPPID, table);
            SqlParameter[] params = new SqlParameter[]{new SqlParameter(FNUMBER, 12, (Object)number)};
            bizAppId = this.queryDB(DBRoute.meta, sql, params);
        } else {
            bizAppId = number;
        }
        String extAppId = (String)ThreadCache.get((Object)("ExtAppId." + bizAppId), () -> {
            ShareMetaAppConfigService service = (ShareMetaAppConfigService)ServiceFactory.getService(ShareMetaAppConfigService.class);
            String ext = service.getExtAppId(bizAppId);
            if (ext == null) {
                ext = "1";
            }
            return ext;
        });
        if ("1".equals(extAppId)) {
            return null;
        }
        return extAppId;
    }

    public String getMetaAppId(String formID) {
        return (String)ThreadCache.get((Object)("ExtAppId." + formID), () -> {
            String extAppId = this.getMetaAppId(formID, this.getGrayTableName(T_META_FORMDESIGN));
            if (StringUtils.isBlank((CharSequence)extAppId)) {
                extAppId = this.getMetaAppId(formID, this.getGrayTableName(T_META_ENTITYDESIGN));
            }
            return extAppId;
        });
    }

    String getExtAppId(String bizAppId) {
        String sql = "Select FExtAppId from T_META_BizAppConfig where FAccountid = ? and FBizAppId = ? ";
        SqlParameter[] params = new SqlParameter[]{new SqlParameter("FAccountID", 12, (Object)RequestContext.get().getAccountId()), new SqlParameter(FNUMBER, 12, (Object)bizAppId)};
        return this.queryDB(DBRoute.meta, sql, params);
    }

    private String queryDB(DBRoute route, String sql, SqlParameter[] params) {
        ResultSetHandler callBackHanlder = rs -> {
            String sFdata = null;
            try {
                if (rs.next()) {
                    sFdata = rs.getString(1);
                }
            }
            catch (SQLException e) {
                throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format(ERROR_S, e.getMessage())});
            }
            return sFdata;
        };
        return (String)this.dbQuery.query(route, sql, params, callBackHanlder);
    }

    public String loadFormPluginScript(String number, String key) {
        RuntimeMetaType type = RuntimeMetaType.FormPluginScript;
        String val = ShareMetaCacheUtils.getDistributeCache(key, key, type.getValue());
        if (val == null) {
            val = this.doQueryScriptMeta(key);
            ShareMetaCacheUtils.putDistributeCache(key, key, type.getValue(), val);
        }
        return val;
    }

    private String doQueryScriptMeta(String ctlKey) {
        if (StringUtils.isNotEmpty((CharSequence)ctlKey)) {
            String sql = "select FSCRIPTCONTEXT_TAG from t_meta_pluginscript where FCLASSNAME = ?";
            SqlParameter[] params = new SqlParameter[]{new SqlParameter(FKEY, 12, (Object)ctlKey)};
            return (String)this.dbQuery.query(DBRoute.meta, sql, params, rs -> {
                String data = null;
                try {
                    if (rs.next()) {
                        data = rs.getString(1);
                    }
                }
                catch (SQLException e) {
                    throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format(ERROR_S, e.getMessage())});
                }
                return data;
            });
        }
        return "";
    }

    private String getGrayTableName(String tabName) {
        String appGroup = AppGroupUtils.getCurrentAppGroup();
        if (this.isGrayGroup()) {
            return String.format("%s_%s", tabName, appGroup);
        }
        return tabName;
    }

    private boolean isGrayGroup() {
        return AppGroupUtils.isGrayGroup();
    }

    public String loadTableDefine(String entityNumber, String entityKey) {
        String val = ShareMetaCacheUtils.getDistributeCache(entityNumber, entityKey, RuntimeMetaType.TableDefine.getValue());
        if (val == null) {
            SqlParameter[] parameters = new SqlParameter[]{new SqlParameter(":FId", 12, (Object)entityNumber), new SqlParameter(":FEntityKey", 12, (Object)entityKey)};
            TableDefine tableDefine = this.loadTableDefine(parameters);
            val = SerializationUtils.toJsonString((Object)tableDefine);
            ShareMetaCacheUtils.putDistributeCache(entityNumber, entityKey, RuntimeMetaType.TableDefine.getValue(), val);
        }
        return val;
    }

    private TableDefine loadTableDefine(SqlParameter[] parameters) {
        StringBuilder sql = new StringBuilder("SELECT FId, FEntityKey, FTableId FROM T_META_EntityInfo ");
        for (int i = 0; i < parameters.length; ++i) {
            if (i == 0) {
                sql.append("WHERE ");
            } else {
                sql.append(" AND ");
            }
            sql.append(parameters[i].getName().substring(1)).append(" = ? ");
        }
        ResultSetHandler action = rs -> {
            TableDefine tableDefine = null;
            if (rs.next()) {
                tableDefine = new TableDefine();
                tableDefine.setEntityNumber(rs.getString("FId"));
                tableDefine.setEntityKey(rs.getString("FEntityKey"));
                tableDefine.setTableId(Long.valueOf(rs.getLong("FTableId")));
            }
            return tableDefine;
        };
        return (TableDefine)this.dbQuery.query(DBRoute.meta, sql.toString(), parameters, action);
    }

    public String loadTableDefine(Long tableId) {
        String key = String.format("%s", tableId);
        String val = ShareMetaCacheUtils.getDistributeCache(key, key, RuntimeMetaType.TableDefine.getValue());
        if (val == null) {
            SqlParameter[] parameters = new SqlParameter[]{new SqlParameter(":FTableId", -5, (Object)tableId)};
            TableDefine tableDefine = this.loadTableDefine(parameters);
            val = SerializationUtils.toJsonString((Object)tableDefine);
            ShareMetaCacheUtils.putDistributeCache(key, key, RuntimeMetaType.TableDefine.getValue(), val);
        }
        return val;
    }

    public boolean isPrivateMeta(String formId) {
        return false;
    }

    public String loadAppInfo(String appGroup, String appid) {
        String metaStr = this.queryAppMeta(appid, appid, RuntimeMetaType.App, appGroup);
        if (StringUtils.isBlank((CharSequence)metaStr)) {
            try {
                BizAppService bizAppService = (BizAppService)ServiceFactory.getService(BizAppService.class);
                metaStr = bizAppService.getAppRuntimeInfo(appid);
            }
            catch (KDException ex) {
                log.error("\u4f7f\u7528AppMetadataCache\u83b7\u53d6\u975e\u8fd0\u884c\u65f6\u5e94\u7528\u5143\u6570\u636e\uff01number=" + appid, (Throwable)ex);
            }
        }
        return metaStr;
    }

    public String getAppMenusInfoByAppId(String number) {
        String metaStr = this.queryAppMeta(number, number + ".menus", RuntimeMetaType.AppMenu, AppGroupUtils.getCurrentAppGroup());
        if (StringUtils.isBlank((CharSequence)metaStr)) {
            try {
                BizAppService bizAppService = (BizAppService)ServiceFactory.getService(BizAppService.class);
                metaStr = bizAppService.getAppRuntimeMenusInfo(number);
            }
            catch (KDException ex) {
                log.error("\u4f7f\u7528AppMetadataCache\u83b7\u53d6\u975e\u8fd0\u884c\u65f6\u5e94\u7528\u5143\u6570\u636e\uff01number=" + number, (Throwable)ex);
            }
        }
        return metaStr;
    }

    private String queryAppMeta(String number, String key, RuntimeMetaType type, String appGroup) {
        String val = ShareMetaCacheUtils.getAppmetaDistributeCache(number, key, type.getValue());
        if (StringUtils.isBlank((CharSequence)val)) {
            if (RuntimeMetaType.App == type) {
                val = this.doQueryAppMeta(number, appGroup);
                if (StringUtils.isBlank((CharSequence)val) && this.isGrayGroup()) {
                    val = this.doQueryAppMeta(number, "defaultGroup");
                }
            } else if (RuntimeMetaType.AppMenu == type && (StringUtils.isBlank((CharSequence)(val = this.doQueryAppMenuMetaByAppId(number, appGroup))) || "[]".equals(val)) && this.isGrayGroup()) {
                val = this.doQueryAppMenuMetaByAppId(number, "defaultGroup");
            }
            if (val != null) {
                ShareMetaCacheUtils.putAppmetaDistributeCache(number, key, type.getValue(), val);
            }
        }
        return val;
    }

    private void putNotNull(Map<String, Object> map, String key, Object data) {
        if (StringUtils.isNotBlank((Object)data)) {
            map.put(key, data);
        }
    }

    private void putNotNullLangObj(Map<String, Object> map, String key, String localeId, Object data) {
        if (StringUtils.isNotBlank((Object)data)) {
            LocaleString langObj = (LocaleString)map.get(key);
            if (langObj != null) {
                langObj.setItem(localeId, (Object)key);
            } else {
                langObj = new LocaleString(localeId, key);
                map.put("name", langObj);
            }
        }
    }

    private String doQueryAppMeta(String number, String appGroup) {
        String selectFields = "FAPPID,FID,FSEQ,FCLOUDID,FCLOUDNUM,FDBROUTE,FIMAGE,FHOMEID,FHOMENUM,FOPENTYPE,FALLUSERAPP,FUSERTYPE,FORGFUNC,FDATA";
        String tableName = AppGroupUtils.getAppGroupTableName((String)appGroup, (String)"T_META_APPRUNTIME");
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT ").append(selectFields).append(" FROM ").append(tableName).append(" WHERE FAPPID = ?");
        String sql = sb.toString();
        SqlParameter[] params = new SqlParameter[]{new SqlParameter(FAPPID, 12, (Object)number)};
        ResultSetHandler callBackHanlder = rs -> {
            JSONObject obj = null;
            if (rs.next()) {
                obj = new JSONObject();
                String appId = rs.getString("FAPPID");
                this.putNotNull((Map<String, Object>)obj, "number", appId);
                this.putNotNull((Map<String, Object>)obj, "appId", appId);
                String id = rs.getString("FID");
                this.putNotNull((Map<String, Object>)obj, "id", id);
                AppReader.updateAppNumberAndIdCache((String)id, (String)number);
                Short seq = rs.getShort("FSEQ");
                this.putNotNull((Map<String, Object>)obj, "seq", seq);
                String cloudId = rs.getString("FCLOUDID");
                this.putNotNull((Map<String, Object>)obj, "cloudId", cloudId);
                String cloudNum = rs.getString("FCLOUDNUM");
                this.putNotNull((Map<String, Object>)obj, "cloudNum", cloudNum);
                String dbRoute = rs.getString("FDBROUTE");
                this.putNotNull((Map<String, Object>)obj, "dbRoute", dbRoute);
                String image = rs.getString("FIMAGE");
                this.putNotNull((Map<String, Object>)obj, "image", image);
                String homeId = rs.getString("FHOMEID");
                this.putNotNull((Map<String, Object>)obj, "homeId", homeId);
                String homeNum = rs.getString("FHOMENUM");
                this.putNotNull((Map<String, Object>)obj, "homeNum", homeNum);
                String openType = rs.getString("FOPENTYPE");
                this.putNotNull((Map<String, Object>)obj, "openType", openType);
                boolean allUserApp = rs.getBoolean("FALLUSERAPP");
                this.putNotNull((Map<String, Object>)obj, "allUserApp", allUserApp);
                String userType = rs.getString("FUSERTYPE");
                this.putNotNull((Map<String, Object>)obj, "userType", userType);
                String orgFunc = rs.getString("FORGFUNC");
                this.putNotNull((Map<String, Object>)obj, "orgFunc", orgFunc);
                String data = rs.getString("FDATA");
                this.putNotNull((Map<String, Object>)obj, "data", data);
            }
            return obj;
        };
        JSONObject sRet = (JSONObject)this.getShareMetaData(number, tableName, sql, params, callBackHanlder);
        if (StringUtils.isNotBlank((Object)sRet)) {
            tableName = AppGroupUtils.getAppGroupTableName((String)appGroup, (String)"T_META_APPRUNTIME_L");
            String langSql = String.format(SQL_SELECT_FLOCALEID, tableName);
            SqlParameter[] parameters = new SqlParameter[]{new SqlParameter(FAPPID, 12, (Object)number)};
            ResultSetHandler callBackLangHanlder = rs -> {
                while (rs.next()) {
                    String localeId = rs.getString("FLOCALEID");
                    if (!StringUtils.isNotBlank((CharSequence)localeId)) continue;
                    String name = rs.getString("FNAME");
                    this.putNotNullLangObj((Map<String, Object>)sRet, "name", localeId, name);
                    String description = rs.getString("FDESCRIPTION");
                    this.putNotNullLangObj((Map<String, Object>)sRet, DESCRIPTION, localeId, description);
                }
                return null;
            };
            this.getShareMetaData(number, tableName, langSql, parameters, callBackLangHanlder);
        }
        return sRet != null && sRet.size() > 0 ? sRet.toJSONString() : null;
    }

    private String doQueryAppMenuMetaByAppId(String appNumber, String appGroup) {
        StringBuilder sb = new StringBuilder();
        String tableName = AppGroupUtils.getAppGroupTableName((String)appGroup, (String)"T_META_MENURUNTIME");
        sb.append("SELECT A.FID,A.FAPPID,A.FSEQ,A.FFORMID,A.FPARAMTYPE,A.FPARAMS,A.FOPENTYPE,A.FPERMISSION,A.FPARENTID,A.FNAVIVECTOR,A.FSHORTCUTICON,A.FDATA,C.FNUMBER ").append(" FROM ").append(tableName).append(" A left join ").append(AppGroupUtils.getAppGroupTableName((String)appGroup, (String)T_META_FORMDESIGN)).append(" B ON A.FFORMID = B.FNUMBER left join ").append(AppGroupUtils.getAppGroupTableName((String)appGroup, (String)"T_META_ENTITYDESIGN")).append(" C ON B.FENTITYID = C.FID WHERE FAPPID = ? ORDER BY FSEQ,FID");
        String sql = sb.toString();
        SqlParameter[] params = new SqlParameter[]{new SqlParameter(FAPPID, 12, (Object)appNumber)};
        ResultSetHandler callBackHanlder = rs -> {
            LinkedHashMap<String, JSONObject> objs = null;
            while (rs.next()) {
                JSONObject obj = new JSONObject();
                String id = rs.getString("FID");
                this.putNotNull((Map<String, Object>)obj, "id", id);
                String appId = rs.getString("FAPPID");
                this.putNotNull((Map<String, Object>)obj, "appId", appId);
                Short seq = rs.getShort("FSEQ");
                this.putNotNull((Map<String, Object>)obj, "seq", seq);
                String formId = rs.getString("FFORMID");
                this.putNotNull((Map<String, Object>)obj, "formId", formId);
                String entityNumber = rs.getString("FNUMBER");
                this.putNotNull((Map<String, Object>)obj, "entityNumber", entityNumber);
                String paramType = rs.getString("FPARAMTYPE");
                this.putNotNull((Map<String, Object>)obj, "paramType", paramType);
                String parameters = rs.getString("FPARAMS");
                this.putNotNull((Map<String, Object>)obj, "params", parameters);
                String openType = rs.getString("FOPENTYPE");
                this.putNotNull((Map<String, Object>)obj, "openType", openType);
                String permission = rs.getString("FPERMISSION");
                this.putNotNull((Map<String, Object>)obj, "permission", permission);
                String parentId = rs.getString("FPARENTID");
                this.putNotNull((Map<String, Object>)obj, "parentId", parentId);
                String naviVector = rs.getString("FNAVIVECTOR");
                this.putNotNull((Map<String, Object>)obj, "naviVector", naviVector);
                String shortcutIcon = rs.getString("FSHORTCUTICON");
                this.putNotNull((Map<String, Object>)obj, "shortcutIcon", shortcutIcon);
                String data = rs.getString("FDATA");
                this.putNotNull((Map<String, Object>)obj, "data", data);
                if (objs == null) {
                    objs = new LinkedHashMap<String, JSONObject>();
                }
                objs.put(id, obj);
            }
            return objs;
        };
        Map menus = (Map)this.getShareMetaData(appNumber, tableName, sql, params, callBackHanlder);
        if (StringUtils.isNotBlank((Object)menus)) {
            String ids = "'" + String.join((CharSequence)"','", menus.keySet()) + "'";
            tableName = AppGroupUtils.getAppGroupTableName((String)appGroup, (String)"T_META_MENURUNTIME_L");
            String langSql = String.format(SQL_SELECT_FLOCALEID_FID, tableName, ids);
            ResultSetHandler callBackLangHanlder = rs -> {
                while (rs.next()) {
                    String localeId = rs.getString("FLOCALEID");
                    String id = rs.getString("FID");
                    if (!StringUtils.isNotBlank((CharSequence)localeId) || !StringUtils.isNotBlank((CharSequence)id)) continue;
                    JSONObject sRet = (JSONObject)menus.get(id);
                    String name = rs.getString("FNAME");
                    this.putNotNullLangObj((Map<String, Object>)sRet, "name", localeId, name);
                    String description = rs.getString("FDESCRIPTION");
                    this.putNotNullLangObj((Map<String, Object>)sRet, DESCRIPTION, localeId, description);
                    String formName = rs.getString("FFORMNAME");
                    this.putNotNullLangObj((Map<String, Object>)sRet, "formName", localeId, formName);
                }
                return menus;
            };
            this.getShareMetaData(appNumber, tableName, langSql, new SqlParameter[0], callBackLangHanlder);
        }
        return this.getReturnMenus(appNumber, appGroup, menus);
    }

    private String getReturnMenus(String appNumber, String appGroup, Map<String, JSONObject> menus) {
        String rt = "";
        if (menus == null) {
            String appInfo = this.queryAppMeta(appNumber, appNumber, RuntimeMetaType.App, appGroup);
            if (appInfo != null) {
                rt = "[]";
            }
        } else {
            rt = menus.values().toString();
        }
        return rt;
    }

    public List<String> getExtAppIds(String number) {
        String sql = "select distinct fbizappid from " + this.getGrayTableName("T_META_ENTITY_fork") + " where fnumber = ? ";
        SqlParameter[] sqlParameters = new SqlParameter[]{new SqlParameter(":number", 12, (Object)number)};
        return (List)this.dbQuery.query(DBRoute.meta, sql, sqlParameters, rs -> {
            ArrayList<String> list = new ArrayList<String>(16);
            while (rs.next()) {
                list.add(rs.getString("fbizappid"));
            }
            return list;
        });
    }
}

