/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.sharemeta;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BOSRuntime;
import kd.bos.framework.gray.GrayStrategy;
import kd.bos.instance.AppGroup;
import kd.bos.metadata.dao.MetaCacheUtils;
import kd.bos.metadata.dao.MetaRebuilder;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.service.metadata.RuntimeMetadataShareService;
import kd.bos.service.sharemeta.MetadataShareServiceReader;

public class RuntimeMetadataShareServiceImpl
implements RuntimeMetadataShareService {
    private String appGroup;
    private final MetadataShareServiceReader reader = new MetadataShareServiceReader();

    public String getAppGroup() {
        return this.appGroup;
    }

    public void setAppGroup(String appGroup) {
        this.appGroup = appGroup;
    }

    public String loadFormRuntimeMeta(String formId, short formMetaType, String key) {
        return this.reader.loadFormRuntimeMeta(formId, formMetaType, key);
    }

    public String loadEntityRuntimeMeta(String entityNumber, int entityMetaType, String key) {
        return this.reader.loadEntityRuntimeMeta(entityNumber, entityMetaType, key);
    }

    public void removeCache(String formId) {
        MetaCacheUtils.removeDistributeCache((String[])new String[]{formId});
    }

    private void rebuildRuntimeMetaDiffVer(String number) {
        MetaRebuilder mr = new MetaRebuilder(this.appGroup);
        mr.rebuildRuntimeMetaDiffVer(number);
    }

    public String getRuntimeMetadataVersion(String formId) {
        String version = this.reader.getRuntimeFormMetaVersion(formId);
        if (BOSRuntime.checkBosVersionExpire((String)version)) {
            this.rebuildRuntimeMetaDiffVer(formId);
            this.removeCache(formId);
            version = this.reader.getRuntimeFormMetaVersion(formId);
        }
        return version;
    }

    public Map<String, String> batchLoadRuntimeMetadataVersion(Collection<String> numbers) {
        Map<String, String> numMaps = this.reader.batchLoadRuntimeFormMetaVersion(numbers);
        if (numMaps != null && !numMaps.isEmpty()) {
            boolean needReload = false;
            for (Map.Entry<String, String> it : numMaps.entrySet()) {
                if (!BOSRuntime.checkBosVersionExpire((String)it.getValue())) continue;
                this.rebuildRuntimeMetaDiffVer(it.getKey());
                this.removeCache(it.getKey());
                needReload = true;
            }
            if (needReload) {
                numMaps = this.reader.batchLoadRuntimeFormMetaVersion(numbers);
            }
        }
        return numMaps;
    }

    public String loadFormPluginScriptMeta(String formId, String ctlKey) {
        return this.reader.loadFormPluginScript(formId, ctlKey);
    }

    public String getEntityNumberById(String entityId) {
        return MetadataDao.getEntityNumberById((String)entityId);
    }

    public List<String> loadEntityAllOperationMeta(String number) {
        return this.reader.loadEntityAllOperationMeta(number);
    }

    public List<String> loadEntityNetCtrlOperationMeta(String number) {
        return this.reader.loadEntityNetCtrlOperationMeta(number);
    }

    public String loadTableDefine(String entityNumber, String entityKey) {
        return this.reader.loadTableDefine(entityNumber, entityKey);
    }

    public String loadTableDefine(Long tableId) {
        return this.reader.loadTableDefine(tableId);
    }

    public boolean isPrivateMeta(String formId) {
        return this.reader.isPrivateMeta(formId);
    }

    public String getMetaISV(String formId) {
        return this.reader.getMetaAppId(formId);
    }

    public String loadAppInfo(String appId) {
        RequestContext rc;
        Map map;
        String currentAppGroup;
        String infoStr = this.reader.loadAppInfo(AppGroup.getCurAppGroup(), appId);
        if (StringUtils.isBlank((CharSequence)infoStr) && StringUtils.isNotBlank((CharSequence)(currentAppGroup = (String)(map = GrayStrategy.getUserAppGroup((String)(rc = RequestContext.get()).getUserId(), (String)rc.getAccountId())).get(appId))) && !"defaultGroup".equals(currentAppGroup)) {
            infoStr = this.reader.loadAppInfo(currentAppGroup, appId);
        }
        return infoStr;
    }

    public String getAppMenusInfoByAppId(String appId) {
        return this.reader.getAppMenusInfoByAppId(appId);
    }

    public List<String> getExtAppIds(String number) {
        return this.reader.getExtAppIds(number);
    }
}

