/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.botp;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.instance.Instance;

public class BOTPServiceFactory {
    private static Map<String, String> serviceMap = new HashMap<String, String>();

    private BOTPServiceFactory() {
        throw new IllegalStateException("Utility class");
    }

    public static <T> T getSingletonService(Class<T> clazz) {
        return (T)BOTPServiceFactory.getService(clazz.getSimpleName(), true);
    }

    public static <T> T getPrototypeService(Class<T> clazz) {
        return (T)BOTPServiceFactory.getService(clazz.getSimpleName(), false);
    }

    public static void putService(String serviceName, String serviceImpl) {
        serviceMap.put(serviceName, serviceImpl);
    }

    public static Object getService(String serviceName, boolean isSingleton) {
        String className = serviceMap.get(serviceName);
        if (className == null) {
            String appName = Instance.getAppName();
            throw new RuntimeException(String.format(ResManager.loadKDString((String)"%1$s\u5bf9\u5e94\u7684\u670d\u52a1\u5b9e\u73b0\u5728%2$s\u672a\u627e\u5230", (String)"BOTPServiceFactory_0", (String)"bos-mservice-botp-api", (Object[])new Object[0]), serviceName, appName));
        }
        if (isSingleton) {
            return TypesContainer.getOrRegisterSingletonInstance((String)className);
        }
        return TypesContainer.createInstance((String)className);
    }

    static {
        serviceMap.put("IBFTrackerEngineProxy", "kd.bos.service.botp.track.BFTrackerEngineProxy");
        serviceMap.put("IConvertRuleMetaDaoPlugin", "kd.bos.metadata.botp.ConvertRuleMetaDaoPlugin");
        serviceMap.put("ICtConvertRuleMetaDaoPlugin", "kd.bos.metadata.ctbotp.CtConvertRuleMetaDaoPlugin");
        serviceMap.put("IWriteBackRuleMetaDaoPlugin", "kd.bos.metadata.botp.WriteBackRuleMetaDaoPlugin");
        serviceMap.put("IConvertRuleReaderProxy", "kd.bos.metadata.botp.ConvertRuleReaderProxy");
        serviceMap.put("IConvertRuleWriterProxy", "kd.bos.metadata.botp.ConvertRuleWriterProxy");
        serviceMap.put("IWriteBackRuleReaderProxy", "kd.bos.metadata.botp.WriteBackRuleReaderProxy");
        serviceMap.put("IWriteBackRuleWriterProxy", "kd.bos.metadata.botp.WriteBackRuleWriterProxy");
        serviceMap.put("IBFTrackerServiceHelperProxy", "kd.bos.servicehelper.botp.IBFTrackerServiceHelperProxy");
        serviceMap.put("IBOTPMetadataReaderProxy", "kd.bos.service.metadata.BOTPMetadataReaderProxy");
        serviceMap.put("ICtBOTPMetadataReaderProxy", "kd.bos.service.metadata.CtBOTPMetadataReaderProxy");
        serviceMap.put("IConvertRuleCacheProxy", "kd.bos.entity.botp.ConvertRuleCacheProxy");
        serviceMap.put("IWriteBackRuleCacheProxy", "kd.bos.entity.botp.WriteBackRuleCacheProxy");
        serviceMap.put("IBOTPFileUtilProxy", "kd.bos.devportal.plugin.botp.BOTPFileUtilProxy");
        serviceMap.put("ICtBFTrackerEngineProxy", "kd.bos.service.ctbotp.track.CtBFTrackerEngineProxy");
    }
}

