/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.formula.platform.api;

import java.util.Hashtable;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.kscript.ParserException;
import kd.bos.kscript.dom.expr.BoolExpr;
import kd.bos.kscript.dom.expr.CodeExpr;
import kd.bos.kscript.dom.expr.DoubleExpr;
import kd.bos.kscript.dom.expr.FloatExpr;
import kd.bos.kscript.dom.expr.IntExpr;
import kd.bos.kscript.dom.expr.LongExpr;
import kd.bos.kscript.dom.expr.NullExpr;
import kd.bos.kscript.dom.expr.StringExpr;
import kd.bos.kscript.parser.KScriptParser;
import kd.bos.kscript.parser.Lexer;
import kd.bos.kscript.parser.TokenList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

class KScriptFormulaParser {
    private static Hashtable<String, KScriptParser> parsedFormula = new Hashtable();
    private static final Log logger = LogFactory.getLog(KScriptFormulaParser.class);

    KScriptFormulaParser() {
    }

    public static KScriptParser parseFormulaStr(String formulaStr) throws ParserException {
        if (formulaStr == null) {
            return null;
        }
        KScriptParser oldParser = parsedFormula.get(formulaStr);
        if (oldParser != null) {
            return oldParser;
        }
        Lexer lexer = new Lexer(formulaStr);
        TokenList tokList = new TokenList(lexer);
        KScriptParser parser = new KScriptParser(tokList);
        try {
            parser.parse();
        }
        catch (Exception e) {
            logger.error("KScriptFormulaParser.parseFormulaStr parse fail,Script is illegal!", (Throwable)e);
            throw new ParserException("0", formulaStr, ResManager.loadKDString((String)"\u811a\u672c\u89e3\u6790\u51fa\u9519", (String)"KScriptFormulaParser_0", (String)"bos-formula-platform", (Object[])new Object[0]), (Throwable)e);
        }
        parsedFormula.put(formulaStr, parser);
        return parser;
    }

    public static String getConstantExprStr(CodeExpr codeExpr) {
        String retStr = "";
        if (codeExpr instanceof IntExpr) {
            IntExpr intExpr = (IntExpr)codeExpr;
            retStr = retStr + intExpr.intValue();
        } else if (codeExpr instanceof DoubleExpr) {
            DoubleExpr dblExpr = (DoubleExpr)codeExpr;
            retStr = retStr + dblExpr.doubleValue();
        } else if (codeExpr instanceof LongExpr) {
            LongExpr longExpr = (LongExpr)codeExpr;
            retStr = retStr + longExpr.longValue();
        } else if (codeExpr instanceof FloatExpr) {
            FloatExpr floatExpr = (FloatExpr)codeExpr;
            retStr = retStr + floatExpr.floatValue();
        } else if (codeExpr instanceof StringExpr) {
            StringExpr strExpr = (StringExpr)codeExpr;
            String originStr = strExpr.text;
            StringBuilder jsStr = new StringBuilder(originStr);
            jsStr = new StringBuilder();
            for (int i = 0; i < originStr.length(); ++i) {
                char currChar = originStr.charAt(i);
                if (currChar == '\n') {
                    jsStr.append("\\n");
                    continue;
                }
                if (currChar == '\r') {
                    jsStr.append("\\r");
                    continue;
                }
                if (currChar == '\f') {
                    jsStr.append("\\f");
                    continue;
                }
                if (currChar == '\b') {
                    jsStr.append("\\b");
                    continue;
                }
                if (currChar == '\t') {
                    jsStr.append("\\t");
                    continue;
                }
                if (currChar == '\"') {
                    jsStr.append("\\\"");
                    continue;
                }
                if (currChar == '\'') {
                    jsStr.append("\\'");
                    continue;
                }
                if (currChar == '\\') {
                    jsStr.append("\\\\");
                    continue;
                }
                jsStr.append(currChar);
            }
            retStr = retStr + "\"" + jsStr + "\"";
        } else if (codeExpr instanceof NullExpr) {
            NullExpr nullExpr = (NullExpr)codeExpr;
            retStr = retStr + nullExpr.toString();
        } else if (codeExpr instanceof BoolExpr) {
            BoolExpr boolExpr = (BoolExpr)codeExpr;
            retStr = retStr + boolExpr.toString();
        }
        return retStr;
    }
}

