/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.formula.platform.builder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.formula.platform.api.BaseFormulaFunctions;
import kd.bos.formula.platform.api.FuncInfo;
import kd.bos.formula.platform.api.IFormulaFunctions;
import kd.bos.formula.platform.api.VarInfo;
import kd.bos.metadata.treebuilder.PropTreeBuildOption;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class FormulaDesignerParameter {
    public static final int MODE_Script = 0;
    public static final int MODE_Formula = 1;
    public static final int MODE_KSQL = 2;
    public static final int MODE_HR = 3;
    private int runMode = 0;
    private String formulaStr;
    private boolean editable = true;
    private Map<String, PropTreeBuildOption> entities = new HashMap<String, PropTreeBuildOption>();
    private List<VarInfo> varInfos = new ArrayList<VarInfo>();
    private List<FuncInfo> funcInfos = new ArrayList<FuncInfo>();

    public void setRunMode(int runMode) {
        this.runMode = runMode;
    }

    public int getRunMode() {
        return this.runMode;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setFormulaStr(String formulaStr) {
        this.formulaStr = formulaStr;
    }

    public String getFormulaStr() {
        return this.formulaStr;
    }

    public Map<String, PropTreeBuildOption> getEntities() {
        return this.entities;
    }

    public void setEntities(Map<String, PropTreeBuildOption> entities) {
        this.entities = entities;
    }

    public void addEntity(String entityNumber) {
        this.entities.put(entityNumber, null);
    }

    public void addEntity(String entityNumber, PropTreeBuildOption option) {
        this.entities.put(entityNumber, option);
    }

    public void setVarInfos(List<VarInfo> varInfos) {
        this.varInfos = varInfos == null ? new ArrayList<VarInfo>() : new ArrayList<VarInfo>(varInfos);
    }

    public List<VarInfo> getVarInfos() {
        return new ArrayList<VarInfo>(this.varInfos);
    }

    public void addVarInfo(VarInfo varInfo) {
        this.varInfos.add(varInfo);
    }

    public List<FuncInfo> getFuncInfos() {
        return new ArrayList<FuncInfo>(this.funcInfos);
    }

    public void setFuncInfos(List<FuncInfo> funcInfos) {
        this.funcInfos = funcInfos == null ? new ArrayList<FuncInfo>() : new ArrayList<FuncInfo>(funcInfos);
    }

    public void clearFunctions() {
        this.funcInfos.clear();
    }

    public void addBaseFormulaFunctions() {
        BaseFormulaFunctions functions = new BaseFormulaFunctions();
        this.addFormulaFunctions(functions);
    }

    public void addFormulaFunctions(IFormulaFunctions functions) {
        String[] funcNames;
        if (functions == null) {
            return;
        }
        for (String funcName : funcNames = functions.getAllFuncNames()) {
            FuncInfo funcInfo = new FuncInfo(funcName, functions.getFuncCaption(funcName), functions.getFuncFormula(funcName), functions.getFuncCategory(funcName), functions.getFuncDesc(funcName), functions.getParaFormId(funcName));
            this.funcInfos.add(funcInfo);
        }
    }

    public void addBatchFormulaFunctions(List<IFormulaFunctions> functions) {
        if (functions == null || functions.size() <= 0) {
            return;
        }
        for (int i = 0; i < functions.size(); ++i) {
            this.addFormulaFunctions(functions.get(i));
        }
    }
}

