/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.formula.platform.builder;

import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.tree.TreeNode;
import kd.bos.formula.platform.api.FuncInfo;

class FuncCategory {
    public static final String Category_Unknow = "unknown";
    private String categoryName = "unknown";
    private static final String BOS_FORMULA_PLATFORM = "bos-formula-platform";
    private Map<String, FuncInfo> funcs = new LinkedHashMap<String, FuncInfo>();

    public FuncCategory() {
    }

    public FuncCategory(String category) {
        this.categoryName = category;
    }

    public void setName(String category) {
        this.categoryName = category;
    }

    public String getName() {
        return this.categoryName;
    }

    public String getCaption() {
        String caption = this.categoryName;
        switch (this.categoryName) {
            case "MATH": {
                caption = ResManager.loadKDString((String)"\u6570\u5b66\u51fd\u6570", (String)"FuncCategory_0", (String)BOS_FORMULA_PLATFORM, (Object[])new Object[0]);
                break;
            }
            case "IO": {
                caption = ResManager.loadKDString((String)"I/O \u51fd\u6570", (String)"FuncCategory_1", (String)BOS_FORMULA_PLATFORM, (Object[])new Object[0]);
                break;
            }
            case "NULLJUDGE": {
                caption = ResManager.loadKDString((String)"\u7a7a\u5904\u7406\u51fd\u6570", (String)"FuncCategory_2", (String)BOS_FORMULA_PLATFORM, (Object[])new Object[0]);
                break;
            }
            case "OTHER": {
                caption = ResManager.loadKDString((String)"\u5176\u4ed6\u51fd\u6570", (String)"FuncCategory_3", (String)BOS_FORMULA_PLATFORM, (Object[])new Object[0]);
                break;
            }
            case "SET": {
                caption = ResManager.loadKDString((String)"\u805a\u5408\u51fd\u6570", (String)"FuncCategory_4", (String)BOS_FORMULA_PLATFORM, (Object[])new Object[0]);
                break;
            }
            case "STRING": {
                caption = ResManager.loadKDString((String)"\u5b57\u7b26\u4e32\u51fd\u6570", (String)"FuncCategory_5", (String)BOS_FORMULA_PLATFORM, (Object[])new Object[0]);
                break;
            }
            case "TIME": {
                caption = ResManager.loadKDString((String)"\u65f6\u95f4\u65e5\u671f\u51fd\u6570", (String)"FuncCategory_6", (String)BOS_FORMULA_PLATFORM, (Object[])new Object[0]);
                break;
            }
            case "unknown": {
                caption = ResManager.loadKDString((String)"\u672a\u5206\u7c7b", (String)"FuncCategory_7", (String)BOS_FORMULA_PLATFORM, (Object[])new Object[0]);
                break;
            }
            default: {
                return this.categoryName;
            }
        }
        return caption;
    }

    public Map<String, FuncInfo> getFuncs() {
        return this.funcs;
    }

    public void setFuncs(Map<String, FuncInfo> funcs) {
        this.funcs = funcs;
    }

    public FuncInfo findFunc(String funcName) {
        return this.funcs.get(funcName);
    }

    public void add(FuncInfo func) {
        this.funcs.put(func.getFuncName(), func);
    }

    public TreeNode buildFuncTree(TreeNode parent) {
        TreeNode selfNode = new TreeNode();
        selfNode.setParentid(parent == null ? "" : parent.getId());
        selfNode.setId(this.getName());
        selfNode.setIsOpened(false);
        selfNode.setText(this.getCaption());
        for (Map.Entry<String, FuncInfo> item : this.funcs.entrySet()) {
            TreeNode childNode = item.getValue().buildFuncTree(selfNode);
            selfNode.addChild(childNode);
        }
        return selfNode;
    }

    public String toString() {
        return this.categoryName;
    }
}

