/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.formula.platform.engine;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicCollectionProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicComplexProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.formula.platform.api.IVarInfo;
import kd.bos.formula.platform.engine.AliasTransformer;
import kd.bos.kscript.ParserException;
import kd.bos.kscript.parser.Lexer;
import kd.bos.kscript.parser.Token;
import kd.bos.kscript.parser.TokenList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

class BOSObjectRetransformerHelper {
    public static final String TYPE_VARINFO = "varinfo";
    public static final String TYPE_PROPERTY = "property";
    public static final String TYPE_METHOD = "method";
    public static final String TYPE_OTHER = "other";
    public static final String TYPE_CONSTANT = "constant";
    private HashMap<String, EntityType> boMap;
    private TokenList tokenlist;
    private Vector<IVarInfo> varList;
    private List<String> analyseList = new ArrayList<String>();
    private static Set<String> chineseKeywords = new HashSet<String>();
    private static Log logger = LogFactory.getLog(BOSObjectRetransformerHelper.class);
    public static final String BOS_FORMULA_PLATFORM = "bos-formula-platform";

    public BOSObjectRetransformerHelper(HashMap<String, EntityType> bos, Vector<IVarInfo> vars, TokenList tokens) {
        this.boMap = bos;
        this.varList = vars;
        this.tokenlist = tokens;
        try {
            this.analyse();
        }
        catch (ParserException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private void analyse() throws ParserException {
        Token token;
        if (this.tokenlist == null) {
            return;
        }
        this.analyseList.clear();
        int index = 0;
        while ((token = this.tokenlist.lookup(index)) != null && token.type != 12) {
            if (this.isVarinfo(token)) {
                this.analyseList.add(TYPE_VARINFO);
            } else if (this.isProperty(index)) {
                this.analyseList.add(TYPE_PROPERTY);
            } else if (this.isMethod(index)) {
                this.analyseList.add(TYPE_METHOD);
            } else if (this.isConstant(index)) {
                this.analyseList.add(TYPE_CONSTANT);
            } else {
                this.analyseList.add(TYPE_OTHER);
            }
            ++index;
        }
    }

    private boolean isVarinfo(Token token) {
        if (this.varList != null && token != null) {
            for (IVarInfo varinfo : this.varList) {
                String name = varinfo.getVarName();
                if (!name.equals(token.value)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isProperty(int index) throws ParserException {
        if (this.tokenlist != null && index > 0) {
            Token self = this.tokenlist.lookup(index);
            if (self != null && self.type != 1) {
                return false;
            }
            Token beforeToken = this.tokenlist.lookup(index - 1);
            Token afterToken = this.tokenlist.lookup(index + 1);
            if (beforeToken.value != null && beforeToken.value.equals(".") && (afterToken == null || afterToken.type == 12 || Token.PeriodToken.equals(afterToken) || 4 == afterToken.type || afterToken.value.equals(";") || 5 == afterToken.type && !Token.OpenBraceToken.equals(afterToken))) {
                return true;
            }
        }
        return false;
    }

    private boolean isMethod(int index) throws ParserException {
        if (this.tokenlist != null && index > 0) {
            Token self = this.tokenlist.lookup(index);
            Token token = this.tokenlist.lookup(index + 1);
            Token bToken = this.tokenlist.lookup(index - 1);
            if (1 == self.type && 5 == token.type && Token.OpenBraceToken.equals(token) && bToken.value != null && bToken.value.equals(".")) {
                return true;
            }
        }
        return false;
    }

    private boolean isConstant(int index) throws ParserException {
        if (index < 1) {
            return false;
        }
        Token token = this.tokenlist.lookup(index);
        return 6 == token.type;
    }

    private IVarInfo getVarinfoByName(String varName) {
        if (this.varList != null) {
            for (IVarInfo varinfo : this.varList) {
                String name = varinfo.getVarName();
                if (!name.equals(varName)) continue;
                return varinfo;
            }
        }
        return null;
    }

    public TokenList getAliasTokenList() throws ParserException {
        Token token;
        StringBuilder aliassb = new StringBuilder();
        int index = 0;
        while ((token = this.tokenlist.lookup(index)) != null && token.type != 12) {
            if (this.isVarinfo(token)) {
                IVarInfo var = this.getVarinfoByName(token.value);
                if (var != null) {
                    aliassb.append(var.getVarAlias());
                }
            } else if (this.isProperty(index)) {
                IDataEntityProperty prop;
                EntityType parent = this.getPropertyOrMethodBO(index);
                boolean find = false;
                if (parent != null && (prop = (IDataEntityProperty)parent.getProperties().get((Object)token.value)) != null) {
                    if (StringUtils.equals((CharSequence)"id", (CharSequence)token.value)) {
                        aliassb.append(ResManager.loadKDString((String)"\u5185\u7801", (String)"BOSObjectRetransformerHelper_13", (String)BOS_FORMULA_PLATFORM, (Object[])new Object[0]));
                    } else {
                        aliassb.append(prop.getDisplayName() == null ? token.value : AliasTransformer.propTransform(prop.getDisplayName().toString()));
                    }
                    find = true;
                }
                if (!find) {
                    aliassb.append(token.value);
                    break;
                }
            } else if (this.isMethod(index)) {
                aliassb.append(token.value);
            } else if (this.isConstant(index)) {
                aliassb.append("\"");
                aliassb.append(token.value);
                aliassb.append("\"");
            } else {
                boolean flag = false;
                if (chineseKeywords.contains(token.value)) {
                    flag = true;
                }
                if (flag) {
                    aliassb.append(" ");
                    aliassb.append(token.value);
                    aliassb.append(" ");
                } else if (token.value.equals("if") || token.value.equals("else")) {
                    aliassb.append(token.value);
                    aliassb.append(" ");
                } else if (token.value.equals("new")) {
                    aliassb.append(token.value);
                    aliassb.append(" ");
                } else {
                    aliassb.append(token.value);
                }
            }
            ++index;
        }
        Lexer _lexer = new Lexer(aliassb.toString());
        TokenList _tokenList = new TokenList(_lexer);
        return _tokenList;
    }

    private EntityType getPropertyOrMethodBO(int index) throws ParserException {
        EntityType parent;
        if (index < 2) {
            return null;
        }
        Token beforToken = this.tokenlist.lookup(index - 2);
        String type = this.analyseList.get(index - 2);
        while (!TYPE_VARINFO.equals(type) && !TYPE_PROPERTY.equals(type) && TYPE_METHOD.equals(type) && --index >= 0) {
            beforToken = this.tokenlist.lookup(index);
            type = this.analyseList.get(index);
        }
        if (TYPE_VARINFO.equals(type)) {
            String varName;
            IVarInfo var = this.getVarinfoByName(beforToken.value);
            if (var != null && this.boMap.containsKey(varName = var.getVarName())) {
                return this.boMap.get(varName);
            }
        } else if (TYPE_PROPERTY.equals(type)) {
            EntityType parent2 = this.getPropertyOrMethodBO(index - 2);
            if (parent2 != null) {
                DynamicProperty prop = parent2.getProperty(beforToken.value);
                if (prop instanceof DynamicCollectionProperty) {
                    return (EntityType)((DynamicCollectionProperty)prop).getItemType();
                }
                if (prop instanceof DynamicComplexProperty) {
                    return (EntityType)((DynamicComplexProperty)prop).getComplexType();
                }
            }
        } else if (TYPE_METHOD.equals(type) && (parent = this.getPropertyOrMethodBO(index - 2)) != null) {
            DynamicProperty prop = parent.getProperty(beforToken.value);
            if (prop instanceof DynamicCollectionProperty) {
                return (EntityType)((DynamicCollectionProperty)prop).getItemType();
            }
            if (prop instanceof DynamicComplexProperty) {
                return (EntityType)((DynamicComplexProperty)prop).getComplexType();
            }
        }
        return null;
    }

    static {
        chineseKeywords.add(ResManager.loadKDString((String)"\u662f", (String)"BOSObjectRetransformerHelper_0", (String)BOS_FORMULA_PLATFORM, (Object[])new Object[0]));
        chineseKeywords.add(ResManager.loadKDString((String)"\u5982\u679c", (String)"BOSObjectRetransformerHelper_1", (String)BOS_FORMULA_PLATFORM, (Object[])new Object[0]));
        chineseKeywords.add(ResManager.loadKDString((String)"\u5426\u5219", (String)"BOSObjectRetransformerHelper_2", (String)BOS_FORMULA_PLATFORM, (Object[])new Object[0]));
        chineseKeywords.add(ResManager.loadKDString((String)"\u5426\u5219\u5982\u679c", (String)"BOSObjectRetransformerHelper_3", (String)BOS_FORMULA_PLATFORM, (Object[])new Object[0]));
        chineseKeywords.add(ResManager.loadKDString((String)"\u5374", (String)"BOSObjectRetransformerHelper_4", (String)BOS_FORMULA_PLATFORM, (Object[])new Object[0]));
        chineseKeywords.add(ResManager.loadKDString((String)"\u6216", (String)"BOSObjectRetransformerHelper_5", (String)BOS_FORMULA_PLATFORM, (Object[])new Object[0]));
        chineseKeywords.add(ResManager.loadKDString((String)"\u4e0d\u662f", (String)"BOSObjectRetransformerHelper_6", (String)BOS_FORMULA_PLATFORM, (Object[])new Object[0]));
        chineseKeywords.add(ResManager.loadKDString((String)"\u5927\u4e8e", (String)"BOSObjectRetransformerHelper_7", (String)BOS_FORMULA_PLATFORM, (Object[])new Object[0]));
        chineseKeywords.add(ResManager.loadKDString((String)"\u5927\u4e8e\u7b49\u4e8e", (String)"BOSObjectRetransformerHelper_8", (String)BOS_FORMULA_PLATFORM, (Object[])new Object[0]));
        chineseKeywords.add(ResManager.loadKDString((String)"\u7b49\u4e8e", (String)"BOSObjectRetransformerHelper_9", (String)BOS_FORMULA_PLATFORM, (Object[])new Object[0]));
        chineseKeywords.add(ResManager.loadKDString((String)"\u5c0f\u4e8e", (String)"BOSObjectRetransformerHelper_10", (String)BOS_FORMULA_PLATFORM, (Object[])new Object[0]));
        chineseKeywords.add(ResManager.loadKDString((String)"\u5c0f\u4e8e\u7b49\u4e8e", (String)"BOSObjectRetransformerHelper_11", (String)BOS_FORMULA_PLATFORM, (Object[])new Object[0]));
        chineseKeywords.add(ResManager.loadKDString((String)"\u4e0d\u7b49\u4e8e", (String)"BOSObjectRetransformerHelper_12", (String)BOS_FORMULA_PLATFORM, (Object[])new Object[0]));
    }
}

