/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.formula.platform.engine;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.formula.platform.engine.IKScriptTransformer;
import kd.bos.kscript.ParserException;
import kd.bos.kscript.parser.Token;
import kd.bos.kscript.parser.TokenList;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

class KeyWordTransformer
implements IKScriptTransformer {
    private static final Log logger = LogFactory.getLog(KeyWordTransformer.class);
    private static final String ELSEIF = "elseif";
    public static final String BOS_FORMULA_PLATFORM = "bos-formula-platform";
    private Map keywordMappingCache;
    private Token[] keywords;

    KeyWordTransformer() {
    }

    public String[] getKeyWords() {
        this.setUpKeyWords();
        String[] ss1 = new String[this.keywordMappingCache.size()];
        ss1 = this.keywordMappingCache.keySet().toArray(ss1);
        String[] ss2 = new String[this.keywords.length + ss1.length];
        for (int i = 0; i < this.keywords.length; ++i) {
            ss2[i] = this.keywords[i].value;
        }
        System.arraycopy(ss1, 0, ss2, this.keywords.length, ss1.length);
        return ss2;
    }

    private void setUpKeyWords() {
        if (this.keywords == null) {
            this.keywords = KeyWordTransformer.getAllPreDefinedTokens();
        }
        if (this.keywordMappingCache != null) {
            return;
        }
        this.keywordMappingCache = new HashMap(32);
        HashMap<String, String[]> keywordResurce = new HashMap<String, String[]>(16);
        Locale locale = Lang.get().getLocale();
        if (StringUtils.equals((CharSequence)locale.toString(), (CharSequence)"zh_CN") || StringUtils.equals((CharSequence)locale.toString(), (CharSequence)"zh_TW")) {
            keywordResurce.put("if", new String[]{ResManager.loadKDString((String)"\u5982\u679c", (String)"KeyWordTransformer_0", (String)BOS_FORMULA_PLATFORM, (Object[])new Object[0])});
            keywordResurce.put("else", new String[]{ResManager.loadKDString((String)"\u5426\u5219", (String)"KeyWordTransformer_1", (String)BOS_FORMULA_PLATFORM, (Object[])new Object[0])});
            keywordResurce.put(ELSEIF, new String[]{ResManager.loadKDString((String)"\u5426\u5219\u5982\u679c", (String)"KeyWordTransformer_2", (String)BOS_FORMULA_PLATFORM, (Object[])new Object[0])});
            keywordResurce.put("then", new String[]{ResManager.loadKDString((String)"\u90a3\u4e48", (String)"KeyWordTransformer_3", (String)BOS_FORMULA_PLATFORM, (Object[])new Object[0])});
            keywordResurce.put("==", new String[]{ResManager.loadKDString((String)"\u7b49\u4e8e", (String)"KeyWordTransformer_4", (String)BOS_FORMULA_PLATFORM, (Object[])new Object[0]), ResManager.loadKDString((String)"\u662f", (String)"KeyWordTransformer_5", (String)BOS_FORMULA_PLATFORM, (Object[])new Object[0])});
            keywordResurce.put("!=", new String[]{ResManager.loadKDString((String)"\u4e0d\u7b49\u4e8e", (String)"KeyWordTransformer_6", (String)BOS_FORMULA_PLATFORM, (Object[])new Object[0])});
            keywordResurce.put(">", new String[]{ResManager.loadKDString((String)"\u5927\u4e8e", (String)"KeyWordTransformer_7", (String)BOS_FORMULA_PLATFORM, (Object[])new Object[0])});
            keywordResurce.put(">=", new String[]{ResManager.loadKDString((String)"\u5927\u4e8e\u7b49\u4e8e", (String)"KeyWordTransformer_8", (String)BOS_FORMULA_PLATFORM, (Object[])new Object[0])});
            keywordResurce.put("<", new String[]{ResManager.loadKDString((String)"\u5c0f\u4e8e", (String)"KeyWordTransformer_9", (String)BOS_FORMULA_PLATFORM, (Object[])new Object[0])});
            keywordResurce.put("<=", new String[]{ResManager.loadKDString((String)"\u5c0f\u4e8e\u7b49\u4e8e", (String)"KeyWordTransformer_10", (String)BOS_FORMULA_PLATFORM, (Object[])new Object[0])});
            keywordResurce.put("&&", new String[]{ResManager.loadKDString((String)"\u4e14", (String)"KeyWordTransformer_11", (String)BOS_FORMULA_PLATFORM, (Object[])new Object[0]), ResManager.loadKDString((String)"\u5e76\u4e14", (String)"KeyWordTransformer_12", (String)BOS_FORMULA_PLATFORM, (Object[])new Object[0])});
            keywordResurce.put("||", new String[]{ResManager.loadKDString((String)"\u6216\u8005", (String)"KeyWordTransformer_13", (String)BOS_FORMULA_PLATFORM, (Object[])new Object[0]), ResManager.loadKDString((String)"\u6216", (String)"KeyWordTransformer_14", (String)BOS_FORMULA_PLATFORM, (Object[])new Object[0])});
        } else {
            keywordResurce.put("if", new String[]{"if"});
            keywordResurce.put("else", new String[]{"else"});
            keywordResurce.put(ELSEIF, new String[]{ELSEIF});
            keywordResurce.put("then", new String[]{"then"});
            keywordResurce.put("==", new String[]{"equalTo"});
            keywordResurce.put("!=", new String[]{"notEqualTo"});
            keywordResurce.put(">", new String[]{">"});
            keywordResurce.put(">=", new String[]{">="});
            keywordResurce.put("<", new String[]{"<"});
            keywordResurce.put("<=", new String[]{"<="});
            keywordResurce.put("&&", new String[]{"and"});
            keywordResurce.put("||", new String[]{"or"});
        }
        for (Map.Entry entry : keywordResurce.entrySet()) {
            String name = (String)entry.getKey();
            boolean match = false;
            for (int i = 0; i < this.keywords.length; ++i) {
                Token keyword = this.keywords[i];
                if (!name.equalsIgnoreCase(keyword.value)) continue;
                match = true;
                String[] ss = (String[])entry.getValue();
                for (int j = 0; j < ss.length; ++j) {
                    this.keywordMappingCache.put(ss[j], keyword);
                }
            }
            if (match) continue;
            String[] ss = (String[])entry.getValue();
            for (int j = 0; j < ss.length; ++j) {
                this.keywordMappingCache.put(ss[j], new Token(3, name));
            }
        }
    }

    @Override
    public TokenList transform(TokenList tokenList) throws ParserException {
        Token k;
        this.setUpKeyWords();
        int index = 0;
        while ((k = tokenList.lookup(index)) != null && k.type != 12) {
            if (this.keywordMappingCache.get(k.value) != null) {
                Token _k = (Token)this.keywordMappingCache.get(k.value);
                k.type = _k.type;
                k.value = _k.value;
            }
            ++index;
        }
        return tokenList;
    }

    static Token[] getAllPreDefinedTokens() {
        Field[] fields = Token.class.getFields();
        ArrayList<Token> keywords = new ArrayList<Token>(fields.length);
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            if (!Modifier.isStatic(field.getModifiers()) || !field.getDeclaringClass().equals(Token.class)) continue;
            try {
                Token keyword = (Token)field.get(null);
                keywords.add(keyword);
                continue;
            }
            catch (Exception e) {
                logger.error("", (Throwable)e);
            }
        }
        return keywords.toArray(new Token[keywords.size()]);
    }

    @Override
    public TokenList reverseTransform(TokenList tokenList) throws ParserException {
        Token k;
        this.setUpKeyWords();
        int index = 0;
        while ((k = tokenList.lookup(index)) != null && k.type != 12) {
            Set entrySet = this.keywordMappingCache.entrySet();
            for (Map.Entry element : entrySet) {
                if (!(element.getValue() instanceof Token) || !k.equals((Token)element.getValue())) continue;
                k.type = 1;
                k.value = (String)element.getKey();
                break;
            }
            ++index;
        }
        return tokenList;
    }

    TokenList fixSpace(TokenList tokenList) throws ParserException {
        Token k;
        int index = 0;
        while ((k = tokenList.lookup(index)) != null && k.type != 12) {
            if (k.type == 4) {
                Token next = tokenList.lookup(index + 1);
                if (k.space.length() == 0) {
                    k.space = " ";
                }
                if (next != null && next.space.length() == 0) {
                    next.space = " ";
                }
            }
            ++index;
        }
        return tokenList;
    }
}

