/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.base;

import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.filter.FilterUtil;
import kd.bos.entity.property.IBasedataField;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.ICorePermissionService;
import kd.bos.service.ServiceFactory;

public class BasedataQFilterBuilder {
    private BasedataQFilterBuilder() {
    }

    public static QFilter getSpecialDataPermissionFilter(String appId, String entityNumber, String operateKey) {
        ICorePermissionService permissionService = (ICorePermissionService)ServiceFactory.getService(ICorePermissionService.class);
        StringBuilder sb = new StringBuilder();
        return permissionService.getOperationRuleFilter(appId, entityNumber, operateKey, sb);
    }

    public static List<QFilter> getDataPermFilter(String appId, String entityNumber) {
        long userId = RequestContext.get().getCurrUserId();
        return FilterUtil.buildDataPermFilter(userId, appId, entityNumber);
    }

    public static List<QFilter> getBaseDataPropertyQFilters(IDataModel model, String entityNumber, IBasedataField basedataProp, String appId, String permissionItem) {
        return FilterUtil.buildBaseDataPropertyQFilters(model, entityNumber, basedataProp, appId, permissionItem);
    }

    public static QFilter getDataRuleForBdProp(String appId, String entityTypeId, String basedataFieldKey, String perItemId) {
        long userId = RequestContext.get().getCurrUserId();
        ICorePermissionService permissionService = (ICorePermissionService)ServiceFactory.getService(ICorePermissionService.class);
        return permissionService.getDataRuleForBdProp(userId, appId, entityTypeId, basedataFieldKey, perItemId);
    }

    public static QFilter getDataRuleForBdProp(String appId, String entityTypeId, String basedataFieldKey, String perItemId, Map<String, Object> customParam) {
        long userId = RequestContext.get().getCurrUserId();
        ICorePermissionService permissionService = (ICorePermissionService)ServiceFactory.getService(ICorePermissionService.class);
        return permissionService.getDataRuleForBdProp(userId, appId, entityTypeId, basedataFieldKey, perItemId, customParam);
    }
}

