/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.config;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import kd.bos.cache.ThreadCache;
import kd.bos.config.RateLimiterConfigProvider;
import kd.bos.config.RateLimiterConfiguration;
import kd.bos.config.RateLimiterDefValue;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.param.service.IParameterReaderService;
import kd.bos.service.ServiceSvcFactory;
import kd.bos.session.SystemPropertyUtils;

public class DefaultRateLimiterConfiguration
implements RateLimiterConfiguration {
    private static final Log log = LogFactory.getLog(DefaultRateLimiterConfiguration.class);
    public static final String KEY_PREFIX = "defaultratelimiterconfig_";
    private static final int CLIENTVIEW_RULEACTION_LIMITCOUNT_MAX = 5000000;
    private static final Map<String, String> limiterDefProps = new HashMap<String, String>(30);
    private static IParameterReaderService parameterReaderService;

    @Override
    public int getDefValue(String key) {
        int def = DefaultRateLimiterConfiguration.getResPropValue(key);
        return RateLimiterDefValue.get().getDefValue(key, def);
    }

    @Override
    public int getRuleActionLimitCount() {
        int limitCount = this.readSysProperty("clientview.ruleaction.limitcount", this.getDefValue("clientview.ruleaction.limitcount"));
        return Math.min(limitCount, 5000000);
    }

    @Override
    public int getFormEntryRowsLimit(String formId) {
        return (Integer)ThreadCache.get((Object)DefaultRateLimiterConfiguration.getThreadCacheKey(formId, "bos.new.form.rows.limit"), () -> this.getLimitCount(formId, "bos.new.form.rows.limit"));
    }

    @Override
    public int getFormEntryCellsLimit(String formId) {
        return (Integer)ThreadCache.get((Object)DefaultRateLimiterConfiguration.getThreadCacheKey(formId, "bos.new.form.cells.limit"), () -> this.getLimitCount(formId, "bos.new.form.cells.limit"));
    }

    @Override
    public int getBillEntryRowsLimit(String formId) {
        return (Integer)ThreadCache.get((Object)DefaultRateLimiterConfiguration.getThreadCacheKey(formId, "bos.new.bill.rows.limit"), () -> this.getLimitCount(formId, "bos.new.bill.rows.limit"));
    }

    @Override
    public int getBillEntryCellsLimit(String formId) {
        return (Integer)ThreadCache.get((Object)DefaultRateLimiterConfiguration.getThreadCacheKey(formId, "bos.new.bill.cells.limit"), () -> this.getLimitCount(formId, "bos.new.bill.cells.limit"));
    }

    @Override
    public int getViewCacheLimitCount() {
        return (Integer)ThreadCache.get((Object)DefaultRateLimiterConfiguration.getThreadCacheKey("", "bos.viewcache.limit"), () -> this.readSysProperty("bos.viewcache.limit", this.getDefValue("bos.viewcache.limit")));
    }

    @Override
    public int getQueryPKLimit() {
        return this.getDefValue("bos.query.pks.limit");
    }

    @Override
    public int getRuleDataEntitiesLimit() {
        return (Integer)ThreadCache.get((Object)DefaultRateLimiterConfiguration.getThreadCacheKey("", "bos.rule.dataentities.limit"), () -> this.readSysProperty("bos.rule.dataentities.limit", this.getDefValue("bos.rule.dataentities.limit")));
    }

    @Override
    public int getQueryRowsLimit() {
        return this.getDefValue("bos.query.rows.limit");
    }

    @Override
    public int getQueryCellsLimit() {
        return this.getDefValue("bos.query.cells.limit");
    }

    @Override
    public int getLoadBillsLimit() {
        return this.getDefValue("bos.load.bills.limit");
    }

    @Override
    public int getDeleteBillsLimit() {
        return this.readSysProperty("bos.delete.bills.limit", this.getDefValue("bos.delete.bills.limit"));
    }

    protected final int readSysProperty(String key, int def) {
        String tenantCode = RequestContext.get().getTenantCode();
        String limitCountStr = System.getProperty(tenantCode + "_" + key);
        if (StringUtils.isBlank((CharSequence)limitCountStr)) {
            limitCountStr = System.getProperty(key);
        }
        if (StringUtils.isBlank((CharSequence)limitCountStr)) {
            return def;
        }
        int val = Integer.parseInt(limitCountStr);
        return val == 0 ? def : val;
    }

    private int getLimitCount(String formId, String mckey) {
        int limitCount = this.getDefValue(mckey);
        String mcvalue = this.getMCValue(formId, mckey);
        if (StringUtils.isNotEmpty((CharSequence)mcvalue)) {
            limitCount = Integer.parseInt(mcvalue);
        }
        return limitCount;
    }

    private String getMCValue(String formId, String mckey) {
        String mcvalue = "";
        String code = RequestContext.get().getTenantCode();
        if (StringUtils.isNotEmpty((CharSequence)formId)) {
            mcvalue = SystemPropertyUtils.getProptyByTenant((String)(mckey + "_" + formId), (String)code);
        }
        if (StringUtils.isEmpty((CharSequence)mcvalue)) {
            mcvalue = SystemPropertyUtils.getProptyByTenant((String)mckey, (String)code);
        }
        return mcvalue;
    }

    private static String getThreadCacheKey(String formId, String mckey) {
        return String.format("%s_%s_%s", KEY_PREFIX, formId, mckey);
    }

    private static int getResPropValue(String key) {
        String val = null;
        if (limiterDefProps.isEmpty()) {
            Properties prop = new Properties();
            String fileName = "RateLimiterDefValue.properties";
            try (InputStream input = RateLimiterConfigProvider.class.getClassLoader().getResourceAsStream(fileName);){
                prop.load(new InputStreamReader(input, StandardCharsets.UTF_8));
                for (Map.Entry<Object, Object> it : prop.entrySet()) {
                    if (!StringUtils.isNotBlank((Object)it.getKey()) || !StringUtils.isNotBlank((Object)it.getValue())) continue;
                    limiterDefProps.put(it.getKey().toString(), it.getValue().toString());
                }
            }
            catch (IOException ex) {
                log.error((Throwable)ex);
            }
        }
        val = limiterDefProps.get(key);
        int limit = 0;
        if (StringUtils.isNotBlank((CharSequence)val)) {
            limit = Integer.parseInt(val);
        }
        return limit;
    }

    @Override
    public int getBaseDataF7SelRowLimit() {
        return this.readSysProperty("bos.bdf7.selrow.limit", this.getDefValue("bos.bdf7.selrow.limit"));
    }

    protected static IParameterReaderService getParameterReaderService() {
        if (parameterReaderService == null) {
            parameterReaderService = (IParameterReaderService)ServiceSvcFactory.getService(IParameterReaderService.class);
        }
        return parameterReaderService;
    }
}

