/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity;

import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.entity.gray.AppGroupUtils;

public class AppMetaRedisCacheUtils {
    private static final String APPMETA_REGION = "appmeta";
    private static final String APPMETA_TYPE_APP = "app";
    private static final String APPMETA_TYPE_MENU = "menu";

    static DistributeSessionlessCache getCache() {
        return CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(APPMETA_REGION, new DistributeCacheHAPolicy());
    }

    public static Map<String, String> getAllAppCache() {
        return AppMetaRedisCacheUtils.getCache().getAll(AppMetaRedisCacheUtils.getAppCacheType(APPMETA_TYPE_APP));
    }

    public static Map<String, String> getAllMenuCache() {
        return AppMetaRedisCacheUtils.getCache().getAll(AppMetaRedisCacheUtils.getAppCacheType(APPMETA_TYPE_MENU));
    }

    public static String getAppCache(String appNumber) {
        DistributeSessionlessCache cache = AppMetaRedisCacheUtils.getCache();
        return (String)AppMetaRedisCacheUtils.getCache().get(AppMetaRedisCacheUtils.getAppCacheType(APPMETA_TYPE_APP), appNumber);
    }

    public static String getMenuCache(String appNumber) {
        return (String)AppMetaRedisCacheUtils.getCache().get(AppMetaRedisCacheUtils.getAppCacheType(APPMETA_TYPE_MENU), appNumber);
    }

    public static Map<String, String> getAllNumberCache() {
        return AppMetaRedisCacheUtils.getCache().getAll(AppMetaRedisCacheUtils.getAppCacheType("id_number"));
    }

    public static void putAppCache(Map<String, String> val) {
        if (val == null) {
            return;
        }
        AppMetaRedisCacheUtils.getCache().put(AppMetaRedisCacheUtils.getAppCacheType(APPMETA_TYPE_APP), val);
    }

    public static void putMenuCache(Map<String, String> val) {
        if (val == null) {
            return;
        }
        AppMetaRedisCacheUtils.getCache().put(AppMetaRedisCacheUtils.getAppCacheType(APPMETA_TYPE_MENU), val);
    }

    public static void putAllNumberCache(Map<String, String> val) {
        if (val == null) {
            return;
        }
        AppMetaRedisCacheUtils.getCache().put(AppMetaRedisCacheUtils.getAppCacheType("id_number"), val);
    }

    public static void clearAppCache() {
        AppMetaRedisCacheUtils.getCache().remove(AppMetaRedisCacheUtils.getAppCacheType(APPMETA_TYPE_APP));
    }

    public static void clearMenuCache() {
        AppMetaRedisCacheUtils.getCache().remove(AppMetaRedisCacheUtils.getAppCacheType(APPMETA_TYPE_MENU));
    }

    public static void clearNumberCache() {
        AppMetaRedisCacheUtils.getCache().remove(AppMetaRedisCacheUtils.getAppCacheType("id_number"));
    }

    public static void clearAppGroupAppCache(String appGroup) {
        DistributeSessionlessCache cache = AppMetaRedisCacheUtils.getCache();
        String cacheKey = AppMetaRedisCacheUtils.getAppCacheType(appGroup, APPMETA_TYPE_APP);
        cache.remove(cacheKey);
    }

    public static void clearAppGroupMenuCache(String appGroup) {
        DistributeSessionlessCache cache = AppMetaRedisCacheUtils.getCache();
        String cacheKey = AppMetaRedisCacheUtils.getAppCacheType(appGroup, APPMETA_TYPE_MENU);
        cache.remove(cacheKey);
    }

    private static String getAppCacheType(String type) {
        String appGroup = AppGroupUtils.getCurrentAppGroup();
        return AppMetaRedisCacheUtils.getAppCacheType(appGroup, type);
    }

    private static String getAppCacheType(String appGroup, String type) {
        String accountId = CacheKeyUtil.getAcctId();
        if ("defaultGroup".equals(appGroup)) {
            return String.format("%s_%s", accountId, type);
        }
        return String.format("%s_%s_%s", accountId, appGroup, type);
    }
}

