/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMenuInfo;
import kd.bos.entity.RuntimeMetaType;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.entity.gray.AppGroupUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.ServiceFactory;
import kd.bos.service.metadata.ShareMetaAppConfigService;
import kd.bos.sharemeta.ShareMetaUtil;
import org.jetbrains.annotations.NotNull;

class AppMetadataLocalCache {
    private static final String REGION = "appmeta";
    private static final String MENUS = ".menus";
    static Log logger = LogFactory.getLog(AppMetadataLocalCache.class);
    private static final CacheConfigInfo info = new CacheConfigInfo();

    AppMetadataLocalCache() {
    }

    public static Map<String, AppInfo> getAllAppInfo() {
        LocalMemoryCache cache = AppMetadataLocalCache.getLocalCache();
        String key = AppMetadataLocalCache.makeCacheKey(RuntimeMetaType.App);
        return (Map)cache.get(key);
    }

    static void putAllAppInfo(Map<String, AppInfo> map) {
        LocalMemoryCache cache = AppMetadataLocalCache.getLocalCache();
        String key = AppMetadataLocalCache.makeCacheKey(RuntimeMetaType.App);
        cache.put(key, map);
    }

    public static Map<String, List<AppMenuInfo>> getAllAppMenusInfo() {
        LocalMemoryCache cache = AppMetadataLocalCache.getLocalCache();
        String type = AppMetadataLocalCache.makeCacheKey(RuntimeMetaType.AppMenu);
        return (Map)cache.get(type);
    }

    static void putAllAppMenusInfo(Map<String, List<AppMenuInfo>> map) {
        LocalMemoryCache cache = AppMetadataLocalCache.getLocalCache();
        String type = AppMetadataLocalCache.makeCacheKey(RuntimeMetaType.AppMenu);
        cache.put(type, map);
    }

    public static AppInfo getAppInfo(String appId) {
        String key = AppMetadataLocalCache.makeCacheKey(RuntimeMetaType.App, appId);
        ConcurrentSkipListMap cache = (ConcurrentSkipListMap)AppMetadataLocalCache.getLocalCache(appId).get(key);
        if (cache == null || appId == null) {
            return null;
        }
        return (AppInfo)cache.get(appId);
    }

    public static List<AppMenuInfo> getAppMenusInfoByAppId(String appId) {
        String key = AppMetadataLocalCache.makeCacheKey(RuntimeMetaType.App, appId);
        ConcurrentSkipListMap cache = (ConcurrentSkipListMap)AppMetadataLocalCache.getLocalCache(appId).get(key);
        if (cache == null) {
            return null;
        }
        ArrayList<AppMenuInfo> menus = null;
        if (cache.get(appId + MENUS) != null && ((Boolean)cache.get(appId + MENUS)).booleanValue()) {
            menus = new ArrayList<AppMenuInfo>();
            for (Map.Entry entry : cache.entrySet()) {
                String mapKey = (String)entry.getKey();
                if (appId.equals(mapKey) || mapKey.equals(appId + MENUS)) continue;
                if (entry.getValue() instanceof AppMenuInfo) {
                    AppMenuInfo menu = (AppMenuInfo)entry.getValue();
                    menus.add(menu);
                    continue;
                }
                logger.warn("\u5e94\u7528\u4e3a:" + appId + "\uff0c\u5176\u83dc\u5355\u5143\u6570\u636e\u6709\u8bef\uff1a" + mapKey);
            }
        }
        if (menus != null && menus.size() > 0) {
            Collections.sort(menus, new Comparator<AppMenuInfo>(){

                @Override
                public int compare(AppMenuInfo arg0, AppMenuInfo arg1) {
                    return arg0.getSeq() - arg1.getSeq();
                }
            });
        }
        return menus;
    }

    public static AppMenuInfo getAppMenuInfo(String appId, String menuId) {
        if (StringUtils.isBlank((CharSequence)appId) || StringUtils.isBlank((CharSequence)menuId)) {
            return null;
        }
        String key = AppMetadataLocalCache.makeCacheKey(RuntimeMetaType.App, appId);
        ConcurrentSkipListMap cache = (ConcurrentSkipListMap)AppMetadataLocalCache.getLocalCache(appId).get(key);
        if (cache == null) {
            return null;
        }
        return (AppMenuInfo)cache.get(menuId);
    }

    public static void putAppInfo(String appId, AppInfo appInfo) {
        String key = AppMetadataLocalCache.makeCacheKey(RuntimeMetaType.App, appId);
        ConcurrentSkipListMap<String, AppInfo> cache = (ConcurrentSkipListMap<String, AppInfo>)AppMetadataLocalCache.getLocalCache(appId).get(key);
        if (cache == null) {
            cache = new ConcurrentSkipListMap<String, AppInfo>();
        }
        if (!appId.equals(appId.toLowerCase(Locale.ENGLISH))) {
            appId = appId.toLowerCase(Locale.ENGLISH);
        }
        cache.put(appId, appInfo);
        AppMetadataLocalCache.getLocalCache(appId).put(key, cache);
    }

    @Deprecated
    public static void putAppMenusInfo(String appId, List<AppMenuInfo> menus) {
        String key = AppMetadataLocalCache.makeCacheKey(RuntimeMetaType.App, appId);
        ConcurrentSkipListMap<String, Serializable> cache = (ConcurrentSkipListMap<String, Serializable>)AppMetadataLocalCache.getLocalCache(appId).get(key);
        if (cache == null) {
            cache = new ConcurrentSkipListMap<String, Serializable>();
        }
        if (menus != null) {
            if (!appId.equals(appId.toLowerCase(Locale.ENGLISH))) {
                appId = appId.toLowerCase(Locale.ENGLISH);
            }
            cache.put(appId + MENUS, Boolean.TRUE);
            for (AppMenuInfo menu : menus) {
                cache.put(menu.getId(), menu);
            }
        }
        AppMetadataLocalCache.getLocalCache(appId).put(key, cache);
    }

    static Map<String, String> getAppNumbers() {
        LocalMemoryCache cache = AppMetadataLocalCache.getLocalCache();
        String cacheKey = null;
        String appGroup = AppGroupUtils.getCurrentAppGroup();
        cacheKey = "defaultGroup".equals(appGroup) ? "idnumber" : String.format("%s_%s", appGroup, "idnumber");
        return (Map)cache.get(cacheKey);
    }

    static void putAppNumbers(Map<String, String> map) {
        LocalMemoryCache cache = AppMetadataLocalCache.getLocalCache();
        String cacheKey = null;
        String appGroup = AppGroupUtils.getCurrentAppGroup();
        cacheKey = "defaultGroup".equals(appGroup) ? "idnumber" : String.format("%s_%s", appGroup, "idnumber");
        cache.put(cacheKey, map);
    }

    public static void remove(String appId) {
        AppMetadataLocalCache.clear();
        String cacheKey = AppMetadataLocalCache.makeCacheKey(RuntimeMetaType.App, appId);
        AppMetadataLocalCache.getLocalCache(appId).remove(new String[]{cacheKey});
    }

    public static void remove(String ... appIds) {
        AppMetadataLocalCache.clear();
        if (appIds != null && appIds.length > 0) {
            if (ShareMetaUtil.enableShareMeta()) {
                for (String appId : appIds) {
                    AppMetadataLocalCache.remove(appId);
                }
            } else {
                String[] cacheKeys = new String[appIds.length];
                for (int i = 0; i < appIds.length; ++i) {
                    cacheKeys[i] = AppMetadataLocalCache.makeCacheKey(RuntimeMetaType.App, appIds[i]);
                }
                AppMetadataLocalCache.getLocalCache("").remove(cacheKeys);
            }
        }
    }

    static void clear() {
        if (ShareMetaUtil.enableShareMeta()) {
            String key = AppMetadataLocalCache.makeCacheKey(RuntimeMetaType.App);
            Map cache = (Map)AppMetadataLocalCache.getLocalCache().get(key);
            for (String appId : cache.keySet()) {
                AppMetadataLocalCache.remove(appId);
            }
        }
        AppMetadataLocalCache.getLocalCache().clear();
    }

    @Deprecated
    private static LocalMemoryCache getLocalCache(String appId) {
        String region = CacheKeyUtil.getAcctId();
        if (StringUtils.isNotBlank((CharSequence)appId)) {
            region = ShareMetaUtil.getAppLocalCacheRegion(region, appId);
        }
        return CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache(region, "AppMetadata", info);
    }

    @Deprecated
    private static String makeCacheKey(RuntimeMetaType type, String appId) {
        return String.format("%s.%s.%s", String.valueOf(type.getValue()), AppGroupUtils.getCurrentAppGroup(), appId).toLowerCase();
    }

    private static LocalMemoryCache getShareLocalCache(String appId) {
        String region = CacheKeyUtil.getAcctId();
        if (!Boolean.getBoolean("Meta.OldAppCache")) {
            if (ShareMetaUtil.enableShareMeta()) {
                ShareMetaAppConfigService service = (ShareMetaAppConfigService)ServiceFactory.getService(ShareMetaAppConfigService.class);
                String extAppId = service.getExtAppId(appId);
                if (StringUtils.isBlank((CharSequence)extAppId)) {
                    return CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache(REGION, "share_kingdee", info);
                }
                return CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache(REGION, "share_" + extAppId, info);
            }
            region = REGION;
        }
        if (StringUtils.isNotBlank((CharSequence)appId)) {
            region = ShareMetaUtil.getAppLocalCacheRegion(region, appId);
        }
        return CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache(region, "AppMetadata", info);
    }

    private static LocalMemoryCache getLocalCache() {
        return CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache(REGION, RequestContext.get().getAccountId(), info);
    }

    @NotNull
    private static String makeCacheKey(RuntimeMetaType type) {
        String appGroup = AppGroupUtils.getCurrentAppGroup();
        if ("defaultGroup".equals(appGroup)) {
            return String.format("%s", new Object[]{type});
        }
        return String.format("%s_%s", new Object[]{appGroup, type});
    }

    static {
        info.setTimeout(43200);
        info.setMaxItemSize(10000);
    }
}

