/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.CollectionPropertyAttribute;
import kd.bos.dataentity.entity.DefaultValueAttribute;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IComplexProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicLocaleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.plugin.Plugin;
import kd.bos.entity.property.EntityTreeNode;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.entity.property.MasterBasedataProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.fulltext.FullTextIndex;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.sdk.annotation.SdkPublic;

@KSObject
@SdkPublic
public class BasedataEntityType
extends BillEntityType {
    private static final Log log = LogFactory.getLog(BasedataEntityType.class);
    public static final int MASTERIDTYPE_NONE = 0;
    public static final int MASTERIDTYPE_MYSELF = 1;
    public static final int MASTERIDTYPE_OTHER = 2;
    private static final String BOS_ORG = "73f9bf0200001dac";
    private String numberProp = "number";
    private String nameProp = "name";
    private String flexProp;
    private String moblistFormId;
    private int masteridType = 0;
    private String masteridPropName;
    private boolean enableNameVersion;
    private static final long serialVersionUID = 5614712449308636737L;
    private transient String refHashValue = null;
    private String customControllerProp;
    private List<Plugin> basedataControllersProp = new ArrayList<Plugin>();

    @SimplePropertyAttribute
    public String getMoblistFormId() {
        return this.moblistFormId;
    }

    public void setMoblistFormId(String moblistFormId) {
        this.moblistFormId = moblistFormId;
    }

    public BasedataEntityType() {
        this.setBillNo("number");
    }

    @Override
    @SimplePropertyAttribute
    @KSMethod
    @DefaultValueAttribute(value="number")
    public String getBillNo() {
        return super.getBillNo();
    }

    @SimplePropertyAttribute
    @KSMethod
    @DefaultValueAttribute(value="number")
    public String getNumberProperty() {
        return this.numberProp;
    }

    public void setNumberProperty(String numberProperty) {
        this.numberProp = numberProperty;
    }

    @SimplePropertyAttribute
    @KSMethod
    @DefaultValueAttribute(value="name")
    public String getNameProperty() {
        return this.nameProp;
    }

    public void setNameProperty(String nameProperty) {
        this.nameProp = nameProperty;
    }

    @SimplePropertyAttribute
    @KSMethod
    public String getFlexProperty() {
        return this.flexProp;
    }

    public void setFlexProperty(String flexProperty) {
        this.flexProp = flexProperty;
    }

    @SimplePropertyAttribute
    @KSMethod
    public int getMasteridType() {
        return this.masteridType;
    }

    public void setMasteridType(int masteridType) {
        this.masteridType = masteridType;
    }

    @SimplePropertyAttribute
    @KSMethod
    public String getMasteridPropName() {
        return this.masteridPropName;
    }

    public void setMasteridPropName(String masteridPropName) {
        this.masteridPropName = masteridPropName;
    }

    @Override
    public List<Map<String, Object>> createEntityTreeNodes(EntityTreeNode parentEntityTreeNode, boolean isIncludeEntry, boolean isAllNode) {
        ArrayList<Map<String, Object>> cols = new ArrayList<Map<String, Object>>(10);
        cols.addAll(((IFieldHandle)this.getPrimaryKey()).createEntityTreeNodes(parentEntityTreeNode, isAllNode));
        cols.addAll(super.createEntityTreeNodes(parentEntityTreeNode, isIncludeEntry, isAllNode));
        return cols;
    }

    public String getSearchNumberKey() {
        if (this.getMasteridType() != 2) {
            return this.getNumberProperty();
        }
        MasterBasedataProp masterIdProp = (MasterBasedataProp)this.findProperty(this.getMasteridPropName());
        if (masterIdProp == null || masterIdProp.getComplexType() == null) {
            return this.getNumberProperty();
        }
        BasedataEntityType refMasterType = (BasedataEntityType)masterIdProp.getComplexType();
        if (refMasterType == null) {
            return this.getNumberProperty();
        }
        return masterIdProp.getName() + "." + refMasterType.getNumberProperty();
    }

    @Override
    protected Set<String> getSubEntityTypeProperties(Collection<String> properties) {
        Set<String> setProps = super.getSubEntityTypeProperties(properties);
        if (StringUtils.isNotBlank((CharSequence)this.nameProp)) {
            setProps.add(this.nameProp);
        }
        if (StringUtils.isNotBlank((CharSequence)this.numberProp)) {
            setProps.add(this.numberProp);
        }
        if (StringUtils.isNotBlank((CharSequence)this.getMasteridPropName())) {
            setProps.add(this.getMasteridPropName());
        }
        if (StringUtils.equals((CharSequence)this.getName(), (CharSequence)"bd_currency")) {
            setProps.add("sign");
            setProps.add("amtprecision");
            setProps.add("priceprecision");
        }
        if (StringUtils.equals((CharSequence)this.getName(), (CharSequence)"bd_measureunits")) {
            setProps.add("precision");
            setProps.add("precisionaccount");
            setProps.add("conversiontype");
        }
        if (StringUtils.equals((CharSequence)this.getName(), (CharSequence)"bos_user")) {
            setProps.add("picturefield");
        }
        if (StringUtils.equals((CharSequence)this.getName(), (CharSequence)"bd_attachment")) {
            setProps.add("filesource");
            setProps.add("dragseq");
            setProps.add("pageid");
        }
        if (this.getProperty("longnumber") != null) {
            setProps.add("longnumber");
        }
        if (this.getProperty("fullname") != null) {
            setProps.add("fullname");
        }
        if (StringUtils.equals((CharSequence)this.getName(), (CharSequence)"bos_org")) {
            setProps.add("simplename");
        }
        return setProps;
    }

    @Override
    protected void fillRefType(DynamicObjectType type, Map<String, DynamicObjectType> types) {
        super.fillRefType(type, types);
    }

    @Override
    public Set<String> getFullIndexFields() {
        List<FullTextIndex> fullTextIndexes = this.getFullTextIndexes();
        HashSet<String> set = new HashSet<String>();
        FullTextIndex fullTextIndex = this.getFullTextIndex(fullTextIndexes);
        if (fullTextIndex != null && StringUtils.isNotBlank((CharSequence)fullTextIndex.getFieldName())) {
            set.addAll(Arrays.asList(fullTextIndex.getFieldName().split(",")));
        }
        if (set.isEmpty()) {
            if (StringUtils.isNotBlank((CharSequence)this.numberProp)) {
                set.add(this.numberProp);
            }
            if (StringUtils.isNotBlank((CharSequence)this.nameProp)) {
                set.add(this.nameProp);
            }
        }
        return set;
    }

    @Deprecated
    public void setCustomControllerProperty(String customControllerProp) {
        this.customControllerProp = customControllerProp;
    }

    @SimplePropertyAttribute
    @KSMethod
    @Deprecated
    public String getCustomControllerProperty() {
        return this.customControllerProp;
    }

    @CollectionPropertyAttribute(collectionItemPropertyType=Plugin.class)
    @KSMethod
    public List<Plugin> getBasedataControllersProp() {
        return this.basedataControllersProp;
    }

    public void setBasedataControllersProp(List<Plugin> basedataControllersProp) {
        this.basedataControllersProp = basedataControllersProp;
    }

    @SimplePropertyAttribute(name="EnableNameVersion")
    public boolean isEnableNameVersion() {
        return this.enableNameVersion;
    }

    public void setEnableNameVersion(boolean enableNameVersion) {
        this.enableNameVersion = enableNameVersion;
    }

    @Override
    protected void afterClone() {
        super.afterClone();
        this.refHashValue = null;
    }

    public void setDataEntityReferenceSchema(Object dataEntityReferenceSchema) {
        super.setDataEntityReferenceSchema(dataEntityReferenceSchema);
        if (dataEntityReferenceSchema != null) {
            this.createRefPropsHashValue(true);
        }
    }

    public final void createRefPropsHashValue(boolean force) {
        if (force || this.refHashValue == null) {
            this.genRefPropsHashValue();
        }
    }

    private void genRefPropsHashValue() {
        try {
            StringBuilder builder = new StringBuilder();
            this.searchDBReferenceProperty(null, (IDataEntityType)this, 0, builder);
            this.refHashValue = builder.length() > 0 ? this.getHashString(builder) : "";
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
    }

    public String getCacheFlag() {
        String cacheFlag = super.getCacheFlag();
        if (StringUtils.isBlank((CharSequence)cacheFlag)) {
            return this.refHashValue;
        }
        if (this.refHashValue == null) {
            return cacheFlag;
        }
        return cacheFlag + "-" + this.refHashValue;
    }

    private String getHashString(StringBuilder builder) {
        int pointsize = 1000;
        if (builder.length() > pointsize) {
            int hash = 0;
            int step = builder.length() / pointsize;
            if (step == 1) {
                StringBuilder temp = builder;
                builder = new StringBuilder();
                builder.append((CharSequence)temp).append((CharSequence)temp);
                ++step;
            }
            for (int i = 0; i < pointsize; ++i) {
                hash = 31 * hash + builder.charAt(i * step);
            }
            return hash + "";
        }
        return builder.toString().hashCode() + "";
    }

    private void searchDBReferenceProperty(IDataEntityProperty prop, IDataEntityType dt, int level, StringBuilder builder) {
        boolean writeSimple;
        if (dt == null || dt.getProperties() == null || builder == null || level > 10 || builder.length() > 0x500000) {
            return;
        }
        boolean bl = writeSimple = level > 0;
        if (prop == null) {
            builder.append(dt.getName()).append("[");
        } else {
            builder.append(prop.getName()).append("[");
        }
        for (IDataEntityProperty property : dt.getProperties()) {
            if (property instanceof IComplexProperty) {
                IDataEntityType complexType = ((IComplexProperty)property).getComplexType();
                this.searchDBReferenceProperty(property, complexType, level + 1, builder);
                continue;
            }
            if ((property instanceof DynamicLocaleProperty || property instanceof MulBasedataProp) && !writeSimple) continue;
            if (property instanceof ICollectionProperty) {
                IDataEntityType collectionType = ((ICollectionProperty)property).getItemType();
                this.searchDBReferenceProperty(property, collectionType, level + 1, builder);
                continue;
            }
            if (!(property instanceof ISimpleProperty) || !writeSimple) continue;
            builder.append(property.getOrdinal()).append("-").append(property.getName()).append(",");
        }
        builder.append(dt.getName()).append("]");
    }
}

