/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.CollectionPropertyAttribute;
import kd.bos.dataentity.entity.DefaultValueAttribute;
import kd.bos.dataentity.entity.IBillEntityType;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IModifierProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ParameterReaderHelper;
import kd.bos.entity.ca.SignField;
import kd.bos.entity.property.MainOrgProp;
import kd.bos.entity.property.org.OrgRelationConfig;
import kd.bos.orm.query.fulltext.FullTextIndex;
import kd.bos.orm.query.fulltext.FullTextIndexQuery;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.sdk.annotation.SdkPublic;

@KSObject
@SdkPublic
public class BillEntityType
extends MainEntityType
implements IBillEntityType {
    private static final long serialVersionUID = -9205168832306739871L;
    private String billNo = "billno";
    private String billStatus;
    private String billType;
    private String billTypePara;
    private String forbidStatus;
    private String billParameter;
    private String defaultPageSetting;
    private List<SignField> signField = new ArrayList<SignField>();
    public static final String PKPropName = "id";
    private String mobFormId;
    private String entityTypeId;
    private Map<String, OrgRelationConfig> orgRelationConfigList;
    private Boolean forceUpdateModifier = null;
    private String billKeyField;

    @SimplePropertyAttribute
    public String getDefaultPageSetting() {
        return this.defaultPageSetting;
    }

    public void setDefaultPageSetting(String defaultPageSetting) {
        this.defaultPageSetting = defaultPageSetting;
    }

    @SimplePropertyAttribute
    public String getBillKeyField() {
        return this.billKeyField;
    }

    public void setBillKeyField(String billKeyField) {
        this.billKeyField = billKeyField;
    }

    @CollectionPropertyAttribute(collectionItemPropertyType=OrgRelationConfig.class)
    public Map<String, OrgRelationConfig> getOrgRelationConfigList() {
        return this.orgRelationConfigList;
    }

    public void setOrgRelationConfigList(Map<String, OrgRelationConfig> orgRelationConfigList) {
        this.orgRelationConfigList = orgRelationConfigList;
    }

    @Deprecated
    @SimplePropertyAttribute
    public String getMobFormId() {
        return this.mobFormId;
    }

    public void setMobFormId(String mobFormId) {
        this.mobFormId = mobFormId;
    }

    @SimplePropertyAttribute
    @KSMethod
    public String getForbidStatus() {
        return this.forbidStatus;
    }

    public void setForbidStatus(String forbidStatus) {
        this.forbidStatus = forbidStatus;
    }

    @SimplePropertyAttribute
    @KSMethod
    @DefaultValueAttribute(value="billno")
    public String getBillNo() {
        return this.billNo;
    }

    public void setBillNo(String billNo) {
        this.billNo = billNo;
    }

    @SimplePropertyAttribute
    @KSMethod
    public String getBillStatus() {
        return this.billStatus;
    }

    public void setBillStatus(String billStatus) {
        this.billStatus = billStatus;
    }

    @SimplePropertyAttribute
    public String getBillType() {
        return this.billType;
    }

    public void setBillType(String billType) {
        this.billType = billType;
    }

    @SimplePropertyAttribute
    public String getBillParameter() {
        return this.billParameter;
    }

    public void setBillParameter(String billParameter) {
        this.billParameter = billParameter;
    }

    @SimplePropertyAttribute
    public String getBillTypePara() {
        return this.billTypePara;
    }

    public void setBillTypePara(String billTypePara) {
        this.billTypePara = billTypePara;
    }

    @SimplePropertyAttribute
    @KSMethod
    public String getEntityTypeId() {
        return this.entityTypeId;
    }

    public void setEntityTypeId(String entityTypeId) {
        this.entityTypeId = entityTypeId;
    }

    @KSMethod
    public MainOrgProp getMainOrgProperty() {
        for (IDataEntityProperty prop : this.getProperties()) {
            if (!(prop instanceof MainOrgProp)) continue;
            return (MainOrgProp)prop;
        }
        return null;
    }

    @CollectionPropertyAttribute(collectionItemPropertyType=SignField.class)
    public List<SignField> getSignField() {
        return this.signField;
    }

    public void setSignField(List<SignField> signField) {
        this.signField = signField;
    }

    @Override
    public IDataEntityProperty findProperty(String name) {
        if (PKPropName.equalsIgnoreCase(name)) {
            return this.getProperty(PKPropName);
        }
        return super.findProperty(name);
    }

    private LocalMemoryCache getLocalCache(String acctId) {
        CacheConfigInfo info = new CacheConfigInfo();
        info.setTimeout(1200);
        info.setMaxMemSize(10000);
        return CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache(acctId, "dynamicobjecttype", info);
    }

    private String getAcctId() {
        return RequestContext.get().getAccountId();
    }

    private void cache(String key, Object value) {
        LocalMemoryCache localCache = this.getLocalCache(this.getAcctId());
        localCache.put(key, value);
    }

    private <T> T getCacheData(String key) {
        LocalMemoryCache localCache = this.getLocalCache(this.getAcctId());
        return (T)localCache.get(key);
    }

    protected List<FullTextIndex> getFullTextIndexes() {
        FullTextIndexQuery fullTextIndexQuery = new FullTextIndexQuery();
        List fullTextIndexMap = (List)this.getCacheData("fulltextindexmap");
        if (fullTextIndexMap == null) {
            fullTextIndexMap = fullTextIndexQuery.getFullTextIndexes();
            this.cache("fulltextindexmap", fullTextIndexMap);
        }
        return fullTextIndexMap;
    }

    protected FullTextIndex getFullTextIndex(List<FullTextIndex> fullTextIndexes) {
        for (FullTextIndex fullTextIndex : fullTextIndexes) {
            if (!this.getName().equalsIgnoreCase(fullTextIndex.getEntityNumber())) continue;
            return fullTextIndex;
        }
        return null;
    }

    public Set<String> getFullIndexFields() {
        List<FullTextIndex> fullTextIndexes = this.getFullTextIndexes();
        HashSet<String> set = new HashSet<String>();
        FullTextIndex fullTextIndex = this.getFullTextIndex(fullTextIndexes);
        if (fullTextIndex != null) {
            set.add(fullTextIndex.getFieldName());
        }
        if (set.isEmpty() && StringUtils.isNotBlank((CharSequence)this.billNo)) {
            set.add(this.billNo);
        }
        return set;
    }

    public boolean isFullIndexDataSynced() {
        List<FullTextIndex> fullTextIndexes = this.getFullTextIndexes();
        FullTextIndex fullTextIndex = this.getFullTextIndex(fullTextIndexes);
        if (fullTextIndex != null) {
            return fullTextIndex.getSyncTime() != null;
        }
        return false;
    }

    public Boolean isForceUpdateModifier() {
        if (this.forceUpdateModifier == null) {
            this.forceUpdateModifier = Boolean.FALSE;
            Map<String, EntityType> entityMap = this.getAllEntities();
            for (Map.Entry<String, EntityType> entry : entityMap.entrySet()) {
                IModifierProperty modifierProp;
                EntityType type = entry.getValue();
                if (!(type instanceof EntryType) || (modifierProp = type.getModifierProperty()) != null) continue;
                this.forceUpdateModifier = Boolean.TRUE;
                break;
            }
        }
        return this.forceUpdateModifier;
    }

    public boolean isTriggerDBRecord() {
        return ParameterReaderHelper.getBillParameter(this.getName());
    }
}

