/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity;

import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.CloudInfo;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.ServiceFactory;
import kd.bos.service.metadata.MetadataService;

public class CloudMetadataCache {
    private static final CacheConfigInfo info = new CacheConfigInfo();

    public static Map<String, CloudInfo> getAllCloudInfo() {
        Map<String, CloudInfo> cloudInfoMap = CloudMetadataCache.getAllCloudInfoLocalCache();
        if (cloudInfoMap == null || cloudInfoMap.isEmpty()) {
            MetadataService metadataService = (MetadataService)ServiceFactory.getService(MetadataService.class);
            Map cloudInfos = metadataService.loadAllCloudInfo();
            if (CollectionUtils.isEmpty((Map)cloudInfos)) {
                return new LinkedHashMap<String, CloudInfo>(0);
            }
            cloudInfoMap = new LinkedHashMap<String, CloudInfo>(cloudInfos.size());
            for (Map.Entry entry : cloudInfos.entrySet()) {
                CloudInfo cloudInfo = (CloudInfo)SerializationUtils.fromJsonString((String)((String)entry.getValue()), CloudInfo.class);
                cloudInfoMap.put((String)entry.getKey(), cloudInfo);
            }
            CloudMetadataCache.putAllCloudInfoLocalCache(cloudInfoMap);
        }
        return cloudInfoMap;
    }

    public static void removeCache() {
        CloudMetadataCache.getLocalCache().clear();
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("cloudmeta", new DistributeCacheHAPolicy());
        String key = CacheKeyUtil.getAcctId() + "_cloud";
        cache.remove(key);
    }

    private static Map<String, CloudInfo> getAllCloudInfoLocalCache() {
        return (Map)CloudMetadataCache.getLocalCache().get("allcloud");
    }

    private static void putAllCloudInfoLocalCache(Map<String, CloudInfo> cloudInfoList) {
        CloudMetadataCache.getLocalCache().put("allcloud", cloudInfoList);
    }

    private static LocalMemoryCache getLocalCache() {
        String region = "cloudmeta";
        return CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache(region, RequestContext.get().getAccountId(), info);
    }

    static {
        info.setTimeout(43200);
        info.setMaxItemSize(500);
    }
}

