/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.session.SystemPropertyUtils;
import kd.bos.util.ConfigurationChangeListener;
import kd.bos.util.ConfigurationUtil;

public class DebugLog {
    static final String OUTLOG_METHOD_PROP = "debuglog.out.method";
    static final String OUTLOG_STACK_PROP = "debuglog.out.stack";
    static Log logger = LogFactory.getLog(DebugLog.class);
    static Boolean outStackLog = null;
    static Map<String, List<String>> outLogClassMap;
    private String className;

    DebugLog(String className) {
        this.className = className;
    }

    void info(String methodName, String msg) {
        try {
            if (!this.getOutStackLog()) {
                return;
            }
            msg = msg + this.traceStack(methodName);
            logger.info(msg);
        }
        catch (Exception e) {
            logger.info(msg);
        }
    }

    void info(String methodName, String msg, Object ... arguments) {
        try {
            if (!this.getOutStackLog()) {
                return;
            }
            msg = msg + this.traceStack(methodName);
            logger.info(msg, arguments);
        }
        catch (Exception e) {
            logger.info(msg, arguments);
        }
    }

    private String traceStack(String methodName) {
        StackTraceElement[] stackTrace;
        if (this.className == null) {
            return "";
        }
        Map<String, List<String>> stackTraceClassMap = this.getOutLogClassMap();
        if (stackTraceClassMap == null) {
            return "";
        }
        List<String> list = stackTraceClassMap.get(this.className);
        if (list == null) {
            return "";
        }
        if (list.size() > 0 && !list.contains(methodName)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(System.lineSeparator()).append(" StackTrace:").append(System.lineSeparator());
        for (StackTraceElement stackTraceElement : stackTrace = Thread.currentThread().getStackTrace()) {
            String stackClassName = stackTraceElement.getClassName();
            String stackMethodName = stackTraceElement.getMethodName();
            sb.append(stackClassName).append(",").append(stackMethodName).append(System.lineSeparator());
        }
        return sb.toString();
    }

    private Map<String, List<String>> getOutLogClassMap() {
        if (outLogClassMap == null) {
            DebugLog.initOutLogClass();
        }
        return outLogClassMap;
    }

    private boolean getOutStackLog() {
        if (outStackLog == null) {
            DebugLog.initOutStackLog();
        }
        if (outStackLog == null) {
            return false;
        }
        return outStackLog;
    }

    private static void initOutLogClass() {
        String tenantId = RequestContext.get().getTenantId();
        if (StringUtils.isNotBlank((CharSequence)tenantId)) {
            try {
                String stackClass = SystemPropertyUtils.getProptyByTenant((String)OUTLOG_METHOD_PROP, (String)tenantId);
                outLogClassMap = StringUtils.isNotBlank((CharSequence)stackClass) ? (Map<Object, Object>)SerializationUtils.fromJsonString((String)stackClass, Map.class) : new HashMap<String, List<String>>(0);
            }
            catch (Exception e) {
                logger.error("\u53d6\u79df\u6237\u53c2\u6570{}\u9519\u8bef\u3002tenantid:" + tenantId, (Object)OUTLOG_METHOD_PROP, (Object)e);
            }
        }
    }

    private static void initOutStackLog() {
        String tenantId = RequestContext.get().getTenantId();
        if (StringUtils.isNotBlank((CharSequence)tenantId)) {
            outStackLog = Boolean.parseBoolean(SystemPropertyUtils.getProptyByTenant((String)OUTLOG_STACK_PROP, (String)tenantId));
        } else {
            logger.error("\u5f53\u524d\u79df\u6237\u4e3a\u7a7a\u3002");
        }
    }

    static {
        ConfigurationUtil.observeChange((String)OUTLOG_STACK_PROP, (ConfigurationChangeListener)new ConfigurationChangeListener(){

            public void onChange(Object key, Object newValue) {
                DebugLog.initOutStackLog();
            }
        });
        ConfigurationUtil.observeChange((String)OUTLOG_METHOD_PROP, (ConfigurationChangeListener)new ConfigurationChangeListener(){

            public void onChange(Object key, Object newValue) {
                DebugLog.initOutLogClass();
            }
        });
    }
}

