/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity;

import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.cache.CacheLoader;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.CtLinkSetElement;
import kd.bos.entity.EntityItemTypes;
import kd.bos.entity.EntityMetadataLocalCache;
import kd.bos.entity.EntityMetadataProvider;
import kd.bos.entity.IEntityMetaDataProvider;
import kd.bos.entity.LinkSetElement;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.PermissionControlType;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.operate.Operations;
import kd.bos.entity.property.org.OrgRelationConfig;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.bos.service.ServiceFactory;
import kd.bos.service.metadata.MetadataService;
import kd.bos.sharemeta.ShareMetaUtil;
import kd.sdk.annotation.SdkPublic;

@KSObject
@SdkPublic
public class EntityMetadataCache {
    private static final String BOS_ENTITY_METADATA = "bos-entity-metadata";
    private static IEntityMetaDataProvider provider;
    private static Log log;
    private static Set<String> bampMoveAppList;
    private static MetadataService metadataService;

    public static IEntityMetaDataProvider getProvider() {
        if (provider == null) {
            provider = ShareMetaUtil.enableShareMeta() ? ShareMetaUtil.getEntityMetaDataProvider() : new EntityMetadataProvider();
        }
        return provider;
    }

    public static void setProvider(IEntityMetaDataProvider pro) {
        provider = pro;
    }

    public static String getAppNumberById(String appId) {
        AppInfo appInfo = EntityMetadataCache.getAppInfo(appId);
        if (appInfo != null) {
            appInfo.getNumber();
        }
        return null;
    }

    public static AppInfo getAppInfo(String appId) {
        AppInfo appInfo = AppMetadataCache.getAppInfo(appId);
        return appInfo;
    }

    @KSMethod
    public static MainEntityType getDataEntityType(String number) {
        MainEntityType dt;
        long ts = System.currentTimeMillis();
        try (EntityTraceSpan entitySpan = EntityTracer.create((String)"EntityMetadataCache", (String)"getDataEntityType");){
            MainEntityType moveDt;
            entitySpan.addTag("number", number);
            dt = EntityMetadataLocalCache.getDataEntityType(number);
            if (dt == null) {
                try (EntityTraceSpan sub = EntityTracer.create((String)"EntityMetadataCache", (String)"provider.getDataEntityType");){
                    sub.addTag("number", number);
                    EntityMetadataCache.getRuntimeMetadataVersion(number);
                    dt = EntityMetadataCache.getProvider().getDataEntityType(number);
                    EntityMetadataCache.makeUnmodifiable(dt);
                    EntityMetadataLocalCache.putDataEntityType(dt);
                    dt.setCheckVersionTimeMillis(System.currentTimeMillis());
                }
            }
            if (ts - dt.getCheckVersionTimeMillis() > 900000L) {
                String runVer = EntityMetadataCache.getRuntimeMetadataVersion(number);
                if (!runVer.equals(dt.getVersion()) || !dt.checkRefEntityVer()) {
                    entitySpan.addTag("dt version", dt.getVersion());
                    entitySpan.addTag("runVersion", runVer);
                    dt = EntityMetadataCache.getProvider().getDataEntityType(number);
                    EntityMetadataCache.makeUnmodifiable(dt);
                    EntityMetadataLocalCache.putDataEntityType(dt);
                }
                dt.setCheckVersionTimeMillis(System.currentTimeMillis());
            }
            if (dt != null && EntityMetadataCache.isBAMPMoveApp(dt.getAppId()) && (moveDt = EntityMetadataCache.rebuildBAMPMetadata(number)) != null && moveDt != MainEntityType.Empty) {
                dt = moveDt;
            }
        }
        return dt;
    }

    private static void makeUnmodifiable(MainEntityType dt) {
        try {
            Field field = DynamicObjectType.class.getDeclaredField("unmodifiable");
            field.setAccessible(true);
            field.set((Object)dt, true);
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
    }

    public static TableDefine loadMainTableDefine(String entityNumber) {
        return EntityMetadataCache.loadTableDefine(entityNumber, entityNumber);
    }

    public static TableDefine loadTableDefine(String entityNumber, String entityKey) {
        TableDefine tableDefine = EntityMetadataLocalCache.getTableDefine(entityNumber, entityKey);
        if (tableDefine == null) {
            tableDefine = EntityMetadataCache.getProvider().loadTableDefine(entityNumber, entityKey);
            if (tableDefine == null) {
                log.warn("\u6839\u636eentityNumber\u548centityKey,\u627e\u4e0d\u5230\u8868\u683c\u5b9a\u4e49\uff1a" + entityNumber + "," + entityKey);
            }
            EntityMetadataLocalCache.putTableDefine(entityNumber, entityKey, tableDefine);
        }
        return tableDefine;
    }

    public static TableDefine loadTableDefine(Long tableId) {
        TableDefine tableDefine = EntityMetadataLocalCache.getTableDefine(tableId);
        if (tableDefine == null) {
            tableDefine = EntityMetadataCache.getProvider().loadTableDefine(tableId);
            if (tableDefine == null) {
                log.warn("\u6839\u636etableId,\u627e\u4e0d\u5230\u8868\u683c\u5b9a\u4e49\uff1a" + tableId);
            }
            EntityMetadataLocalCache.putTableDefine(tableId, tableDefine);
        }
        return tableDefine;
    }

    public static String getBizAppNumber(String entityNumber) {
        return EntityMetadataCache.getBizAppNumbers(new String[]{entityNumber})[0];
    }

    public static String[] getBizAppNumbers(String[] entityNumbers) {
        String[] appNumbers = new String[entityNumbers.length];
        ArrayList<Object> noCacheList = new ArrayList<Object>(10);
        ArrayList<Integer> idxs = new ArrayList<Integer>(10);
        for (int i = 0; i < entityNumbers.length; ++i) {
            String appNumber = EntityMetadataLocalCache.getBizAppNumber(entityNumbers[i]);
            if (appNumber == null) {
                noCacheList.add(entityNumbers[i]);
                idxs.add(i);
                continue;
            }
            appNumbers[i] = appNumber;
        }
        Map<String, String> entityAppMap = EntityMetadataCache.getProvider().getAppNumberByEntityNumbers(noCacheList);
        Iterator iterator = idxs.iterator();
        while (iterator.hasNext()) {
            int idx = (Integer)iterator.next();
            String appNumber = entityAppMap.get(entityNumbers[idx]);
            if (StringUtils.isBlank((CharSequence)appNumber)) {
                appNumber = "";
            }
            appNumbers[idx] = appNumber;
            EntityMetadataLocalCache.putBizAppNumber(entityNumbers[idx], appNumber);
        }
        return appNumbers;
    }

    public static void putBizAppNumber(String entityNumber, String bizAppNumber) {
        EntityMetadataLocalCache.putBizAppNumber(entityNumber, bizAppNumber);
    }

    public static void removeDataEntityTypeLocalCache(String number) {
        EntityMetadataCache.removeDataEntityTypeLocalCache("", number);
    }

    public static void removeDataEntityTypeLocalCache(String appGroup, String number) {
        EntityMetadataLocalCache.remove(appGroup, number);
    }

    @KSMethod
    public static String getRuntimeMetadataVersion(final String number) {
        String cacheKey = EntityMetadataCache.getThreadCacheKey("ver", number);
        return (String)ThreadCache.get((Object)cacheKey, (CacheLoader)new CacheLoader<String>(){

            public String load() {
                return EntityMetadataCache.getProvider().getRuntimeMetadataVersion(number);
            }
        });
    }

    public static MainEntityType getDataEntityType(final URL url) {
        String cacheKey = EntityMetadataCache.getThreadCacheKey(url.toString());
        return (MainEntityType)((Object)ThreadCache.get((Object)cacheKey, (CacheLoader)new CacheLoader<MainEntityType>(){

            public MainEntityType load() {
                return (MainEntityType)EntityItemTypes.fromXmlString(url);
            }
        }));
    }

    public static MainEntityType getDataEntityTypeNoCache(String number) {
        return EntityMetadataCache.getProvider().getDataEntityType(number);
    }

    public static MainEntityType getDataEntityTypeById(String entityId) {
        String number = EntityMetadataCache.getProvider().getEntityNumberById(entityId);
        if (StringUtils.isBlank((CharSequence)number)) {
            throw new KDException(BosErrorCode.metaNotFound, new Object[]{String.format(ResManager.loadKDString((String)"entityId\u4e3a%1$s\u7684\u5b9e\u4f53\u5143\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"EntityMetadataCache_0", (String)BOS_ENTITY_METADATA, (Object[])new Object[0]), entityId)});
        }
        return EntityMetadataCache.getDataEntityType(number);
    }

    @KSMethod
    public static Operations getDataEntityOperations(String entityNumber) {
        return EntityMetadataCache.getProvider().getDataEntityOperations(entityNumber);
    }

    public static Map<String, List<Map<String, Object>>> getDataEntityOperations(Collection<String> entityNumbers) {
        if (entityNumbers == null || entityNumbers.isEmpty()) {
            return new HashMap<String, List<Map<String, Object>>>(1);
        }
        HashMap<String, List<Map<String, Object>>> result = new HashMap<String, List<Map<String, Object>>>(entityNumbers.size());
        Map<String, List<String>> datas = EntityMetadataCache.getProvider().getDataEntityOperationKeys(entityNumbers);
        for (Map.Entry<String, List<String>> it : datas.entrySet()) {
            String num = it.getKey();
            List<String> opKeys = it.getValue();
            ArrayList<Map<String, Object>> opMetas = new ArrayList<Map<String, Object>>(opKeys.size());
            result.put(num, opMetas);
            for (String opKey : opKeys) {
                Map<String, Object> opMeta = EntityMetadataCache.getDataEntityOperate(num, opKey);
                opMetas.add(opMeta);
            }
        }
        return result;
    }

    @KSMethod
    public static Map<String, Object> getDataEntityOperate(String entityNumber, String operKey) {
        Map<String, Object> operate = EntityMetadataLocalCache.getDataEntityOperate(entityNumber, operKey);
        if (operate == null) {
            operate = EntityMetadataCache.getProvider().getDataEntityOperate(entityNumber, operKey);
            EntityMetadataLocalCache.putDataEntityOperate(entityNumber, operKey, operate);
        }
        return operate;
    }

    @Deprecated
    public static Set<String> getFeatureEnabledEntity(String entityNumber, String featureName) {
        String cacheKey = EntityMetadataCache.getThreadCacheKey("FeatureEnabled", entityNumber, featureName);
        return (Set)ThreadCache.get((Object)cacheKey, () -> {
            List<String> fts = EntityMetadataCache.getProvider().getFeatureEnabledEntity(entityNumber, featureName);
            HashSet<String> ftSet = new HashSet<String>(16);
            ftSet.addAll(fts);
            return ftSet;
        });
    }

    @KSMethod
    public static List<Map<String, Object>> getDataEntityOperate(String entityNumber) {
        return EntityMetadataCache.getProvider().getDataEntityOperate(entityNumber);
    }

    public static Map<String, List<Map<String, Object>>> getDataEntityNetCtrlOperate(String entityNumber) {
        Map<String, List<Map<String, Object>>> netCtrls = EntityMetadataLocalCache.getNetCtrlOperate(entityNumber);
        if (netCtrls == null) {
            netCtrls = EntityMetadataCache.getProvider().getDataEntityNetCtrlOperate(entityNumber);
            if (netCtrls == null) {
                netCtrls = new HashMap<String, List<Map<String, Object>>>();
            }
            EntityMetadataLocalCache.putNetCtrlOperate(entityNumber, netCtrls);
        }
        return netCtrls;
    }

    public static DynamicObjectType getSubDataEntityType(String entityNumber, Collection<String> properties) {
        return EntityMetadataCache.getDataEntityType(entityNumber).getSubEntityType(properties);
    }

    public static String getPluginScripts(String key) {
        return EntityMetadataCache.getProvider().getPluginScripts(key);
    }

    public static FilterCondition getBaseDataFieldFilterMeta(String formId, String key) {
        FilterCondition filterCondition = (FilterCondition)EntityMetadataLocalCache.getBaseDataFieldFilterMeta(formId, key);
        if (filterCondition != null) {
            return filterCondition;
        }
        filterCondition = EntityMetadataCache.getProvider().getBaseDataFieldFilterMeta(formId, key);
        if (filterCondition != null) {
            EntityMetadataLocalCache.cacheBaseDataFieldFilterMeta(formId, key, filterCondition);
        } else {
            EntityMetadataLocalCache.cacheBaseDataFieldFilterMeta(formId, key, new FilterCondition());
        }
        return filterCondition;
    }

    private static String getThreadCacheKey(String ... keys) {
        StringBuilder sb = new StringBuilder("EntityMetadata");
        for (String key : keys) {
            sb.append('.').append(key);
        }
        return sb.toString();
    }

    public static LinkSetElement getLinkSet(String entityNumber) {
        LinkSetElement linkSet = EntityMetadataLocalCache.getLinkSet(entityNumber);
        if (linkSet == null) {
            linkSet = EntityMetadataCache.getProvider().getLinkSet(entityNumber);
            if (linkSet == null) {
                linkSet = new LinkSetElement();
            }
            EntityMetadataLocalCache.putLinkSet(entityNumber, linkSet);
        }
        return linkSet;
    }

    public static CtLinkSetElement getCtLinkSet(String entityNumber) {
        CtLinkSetElement ctLinkSet = EntityMetadataLocalCache.getCtLinkSet(entityNumber);
        if (ctLinkSet == null) {
            ctLinkSet = EntityMetadataCache.getProvider().getCtLinkSet(entityNumber);
            if (ctLinkSet == null) {
                ctLinkSet = new CtLinkSetElement();
            }
            EntityMetadataLocalCache.putCtLinkSet(entityNumber, ctLinkSet);
        }
        return ctLinkSet;
    }

    public static PermissionControlType getPermissionControlType(String entityNumber) {
        PermissionControlType permissionControlType = EntityMetadataLocalCache.getPermissionControlType(entityNumber);
        if (permissionControlType == null) {
            permissionControlType = EntityMetadataCache.getProvider().getPermissionControlType(entityNumber);
            if (permissionControlType == null) {
                permissionControlType = new PermissionControlType();
                permissionControlType.setEmptyObject(true);
                log.warn(String.format("getPermissionControlType\uff1a\u6839\u636e\u5b9e\u4f53\u7f16\u7801\u3010%s\u3011\u672a\u83b7\u53d6\u5230\u6743\u9650\u63a7\u5236\u8fd0\u884c\u65f6\u5143\u6570\u636e\uff0c\u8bf7\u91cd\u5efa\u8868\u5355\u540e\u518d\u8bd5", entityNumber));
            }
            EntityMetadataLocalCache.putPermissionControlType(entityNumber, permissionControlType);
        }
        return permissionControlType;
    }

    public static Set<String> getPermissionItems(String entityNumber) {
        Set<String> permItems = EntityMetadataLocalCache.getPermissionItems(entityNumber);
        if (permItems == null) {
            permItems = EntityMetadataCache.getProvider().getPermissionItems(entityNumber);
            EntityMetadataLocalCache.putPermissionItems(entityNumber, permItems);
        }
        return Collections.unmodifiableSet(permItems);
    }

    public static Map<String, OrgRelationConfig> getPrincipalRelation(String entityNumber) {
        Map<String, OrgRelationConfig> principalRelation = EntityMetadataLocalCache.getPrincipalRelation(entityNumber);
        if (principalRelation == null) {
            principalRelation = EntityMetadataCache.getProvider().getDataEntityPrincipalRelation(entityNumber);
            if (principalRelation == null) {
                principalRelation = new HashMap<String, OrgRelationConfig>();
            }
            EntityMetadataLocalCache.putPrincipalRelation(entityNumber, principalRelation);
        }
        return principalRelation;
    }

    public static Map<String, List<String>> getEnabledControlsMap(String formId) {
        Map<String, List<String>> lockedControlsMap = EntityMetadataLocalCache.getLockFields(formId);
        if (lockedControlsMap == null) {
            lockedControlsMap = EntityMetadataCache.getProvider().getEnabledControlsMap(formId);
            EntityMetadataLocalCache.putLockFields(formId, lockedControlsMap);
        }
        return lockedControlsMap;
    }

    private static MainEntityType rebuildBAMPMetadata(String number) {
        if (StringUtils.isBlank((CharSequence)number)) {
            return null;
        }
        log.info(String.format("rebuildBAMPMetadata,metaNumber:%s", number));
        metadataService.rebuildFormRuntimeMeta(number);
        MainEntityType dt = EntityMetadataCache.getProvider().getDataEntityType(number);
        return dt;
    }

    private static boolean isBAMPMoveApp(String bizappId) {
        return bampMoveAppList.contains(bizappId);
    }

    static {
        log = LogFactory.getLog((String)"EntityMetadataCache");
        bampMoveAppList = new HashSet<String>(7);
        metadataService = (MetadataService)ServiceFactory.getService(MetadataService.class);
        bampMoveAppList.add("base");
        bampMoveAppList.add("cts");
        bampMoveAppList.add("secm");
        bampMoveAppList.add("customize");
        bampMoveAppList.add("open");
        bampMoveAppList.add("sbd");
        bampMoveAppList.add("mpdm");
        bampMoveAppList.add("gmc");
    }
}

