/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicCollectionProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicComplexProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryEntityDto;
import kd.bos.entity.ExtendedEntityTypeByFlexPropResult;
import kd.bos.entity.GetFilterFieldsParameter;
import kd.bos.entity.LinkEntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SingleOrgContextHelper;
import kd.bos.entity.datamodel.DynamicTextListField;
import kd.bos.entity.datamodel.IRegisterPropertyListener;
import kd.bos.entity.datamodel.ListField;
import kd.bos.entity.datamodel.events.RegisterPropertyArgs;
import kd.bos.entity.filter.CompareType;
import kd.bos.entity.filter.FieldName;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.filter.FilterMetadata;
import kd.bos.entity.list.JoinProperty;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BillTypeProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.CreateExtendFilterFieldsResult;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.IBasedataField;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.entity.property.IRefBillField;
import kd.bos.entity.property.LinkEntryProp;
import kd.bos.entity.property.MasterBasedataProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.OrgProp;
import kd.bos.entity.property.PKFieldProp;
import kd.bos.entity.property.SubEntryProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.qing.AnalysisField;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.product.ICoreProductSettingService;
import kd.bos.service.ServiceFactory;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class EntityTypeUtil {
    private static final String FORMAT = "%s.%s";
    private static EntityTypeUtil instance;

    public static List<EntryEntityDto> getEntryEntitiesForForQing(EntityType entityType) {
        ArrayList<EntryEntityDto> entryEntityDtos = new ArrayList<EntryEntityDto>();
        EntryEntityDto entryEntityDto = new EntryEntityDto(entityType.getName(), entityType.getDisplayName());
        entryEntityDto.setParentKey("");
        entryEntityDto.setDBIgnore(entityType.isDbIgnore());
        if (StringUtils.isNotBlank((Object)entityType.getPrimaryKey())) {
            entryEntityDto.setPkFieldName(String.format(FORMAT, entityType.getName(), entityType.getPrimaryKey().getName()));
        }
        entryEntityDtos.add(entryEntityDto);
        entryEntityDtos.addAll(EntityTypeUtil.getEntryEntityDtoList((IDataEntityType)entityType, "", true));
        return entryEntityDtos;
    }

    public static List<EntryEntityDto> getEntryEntities(EntityType entityType) {
        ArrayList<EntryEntityDto> entryEntityDtos = new ArrayList<EntryEntityDto>();
        EntryEntityDto entryEntityDto = new EntryEntityDto(entityType.getName(), entityType.getDisplayName());
        entryEntityDto.setParentKey("");
        entryEntityDto.setDBIgnore(entityType.isDbIgnore());
        if (StringUtils.isNotBlank((Object)entityType.getPrimaryKey())) {
            entryEntityDto.setPkFieldName(String.format(FORMAT, entityType.getName(), entityType.getPrimaryKey().getName()));
        }
        entryEntityDtos.add(entryEntityDto);
        entryEntityDtos.addAll(EntityTypeUtil.getEntryEntityDtoList((IDataEntityType)entityType, "", false));
        return entryEntityDtos;
    }

    private static List<EntryEntityDto> getEntryEntityDtoList(IDataEntityType entityType, String rootName, boolean ignoreLinkEntryProp) {
        ArrayList<EntryEntityDto> entryEntityDtos = new ArrayList<EntryEntityDto>();
        for (ICollectionProperty colp : entityType.getProperties().getCollectionProperties(false)) {
            String subRootName;
            String string = subRootName = rootName.isEmpty() ? colp.getItemType().getName() : rootName + "." + colp.getItemType().getName();
            if (!(colp instanceof EntryProp) || ignoreLinkEntryProp && colp instanceof LinkEntryProp) continue;
            EntryEntityDto entryEntityDto = new EntryEntityDto(colp.getName(), ((EntryProp)colp).getDisplayName());
            String pkFieldName = String.format(FORMAT, subRootName, colp.getItemType().getPrimaryKey().getName());
            entryEntityDto.setDBIgnore(((EntryProp)colp).isDbIgnore());
            entryEntityDto.setPkFieldName(pkFieldName);
            entryEntityDto.setParentKey(entityType.getName());
            entryEntityDtos.add(entryEntityDto);
            entryEntityDtos.addAll(EntityTypeUtil.getEntryEntityDtoList(colp.getItemType(), subRootName, ignoreLinkEntryProp));
        }
        return entryEntityDtos;
    }

    public static List<EntryEntityDto> getParentEntryEntities(List<EntryEntityDto> entryEntities, String entryEntity) {
        ArrayList<EntryEntityDto> entryEntityDtos = new ArrayList<EntryEntityDto>();
        for (EntryEntityDto entryEntityDto : entryEntities) {
            if (!entryEntity.equals(entryEntityDto.getKey())) continue;
            if (StringUtils.isNotEmpty((CharSequence)entryEntityDto.getParentKey())) {
                entryEntityDtos.addAll(EntityTypeUtil.getParentEntryEntities(entryEntities, entryEntityDto.getParentKey()));
            }
            entryEntityDtos.add(entryEntityDto);
        }
        return entryEntityDtos;
    }

    public static FieldProp getFieldProp(String fieldKey, EntityType dataType) {
        return EntityTypeUtil.getFieldProp(fieldKey, dataType, true);
    }

    public static FieldProp getFieldProp(String fieldKey, EntityType dataType, boolean isThrowException) {
        IDataEntityProperty prop = EntityTypeUtil.getDataEntityProperty(fieldKey, dataType, isThrowException);
        if (prop instanceof FieldProp) {
            return (FieldProp)prop;
        }
        if (isThrowException) {
            throw new KDException(BosErrorCode.canNotCast, new Object[]{prop.getClass(), FieldProp.class});
        }
        return null;
    }

    public static IDataEntityProperty getDataEntityProperty(String fieldKey, EntityType dataType) {
        return EntityTypeUtil.getDataEntityProperty(fieldKey, dataType, false);
    }

    public static IDataEntityProperty getDataEntityProperty(String fieldKey, EntityType dataType, boolean isThrowException) {
        Object prop;
        String[] keys = fieldKey.split("\\.");
        if (keys.length > 1 && dataType.findProperty(fieldKey) == null) {
            prop = dataType.findProperty(keys[0]);
            if (prop != null) {
                if (prop instanceof IBasedataField) {
                    MainEntityType baseEntityType = (MainEntityType)((IBasedataField)prop).getComplexType();
                    if ((prop = baseEntityType.getPrimaryKey().getName().equals(keys[1]) ? baseEntityType.getPrimaryKey() : baseEntityType.findProperty(keys[1])) instanceof IBasedataField && keys.length > 2) {
                        MainEntityType baseEntityType1 = (MainEntityType)((IBasedataField)prop).getComplexType();
                        prop = baseEntityType1.getPrimaryKey().getName().equals(keys[2]) ? baseEntityType1.getPrimaryKey() : baseEntityType1.findProperty(keys[2]);
                    }
                } else if (prop instanceof EntryProp) {
                    prop = dataType.findProperty(fieldKey);
                }
            }
        } else {
            prop = dataType.findProperty(fieldKey);
        }
        if (prop == null && isThrowException) {
            throw new KDBizException(BosErrorCode.fieldNotExist, new Object[]{dataType.getName(), fieldKey});
        }
        return prop;
    }

    public static FieldName getORMFieldName(String fieldKey, EntityType dataType) {
        FilterField filterField = FilterField.create((MainEntityType)dataType, fieldKey);
        FieldName fieldName = new FieldName(filterField.getCaption(), filterField.getFullFieldName(), filterField.getRefEntityId(), filterField.getCompareGroupID());
        return fieldName;
    }

    public static boolean isContainKey(List<EntryEntityDto> entryList, String key) {
        for (EntryEntityDto entryEntityDto : entryList) {
            if (!key.equals(entryEntityDto.getKey())) continue;
            return true;
        }
        return false;
    }

    public static synchronized EntityTypeUtil getInstance() {
        if (instance == null) {
            instance = new EntityTypeUtil();
        }
        return instance;
    }

    public List<String> getListFields(IDataEntityType dataEntityType) {
        ArrayList<String> listFields = new ArrayList<String>();
        EntityTypeWalker entityTypeWalker = entityTypeWalkerArgs -> {
            IDataEntityProperty dataEntityProperty = entityTypeWalkerArgs.getDataEntityProperty();
            if (dataEntityProperty instanceof FieldProp) {
                FieldProp fieldProp = (FieldProp)dataEntityProperty;
                if (entityTypeWalkerArgs.getSrcDataEntityProperty() != null) {
                    listFields.add(String.format(FORMAT, entityTypeWalkerArgs.getSrcDataEntityProperty().getName(), fieldProp.getName()));
                } else {
                    listFields.add(fieldProp.getName());
                }
            }
        };
        this.dataEntityTypeWalker(dataEntityType, entityTypeWalker, null, null, null);
        return listFields;
    }

    private void dataEntityTypeWalker(IDataEntityType dataEntityType, EntityTypeWalker entityTypeWalker, IDataEntityProperty srcDataEntityProperty, String srcFieldName, String srcFieldCaption) {
        if (dataEntityType == null) {
            return;
        }
        for (IDataEntityProperty dataEntityProperty : dataEntityType.getProperties().getSimpleProperties(false)) {
            EntityTypeWalkerArgs entityTypeWalkerArgs = new EntityTypeWalkerArgs(dataEntityProperty, dataEntityType, srcDataEntityProperty, srcFieldName, srcFieldCaption);
            if (!(dataEntityProperty instanceof FieldProp)) continue;
            entityTypeWalker.callBack(entityTypeWalkerArgs);
        }
        for (IDataEntityProperty dataEntityProperty : dataEntityType.getProperties().getComplexProperties(false)) {
            String srcFieldName1 = StringUtils.isNotBlank((CharSequence)srcFieldName) ? String.format(FORMAT, srcFieldName, dataEntityProperty.getName()) : dataEntityProperty.getName();
            LocaleString srcFieldCaptionLocalString = ((DynamicComplexProperty)dataEntityProperty).getDisplayName();
            String srcFieldCaption1 = StringUtils.isNotBlank((CharSequence)srcFieldCaption) ? String.format(FORMAT, srcFieldCaption, srcFieldCaptionLocalString.getLocaleValue()) : (srcFieldCaptionLocalString == null ? "" : srcFieldCaptionLocalString.getLocaleValue());
            this.dataEntityTypeWalker(dataEntityProperty.getComplexType(), entityTypeWalker, dataEntityProperty, srcFieldName1, srcFieldCaption1);
        }
        for (IDataEntityProperty dataEntityProperty : dataEntityType.getProperties().getCollectionProperties(false)) {
            if (!(dataEntityProperty instanceof EntryProp)) continue;
            LocaleString srcFieldCaptionLocalString = ((DynamicCollectionProperty)dataEntityProperty).getDisplayName();
            String srcFieldCaption1 = StringUtils.isNotBlank((CharSequence)srcFieldCaption) ? String.format(FORMAT, srcFieldCaption, srcFieldCaptionLocalString.getLocaleValue()) : (srcFieldCaptionLocalString == null ? "" : srcFieldCaptionLocalString.getLocaleValue());
            this.dataEntityTypeWalker(dataEntityProperty.getItemType(), entityTypeWalker, dataEntityProperty, srcFieldName, srcFieldCaption1);
        }
    }

    public static String getType(IDataEntityProperty prop) {
        if (prop instanceof ComboProp || prop instanceof BooleanProp) {
            return "enum";
        }
        if (prop instanceof DateProp) {
            return "date";
        }
        if (prop instanceof TextProp) {
            return "text";
        }
        return "text";
    }

    public static List<CompareType> setCompareTypes(List<CompareType> compareTypes, boolean isFieldCompare) {
        return EntityTypeUtil.setCompareTypes(compareTypes, true, isFieldCompare);
    }

    public static List<CompareType> setCompareTypes(List<CompareType> compareTypes, boolean isNeedCompareTypeField, boolean isFieldCompare) {
        return EntityTypeUtil.setCompareTypes(compareTypes, isNeedCompareTypeField, isFieldCompare, true);
    }

    public static List<CompareType> setCompareTypes(List<CompareType> compareTypes, boolean isNeedCompareTypeField, boolean isFieldCompare, boolean isFieldCompareVisible) {
        ArrayList<CompareType> list = new ArrayList<CompareType>();
        list.addAll(compareTypes);
        if (isNeedCompareTypeField) {
            List<CompareType> fieldCompareList = FilterMetadata.get().getCompareTypes("9");
            for (CompareType compareType : fieldCompareList) {
                CompareType newCompareType = new CompareType(compareType);
                newCompareType.setFieldCompare(isFieldCompare);
                newCompareType.setVisible(isFieldCompareVisible);
                list.add(newCompareType);
            }
        }
        return list;
    }

    public List<AnalysisField> getAnalysisField(IDataEntityType dataEntityType) {
        ArrayList<AnalysisField> filterFields = new ArrayList<AnalysisField>();
        MainEntityType mainType = (MainEntityType)dataEntityType;
        for (IDataEntityProperty fieldProp : mainType.getAllFields().values()) {
            if (!(fieldProp instanceof IFieldHandle) || SingleOrgContextHelper.isFieldNeedHide(fieldProp)) continue;
            List<AnalysisField> list = ((IFieldHandle)fieldProp).createAnalysisFields(mainType);
            Iterator<AnalysisField> it = list.iterator();
            while (it.hasNext()) {
                AnalysisField ff = it.next();
                IDataEntityProperty ref1 = ff.getRefProp1();
                IDataEntityProperty ref2 = ff.getRefProp2();
                if ((ref1 == null || !SingleOrgContextHelper.isFieldNeedHide(ref1)) && (ref2 == null || !SingleOrgContextHelper.isFieldNeedHide(ref2))) continue;
                it.remove();
            }
            filterFields.addAll(list);
        }
        return filterFields;
    }

    public List<FilterField> getFilterFields(IDataEntityType dataEntityType) {
        return this.getFilterFields(false, dataEntityType);
    }

    public List<FilterField> getFilterFields(boolean bCompatibleProductMode, IDataEntityType dataEntityType) {
        GetFilterFieldsParameter getFilterFieldsParameter = new GetFilterFieldsParameter(dataEntityType);
        getFilterFieldsParameter.setbCompatibleProductMode(bCompatibleProductMode);
        return EntityTypeUtil.getFilterFields(getFilterFieldsParameter);
    }

    public List<FilterField> getFilterFields(IDataEntityType dataEntityType, boolean isOnlyMainEntityField) {
        return this.getFilterFields(false, dataEntityType, isOnlyMainEntityField);
    }

    public List<FilterField> getFilterFields(boolean bCompatibleProductMode, IDataEntityType dataEntityType, boolean isOnlyMainEntityField) {
        GetFilterFieldsParameter getFilterFieldsParameter = new GetFilterFieldsParameter(dataEntityType);
        getFilterFieldsParameter.setbCompatibleProductMode(bCompatibleProductMode);
        getFilterFieldsParameter.setOnlyMainEntityField(isOnlyMainEntityField);
        return EntityTypeUtil.getFilterFields(getFilterFieldsParameter);
    }

    public static List<FilterField> getFilterFields(GetFilterFieldsParameter parameterObject) {
        ArrayList<FilterField> filterFields = new ArrayList<FilterField>();
        MainEntityType mainType = (MainEntityType)parameterObject.getDataEntityType();
        ArrayList blackFields = new ArrayList();
        if (parameterObject.isbCompatibleProductMode()) {
            ICoreProductSettingService pService = (ICoreProductSettingService)ServiceFactory.getService(ICoreProductSettingService.class);
            blackFields.addAll(pService.getFormDisVisitField(parameterObject.getDataEntityType().getName()));
        }
        Collection<IDataEntityProperty> values = mainType.getAllFields().values();
        HashSet<String> baseDataIds = new HashSet<String>(values.size());
        for (IDataEntityProperty fieldProp : values) {
            FilterField ff2;
            Iterator<FilterField> it;
            List<FilterField> filterFieldList;
            if (fieldProp instanceof FlexProp && !parameterObject.isNeedFlexField() || !(fieldProp instanceof IFieldHandle)) continue;
            boolean isFilterField = true;
            IDataEntityType parentType = fieldProp.getParent();
            if (null != parentType && parentType instanceof LinkEntryType || parameterObject.isbCompatibleProductMode() && SingleOrgContextHelper.isFieldNeedHide(fieldProp)) continue;
            if (parameterObject.isOnlyMainEntityField() && !(parentType instanceof MainEntityType)) {
                isFilterField = false;
            }
            if (!isFilterField) continue;
            if (fieldProp instanceof FlexProp && parameterObject.isFlexFieldNeedExpand()) {
                CreateExtendFilterFieldsResult createExtendFilterFieldsResult = ((FlexProp)fieldProp).createExtendFilterFields(mainType);
                filterFieldList = createExtendFilterFieldsResult.getFilterFields();
            } else {
                filterFieldList = ((IFieldHandle)fieldProp).createFilterFields(mainType);
            }
            if (parameterObject.isbCompatibleProductMode()) {
                it = filterFieldList.iterator();
                while (it.hasNext()) {
                    ff2 = it.next();
                    IDataEntityProperty ref1 = ff2.getRefProp1();
                    IDataEntityProperty ref2 = ff2.getRefProp2();
                    if (ref1 != null && SingleOrgContextHelper.isFieldNeedHide(ref1) || ref2 != null && SingleOrgContextHelper.isFieldNeedHide(ref2)) {
                        it.remove();
                    }
                    if (blackFields.isEmpty() || ff2.getSrcFieldProp() == null || !blackFields.contains(String.valueOf(ff2.getSrcFieldProp().getName()))) continue;
                    it.remove();
                }
            }
            if (!parameterObject.isNeedAliasEmptyFieldProp()) {
                it = filterFieldList.iterator();
                while (it.hasNext()) {
                    ff2 = it.next();
                    if (!ff2.isFieldPropAliasEmpty()) continue;
                    it.remove();
                }
            }
            if (!parameterObject.isNeedMulBasedataField()) {
                it = filterFieldList.iterator();
                while (it.hasNext()) {
                    ff2 = it.next();
                    if (!(ff2.getSrcFieldProp() instanceof MulBasedataProp) && !(ff2.getRefProp1() instanceof MulBasedataProp) && !(ff2.getFieldProp() instanceof MulBasedataProp)) continue;
                    it.remove();
                }
            }
            if (parameterObject.isNeedBasedataIdField()) {
                for (FilterField ff2 : filterFieldList) {
                    FilterField idFilterField;
                    if (!(ff2.getLatestParent() instanceof IBasedataField) || !baseDataIds.add((idFilterField = ff2.convertToId()).getFieldName()) || !(idFilterField.getFieldProp() instanceof PKFieldProp)) continue;
                    int lastIndexOf = idFilterField.getCaption().toString().lastIndexOf(46);
                    if (lastIndexOf > -1) {
                        idFilterField.setCaption(new LocaleString(idFilterField.getCaption().toString().substring(0, lastIndexOf)));
                    }
                    filterFields.add(idFilterField);
                }
            }
            filterFields.addAll(filterFieldList);
        }
        return filterFields;
    }

    public List<Map<String, Object>> getFilterColumns(IDataEntityType dataEntityType) {
        return this.createFilterColumns(dataEntityType, true);
    }

    public List<Map<String, Object>> createFilterColumns(IDataEntityType dataEntityType, boolean isNeedCompareTypeField) {
        GetFilterFieldsParameter getFilterFieldsParameter = new GetFilterFieldsParameter(dataEntityType);
        getFilterFieldsParameter.setbCompatibleProductMode(false);
        getFilterFieldsParameter.setNeedFieldCompareType(isNeedCompareTypeField);
        return EntityTypeUtil.createFilterColumns(getFilterFieldsParameter);
    }

    public List<Map<String, Object>> createFilterColumns(IDataEntityType dataEntityType, boolean isNeedCompareTypeField, boolean bCompatibleProductModel) {
        GetFilterFieldsParameter getFilterFieldsParameter = new GetFilterFieldsParameter(dataEntityType);
        getFilterFieldsParameter.setbCompatibleProductMode(bCompatibleProductModel);
        getFilterFieldsParameter.setNeedFieldCompareType(isNeedCompareTypeField);
        return EntityTypeUtil.createFilterColumns(getFilterFieldsParameter);
    }

    public static List<Map<String, Object>> createFilterColumns(GetFilterFieldsParameter parameterObject) {
        ArrayList<Map<String, Object>> filterColumns = new ArrayList<Map<String, Object>>(10);
        MainEntityType mainType = (MainEntityType)parameterObject.getDataEntityType();
        List<FilterField> filterFields = EntityTypeUtil.getFilterFields(parameterObject);
        ICoreProductSettingService pService = (ICoreProductSettingService)ServiceFactory.getService(ICoreProductSettingService.class);
        List fields = pService.getFormDisVisitField(parameterObject.getDataEntityType().getName());
        for (FilterField filterField : filterFields) {
            List<CompareType> compareTypes;
            IDataEntityProperty prop;
            String fieldKey = filterField.getFieldName().split("\\.")[0];
            if (!fields.isEmpty() && fields.contains(fieldKey) || parameterObject.isbCompatibleProductMode() && SingleOrgContextHelper.isFieldNeedHide(prop = mainType.getAllFields().get(fieldKey))) continue;
            String filterFieldName = filterField.getFieldName();
            int lastIndexOf = filterFieldName.lastIndexOf(".");
            String preFitlerName = filterFieldName;
            if (lastIndexOf > -1) {
                preFitlerName = filterFieldName.substring(0, lastIndexOf);
            }
            if ((compareTypes = parameterObject.getFieldCompareTypeMap().get(preFitlerName)) != null) {
                filterField.addCustomCompareTypes(compareTypes);
            }
            Map<String, Object> filterColumn = filterField.createFilterColumn(parameterObject.isNeedFieldCompareType());
            filterColumns.add(filterColumn);
        }
        return filterColumns;
    }

    public List<Map<String, Object>> getFilterColumns(IDataEntityType dataEntityType, boolean isOnlyMainEntityField) {
        ArrayList<Map<String, Object>> filterColumns = new ArrayList<Map<String, Object>>(10);
        MainEntityType mainType = (MainEntityType)dataEntityType;
        List<FilterField> filterFields = this.getFilterFields((IDataEntityType)mainType, isOnlyMainEntityField);
        for (FilterField filterField : filterFields) {
            Map<String, Object> filterColumn = filterField.createFilterColumn();
            filterColumns.add(filterColumn);
        }
        return filterColumns;
    }

    public static Map<String, String> getKeyFields(MainEntityType entityType) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (entityType instanceof BasedataEntityType) {
            BasedataEntityType basedataEntityType = (BasedataEntityType)entityType;
            if (basedataEntityType.getMasteridType() == 2) {
                BasedataProp masterIdProp = (BasedataProp)basedataEntityType.findProperty(basedataEntityType.getMasteridPropName());
                if (masterIdProp != null && masterIdProp.getComplexType() != null) {
                    BasedataEntityType refType = (BasedataEntityType)masterIdProp.getComplexType();
                    if (StringUtils.isNotBlank((CharSequence)refType.getNumberProperty())) {
                        map.put("number", masterIdProp.getName() + "." + refType.getNumberProperty());
                    }
                    if (StringUtils.isNotBlank((CharSequence)refType.getNameProperty())) {
                        map.put("name", masterIdProp.getName() + "." + refType.getNameProperty());
                    }
                }
            } else {
                if (StringUtils.isNotBlank((CharSequence)basedataEntityType.getNumberProperty())) {
                    map.put("number", basedataEntityType.getNumberProperty());
                }
                if (StringUtils.isNotBlank((CharSequence)basedataEntityType.getNameProperty())) {
                    map.put("name", basedataEntityType.getNameProperty());
                }
            }
            if (StringUtils.isNotBlank((CharSequence)basedataEntityType.getBillStatus())) {
                map.put("billStatus", basedataEntityType.getBillStatus());
            }
        } else if (entityType instanceof BillEntityType) {
            String billtypeId;
            BillEntityType billEntityType = (BillEntityType)entityType;
            if (StringUtils.isNotBlank((CharSequence)billEntityType.getBillNo()) && StringUtils.isNotBlank((CharSequence)billEntityType.getProperty(billEntityType.getBillNo()).getAlias())) {
                map.put("billNo", billEntityType.getBillNo());
            }
            if (StringUtils.isNotBlank((CharSequence)billEntityType.getBillStatus())) {
                map.put("billStatus", billEntityType.getBillStatus());
            }
            if (StringUtils.isNotBlank((CharSequence)(billtypeId = EntityTypeUtil.getBilltypeId(billEntityType)))) {
                map.put(StringUtils.replaceChars((String)billtypeId, (char)'.', (char)'_'), billtypeId);
                map.put("billType", billtypeId);
            }
        }
        String mainOrgId = EntityTypeUtil.getMainOrgId(entityType);
        if (StringUtils.isNotBlank((CharSequence)mainOrgId)) {
            map.put("mainOrgId", mainOrgId);
        }
        return map;
    }

    public static String getBilltypeId(BillEntityType entityType) {
        BillTypeProp billTypeProp;
        if (StringUtils.isNotBlank((CharSequence)entityType.getBillType()) && (billTypeProp = (BillTypeProp)entityType.findProperty(entityType.getBillType())) != null) {
            return entityType.getBillType() + ".id";
        }
        return null;
    }

    public static String getMainOrgId(MainEntityType entityType) {
        OrgProp orgProp;
        if (StringUtils.isNotBlank((CharSequence)entityType.getMainOrg()) && (orgProp = (OrgProp)entityType.findProperty(entityType.getMainOrg())) != null) {
            return entityType.getMainOrg() + "." + orgProp.getComplexType().getPrimaryKey().getName();
        }
        return null;
    }

    public static List<String> toCachedListFields(List<ListField> listFields) {
        ArrayList<String> newListFields = new ArrayList<String>();
        for (ListField listField : listFields) {
            if (listField instanceof DynamicTextListField) {
                DynamicTextListField dynamicTextListField = (DynamicTextListField)listField;
                for (ListField listField2 : dynamicTextListField.getListFields()) {
                    if (newListFields.contains(listField2.getFieldName())) continue;
                    newListFields.add(listField2.getFieldName());
                }
                continue;
            }
            if (newListFields.contains(listField.getFieldName())) continue;
            newListFields.add(listField.getFieldName());
        }
        return newListFields;
    }

    public static ListField getMainOrgListField(MainEntityType entityType) {
        String mainOrgId = EntityTypeUtil.getMainOrgId(entityType);
        if (StringUtils.isNotBlank((CharSequence)mainOrgId)) {
            ListField keyField = new ListField(mainOrgId);
            keyField.setListFieldKey(mainOrgId);
            keyField.setFieldName(mainOrgId);
            keyField.setLookup(true);
            return keyField;
        }
        return null;
    }

    public static List<ListField> getKeyFields(EntityType entityType) {
        ArrayList<ListField> keyFields = new ArrayList<ListField>();
        Map<String, String> keyMapFields = EntityTypeUtil.getKeyFields((MainEntityType)entityType);
        for (Map.Entry<String, String> entry : keyMapFields.entrySet()) {
            ListField keyField = new ListField(entry.getValue());
            keyField.setListFieldKey(entry.getValue());
            keyField.setFieldName(entry.getValue());
            keyField.setLookup(true);
            if (keyFields.contains(keyField)) continue;
            keyFields.add(keyField);
        }
        return keyFields;
    }

    public static List<ListField> expandListFields(List<ListField> listFields) {
        ArrayList<ListField> newListFields = new ArrayList<ListField>(20);
        for (ListField listField : listFields) {
            if (listField instanceof DynamicTextListField) {
                DynamicTextListField dynamicTextListField = (DynamicTextListField)listField;
                for (ListField listField2 : dynamicTextListField.getListFields()) {
                    if (newListFields.contains(listField2)) continue;
                    newListFields.add(listField2);
                }
                continue;
            }
            if (newListFields.contains(listField)) continue;
            newListFields.add(listField);
        }
        return newListFields;
    }

    public static List<ListField> getAllListField(EntityType entityType, List<ListField> listFields, boolean isNeedKeyFields) {
        ArrayList<ListField> newListFields = new ArrayList<ListField>(20);
        HashSet<ListField> newListFieldsSet = new HashSet<ListField>(20);
        for (ListField listField : listFields) {
            if (!newListFieldsSet.add(listField)) continue;
            newListFields.add(listField);
        }
        if (isNeedKeyFields) {
            for (ListField listField : EntityTypeUtil.getKeyFields(entityType)) {
                if (!newListFieldsSet.add(listField)) continue;
                newListFields.add(listField);
            }
        }
        List<ListField> pkListFields = EntityTypeUtil.getValidPkFields(entityType, listFields);
        for (ListField listField : pkListFields) {
            if (!newListFieldsSet.add(listField)) continue;
            newListFields.add(listField);
        }
        return newListFields;
    }

    private static ListField getPkField(String preName, EntityType entityType) {
        String fieldName;
        String key = entityType.getName() + "." + entityType.getPrimaryKey().getName();
        ListField pkField = new ListField(key);
        if (StringUtils.isNotBlank((CharSequence)preName)) {
            fieldName = String.format(FORMAT, preName, entityType.getPrimaryKey().getName());
            pkField.setKey(fieldName);
        } else {
            fieldName = entityType.getPrimaryKey().getName();
        }
        pkField.setFieldName(fieldName);
        pkField.setEntityName(entityType.getName());
        pkField.setLookup(true);
        IDataEntityProperty dataEntityProperty = entityType.findProperty(key);
        pkField.setSrcFieldProp(dataEntityProperty);
        return pkField;
    }

    public static List<ListField> getValidPkFields(EntityType entityType, List<ListField> listFields) {
        ArrayList<ListField> pkFields = new ArrayList<ListField>();
        ArrayList<ListField> newListFields = new ArrayList<ListField>();
        newListFields.addAll(EntityTypeUtil.expandListFields(listFields));
        pkFields.add(EntityTypeUtil.getPkField("", entityType));
        for (ListField listField : newListFields) {
            String subFieldName;
            IDataEntityProperty property;
            if (listField.isListBusinessField()) continue;
            String fieldName = listField.getFieldName();
            IDataEntityProperty dataEntityProperty = entityType.findProperty(fieldName.split("\\.")[0]);
            if (dataEntityProperty instanceof EntryProp) {
                EntityTypeUtil.addSubPkFields(entityType, pkFields, fieldName, dataEntityProperty, null);
                continue;
            }
            if (!(dataEntityProperty instanceof JoinProperty)) continue;
            MainEntityType joinEntityType = (MainEntityType)((JoinProperty)dataEntityProperty).getComplexType();
            ListField subQueryPkField = EntityTypeUtil.getPkField(dataEntityProperty.getName(), joinEntityType);
            if (!pkFields.contains(subQueryPkField)) {
                subQueryPkField.setEntityName(dataEntityProperty.getName());
                pkFields.add(subQueryPkField);
            }
            if (!((property = joinEntityType.findProperty((subFieldName = fieldName.substring(fieldName.split("\\.")[0].length() + 1)).split("\\.")[0])) instanceof EntryProp)) continue;
            EntityTypeUtil.addSubPkFields(entityType, pkFields, subFieldName, property, joinEntityType.getName());
        }
        return pkFields;
    }

    private static void addSubPkFields(EntityType entityType, List<ListField> pkFields, String fieldName, IDataEntityProperty dataEntityProperty, String preName) {
        EntityType subEntryEntityType;
        ListField subEntryPkField;
        EntityType entryEntityType;
        ListField entryPkField = EntityTypeUtil.getPkField(preName == null ? entryEntityType.getName() : preName + "." + entryEntityType.getName(), entryEntityType = (EntityType)((EntryProp)dataEntityProperty).getItemType());
        if (!pkFields.contains(entryPkField)) {
            pkFields.add(entryPkField);
        }
        if ((dataEntityProperty = entityType.findProperty((fieldName = fieldName.substring(fieldName.split("\\.")[0].length() + 1)).split("\\.")[0])) instanceof SubEntryProp && !pkFields.contains(subEntryPkField = EntityTypeUtil.getPkField(preName == null ? entryEntityType.getName() + "." + subEntryEntityType.getName() : preName + "." + entryEntityType.getName() + "." + subEntryEntityType.getName(), subEntryEntityType = (EntityType)((EntryProp)dataEntityProperty).getItemType()))) {
            pkFields.add(subEntryPkField);
        }
    }

    public static boolean isMainOrgProp(IDataEntityProperty bdProp) {
        if (!(bdProp instanceof OrgProp)) {
            return false;
        }
        if (!(bdProp.getParent() instanceof BillEntityType)) {
            return false;
        }
        BillEntityType billEntityType = (BillEntityType)bdProp.getParent();
        if (billEntityType == null) {
            return false;
        }
        OrgProp orgProp = (OrgProp)bdProp;
        return billEntityType.getMainOrgProperty() != null && billEntityType.getMainOrgProperty().getName() != null && billEntityType.getMainOrgProperty().getName().equals(orgProp == null ? null : orgProp.getName());
    }

    public static boolean isContainPropertyName(DynamicObjectType dynamicObjectType, String fieldName) {
        boolean isContainPropertyName = false;
        for (IDataEntityProperty iDataEntityProperty : dynamicObjectType.getProperties()) {
            if (!fieldName.equalsIgnoreCase(iDataEntityProperty.getName())) continue;
            isContainPropertyName = true;
            break;
        }
        return isContainPropertyName;
    }

    public static String[] getBasedataDisplayProps(IDataEntityProperty property) {
        String[] resultArr = null;
        String displayProp = "";
        if (property instanceof IBasedataField) {
            ((IBasedataField)property).getDispProp();
            displayProp = ((IBasedataField)property).getDisplayProp();
        } else if (property instanceof IRefBillField) {
            displayProp = ((IRefBillField)property).getDisplayProp();
        } else {
            return null;
        }
        if (StringUtils.isNotBlank((CharSequence)displayProp)) {
            displayProp = displayProp.replaceAll("\\)", "");
            resultArr = displayProp.split(",| |_|/|\\(");
            BasedataEntityType basedataEntityType = (BasedataEntityType)((DynamicComplexProperty)property).getDynamicComplexPropertyType();
            for (int i = 0; i < resultArr.length; ++i) {
                resultArr[i] = EntityTypeUtil.getMasterDisplayProp(basedataEntityType, resultArr[i]);
            }
        }
        return resultArr;
    }

    private static String getMasterDisplayProp(BasedataEntityType basedataEntityType, String displayProp) {
        if (basedataEntityType.getMasteridType() != 2) {
            return EntityTypeUtil.convertDisplayProp(basedataEntityType, displayProp);
        }
        MasterBasedataProp masterIdProp = (MasterBasedataProp)basedataEntityType.findProperty(basedataEntityType.getMasteridPropName());
        if (masterIdProp == null || masterIdProp.getComplexType() == null) {
            return EntityTypeUtil.convertDisplayProp(basedataEntityType, displayProp);
        }
        BasedataEntityType refMasterType = (BasedataEntityType)masterIdProp.getComplexType();
        if (refMasterType == null) {
            return EntityTypeUtil.convertDisplayProp(basedataEntityType, displayProp);
        }
        return masterIdProp.getName() + "." + EntityTypeUtil.convertDisplayProp(refMasterType, displayProp);
    }

    private static String convertDisplayProp(BasedataEntityType basedataEntityType, String displayProp) {
        if ("name".equals(displayProp)) {
            displayProp = basedataEntityType.getNameProperty();
        } else if ("number".equals(displayProp)) {
            displayProp = basedataEntityType.getNumberProperty();
        }
        return displayProp;
    }

    public static ExtendedEntityTypeByFlexPropResult extendMainEntityTypeByFlexProp(EntityType mainEntityType, List<String> selectFields, List<String> selectFieldsWithNotCompare, List<IRegisterPropertyListener> registerPropertyListeners) {
        EntityType cloneEntityType;
        try {
            cloneEntityType = (EntityType)((Object)mainEntityType.clone());
        }
        catch (CloneNotSupportedException e) {
            throw new KDException((Throwable)e, BosErrorCode.bOS, new Object[]{ResManager.loadKDString((String)"\u5b9e\u4f53\u4e0d\u652f\u6301\u514b\u9686", (String)"ListModel_0", (String)"bos-form-mvc", (Object[])new Object[0])});
        }
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(selectFields.size());
        for (IRegisterPropertyListener registerPropertyListener : registerPropertyListeners) {
            QFilter qFilter1;
            RegisterPropertyArgs registerPropertyArgs = new RegisterPropertyArgs((DynamicObjectType)cloneEntityType, selectFields);
            RegisterPropertyArgs registerPropertyResult1 = registerPropertyListener.registerSimpleProperty(registerPropertyArgs);
            RegisterPropertyArgs registerPropertyResult2 = registerPropertyListener.registerComplexProperty(registerPropertyArgs);
            QFilter qFilter = EntityTypeUtil.buildNotCompareFilter(registerPropertyResult1, selectFieldsWithNotCompare);
            if (qFilter != null) {
                qFilters.add(qFilter);
            }
            if ((qFilter1 = EntityTypeUtil.buildNotCompareFilter(registerPropertyResult2, selectFieldsWithNotCompare)) == null) continue;
            qFilters.add(qFilter);
        }
        return new ExtendedEntityTypeByFlexPropResult(cloneEntityType, qFilters);
    }

    private static QFilter buildNotCompareFilter(RegisterPropertyArgs registerPropertyResult, List<String> selectFieldsWithNotCompare) {
        if (registerPropertyResult != null && EntityTypeUtil.isContainDemensionProp(selectFieldsWithNotCompare, registerPropertyResult.getDimensionPropName()) && registerPropertyResult.getQFilter() != null) {
            return registerPropertyResult.getQFilter().or(QFilter.emptyOrNotExists((String)registerPropertyResult.getQFilter().getProperty()));
        }
        return null;
    }

    private static boolean isContainDemensionProp(List<String> includeProperties, String dimensionPropName) {
        for (String selectField : includeProperties) {
            if (!selectField.split("\\.")[0].equals(dimensionPropName)) continue;
            return true;
        }
        return false;
    }

    static interface EntityTypeWalker {
        public void callBack(EntityTypeWalkerArgs var1);
    }

    static class EntityTypeWalkerArgs {
        IDataEntityProperty dataEntityProperty;
        IDataEntityProperty srcDataEntityProperty;
        String srcFieldName;
        String srcFieldCaption;

        public EntityTypeWalkerArgs(IDataEntityProperty dataEntityProperty, IDataEntityType dataEntityType, IDataEntityProperty srcDataEntityProperty, String srcFieldName, String srcFieldCaption) {
            this.dataEntityProperty = dataEntityProperty;
            this.srcDataEntityProperty = srcDataEntityProperty;
            this.srcFieldName = srcFieldName;
            this.srcFieldCaption = srcFieldCaption;
        }

        public String getSrcFieldName() {
            return this.srcFieldName;
        }

        public void setSrcFieldName(String srcFieldName) {
            this.srcFieldName = srcFieldName;
        }

        public String getSrcFieldCaption() {
            return this.srcFieldCaption;
        }

        public void setSrcFieldCaption(String srcFieldCaption) {
            this.srcFieldCaption = srcFieldCaption;
        }

        public IDataEntityProperty getSrcDataEntityProperty() {
            return this.srcDataEntityProperty;
        }

        public void setSrcDataEntityProperty(IDataEntityProperty srcDataEntityProperty) {
            this.srcDataEntityProperty = srcDataEntityProperty;
        }

        public IDataEntityProperty getDataEntityProperty() {
            return this.dataEntityProperty;
        }

        public void setDataEntityProperty(IDataEntityProperty dataEntityProperty) {
            this.dataEntityProperty = dataEntityProperty;
        }
    }
}

