/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.CollectionPropertyAttribute;
import kd.bos.dataentity.entity.DefaultValueAttribute;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.PermissionControlType;
import kd.bos.entity.RefEntityTypeCache;
import kd.bos.entity.RefPropType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntityTreeNode;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.ItemClassTypeProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.RefBillProp;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.bos.service.ServiceFactory;
import kd.bos.service.metadata.MetadataService;
import kd.bos.util.ConfigurationChangeListener;
import kd.bos.util.ConfigurationUtil;
import kd.sdk.annotation.SdkPublic;
import org.apache.commons.collections4.map.CaseInsensitiveMap;
import org.apache.commons.collections4.map.LRUMap;

@KSObject
@SdkPublic
public class MainEntityType
extends EntityType {
    private String userOption = "bos_useroptiontpl";
    private String appId;
    private String mainOrg;
    private transient long checkVersionTimeMillis;
    private PermissionControlType permissionControlType;
    private String inheritPath;
    private String bizAppNumber;
    private transient Map<String, MainEntityType> subEntityTypecache = new ConcurrentHashMap<String, MainEntityType>();
    private transient Map<String, String> refEntityTypeVer = new ConcurrentHashMap<String, String>();
    private static String SUBENTITYTYPECACHELRUSUBKEY = "mainentitytype.subentitytypecache.LRU.subsize";
    private static String SUBENTITYTYPECACHELRUENTITYKEY = "mainentitytype.subentitytypecache.LRU.entitysize";
    private static int subEntityLRUCount = 0;
    private static int subEntityLRUEntityCount = 2000;
    private static transient Map<String, Map<String, MainEntityType>> subEntityTypeLRUCache;
    public static final MainEntityType Empty;
    private static final long serialVersionUID = -2023817046480057938L;
    protected List<RefPropType> refPropTypes = new ArrayList<RefPropType>();
    volatile transient Map<String, EntityType> dctEntitys;
    volatile transient Map<String, IDataEntityProperty> dctFields;
    transient List<ISimpleProperty> pkList = new ArrayList<ISimpleProperty>();
    private String version;
    private String bosver;
    private String versionControl;

    @SimplePropertyAttribute
    @KSMethod
    public String getVersionControl() {
        return this.versionControl;
    }

    public void setVersionControl(String versionControl) {
        this.versionControl = versionControl;
    }

    public List<ISimpleProperty> getPkList() {
        this.createEntityDictionary();
        return this.pkList;
    }

    @SimplePropertyAttribute
    @KSMethod
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @SimplePropertyAttribute
    @KSMethod
    public String getBOSVer() {
        return this.bosver;
    }

    public void setBOSVer(String bosver) {
        this.bosver = bosver;
    }

    @CollectionPropertyAttribute(collectionItemPropertyType=RefPropType.class)
    public List<RefPropType> getRefPropTypes() {
        return this.refPropTypes;
    }

    @Override
    public synchronized void endInit() {
        super.endInit();
        if (this.refPropTypes != null && !this.refPropTypes.isEmpty()) {
            String baseRefBatchEnable = System.getProperty("base.refentity.batch.enable");
            Map<String, DynamicObjectType> types = "false".equals(baseRefBatchEnable) ? RefEntityTypeCache.getRefTypes(this.refPropTypes) : RefEntityTypeCache.getRefTypes(this);
            this.fillRefType(this, types);
            for (Map.Entry<String, DynamicObjectType> it : types.entrySet()) {
                if (it.getValue() == null || StringUtils.equalsIgnoreCase((CharSequence)it.getValue().getName(), (CharSequence)this.getName()) || StringUtils.isBlank((CharSequence)it.getValue().getVersion())) continue;
                this.refEntityTypeVer.put(it.getValue().getName(), it.getValue().getVersion());
            }
            this.refPropTypes = null;
        }
        subEntityTypeLRUCache.remove(MainEntityType.getCacheMapKey(this.getName()));
    }

    public boolean checkRefEntityVer() {
        if (this.isInitialized()) {
            return false;
        }
        MetadataService service = (MetadataService)ServiceFactory.getService(MetadataService.class);
        if (!this.refEntityTypeVer.isEmpty()) {
            Map dbVersion = service.batchLoadRuntimeMetadataVersion(this.refEntityTypeVer.keySet());
            for (Map.Entry<String, String> it : this.refEntityTypeVer.entrySet()) {
                if (StringUtils.equals((CharSequence)it.getValue(), (CharSequence)dbVersion.getOrDefault(it.getKey(), ""))) continue;
                return false;
            }
        }
        return true;
    }

    protected Object readResolve() {
        this.pkList = new ArrayList<ISimpleProperty>();
        this.subEntityTypecache = new ConcurrentHashMap<String, MainEntityType>();
        return this;
    }

    @KSMethod
    public Map<String, EntityType> getAllEntities() {
        this.createEntityDictionary();
        LinkedHashMap<String, EntityType> allEntities = new LinkedHashMap<String, EntityType>();
        allEntities.putAll(this.dctEntitys);
        return allEntities;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createEntityDictionary() {
        MainEntityType mainEntityType;
        if (this.dctEntitys == null) {
            mainEntityType = this;
            synchronized (mainEntityType) {
                if (this.dctEntitys == null) {
                    LinkedHashMap<String, EntityType> dctEntitysTemp = new LinkedHashMap<String, EntityType>(16);
                    dctEntitysTemp.put(this.getName(), this);
                    List<EntityType> childEntities = this.getChildEntities(this);
                    for (EntityType entityType : childEntities) {
                        dctEntitysTemp.put(entityType.getName(), entityType);
                    }
                    this.dctEntitys = dctEntitysTemp;
                }
            }
        }
        if (this.pkList.isEmpty()) {
            mainEntityType = this;
            synchronized (mainEntityType) {
                if (this.pkList.isEmpty()) {
                    ArrayList<ISimpleProperty> pkListTemp = new ArrayList<ISimpleProperty>();
                    for (Map.Entry<String, EntityType> entry : this.dctEntitys.entrySet()) {
                        if (entry.getValue().getPrimaryKey() == null) continue;
                        pkListTemp.add(entry.getValue().getPrimaryKey());
                    }
                    this.pkList = pkListTemp;
                }
            }
        }
    }

    @Override
    protected EntityType createSubEntityType(List<String> props) {
        String str = props.toString();
        MainEntityType type = null;
        if (subEntityLRUCount == 0) {
            type = this.subEntityTypecache.get(str);
            if (type == null) {
                type = (MainEntityType)super.createSubEntityType(props);
                type.setUnmodifiable(this.isUnmodifiable());
                this.subEntityTypecache.put(str, type);
            }
        } else {
            String mapKey = MainEntityType.getCacheMapKey(this.getName());
            Map<String, MainEntityType> subEntityTypeMap = subEntityTypeLRUCache.get(mapKey);
            if (subEntityTypeMap == null) {
                subEntityTypeMap = Collections.synchronizedMap(new LRUMap(subEntityLRUCount));
                subEntityTypeLRUCache.put(mapKey, subEntityTypeMap);
            }
            if ((type = subEntityTypeMap.get(str)) == null) {
                type = (MainEntityType)super.createSubEntityType(props);
                type.setUnmodifiable(this.isUnmodifiable());
                subEntityTypeMap.put(str, type);
            }
        }
        return type;
    }

    private List<EntityType> getChildEntities(EntityType entityType) {
        ArrayList<EntityType> childEntities = new ArrayList<EntityType>();
        for (IDataEntityProperty property : entityType.getProperties()) {
            ICollectionProperty collProp;
            if (!(property instanceof ICollectionProperty) || !((collProp = (ICollectionProperty)property).getItemType() instanceof EntityType)) continue;
            EntityType childEntity = (EntityType)collProp.getItemType();
            childEntities.add(childEntity);
            childEntities.addAll(this.getChildEntities(childEntity));
        }
        return childEntities;
    }

    public List<Map<String, Object>> createEntityTreeNodes(EntityTreeNode parentEntityTreeNode, boolean isIncludeEntry, boolean isAllNode) {
        Map<String, IDataEntityProperty> fields = isIncludeEntry ? this.getAllFields() : this.getFields();
        ArrayList<Map<String, Object>> cols = new ArrayList<Map<String, Object>>();
        for (IDataEntityProperty fieldProp : fields.values()) {
            if (parentEntityTreeNode.isBaseData() && fieldProp.getParent() instanceof EntryType || !(fieldProp instanceof IFieldHandle)) continue;
            cols.addAll(((IFieldHandle)fieldProp).createEntityTreeNodes(parentEntityTreeNode, isAllNode));
        }
        return cols;
    }

    @KSMethod
    public Map<String, IDataEntityProperty> getAllFields() {
        this.createFieldDictionary();
        LinkedHashMap<String, IDataEntityProperty> allFields = new LinkedHashMap<String, IDataEntityProperty>();
        allFields.putAll(this.dctFields);
        return allFields;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createFieldDictionary() {
        if (this.dctFields == null) {
            MainEntityType mainEntityType = this;
            synchronized (mainEntityType) {
                if (this.dctFields == null) {
                    LinkedHashMap<String, IDataEntityProperty> dctFieldsTemp = new LinkedHashMap<String, IDataEntityProperty>();
                    this.createEntityDictionary();
                    for (EntityType entityType : this.dctEntitys.values()) {
                        dctFieldsTemp.putAll(entityType.getFields());
                    }
                    this.dctFields = dctFieldsTemp;
                }
            }
        }
    }

    protected void fillRefType(DynamicObjectType type, Map<String, DynamicObjectType> types) {
        this.doFillRefType(type, types);
        this.fillRefParentProperty(type);
    }

    private void doFillRefType(DynamicObjectType type, Map<String, DynamicObjectType> types) {
        ArrayList<DynamicProperty> refIds = new ArrayList<DynamicProperty>();
        for (IDataEntityProperty prop : (DataEntityPropertyCollection)type.getProperties().clone()) {
            if (prop instanceof ItemClassProp) {
                this.fillRefToItemClassProp(types, refIds, (ItemClassProp)prop);
                continue;
            }
            if (prop instanceof ItemClassTypeProp) {
                this.fillRefToItemClassTypeProp(types, (ItemClassTypeProp)prop);
                continue;
            }
            if (prop instanceof FlexProp) {
                FlexProp flexProp = (FlexProp)prop;
                DynamicObjectType dt = flexProp.getFlexDataType();
                flexProp.setComplexType((IDataEntityType)dt);
                LongProp pRefId = new LongProp(true);
                if (StringUtils.isBlank((CharSequence)prop.getAlias())) {
                    pRefId.setDbIgnore(true);
                } else {
                    pRefId.setAlias(prop.getAlias());
                    pRefId.setTableGroup(((FlexProp)prop).getTableGroup());
                }
                pRefId.setPrimaryKey(false);
                pRefId.setName(prop.getName() + "_id");
                refIds.add((DynamicProperty)pRefId);
                flexProp.setRefIdPropName(prop.getName() + "_id");
                flexProp.setRefIdProp((IDataEntityProperty)pRefId);
                continue;
            }
            if (prop instanceof BasedataProp) {
                this.fillRefToBaseDataProp(types, refIds, (BasedataProp)prop);
                continue;
            }
            if (prop instanceof RefBillProp) {
                this.fillRefToRefBillProp(types, refIds, (RefBillProp)prop);
                continue;
            }
            if (prop instanceof EntryProp) {
                this.doFillRefType((EntityType)((EntryProp)prop).getItemType(), types);
                continue;
            }
            if (!(prop instanceof MulBasedataProp)) continue;
            this.doFillRefType((DynamicObjectType)((MulBasedataProp)prop).getItemType(), types);
        }
        for (DynamicProperty prop : refIds) {
            type.addProperty(prop);
        }
    }

    private void fillRefParentProperty(DynamicObjectType type) {
        HashMap<String, BasedataProp> baseProps = new HashMap<String, BasedataProp>(16);
        ArrayList<FlexProp> flexProps = new ArrayList<FlexProp>(16);
        for (IDataEntityProperty iDataEntityProperty : type.getProperties()) {
            if (iDataEntityProperty instanceof ItemClassProp) {
                ItemClassProp itemProp = (ItemClassProp)iDataEntityProperty;
                if (!(itemProp.getParent() instanceof EntryType) || !(this.findProperty(itemProp.getTypePropName()).getParent() instanceof MainEntityType)) continue;
                ((EntryType)itemProp.getParent()).setRefParentProperty(true);
                continue;
            }
            if (iDataEntityProperty instanceof EntryProp) {
                this.fillRefParentProperty((EntityType)((EntryProp)iDataEntityProperty).getItemType());
                continue;
            }
            if (iDataEntityProperty instanceof MulBasedataProp) {
                this.fillRefParentProperty((DynamicObjectType)((MulBasedataProp)iDataEntityProperty).getItemType());
                continue;
            }
            if (iDataEntityProperty instanceof FlexProp) {
                flexProps.add((FlexProp)iDataEntityProperty);
                continue;
            }
            if (!(iDataEntityProperty instanceof BasedataProp)) continue;
            baseProps.put(iDataEntityProperty.getName(), (BasedataProp)iDataEntityProperty);
        }
        for (FlexProp flexProp : flexProps) {
            String baseKey = flexProp.getBasePropertyKey();
            BasedataProp bdprop = (BasedataProp)baseProps.get(baseKey);
            if (bdprop == null) continue;
            bdprop.addRelationControlledProp((IDataEntityProperty)flexProp);
        }
    }

    private void fillRefToItemClassTypeProp(Map<String, DynamicObjectType> types, ItemClassTypeProp prop) {
        List<String> baseEntityIds = prop.getBaseEntityIds();
        for (String baseEntityId : baseEntityIds) {
            prop.setItemType(types.get(baseEntityId));
        }
    }

    private void fillRefToItemClassProp(Map<String, DynamicObjectType> types, List<DynamicProperty> refIds, ItemClassProp prop) {
        LongProp pRefId = new LongProp(true);
        if (StringUtils.isBlank((CharSequence)prop.getAlias())) {
            pRefId.setDbIgnore(true);
        } else {
            pRefId.setAlias(prop.getAlias());
            pRefId.setTableGroup(prop.getTableGroup());
        }
        pRefId.setPrimaryKey(false);
        pRefId.setName(prop.getName() + "_id");
        refIds.add((DynamicProperty)pRefId);
        prop.setRefIdPropName(prop.getName() + "_id");
        prop.setRefIdProp((IDataEntityProperty)pRefId);
    }

    private void fillRefToBaseDataProp(Map<String, DynamicObjectType> types, List<DynamicProperty> refIds, BasedataProp prop) {
        BasedataProp baseProp = prop;
        DynamicObjectType dt = types.get(baseProp.getBaseEntityId());
        if (dt != null) {
            baseProp.setComplexType((IDataEntityType)dt);
            DynamicSimpleProperty pRefId = baseProp.createRefIDProp();
            pRefId.setPrimaryKey(false);
            if (StringUtils.isBlank((CharSequence)prop.getAlias())) {
                pRefId.setDbIgnore(true);
            } else {
                pRefId.setAlias(prop.getAlias());
                pRefId.setTableGroup(prop.getTableGroup());
            }
            pRefId.setName(prop.getName() + "_id");
            refIds.add((DynamicProperty)pRefId);
            baseProp.setRefIdPropName(prop.getName() + "_id");
            baseProp.setRefIdProp((IDataEntityProperty)pRefId);
        }
    }

    private void fillRefToRefBillProp(Map<String, DynamicObjectType> types, List<DynamicProperty> refIds, RefBillProp prop) {
        RefBillProp billProp = prop;
        DynamicObjectType dt = types.get(billProp.getBillEntityId());
        if (dt != null) {
            billProp.setComplexType((IDataEntityType)dt);
            DynamicSimpleProperty pRefId = billProp.createRefIDProp();
            pRefId.setPrimaryKey(false);
            if (StringUtils.isBlank((CharSequence)prop.getAlias())) {
                pRefId.setDbIgnore(true);
            } else {
                pRefId.setAlias(prop.getAlias());
                pRefId.setTableGroup(prop.getTableGroup());
            }
            pRefId.setName(prop.getName() + "_id");
            refIds.add((DynamicProperty)pRefId);
            billProp.setRefIdPropName(prop.getName() + "_id");
            billProp.setRefIdProp((IDataEntityProperty)pRefId);
        }
    }

    @SimplePropertyAttribute
    @DefaultValueAttribute(value="bos_useroptiontpl")
    public String getUserOption() {
        return this.userOption;
    }

    public void setUserOption(String userOption) {
        this.userOption = userOption;
    }

    @SimplePropertyAttribute
    @KSMethod
    public String getMainOrg() {
        return this.mainOrg;
    }

    public void setMainOrg(String mainOrg) {
        this.mainOrg = mainOrg;
    }

    @SimplePropertyAttribute
    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    @SimplePropertyAttribute
    public String getBizAppNumber() {
        return this.bizAppNumber;
    }

    public void setBizAppNumber(String bizAppNumber) {
        this.bizAppNumber = bizAppNumber;
    }

    @SimplePropertyAttribute
    @KSMethod
    public String getInheritPath() {
        return this.inheritPath;
    }

    public void setInheritPath(String inheritPath) {
        this.inheritPath = inheritPath;
    }

    public boolean isInheritFrom(String entityNumber) {
        String[] inheritNumbers;
        for (String number : inheritNumbers = this.inheritPath.split(",")) {
            if (!number.equals(entityNumber)) continue;
            return true;
        }
        return false;
    }

    public synchronized PermissionControlType getPermissionControlType() {
        if (this.permissionControlType == null) {
            this.permissionControlType = EntityMetadataCache.getPermissionControlType(this.getName());
            if (this.permissionControlType == null) {
                this.permissionControlType = new PermissionControlType();
            }
        }
        return this.permissionControlType;
    }

    public synchronized void setPermissionControlType(PermissionControlType permissionControlType) {
        this.permissionControlType = permissionControlType;
    }

    public long getCheckVersionTimeMillis() {
        return this.checkVersionTimeMillis;
    }

    public void setCheckVersionTimeMillis(long checkVersionTimeMillis) {
        this.checkVersionTimeMillis = checkVersionTimeMillis;
    }

    public Object clone() throws CloneNotSupportedException {
        MainEntityType cloneDT = (MainEntityType)((Object)super.clone());
        cloneDT.dctEntitys = null;
        cloneDT.dctFields = null;
        cloneDT.pkList = new ArrayList<ISimpleProperty>(10);
        return cloneDT;
    }

    public synchronized void createPropIndexsNoCache() {
        CaseInsensitiveMap tmpMap = new CaseInsensitiveMap();
        this.createPropIndexs((IDataEntityType)this, (Map<String, IDataEntityProperty>)tmpMap);
        this.propindexs = tmpMap;
    }

    public void clearSubEntityTypecache() {
        this.subEntityTypecache = new ConcurrentHashMap<String, MainEntityType>();
        subEntityTypeLRUCache.remove(MainEntityType.getCacheMapKey(this.getName()));
    }

    public void clearRefEntityTypeVer() {
        this.refEntityTypeVer = new ConcurrentHashMap<String, String>();
    }

    private static String getCacheMapKey(String entityTypeName) {
        if (RequestContext.get() == null) {
            return "";
        }
        String tenantId = RequestContext.get().getTenantId();
        return tenantId + "." + entityTypeName;
    }

    static {
        subEntityLRUCount = Integer.getInteger(SUBENTITYTYPECACHELRUSUBKEY, 0);
        subEntityLRUEntityCount = Integer.getInteger(SUBENTITYTYPECACHELRUENTITYKEY, 2000);
        ConfigurationUtil.observeChange((String)SUBENTITYTYPECACHELRUSUBKEY, (ConfigurationChangeListener)new ConfigurationChangeListener(){

            public void onChange(Object key, Object newValue) {
                subEntityLRUCount = Integer.getInteger(SUBENTITYTYPECACHELRUSUBKEY);
            }
        });
        subEntityTypeLRUCache = Collections.synchronizedMap(new LRUMap(subEntityLRUEntityCount));
        Empty = new MainEntityType();
        Empty.setName("empty");
    }
}

