/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.NumberFormatInitParam;
import kd.bos.entity.datamodel.FmtBaseDataPropField;
import kd.bos.entity.datamodel.FmtField;
import kd.bos.entity.datamodel.FmtInfoUtils;
import kd.bos.entity.datamodel.NumberPrecision;
import kd.bos.entity.format.FormatFactory;
import kd.bos.entity.format.FormatObject;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BigIntProp;
import kd.bos.entity.property.CurrencyProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.ExchangeRateProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.property.INumberPrecision;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.property.PriceProp;
import kd.bos.entity.property.UnitProp;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.InteTimeZone;
import kd.bos.service.TimeService;
import kd.bos.service.TransType;
import kd.bos.utils.ExRateConfigUtil;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class NumberFormatProvider {
    public static final String COLFMTKEY = "colfmt";
    public static final String UNITFMTKEY = "unitfmt";
    public static final String CURRENCYFMTKEY = "currencyfmt";
    public static final String TIMEZONEFMTKEY = "timezonefmt";
    public static final String DECIMALFIELDSKEY = "decimalfields";
    public static final String COMBOFIELDSKEY = "combofields";
    private static final Log log = LogFactory.getLog(NumberFormatProvider.class);
    public static final String NUMTYPE = "nt";
    public static final String PRECISION = "pc";
    public static final String SCALE = "sc";
    public static final String SCALEFIELD = "sf";
    private static final String PRICE = "price";
    private static final String AMOUNT = "amount";
    private static final String NUMBER = "number";
    List<FmtField> fmtFields;
    DynamicObjectCollection dataEntitys;
    DynamicObject dataEntity;
    int rowStartIndex = 0;
    private boolean isApplyMaterialPrecision;
    Map<String, IDataEntityProperty> curEntryControlFields = new HashMap<String, IDataEntityProperty>();
    Map<String, Map<String, Object>> colfmt = new HashMap<String, Map<String, Object>>();
    Map<String, Object> currencyfmt = new HashMap<String, Object>();
    Map<String, Object> timeZoneFmt = new HashMap<String, Object>();
    Map<String, Object> unitfmt = new HashMap<String, Object>();
    Map<Integer, Map<String, Object>> rowFmtInfo = new HashMap<Integer, Map<String, Object>>();
    Map<Integer, Map<String, Map<String, Object>>> rowAllFmtInfo = new HashMap<Integer, Map<String, Map<String, Object>>>();
    Map<String, Map<String, Object>> decimalFieldMap = new HashMap<String, Map<String, Object>>();
    private FormatObject formatObject = null;
    Map<String, String> fieldControlPropMap = new HashMap<String, String>();
    Map<String, Map<String, Map<String, Object>>> fieldFmtInfo = new HashMap<String, Map<String, Map<String, Object>>>();
    private Map<String, UnitProp> unitFields = new HashMap<String, UnitProp>();
    private Map<String, Map<String, Integer>> materielMapping = new HashMap<String, Map<String, Integer>>();

    public List<FmtField> getFmtFields() {
        return this.fmtFields;
    }

    public void setFmtFields(List<FmtField> fmtFields) {
        this.fmtFields = fmtFields;
    }

    public Map<String, Map<String, Object>> getColfmt() {
        return this.colfmt;
    }

    public Map<String, Object> getCurrencyfmt() {
        return this.currencyfmt;
    }

    public Map<String, Object> getTimeZoneFmt() {
        return this.timeZoneFmt;
    }

    public Map<String, Object> getUnitfmt() {
        return this.unitfmt;
    }

    public Map<Integer, Map<String, Object>> getRowFmtInfo() {
        return this.rowFmtInfo;
    }

    public Map<Integer, Map<String, Map<String, Object>>> getRowAllFmtInfo() {
        return this.rowAllFmtInfo;
    }

    public Map<String, Map<String, Object>> getDecimalFieldMap() {
        return this.decimalFieldMap;
    }

    public Map<String, String> getFieldControlPropMap() {
        return this.fieldControlPropMap;
    }

    public Map<String, Map<String, Map<String, Object>>> getFieldFmtInfo() {
        return this.fieldFmtInfo;
    }

    public NumberFormatProvider(List<FmtField> fmtFields, DynamicObjectCollection dataEntitys) {
        this(fmtFields, dataEntitys, null);
    }

    public NumberFormatProvider(List<FmtField> fmtFields, DynamicObjectCollection dataEntitys, DynamicObject dataEntity) {
        this(fmtFields, dataEntitys, dataEntity, 0);
    }

    public NumberFormatProvider(List<FmtField> fmtFields, DynamicObjectCollection dataEntitys, DynamicObject dataEntity, int rowStartIndex) {
        this(fmtFields, dataEntitys, dataEntity, rowStartIndex, FmtInfoUtils.applyMaterialPrecision());
    }

    public NumberFormatProvider(List<FmtField> fmtFields, DynamicObjectCollection dataEntitys, DynamicObject dataEntity, int rowStartIndex, boolean isApplyMaterialPrecision) {
        this.fmtFields = fmtFields;
        this.dataEntitys = dataEntitys;
        this.dataEntity = dataEntity;
        this.rowStartIndex = rowStartIndex;
        this.isApplyMaterialPrecision = isApplyMaterialPrecision;
        this.init();
    }

    public NumberFormatProvider(NumberFormatInitParam initParam) {
        this.fmtFields = initParam.getFmtFields();
        this.dataEntitys = initParam.getDataEntitys();
        this.dataEntity = initParam.getDataEntity();
        this.rowStartIndex = initParam.getRowStartIndex();
        this.isApplyMaterialPrecision = initParam.isApplyMaterialPrecision();
        this.formatObject = initParam.getFormatObject();
        this.init(false);
    }

    public NumberFormatProvider(List<FmtField> fmtFields, DynamicObjectCollection dataEntitys, DynamicObject dataEntity, FormatObject formatObject, boolean isApplyMaterialPrecision) {
        this.fmtFields = fmtFields;
        this.dataEntitys = dataEntitys;
        this.dataEntity = dataEntity;
        this.rowStartIndex = 0;
        this.isApplyMaterialPrecision = isApplyMaterialPrecision;
        for (FmtField field : fmtFields) {
            IDataEntityProperty fieldProp = field.getFieldProp();
            if (fieldProp instanceof DateTimeProp) {
                this.setDateTimeFormat(dataEntity, field);
                continue;
            }
            this.setDecimalFormat(field);
        }
        this.setFmtInfo();
        this.formatObject = formatObject;
    }

    public NumberFormatProvider(List<FmtField> fmtFields, DynamicObjectCollection dataEntitys, DynamicObject dataEntity, FormatObject formatObject) {
        this.fmtFields = fmtFields;
        this.dataEntitys = dataEntitys;
        this.dataEntity = dataEntity;
        this.rowStartIndex = 0;
        this.isApplyMaterialPrecision = FmtInfoUtils.applyMaterialPrecision();
        for (FmtField field : fmtFields) {
            if (field instanceof FmtBaseDataPropField) {
                this.obtainRowFmtInfo((FmtBaseDataPropField)field);
                continue;
            }
            IDataEntityProperty fieldProp = field.getFieldProp();
            if (fieldProp instanceof DateTimeProp) {
                this.setDateTimeFormat(dataEntity, field);
                continue;
            }
            this.setDecimalFormat(field);
        }
        this.setFmtInfo();
        this.formatObject = formatObject;
    }

    private void setFieldControlProp(String controlFieldKey, DecimalProp decimalProp) {
        HashMap<String, Object> colType = new HashMap<String, Object>();
        if (decimalProp instanceof AmountProp) {
            Map<String, Object> mainCurrencyFmt = FmtInfoUtils.getMainCurrencyFmt();
            if (decimalProp instanceof PriceProp) {
                colType.put(NUMTYPE, PRICE);
                colType.put(SCALE, mainCurrencyFmt.get("pp"));
            } else {
                colType.put(NUMTYPE, AMOUNT);
                colType.put(SCALE, mainCurrencyFmt.get("ap"));
            }
        } else {
            colType.put(NUMTYPE, "qty");
            colType.put(SCALE, decimalProp.getScale());
        }
        colType.put(SCALEFIELD, controlFieldKey);
        colType.put(PRECISION, decimalProp.getPrecision());
        this.decimalFieldMap.put(decimalProp.getName(), colType);
    }

    private void setDecimalFormat(FmtField field) {
        IDataEntityProperty decimalProp = field.getFieldProp();
        String controlFieldName = field.getControlFieldName();
        if (StringUtils.isNotBlank((CharSequence)controlFieldName)) {
            IDataEntityProperty prop = null;
            DynamicObjectType parentType = this.dataEntitys.getDynamicObjectType();
            prop = (IDataEntityProperty)parentType.getProperties().get((Object)controlFieldName);
            if (prop == null && (parentType = parentType.getParent()) != null) {
                prop = (IDataEntityProperty)parentType.getProperties().get((Object)controlFieldName);
            }
            if (prop == null && parentType != null && (parentType = parentType.getParent()) != null) {
                prop = (IDataEntityProperty)parentType.getProperties().get((Object)controlFieldName);
            }
            if (prop != null) {
                String controlFieldKey = StringUtils.isEmpty((CharSequence)field.getControlFieldKey()) ? controlFieldName : field.getControlFieldKey().replace('.', '_');
                this.curEntryControlFields.put(controlFieldKey, prop);
                this.fieldControlPropMap.put(field.getFieldName(), controlFieldKey.toLowerCase(Lang.en_US.getLocale()));
                this.setFieldControlProp(controlFieldKey, (DecimalProp)decimalProp);
            }
        } else if (decimalProp instanceof AmountProp || decimalProp instanceof PriceProp) {
            Map<String, Object> mainCurrencyFmt = FmtInfoUtils.getMainCurrencyFmt();
            this.colfmt.put("_MainCurrency_", mainCurrencyFmt);
            this.fieldFmtInfo.put(decimalProp.getName(), this.colfmt);
            HashMap<String, String> colType = new HashMap<String, String>();
            if (decimalProp instanceof PriceProp) {
                colType.put(NUMTYPE, PRICE);
            } else {
                colType.put(NUMTYPE, AMOUNT);
            }
            colType.put(SCALEFIELD, "_MainCurrency_");
            this.decimalFieldMap.put(decimalProp.getName(), colType);
        } else if (decimalProp instanceof DecimalProp) {
            DecimalProp newDecimalProp = (DecimalProp)decimalProp;
            HashMap<String, Object> colType = new HashMap<String, Object>();
            colType.put(NUMTYPE, "D");
            colType.put(PRECISION, newDecimalProp.getPrecision());
            colType.put(SCALE, field.getScale() == -1 ? newDecimalProp.getScale() : field.getScale());
            this.decimalFieldMap.put(decimalProp.getName(), colType);
        }
    }

    private void getMaterielData(UnitProp unitProp, DynamicObject dataRowEntity, List<DynamicObject> materialObjs) {
        DynamicObject unitObj = (DynamicObject)unitProp.getValueFast(dataRowEntity);
        if (unitObj == null) {
            return;
        }
        String materialKey = unitProp.getMaterielField();
        IDataEntityProperty materialProp = null;
        DynamicObject materialObj = null;
        if (StringUtils.isNotBlank((CharSequence)materialKey)) {
            DynamicObjectType parentType = dataRowEntity.getDynamicObjectType();
            materialProp = (IDataEntityProperty)parentType.getProperties().get((Object)materialKey);
            materialObj = materialProp != null ? (DynamicObject)materialProp.getValue((Object)dataRowEntity) : this.getControlFieldObj(materialKey, dataRowEntity);
        }
        if (materialObj != null) {
            materialObjs.add(materialObj);
        }
    }

    private void setUnitPrecisionFmt(UnitProp unitProp, int rowindex, DynamicObject dataRowEntity, Map<String, Object> precisionFmt, BiFunction<DynamicObject, DynamicObject, Map<String, Object>> mapper, Map<String, Map<String, Object>> fmt, Map<String, Map<String, Integer>> mapping) {
        DynamicObject unitObj = (DynamicObject)unitProp.getValueFast(dataRowEntity);
        if (unitObj == null) {
            return;
        }
        String materialKey = unitProp.getMaterielField();
        IDataEntityProperty materialProp = null;
        DynamicObject materialObj = null;
        if (StringUtils.isNotBlank((CharSequence)materialKey)) {
            DynamicObjectType parentType = dataRowEntity.getDynamicObjectType();
            materialProp = (IDataEntityProperty)parentType.getProperties().get((Object)materialKey);
            materialObj = materialProp != null ? (DynamicObject)materialProp.getValue((Object)dataRowEntity) : this.getControlFieldObj(materialKey, dataRowEntity);
            Map<String, Object> unitFmt = FmtInfoUtils.getUnitFmt(unitProp, unitObj, materialObj, mapping);
            this.addRowFmtInfo(rowindex, unitProp.getName(), UNITFMTKEY, unitFmt, true);
        } else {
            String number = unitObj.getString(NUMBER);
            if (!fmt.containsKey(number)) {
                Map<String, Object> unitFmt = FmtInfoUtils.getUnitFmt(unitProp, unitObj, materialObj, mapping);
                fmt.put(number, unitFmt);
                precisionFmt.put(number, unitFmt);
            }
        }
    }

    private void setPrecisionFmt(IDataEntityProperty property, DynamicObject dataRowEntity, Map<String, Object> precisionFmt, Function<DynamicObject, Map<String, Object>> mapper, Map<String, Map<String, Object>> fmt) {
        String number;
        DynamicObject currencySym = (DynamicObject)property.getValueFast((Object)dataRowEntity);
        if (currencySym != null && !fmt.containsKey(number = currencySym.getString(NUMBER))) {
            Map<String, Object> currencyFmt = mapper.apply(currencySym);
            fmt.put(number, currencyFmt);
            precisionFmt.put(number, currencyFmt);
        }
    }

    private Map<String, Map<String, Object>> getFmt(IDataEntityProperty property, Map<String, Object> precisionFmt, Function<DynamicObject, Map<String, Object>> mapper) {
        HashMap<String, Map<String, Object>> fmt = new HashMap<String, Map<String, Object>>();
        IDataEntityType parentType = property.getParent();
        if (!parentType.getName().equals(this.dataEntitys.getDynamicObjectType().getName()) || parentType instanceof BillEntityType) {
            DynamicObject currencySym;
            DynamicObject controlData;
            Object object = parentType instanceof EntryType ? (this.dataEntitys.isEmpty() ? null : (DynamicObject)((DynamicObject)this.dataEntitys.get(0)).getParent()) : (controlData = this.getRootData());
            if (controlData != null && (currencySym = (DynamicObject)property.getValueFast((Object)controlData)) != null) {
                Map<String, Object> nmp = mapper.apply(currencySym);
                this.colfmt.put(property.getName(), nmp);
                fmt.put(property.getName(), nmp);
            }
        } else {
            for (DynamicObject dataRowEntity : this.dataEntitys) {
                this.setPrecisionFmt(property, dataRowEntity, precisionFmt, mapper, fmt);
            }
        }
        return fmt;
    }

    private DynamicObject getRootData() {
        Object data = this.dataEntity;
        if (this.dataEntity == null && this.dataEntitys != null) {
            DynamicObject obj = (DynamicObject)this.dataEntitys.getParent();
            if (obj == null) {
                return null;
            }
            data = obj.getDynamicObjectType() instanceof EntryType ? (DynamicObject)obj.getParent() : (obj.getDynamicObjectType() instanceof MainEntityType ? obj : null);
        }
        return data;
    }

    private void initMaterielMapping(List<UnitProp> unitPropList, Map map) {
        ArrayList<DynamicObject> materielObjs = new ArrayList<DynamicObject>();
        for (UnitProp unitProp : unitPropList) {
            IDataEntityType parentType = unitProp.getParent();
            if (!parentType.getName().equals(this.dataEntitys.getDynamicObjectType().getName()) || this.dataEntity != null && parentType instanceof BillEntityType) {
                String materialKey = unitProp.getMaterielField();
                DynamicObject data = parentType instanceof EntryType ? (this.dataEntitys.isEmpty() ? null : (DynamicObject)((DynamicObject)this.dataEntitys.get(0)).getParent()) : this.dataEntity;
                DynamicObject materailData = null;
                if (!StringUtils.isNotBlank((CharSequence)materialKey) || (materailData = this.getControlFieldObj(materialKey, data)) == null) continue;
                materielObjs.add(materailData);
                continue;
            }
            for (DynamicObject dataRowEntity : this.dataEntitys) {
                this.getMaterielData(unitProp, dataRowEntity, materielObjs);
            }
        }
        map.putAll(FmtInfoUtils.getMultiUnitPrecisionMapping(materielObjs));
    }

    private Map<String, Map<String, Object>> obtainUnitFmt(UnitProp unitProp, Map<String, Object> precisionFmt, Map<Integer, Map<String, Object>> rowFmt, BiFunction<DynamicObject, DynamicObject, Map<String, Object>> mapper, Map<String, Map<String, Integer>> mapping) {
        HashMap<String, Map<String, Object>> fmt = new HashMap<String, Map<String, Object>>();
        IDataEntityType parentType = unitProp.getParent();
        if (!parentType.getName().equals(this.dataEntitys.getDynamicObjectType().getName()) || this.dataEntity != null && parentType instanceof BillEntityType) {
            DynamicObject unitData;
            String materialKey = unitProp.getMaterielField();
            DynamicObject data = parentType instanceof EntryType ? (this.dataEntitys.isEmpty() ? null : (DynamicObject)((DynamicObject)this.dataEntitys.get(0)).getParent()) : this.dataEntity;
            DynamicObject materailData = null;
            if (StringUtils.isNotBlank((CharSequence)materialKey)) {
                materailData = this.getControlFieldObj(materialKey, data);
            }
            if (data != null && (unitData = (DynamicObject)unitProp.getValueFast(data)) != null) {
                Map<String, Object> nmp = FmtInfoUtils.getUnitFmt(unitProp, unitData, materailData, mapping);
                this.colfmt.put(unitProp.getName(), nmp);
                fmt.put(unitProp.getName(), nmp);
            }
        } else {
            int rowindex = this.rowStartIndex;
            for (DynamicObject dataRowEntity : this.dataEntitys) {
                this.setUnitPrecisionFmt(unitProp, rowindex++, dataRowEntity, precisionFmt, mapper, fmt, mapping);
            }
        }
        return fmt;
    }

    private DynamicObject getControlFieldObj(String fieldName, DynamicObject object) {
        if (object == null) {
            return null;
        }
        DynamicObjectType parentType = object.getDynamicObjectType();
        IDataEntityProperty prop = null;
        prop = (IDataEntityProperty)parentType.getProperties().get((Object)fieldName);
        if (prop != null) {
            return (DynamicObject)prop.getValueFast((Object)object);
        }
        if (prop == null && (parentType = parentType.getParent()) != null) {
            prop = (IDataEntityProperty)parentType.getProperties().get((Object)fieldName);
        }
        if (prop != null) {
            return object.getParent() != null ? (DynamicObject)prop.getValueFast(object.getParent()) : null;
        }
        if (prop == null && parentType != null && (parentType = parentType.getParent()) != null) {
            prop = (IDataEntityProperty)parentType.getProperties().get((Object)fieldName);
        }
        if (prop != null) {
            return this.dataEntity != null ? (DynamicObject)prop.getValueFast((Object)this.dataEntity) : null;
        }
        return null;
    }

    private void setFmtInfo() {
        for (Map.Entry<String, IDataEntityProperty> entry : this.curEntryControlFields.entrySet()) {
            String fieldName = entry.getKey();
            IDataEntityProperty property = entry.getValue();
            if (property instanceof UnitProp) {
                if (this.isApplyMaterialPrecision) {
                    this.unitFields.put(fieldName, (UnitProp)property);
                    continue;
                }
                this.fieldFmtInfo.put(fieldName, this.getFmt(property, this.unitfmt, FmtInfoUtils::getUnitFmt));
                continue;
            }
            this.fieldFmtInfo.put(fieldName, this.getFmt(property, this.currencyfmt, FmtInfoUtils::getCurrencyFmt));
        }
        if (this.isApplyMaterialPrecision) {
            this.initMaterielMapping(Arrays.asList(this.unitFields.values().toArray(new UnitProp[0])), this.materielMapping);
            for (Map.Entry<String, Object> entry : this.unitFields.entrySet()) {
                this.fieldFmtInfo.put(entry.getKey(), this.obtainUnitFmt((UnitProp)entry.getValue(), this.unitfmt, this.rowFmtInfo, FmtInfoUtils::getUnitFmt, this.materielMapping));
            }
        }
    }

    private void init() {
        this.init(true);
    }

    private void init(boolean forceRefreshFmtObj) {
        for (FmtField field : this.fmtFields) {
            if (field instanceof FmtBaseDataPropField) {
                this.obtainRowFmtInfo((FmtBaseDataPropField)field);
                continue;
            }
            IDataEntityProperty fieldProp = field.getFieldProp();
            if (fieldProp instanceof DateTimeProp) {
                this.setDateTimeFormat(this.dataEntity, field);
                continue;
            }
            this.setDecimalFormat(field);
        }
        this.setFmtInfo();
        if (forceRefreshFmtObj || this.formatObject == null) {
            this.formatObject = FormatFactory.getFormat(RequestContext.get().getCurrUserId());
        }
    }

    private void setDateTimeFormat(DynamicObject dataEntity, FmtField field) {
        if (field.getFieldProp() instanceof DateProp) {
            this.colfmt.put(field.getFieldName(), this.getTimeZoneInfo(field.getFieldProp(), 0L));
            return;
        }
        String controlFieldName = field.getControlFieldName();
        if (StringUtils.isBlank((CharSequence)controlFieldName)) {
            DynamicObject org;
            DynamicObjectType entityType = null;
            long orgId = 0L;
            while (dataEntity != null && !((entityType = dataEntity.getDynamicObjectType()) instanceof MainEntityType)) {
                dataEntity = (DynamicObject)dataEntity.getParent();
                entityType = dataEntity.getDataEntityType();
            }
            if (dataEntity != null && StringUtils.isNotBlank((CharSequence)(controlFieldName = ((MainEntityType)entityType).getMainOrg())) && (org = dataEntity.getDynamicObject(controlFieldName)) != null) {
                orgId = (Long)org.getPkValue();
            }
            this.colfmt.put(field.getFieldName(), this.getTimeZoneInfo(field.getFieldProp(), orgId));
        } else {
            Iterator org;
            IDataEntityProperty prop = null;
            DynamicObjectType parentType = this.dataEntitys.getDynamicObjectType();
            prop = (IDataEntityProperty)parentType.getProperties().get((Object)controlFieldName);
            if (prop != null) {
                org = this.dataEntitys.iterator();
                while (org.hasNext()) {
                    String number;
                    DynamicObject row = (DynamicObject)org.next();
                    DynamicObject org2 = row.getDynamicObject(prop);
                    if (org2 == null || this.timeZoneFmt.containsKey(number = org2.getString(((BasedataEntityType)org2.getDynamicObjectType()).getNumberProperty()))) continue;
                    this.timeZoneFmt.put(number, this.getTimeZoneInfo(field.getFieldProp(), (Long)org2.getPkValue()));
                }
            }
            DynamicObject parent = null;
            if (this.dataEntitys != null && this.dataEntitys.size() > 0) {
                parent = (DynamicObject)((DynamicObject)this.dataEntitys.get(0)).getParent();
            }
            if (prop == null && (parentType = parentType.getParent()) != null && (prop = (IDataEntityProperty)parentType.getProperties().get((Object)controlFieldName)) != null && parent != null && (org = parent.getDynamicObject(prop)) != null) {
                this.colfmt.put(field.getFieldName(), this.getTimeZoneInfo(field.getFieldProp(), (Long)org.getPkValue()));
            }
            if (prop == null && parentType != null && (parentType = parentType.getParent()) != null && (prop = (IDataEntityProperty)parentType.getProperties().get((Object)controlFieldName)) != null && parent != null && (org = (parent = (DynamicObject)parent.getParent()).getDynamicObject(prop)) != null) {
                this.colfmt.put(field.getFieldName(), this.getTimeZoneInfo(field.getFieldProp(), (Long)org.getPkValue()));
            }
        }
    }

    private Map<String, Object> getTimeZoneInfo(IDataEntityProperty fieldProp, Long orgId) {
        InteTimeZone zone;
        if (fieldProp instanceof DateProp) {
            Long userId = Long.parseLong(RequestContext.get().getUserId());
            zone = InteTimeZone.getUserTimeZone((long)userId);
        } else {
            zone = ((DateTimeProp)fieldProp).getTimeZone(orgId);
        }
        HashMap<String, Object> colTimeZone = new HashMap<String, Object>();
        if (TransType.get((int)((DateTimeProp)fieldProp).getTimeZoneTransType()) == TransType.ORGTIMEZONE) {
            colTimeZone.put("timezone", zone.getTimeZoneDesc());
        }
        colTimeZone.put("today", zone.format(new TimeService().now(), ((DateTimeProp)fieldProp).getDateFormat()));
        return colTimeZone;
    }

    private void formatByFmtInfo(Map<String, Map<String, Object>> fmtInfo, String numType, String numberKey, NumberPrecision numberPrecision) {
        int precision = -1;
        if (!fmtInfo.values().iterator().hasNext()) {
            numberPrecision.setPrecision(precision);
            return;
        }
        Map<String, Object> preciseMap = StringUtils.isBlank((CharSequence)numberKey) ? fmtInfo.values().iterator().next() : fmtInfo.get(numberKey);
        if (preciseMap == null) {
            return;
        }
        if ("qty".equals(numType)) {
            precision = Integer.parseInt(preciseMap.get("ps").toString());
        } else if (AMOUNT.equals(numType) || PRICE.equals(numType)) {
            precision = AMOUNT.equals(numType) ? Integer.parseInt(preciseMap.get("ap").toString()) : Integer.parseInt(preciseMap.get("pp").toString());
            numberPrecision.setSign(preciseMap.get("cs").toString());
            numberPrecision.setShowSign(false);
        }
        numberPrecision.setPrecision(precision);
    }

    public NumberPrecision getFormatPrecision(String scaleFieldKey, DynamicObject rowData) {
        return this.getFormatPrecision(scaleFieldKey, rowData, null);
    }

    public NumberPrecision getFormatPrecision(String scaleFieldName, DynamicObject rowData, DynamicObject fmtRowData) {
        if (fmtRowData == null) {
            fmtRowData = rowData;
        }
        String scaleFieldKey = scaleFieldName.substring(Math.max(0, scaleFieldName.lastIndexOf(46) + 1));
        IDataEntityProperty scaleFieldProp = null;
        if (this.fmtFields != null) {
            for (FmtField field : this.fmtFields) {
                if (!Objects.nonNull(field.getFieldProp()) || !field.getFieldProp().getName().equals(scaleFieldKey)) continue;
                scaleFieldProp = field.getFieldProp();
                break;
            }
        }
        NumberPrecision numberPrecision = null;
        numberPrecision = scaleFieldProp instanceof INumberPrecision ? ((INumberPrecision)scaleFieldProp).create(this.formatObject) : new NumberPrecision(this.formatObject);
        String controlFieldName = this.fieldControlPropMap.get(scaleFieldKey);
        Map<String, Map<String, Object>> fmtInfo = StringUtils.isBlank((CharSequence)controlFieldName) ? this.fieldFmtInfo.get(scaleFieldKey) : this.fieldFmtInfo.get(controlFieldName);
        if (fmtInfo != null && fmtInfo.size() > 0) {
            String numberKey = null;
            if (rowData != null && StringUtils.isNotBlank((CharSequence)controlFieldName)) {
                IDataEntityProperty property = this.curEntryControlFields.get(controlFieldName);
                boolean isEqualControl = property.getParent().getName().equals(rowData.getDynamicObjectType().getName());
                if (this.dataEntity != null && property.getParent() instanceof BillEntityType || !isEqualControl) {
                    numberKey = property.getName();
                } else {
                    DynamicObject curDynamicObject = (DynamicObject)property.getValueFast((Object)(isEqualControl ? rowData : fmtRowData));
                    if (curDynamicObject != null) {
                        numberKey = curDynamicObject.getString(NUMBER);
                        if (!fmtInfo.containsKey(numberKey)) {
                            if (property instanceof CurrencyProp) {
                                fmtInfo.put(numberKey, FmtInfoUtils.getCurrencyFmt(curDynamicObject));
                            } else if (property instanceof UnitProp) {
                                fmtInfo.put(numberKey, FmtInfoUtils.getUnitFmt(curDynamicObject));
                            }
                        }
                    } else {
                        BigDecimal value = rowData.getBigDecimal(scaleFieldName);
                        numberPrecision.setResult(value);
                        if (scaleFieldProp instanceof INumberPrecision) {
                            numberPrecision.setPrecision(((INumberPrecision)scaleFieldProp).getDefaultPrecision());
                        } else if (value != null) {
                            numberPrecision.setPrecision(value.scale());
                        }
                        return numberPrecision;
                    }
                }
            }
            Map<String, Object> colType = this.decimalFieldMap.get(scaleFieldKey);
            String numType = colType.get(NUMTYPE).toString();
            this.formatByFmtInfo(fmtInfo, numType, numberKey, numberPrecision);
        } else {
            Map<String, Object> colType = this.decimalFieldMap.get(scaleFieldKey);
            if (colType != null) {
                int precision = Integer.parseInt(colType.get(SCALE).toString());
                numberPrecision.setPrecision(precision);
            }
        }
        if (scaleFieldProp instanceof ExchangeRateProp && ExRateConfigUtil.isEnableExRatePrecisionControl()) {
            CurrencyProp oriProp = (CurrencyProp)this.getProp(((ExchangeRateProp)scaleFieldProp).getOriginalCurrencyFieldKey());
            CurrencyProp tarProp = (CurrencyProp)this.getProp(((ExchangeRateProp)scaleFieldProp).getTargetCurrencyFieldKey());
            Object oriCurr = this.getValue((IDataEntityProperty)oriProp, rowData);
            Object tarCurr = this.getValue((IDataEntityProperty)tarProp, rowData);
            if (oriProp != null && tarProp != null && oriCurr != null && tarCurr != null) {
                int currencyPairScale = ExRateConfigUtil.getExchangeRatePrecision((Long)oriCurr, (Long)tarCurr);
                if (currencyPairScale > 0) {
                    BigDecimal value = null;
                    value = this.dataEntitys.getDynamicObjectType().getName().equals("QueryObject") ? (BigDecimal)this.getValue(this.getProp(scaleFieldProp.getName()), rowData) : (BigDecimal)this.getValue(scaleFieldProp, rowData);
                    if (value != null) {
                        int valScale = value.stripTrailingZeros().scale();
                        numberPrecision.setPrecision(Math.max(currencyPairScale, valScale));
                    } else {
                        numberPrecision.setPrecision(currencyPairScale);
                    }
                }
            } else {
                int defaultPrecision = ExRateConfigUtil.getExchangeRateDefaultPrecision();
                if (defaultPrecision > 0) {
                    numberPrecision.setPrecision(defaultPrecision);
                }
            }
        }
        if (rowData != null) {
            BigDecimal val = null;
            DynamicProperty prop = rowData.getDynamicObjectType().getProperty(scaleFieldName);
            if (prop instanceof BigIntProp || prop instanceof IntegerProp) {
                Object v = rowData.get((IDataEntityProperty)prop);
                if (v == null && prop.isEnableNull()) {
                    return null;
                }
                val = v == null ? new BigDecimal(0) : new BigDecimal(v.toString());
            } else {
                val = rowData.getBigDecimal(scaleFieldName, prop.isEnableNull());
            }
            if (val == null) {
                return null;
            }
            if (prop instanceof FieldProp && !((FieldProp)prop).isZeroShow() && BigDecimal.ZERO.compareTo(val) == 0) {
                return null;
            }
            numberPrecision.setResult(val);
        }
        return numberPrecision;
    }

    private IDataEntityProperty getProp(String key) {
        IDataEntityProperty prop = null;
        DynamicObjectType parentType = this.dataEntitys.getDynamicObjectType();
        if (parentType.getName().equals("QueryObject")) {
            for (IDataEntityProperty property : parentType.getProperties()) {
                String propFullName = property.getName();
                String propName = propFullName.split("\\.")[propFullName.split("\\.").length - 1];
                if (!propName.equals(key)) continue;
                return property;
            }
            return null;
        }
        prop = (IDataEntityProperty)parentType.getProperties().get((Object)key);
        if (prop != null) {
            return prop;
        }
        DynamicObject parent = null;
        if (this.dataEntitys != null && this.dataEntitys.size() > 0) {
            parent = (DynamicObject)((DynamicObject)this.dataEntitys.get(0)).getParent();
        }
        if (prop == null && (parentType = parentType.getParent()) != null && (prop = (IDataEntityProperty)parentType.getProperties().get((Object)key)) != null && parent != null) {
            return prop;
        }
        if (prop == null && parentType != null && (parentType = parentType.getParent()) != null && (prop = (IDataEntityProperty)parentType.getProperties().get((Object)key)) != null && parent != null) {
            return prop;
        }
        return null;
    }

    private Object getValue(IDataEntityProperty property, DynamicObject rowData) {
        if (property == null) {
            return null;
        }
        Object value = null;
        boolean isEqualControl = property.getParent().getName().equals(rowData.getDynamicObjectType().getName());
        if (isEqualControl) {
            value = property.getValueFast((Object)rowData);
        } else {
            boolean isParentControl;
            boolean bl = isParentControl = rowData.getParent() != null ? property.getParent().getName().equals(((DynamicObject)rowData.getParent()).getDynamicObjectType().getName()) : false;
            if (isParentControl) {
                value = property.getValueFast(rowData.getParent());
            }
        }
        if (value instanceof DynamicObject) {
            return ((DynamicObject)value).getPkValue();
        }
        return value;
    }

    private void obtainRowFmtInfo(FmtBaseDataPropField field) {
        try {
            if (!field.isNeedRowFmt()) {
                return;
            }
            int rowIndex = this.rowStartIndex;
            for (DynamicObject dataEntity : this.dataEntitys) {
                Object baseObj;
                String refDisplayProp = field.getRefDisplayProp();
                IDataEntityProperty fieldProp = field.getFieldProp();
                if (fieldProp != null && StringUtils.isNotBlank((CharSequence)refDisplayProp) && (baseObj = fieldProp.getValue((Object)dataEntity)) instanceof DynamicObject) {
                    DynamicObject fmtData = (DynamicObject)baseObj;
                    String[] refs = refDisplayProp.split("\\.");
                    IDataEntityProperty refProp = (IDataEntityProperty)fmtData.getDataEntityType().getProperties().get((Object)refs[0]);
                    if (refs.length == 2 && refProp instanceof BasedataProp) {
                        fmtData = fmtData.getDynamicObject(refProp);
                        refProp = (IDataEntityProperty)((BasedataProp)refProp).getComplexType().getProperties().get((Object)refs[1]);
                    }
                    this.addRowFmtInfo(rowIndex, fieldProp.getName(), refProp, fmtData);
                }
                ++rowIndex;
            }
        }
        catch (Exception e) {
            log.error(String.format("\u83b7\u53d6\u5b57\u6bb5\u7684\u683c\u5f0f\u5316\u4fe1\u606f\u5931\u8d25, fieldKey:%s, displayProp:%s", field.getFieldName(), field.getRefDisplayProp()), (Throwable)e);
        }
    }

    private void addRowFmtInfo(int rowIndex, String fieldName, IDataEntityProperty property, DynamicObject dataEntity) {
        if (dataEntity != null && property instanceof DecimalProp) {
            String controlPropName = ((DecimalProp)property).getControlPropName();
            if (StringUtils.isBlank((CharSequence)controlPropName)) {
                if (property instanceof AmountProp) {
                    this.addRowFmtInfo(rowIndex, "_MainCurrency_", CURRENCYFMTKEY, FmtInfoUtils.getMainCurrencyFmt(), false);
                }
            } else {
                IDataEntityProperty refProp = (IDataEntityProperty)dataEntity.getDataEntityType().getProperties().get((Object)controlPropName);
                if (refProp == null) {
                    return;
                }
                DynamicObject data = dataEntity.getDynamicObject(controlPropName);
                if (refProp instanceof CurrencyProp && data != null) {
                    HashMap<String, Object> fmt = new HashMap<String, Object>(4);
                    fmt.put("ap", data.get("amtprecision"));
                    fmt.put("pp", data.get("priceprecision"));
                    fmt.put("cs", data.get("sign"));
                    fmt.put("cn", data.get(NUMBER));
                    this.addRowFmtInfo(rowIndex, fieldName, CURRENCYFMTKEY, fmt, false);
                } else if (refProp instanceof UnitProp) {
                    this.addRowFmtInfo(rowIndex, fieldName, UNITFMTKEY, FmtInfoUtils.getUnitFmt(data), false);
                }
            }
        }
    }

    private void addRowFmtInfo(int rowIndex, String key, String type, Map<String, Object> fmt, boolean isAddRowFmtInfo) {
        if (CollectionUtils.isEmpty(fmt)) {
            return;
        }
        if (isAddRowFmtInfo && StringUtils.equals((CharSequence)type, (CharSequence)UNITFMTKEY)) {
            if (this.rowFmtInfo.get(rowIndex) != null) {
                this.rowFmtInfo.get(rowIndex).put(key, fmt);
            } else {
                HashMap<String, Map<String, Object>> info = new HashMap<String, Map<String, Object>>();
                info.put(key, fmt);
                this.rowFmtInfo.put(rowIndex, info);
            }
        }
        if (this.rowAllFmtInfo.get(rowIndex) == null) {
            this.rowAllFmtInfo.put(rowIndex, new HashMap(16));
        }
        if (this.rowAllFmtInfo.get(rowIndex).get(type) == null) {
            this.rowAllFmtInfo.get(rowIndex).put(type, new HashMap(16));
        }
        this.rowAllFmtInfo.get(rowIndex).get(type).put(key, fmt);
    }
}

