/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityMetadataLocalCache;
import kd.bos.entity.EntityMetadataProvider;
import kd.bos.entity.IEntityMetaDataProvider;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.RefEntityType;
import kd.bos.entity.RefPropType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.script.annotations.KSMethod;
import kd.bos.sharemeta.ShareMetaUtil;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class RefEntityTypeCache {
    private static final Log logger = LogFactory.getLog(RefEntityTypeCache.class);
    private static final Object lock = new Object();
    private static final int REF_LEVEL = 4;
    private static IEntityMetaDataProvider provider;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IEntityMetaDataProvider getProvider() {
        Object object = lock;
        synchronized (object) {
            provider = ShareMetaUtil.enableShareMeta() ? ShareMetaUtil.getEntityMetaDataProvider() : new EntityMetadataProvider();
        }
        return provider;
    }

    @KSMethod
    public static RefEntityType getRefEntityType(String number, boolean fillRef) {
        RefEntityType refEntityType = RefEntityTypeCache.tryGetInnerRefEntityType(number, fillRef);
        EntityMetadataLocalCache.clearNoFillRefDataEntityType(number);
        return refEntityType;
    }

    private static RefEntityType tryGetInnerRefEntityType(String number, boolean fillRef) {
        try {
            return RefEntityTypeCache.getInnerRefEntityType(number, fillRef);
        }
        catch (RuntimeException exp) {
            EntityMetadataLocalCache.remove(number);
            return RefEntityTypeCache.getInnerRefEntityType(number, fillRef);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static RefEntityType getInnerRefEntityType(String number, boolean fillRef) {
        RefEntityType dt = RefEntityTypeCache.getRefEntityTypeFromLocalCache(number);
        boolean fromLocalCache = true;
        if (dt == null) {
            dt = EntityMetadataLocalCache.getNoFillRefDataEntityType(number);
            fromLocalCache = false;
        }
        if (dt == null || dt == RefEntityType.Empty) {
            dt = RefEntityTypeCache.getProvider().getRefEntityType(number);
            dt.setCheckVersionTimeMillis(System.currentTimeMillis());
            fromLocalCache = false;
            logger.debug("\u5f15\u7528\u5b9e\u4f53\u7f13\u5b58\u6279\u91cf\u672a\u53d6\u5230\u3002traceid:{}, number:{}", (Object)RequestContext.get().getTraceId(), (Object)number);
        }
        if (fillRef) {
            RefEntityType refEntityType = dt;
            synchronized (refEntityType) {
                RefEntityTypeCache.fillRefTypes(dt);
            }
            if (!fromLocalCache) {
                RefEntityTypeCache.putRefEntityTypeToLocalCache(dt);
            }
        }
        return dt;
    }

    private static void fillRefTypes(RefEntityType dt) {
        List<RefPropType> refPropTypes = dt.getRefPropTypes();
        if (refPropTypes != null && !refPropTypes.isEmpty()) {
            HashMap<String, DynamicObjectType> types = new HashMap<String, DynamicObjectType>(16);
            for (RefPropType refPropType : new ArrayList<RefPropType>(refPropTypes)) {
                RefEntityType refDT = null;
                try {
                    if (dt.getName().equals(refPropType.getId())) {
                        refDT = dt;
                    } else {
                        refDT = RefEntityTypeCache.tryGetInnerRefEntityType(refPropType.getId(), refPropType.isMaster());
                        if (refDT.refPropTypes != null && !refDT.refPropTypes.isEmpty()) {
                            ArrayList<RefPropType> refMasterTypes2 = new ArrayList<RefPropType>(1);
                            RefPropType removeType = null;
                            for (RefPropType refPropType2 : new ArrayList(refDT.refPropTypes)) {
                                if (!refPropType2.isMaster()) continue;
                                refMasterTypes2.add(refPropType2);
                                Map<String, DynamicObjectType> refTypes2 = RefEntityTypeCache.getInnerRefTypes(refMasterTypes2, true);
                                refDT.fillRefType(refDT, refTypes2);
                                removeType = refPropType2;
                                break;
                            }
                            if (removeType != null) {
                                refDT.refPropTypes.remove(removeType);
                            }
                        }
                    }
                    types.put(refPropType.getId(), refDT.getSubEntityType(refPropType.getPropSet()));
                }
                catch (RuntimeException exp) {
                    EntityMetadataLocalCache.remove(refPropType.getId());
                    throw exp;
                }
            }
            dt.fillRefEntityTypes(types);
        }
    }

    public static Map<String, DynamicObjectType> getRefTypes(List<RefPropType> refPropTypes) {
        return RefEntityTypeCache.getRefTypes(refPropTypes, true);
    }

    public static Map<String, DynamicObjectType> getRefTypes(MainEntityType met) {
        HashSet<MainEntityType> list = new HashSet<MainEntityType>(1);
        list.add(met);
        RefEntityTypeCache.loadRefDT(list, 0);
        HashMap<String, DynamicObjectType> types = new HashMap<String, DynamicObjectType>(16);
        for (RefPropType refPropType : met.getRefPropTypes()) {
            RefEntityType refDT = RefEntityTypeCache.getRefEntityType(refPropType.getId(), true);
            types.put(refPropType.getId(), refDT.getSubEntityType(refPropType.getPropSet()));
        }
        return types;
    }

    private static void loadRefDT(Set<MainEntityType> entityTypes, int level) {
        HashMap<String, Set<String>> noCacheRefMap = new HashMap<String, Set<String>>(16);
        HashSet<MainEntityType> subEntityTypes = new HashSet<MainEntityType>(10);
        for (MainEntityType rt : entityTypes) {
            if (rt.getRefPropTypes() == null || rt.getRefPropTypes().size() <= 0) continue;
            noCacheRefMap.putAll(RefEntityTypeCache.getNoCacheRef(rt.getRefPropTypes(), subEntityTypes));
        }
        if (noCacheRefMap.size() > 0) {
            RefEntityTypeCache.loadRedisRefTypes(noCacheRefMap, subEntityTypes);
        }
        if (level < 4) {
            RefEntityTypeCache.loadRefDT(subEntityTypes, level + 1);
        }
    }

    private static void loadRedisRefTypes(Map<String, Set<String>> noCacheRefMap, Set<MainEntityType> types) {
        Map<String, RefEntityType> refPropTypeMap = RefEntityTypeCache.getProvider().getRefEntityTypes(noCacheRefMap.keySet());
        for (Map.Entry<String, Set<String>> entry : noCacheRefMap.entrySet()) {
            String key = entry.getKey();
            RefEntityType dt = refPropTypeMap.get(key);
            dt.setCheckVersionTimeMillis(System.currentTimeMillis());
            EntityMetadataLocalCache.putNoFillRefDataEntityType(dt);
            types.add(dt);
        }
    }

    public static Map<String, DynamicObjectType> getRefTypes(List<RefPropType> refPropTypes, boolean fillRef) {
        Map<String, DynamicObjectType> map = RefEntityTypeCache.getInnerRefTypes(refPropTypes, fillRef);
        for (RefPropType refPropType : refPropTypes) {
            EntityMetadataLocalCache.clearNoFillRefDataEntityType(refPropType.getId());
        }
        return map;
    }

    private static Map<String, DynamicObjectType> getInnerRefTypes(List<RefPropType> refPropTypes, boolean fillRef) {
        HashMap<String, DynamicObjectType> types = new HashMap<String, DynamicObjectType>(16);
        for (RefPropType refPropType : refPropTypes) {
            RefEntityType refDT = RefEntityTypeCache.tryGetInnerRefEntityType(refPropType.getId(), fillRef);
            types.put(refPropType.getId(), refDT.getSubEntityType(refPropType.getPropSet()));
        }
        return types;
    }

    private static Map<String, Set<String>> getNoCacheRef(List<RefPropType> refPropTypes, Set<MainEntityType> types) {
        HashMap<String, Set<String>> noCacheRefMap = new HashMap<String, Set<String>>(10);
        RefEntityType dt = null;
        ArrayList<RefPropType> copyList = new ArrayList<RefPropType>(refPropTypes);
        for (RefPropType refPropType : copyList) {
            dt = RefEntityTypeCache.getRefEntityTypeFromLocalCache(refPropType.getId());
            if (dt == null) {
                dt = EntityMetadataLocalCache.getNoFillRefDataEntityType(refPropType.getId());
            }
            if (dt == null || dt == RefEntityType.Empty) {
                noCacheRefMap.put(refPropType.getId(), refPropType.getPropSet());
                continue;
            }
            types.add(dt);
        }
        return noCacheRefMap;
    }

    private static RefEntityType getRefEntityTypeFromLocalCache(String number) {
        RefEntityType dt = EntityMetadataLocalCache.getRefDataEntityType(number);
        String version = null;
        if (dt != null && System.currentTimeMillis() - dt.getCheckVersionTimeMillis() > 9000000L) {
            version = EntityMetadataCache.getRuntimeMetadataVersion(number);
            if (version.equals(dt.getVersion())) {
                dt.setCheckVersionTimeMillis(System.currentTimeMillis());
            } else {
                dt = null;
                EntityMetadataLocalCache.clearNoFillRefDataEntityType(number);
            }
        }
        return dt;
    }

    private static void putRefEntityTypeToLocalCache(RefEntityType dt) {
        EntityMetadataLocalCache.putRefDataEntityType(dt);
    }

    private static void putNoFillRefEntityTypeToLocalCache(RefEntityType dt) {
        EntityMetadataLocalCache.putNoFillRefDataEntityType(dt);
    }
}

