/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.api;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.sdk.annotation.SdkPublic;

@KSObject(name="ApiResult")
@SdkPublic
public class ApiResult {
    private static final String BOS_ENTITY_METADATA = "bos-entity-metadata";
    private static final String SUCCESS = "success";
    private static final String ERROR = "fail";
    private boolean success_s = true;
    private Integer httpStatus;
    private Object data;
    private String message;
    private String errorCode;

    @KSMethod
    public void setSuccess(boolean success) {
        if (StringUtils.isEmpty((CharSequence)this.errorCode)) {
            this.errorCode = success ? SUCCESS : ERROR;
        }
        this.success_s = success;
    }

    @KSMethod
    public boolean getSuccess() {
        return this.success_s;
    }

    @KSMethod
    public Object getData() {
        return this.data;
    }

    @KSMethod
    public void setData(Object data) {
        this.data = data;
    }

    @KSMethod
    public void setMessage(String message) {
        this.message = message;
    }

    @KSMethod
    public String getMessage() {
        return this.message;
    }

    @KSMethod
    public String getErrorCode() {
        return this.errorCode;
    }

    @KSMethod
    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    protected void init(Map<String, Object> obj) {
        this.setSuccess((Boolean)obj.get(SUCCESS));
        this.setMessage((String)obj.get("message"));
        this.setData(obj.get("data"));
        this.setErrorCode((String)obj.get("errorCode"));
    }

    protected Map<String, Object> toMap() {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put(SUCCESS, this.getSuccess());
        ret.put("message", this.getMessage());
        ret.put("data", this.getData());
        ret.put("errorCode", this.getErrorCode());
        return ret;
    }

    @KSMethod
    public static ApiResult fail(String msg) {
        return ApiResult.fail(msg, ERROR);
    }

    @KSMethod
    public static ApiResult fail(String msg, String errorCode) {
        ApiResult result = new ApiResult();
        result.setSuccess(false);
        result.setMessage(msg);
        result.setErrorCode(errorCode);
        return result;
    }

    @KSMethod
    public static ApiResult success(Object data) {
        ApiResult result = new ApiResult();
        result.setSuccess(true);
        result.setData(data);
        result.setErrorCode(SUCCESS);
        return result;
    }

    @KSMethod
    public static ApiResult ex(Throwable ex) {
        ApiResult result = new ApiResult();
        result.setSuccess(false);
        result.setMessage(ex.getMessage());
        result.setErrorCode(ApiResult.getErrorCode(ex));
        return result;
    }

    public static ApiResult ex(Throwable ex, boolean showStackTrace) {
        ApiResult result = new ApiResult();
        result.setSuccess(false);
        if (ex instanceof KDBizException) {
            result.setMessage(ex.getMessage());
        } else {
            result.setMessage(showStackTrace ? ApiResult.formatException(ex) : ResManager.loadKDString((String)"\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u65e5\u5fd7\u5206\u6790\u3002", (String)"ApiResult_0", (String)BOS_ENTITY_METADATA, (Object[])new Object[0]));
        }
        result.setErrorCode(ApiResult.getErrorCode(ex));
        return result;
    }

    /*
     * Exception decompiling
     */
    private static String formatException(Throwable throwable) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static String getErrorCode(Throwable ex) {
        if (ex instanceof KDException) {
            ErrorCode errorCode = ((KDException)ex).getErrorCode();
            if (errorCode != null && StringUtils.isNotBlank((CharSequence)errorCode.getCode())) {
                return errorCode.getCode();
            }
            return ERROR;
        }
        return ERROR;
    }

    @KSMethod
    public static ApiResult fromMap(Map<String, Object> ret) {
        ApiResult apiret = new ApiResult();
        apiret.init(ret);
        return apiret;
    }

    @KSMethod
    public static Map<String, Object> toMap(ApiResult result) {
        return result.toMap();
    }

    public Integer getHttpStatus() {
        return this.httpStatus;
    }

    public void setHttpStatus(Integer httpStatus) {
        this.httpStatus = httpStatus;
    }
}

