/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.dynplugin;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.entity.dynplugin.EntityDynamicPluginCache;
import kd.bos.service.dynplugin.DynPlugin;

public interface KingScriptEntityDynamicProxyPlugin {
    public void register();

    public static class OperateDynamicProxyPlugin
    implements KingScriptEntityDynamicProxyPlugin {
        private List<Map<String, Object>> operatePlugins;
        private String entityId;
        private String operationKey;

        public OperateDynamicProxyPlugin(List<Map<String, Object>> operatePlugins, String entityId, String operationKey) {
            this.operatePlugins = operatePlugins;
            this.entityId = entityId;
            this.operationKey = operationKey;
        }

        @Override
        public void register() {
            Map<Integer, String> classNames = this.loadTS();
            classNames.forEach(this::registerMixtureProxyPlugin);
        }

        private Map<Integer, String> loadTS() {
            String eventmethod = "ALL";
            List<DynPlugin> dynamicPlugins = EntityDynamicPluginCache.getDynamicPlugins(this.entityId, eventmethod, this.operationKey);
            HashMap<Integer, String> result = new HashMap<Integer, String>(dynamicPlugins == null ? 0 : dynamicPlugins.size());
            if (dynamicPlugins != null && dynamicPlugins.size() > 0) {
                for (int i = 0; i < dynamicPlugins.size(); ++i) {
                    DynPlugin dynamicPlugin = dynamicPlugins.get(i);
                    result.put(i, dynamicPlugin.getClassName());
                }
            }
            return result;
        }

        private void registerMixtureProxyPlugin(int row, String className) {
            this.operatePlugins.add(this.getOperateProxyPlugin(row, className));
        }

        private Map<String, Object> getOperateProxyPlugin(int row, String className) {
            LinkedHashMap<String, Object> pluginMap = new LinkedHashMap<String, Object>(6);
            pluginMap.put("className", className);
            pluginMap.put("rowKey", row);
            pluginMap.put("enabled", true);
            pluginMap.put("type", 4);
            return pluginMap;
        }
    }
}

