/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.filter;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.filter.IConditionVariableAnalysis;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;

public class ConditionVariableFactory {
    static Map<String, Class<?>> typesDict = new HashMap();
    static volatile ConditionVariableFactory mInstance = null;
    static Object lockObject = new Object();

    private ConditionVariableFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConditionVariableFactory getSingleInstance() {
        if (mInstance == null) {
            Object object = lockObject;
            synchronized (object) {
                if (mInstance == null) {
                    mInstance = new ConditionVariableFactory();
                }
            }
        }
        return mInstance;
    }

    public IConditionVariableAnalysis getOrRegisterVariableInstance(String className) {
        if (StringUtils.isBlank((CharSequence)className)) {
            return null;
        }
        Class<?> type = typesDict.get(className);
        if (type == null) {
            try {
                type = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                throw new KDBizException((Throwable)e, BosErrorCode.cannotLoadBeanClass, new Object[]{className});
            }
            if (type != null) {
                typesDict.put(className, type);
            } else {
                return null;
            }
        }
        try {
            return (IConditionVariableAnalysis)type.newInstance();
        }
        catch (InstantiationException e) {
            throw new KDBizException((Throwable)e, BosErrorCode.beanInstantiation, new Object[]{className});
        }
        catch (IllegalAccessException e) {
            throw new KDBizException((Throwable)e, BosErrorCode.beanCreationNotAllowed, new Object[]{className});
        }
    }
}

