/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.filter;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.DefaultFilterValueSetter;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.filter.IFilterValueSetter;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class FilterBuilderParameter {
    private final MainEntityType dataType;
    private final FilterCondition filterCondition;
    private IFilterValueSetter filterValueSetter = new DefaultFilterValueSetter();
    private boolean isCheckInput = true;
    private List<FilterField> filterFields = null;
    private boolean isNeedParse = true;
    private boolean isNeedParseBaseDataIds;
    private Set<String> flexFields = new HashSet<String>(16);

    public FilterBuilderParameter(MainEntityType dataType, FilterCondition filterCondition) {
        this.dataType = dataType;
        this.filterCondition = filterCondition;
    }

    public FilterBuilderParameter setFilterValueSetter(IFilterValueSetter filterValueSetter) {
        this.filterValueSetter = filterValueSetter;
        return this;
    }

    public FilterBuilderParameter setCheckInput(boolean checkInput) {
        this.isCheckInput = checkInput;
        return this;
    }

    public FilterBuilderParameter setFilterFields(List<FilterField> filterFields) {
        this.filterFields = filterFields;
        return this;
    }

    public FilterBuilderParameter setNeedParse(boolean needParse) {
        this.isNeedParse = needParse;
        return this;
    }

    public FilterBuilderParameter setNeedParseBaseDataIds(boolean needParseBaseDataIds) {
        this.isNeedParseBaseDataIds = needParseBaseDataIds;
        return this;
    }

    public FilterBuilderParameter addFlexField(String flexField) {
        this.flexFields.add(flexField);
        return this;
    }

    public MainEntityType getDataType() {
        return this.dataType;
    }

    public FilterCondition getFilterCondition() {
        return this.filterCondition;
    }

    public IFilterValueSetter getFilterValueSetter() {
        return this.filterValueSetter;
    }

    public boolean isCheckInput() {
        return this.isCheckInput;
    }

    public List<FilterField> getFilterFields() {
        return this.filterFields;
    }

    public boolean isNeedParse() {
        return this.isNeedParse;
    }

    public boolean isNeedParseBaseDataIds() {
        return this.isNeedParseBaseDataIds;
    }

    public Set<String> getFlexFields() {
        return this.flexFields;
    }
}

