/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.filter;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.CollectionPropertyAttribute;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcxmlSerializer;
import kd.bos.dataentity.serialization.ListDcxmlBinder;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.filter.CompareCategory;
import kd.bos.entity.filter.CompareType;
import kd.bos.entity.filter.LogicOperate;
import kd.bos.entity.filter.SortType;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.lang.Lang;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class FilterMetadata {
    private static final String CLONE_NOT_SUPPORTED_EXCEPTION_S = "CloneNotSupportedException:%s";
    public static final String FILTER_META_ID = "269QKQ0Q4X58";
    private static FilterMetadata filterMetadata_f;
    private static Map<String, FilterMetadata> filterMetadataMap;
    private String marks;
    private String nullMarks = "ISNULL({0},0)";
    private String nullMarksExt = "ISNULL({0},'')";
    private List<SortType> sortTypes;
    private List<LogicOperate> logics;
    private List<CompareCategory> compareCategories = new ArrayList<CompareCategory>(10);

    public String getMarks() {
        return this.marks;
    }

    public void setMarks(String marks) {
        this.marks = marks;
    }

    public List<SortType> getSortTypes() {
        return this.sortTypes;
    }

    public void setSortTypes(List<SortType> sortTypes) {
        this.sortTypes = sortTypes;
    }

    public List<LogicOperate> getLogics() {
        return this.logics;
    }

    public void setLogics(List<LogicOperate> logics) {
        this.logics = logics;
    }

    public String getNullMarks() {
        return this.nullMarks;
    }

    public void setNullMarks(String nullMarks) {
        this.nullMarks = nullMarks;
    }

    public String getNullMarksExt() {
        return this.nullMarksExt;
    }

    public void setNullMarksExt(String nullMarksExt) {
        this.nullMarksExt = nullMarksExt;
    }

    public FilterMetadata() {
        this.sortTypes = new ArrayList<SortType>();
        this.sortTypes.add(SortType.ASC);
        this.sortTypes.add(SortType.DESC);
        this.logics = new ArrayList<LogicOperate>();
        this.logics.add(LogicOperate.AND);
        this.logics.add(LogicOperate.OR);
    }

    public static synchronized FilterMetadata getFromXml() {
        ArrayList<IDataEntityType> dts = new ArrayList<IDataEntityType>();
        dts.add(OrmUtils.getDataEntityType(FilterMetadata.class));
        dts.add(OrmUtils.getDataEntityType(CompareCategory.class));
        dts.add(OrmUtils.getDataEntityType(CompareType.class));
        DcxmlSerializer ser = new DcxmlSerializer(dts);
        ser.getBinder().setLCId(Lang.zh_CN.toString());
        URL url = FilterMetadata.class.getResource("/FilterMetadata.xml");
        FilterMetadata localFilterMetadata = (FilterMetadata)ser.deserialize(url, null);
        ser.setOnlyLocaleVale(true);
        for (Lang lang : Lang.values()) {
            URL localeResourceUrl = FilterMetadata.class.getClassLoader().getResource("FilterMetadata." + lang.toString() + ".xml");
            if (localeResourceUrl == null) continue;
            ser.getBinder().setLCId(lang.toString());
            localFilterMetadata = (FilterMetadata)ser.deserialize(localeResourceUrl, (Object)localFilterMetadata);
        }
        return localFilterMetadata;
    }

    public static synchronized void cleareCache() {
        filterMetadataMap.remove(RequestContext.get().getAccountId());
    }

    public static synchronized FilterMetadata get() {
        return filterMetadataMap.computeIfAbsent(RequestContext.get().getAccountId(), k -> {
            FilterMetadata localFilterMetadata = filterMetadata_f;
            if (localFilterMetadata == null) {
                filterMetadata_f = localFilterMetadata = FilterMetadata.getFromXml();
            }
            return FilterMetadata.loadLangFromDB(localFilterMetadata);
        });
    }

    private static FilterMetadata loadLangFromDB(FilterMetadata localFilterMetadata) {
        String sql = "select flocaleid,fdata from t_meta_formdesign_l where fid = '269QKQ0Q4X58'";
        ArrayList xmlList = new ArrayList();
        DB.query((DBRoute)DBRoute.meta, (String)sql, rs -> {
            while (rs.next()) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("lcid", rs.getString("flocaleid"));
                map.put("xml", rs.getString("fdata"));
                xmlList.add(map);
            }
            return xmlList;
        });
        if (xmlList.size() > 0) {
            ArrayList<IDataEntityType> dts = new ArrayList<IDataEntityType>();
            dts.add(OrmUtils.getDataEntityType(FilterMetadata.class));
            dts.add(OrmUtils.getDataEntityType(CompareCategory.class));
            dts.add(OrmUtils.getDataEntityType(CompareType.class));
            localFilterMetadata = (FilterMetadata)FilterMetadata.cloneObject(dts, filterMetadata_f, Lang.zh_CN.toString());
            DcxmlSerializer ser = new DcxmlSerializer(dts);
            ser.setOnlyLocaleVale(true);
            for (Map map : xmlList) {
                ser.getBinder().setLCId((String)map.get("lcid"));
                ser.deserializeFromString((String)map.get("xml"), (Object)localFilterMetadata);
            }
            return localFilterMetadata;
        }
        return localFilterMetadata;
    }

    private static Object cloneObject(List<IDataEntityType> dts, Object entity, String lcid) {
        String xml = FilterMetadata.toXml(dts, entity, null, lcid);
        return FilterMetadata.toObject(dts, xml, lcid, null);
    }

    private static Object toObject(List<IDataEntityType> dts, String xml, String lcid, Object base) {
        ListDcxmlBinder binder = new ListDcxmlBinder(true, dts);
        binder.setLCId(lcid);
        DcxmlSerializer ser = new DcxmlSerializer((DcBinder)binder);
        ser.setIsLocaleValueFull(true);
        return ser.deserializeFromString(xml, base);
    }

    private static String toXml(List<IDataEntityType> dts, Object entity, Object base, String lcid) {
        ListDcxmlBinder binder = new ListDcxmlBinder(true, dts);
        binder.setLCId(lcid);
        DcxmlSerializer ser = new DcxmlSerializer((DcBinder)binder);
        ser.setIndent(true);
        ser.setNewlines(true);
        ser.setIsLocaleValueFull(true);
        return ser.serializeToString(entity, base);
    }

    @CollectionPropertyAttribute(collectionItemPropertyType=CompareCategory.class)
    public List<CompareCategory> getCompareCategories() {
        return this.compareCategories;
    }

    public CompareType getCompareType(String compareGroupId, String compareTypeId) {
        List<CompareType> compareTypes = this.getCompareTypes(compareGroupId);
        for (CompareType compareType : compareTypes) {
            if (!compareTypeId.equals(compareType.getId())) continue;
            try {
                return (CompareType)compareType.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new KDException((Throwable)e, new ErrorCode(CLONE_NOT_SUPPORTED_EXCEPTION_S, "CompareType not support clone!"), new Object[0]);
            }
        }
        return null;
    }

    public List<CompareType> getCompareTypes(String compareGroupId) {
        String[] groupIds;
        ArrayList<CompareType> list = new ArrayList<CompareType>();
        block2: for (String groupId : groupIds = compareGroupId.split(",")) {
            int intGroupId = Integer.parseInt(groupId);
            for (CompareCategory cc : this.compareCategories) {
                if (!groupId.equalsIgnoreCase(cc.getId())) continue;
                try {
                    CompareCategory compareCategory = (CompareCategory)cc.clone();
                    for (CompareType compareType : compareCategory.getCompareTypes()) {
                        compareType.setGroupId(intGroupId);
                    }
                    list.addAll(compareCategory.getCompareTypes());
                    continue block2;
                }
                catch (CloneNotSupportedException e) {
                    throw new KDException((Throwable)e, new ErrorCode(CLONE_NOT_SUPPORTED_EXCEPTION_S, "CompareCategory not support clone!"), new Object[0]);
                }
            }
        }
        return list;
    }

    public CompareType getCompareTypeByCompareTypeId(String compareTypeId) {
        for (CompareCategory cc : this.compareCategories) {
            try {
                CompareCategory compareCategory = (CompareCategory)cc.clone();
                for (CompareType type : compareCategory.getCompareTypes()) {
                    if (!type.getId().equals(compareTypeId)) continue;
                    return type;
                }
            }
            catch (CloneNotSupportedException e) {
                throw new KDException((Throwable)e, new ErrorCode(CLONE_NOT_SUPPORTED_EXCEPTION_S, "CompareCategory not support clone!"), new Object[0]);
            }
        }
        return null;
    }

    static {
        filterMetadataMap = new ConcurrentHashMap<String, FilterMetadata>();
    }
}

