/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.filter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.filter.FilterMetadata;
import kd.bos.entity.filter.FilterResult;
import kd.bos.entity.filter.FilterRow;
import kd.bos.entity.filter.FilterScriptBuilder;
import kd.bos.entity.filter.FilterSqlBuilder;
import kd.bos.inte.api.IInteService;
import kd.bos.orm.query.QFilter;
import kd.bos.service.IUserService;
import kd.bos.service.ServiceFactory;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class FilterObject {
    private FilterMetadata filterMetaData;
    protected MainEntityType dataType;
    protected Map<String, FilterField> filterFields = new HashMap<String, FilterField>();
    protected Map<String, FilterField> allFilterFields = new HashMap<String, FilterField>();
    protected Map<String, FilterField> compareFilterFields = new HashMap<String, FilterField>();
    private List<FilterRow> filterRows = new ArrayList<FilterRow>();
    private String advancedSetting;
    private IUserService userService;
    private QFilter qFilter;
    private String filter;
    private List<SqlParameter> param = new ArrayList<SqlParameter>();
    private boolean isCheckInput;
    private FilterResult filterResult;
    private IInteService inteService;
    private List<String> selectFields = new ArrayList<String>(10);
    private List<String> selectFieldsWithNotCompare = new ArrayList<String>(10);

    public FilterResult getFilterResult() {
        return this.filterResult;
    }

    public Map<String, FilterField> getCompareFilterFields() {
        return this.compareFilterFields;
    }

    @SdkInternal
    public void setCompareFilterFields(Map<String, FilterField> compareFilterFields) {
        this.compareFilterFields = compareFilterFields;
    }

    public boolean isCheckInput() {
        return this.isCheckInput;
    }

    @SdkInternal
    public void setCheckInput(boolean isCheckInput) {
        this.isCheckInput = isCheckInput;
    }

    public MainEntityType getDataType() {
        return this.dataType;
    }

    public void setDataType(MainEntityType dataType) {
        this.dataType = dataType;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public QFilter getQFilter() {
        return this.qFilter;
    }

    public void setQFilter(QFilter qFilter) {
        this.qFilter = qFilter;
    }

    @SdkInternal
    public IUserService getUserService() {
        return this.userService;
    }

    @SdkInternal
    public void setUserService(IUserService userService) {
        this.userService = userService;
    }

    IInteService getInteService() {
        return this.inteService;
    }

    @SdkInternal
    public List<SqlParameter> getParam() {
        return this.param;
    }

    @SdkInternal
    public void setParam(List<SqlParameter> param) {
        this.param = param;
    }

    @SdkInternal
    public FilterMetadata getFilterMetaData() {
        return this.filterMetaData;
    }

    @SdkInternal
    public void setFilterMetaData(FilterMetadata filterMetaData) {
        this.filterMetaData = filterMetaData;
    }

    public List<FilterRow> getFilterRows() {
        return this.filterRows;
    }

    public void setFilterRows(List<FilterRow> filterRows) {
        this.filterRows = filterRows;
    }

    public Map<String, FilterField> getFilterFields() {
        return this.filterFields;
    }

    @SdkInternal
    public void setFilterFields(Map<String, FilterField> filterFields) {
        this.filterFields = filterFields;
    }

    public Map<String, FilterField> getAllFilterFields() {
        return this.allFilterFields;
    }

    @SdkInternal
    public void setAllFilterFields(Map<String, FilterField> allFilterFields) {
        this.allFilterFields = allFilterFields;
    }

    @SdkInternal
    public void addField(FilterField field) {
        this.allFilterFields.put(field.getFieldName(), field);
    }

    @SdkInternal
    public void addFields(List<FilterField> fields) {
        for (FilterField filterField : fields) {
            this.addField(filterField);
        }
    }

    @SdkInternal
    public void addCompareFiled(FilterField field) {
        this.compareFilterFields.put(field.getFieldName(), field);
    }

    @SdkInternal
    public void addCompareFileds(List<FilterField> compareFields) {
        for (FilterField filterField : compareFields) {
            this.addCompareFiled(filterField);
        }
    }

    @SdkInternal
    @Deprecated
    public String getAdvancedSetting() {
        return this.advancedSetting;
    }

    @SdkInternal
    @Deprecated
    public void setAdvancedSetting(String advancedSetting) {
        this.advancedSetting = advancedSetting;
    }

    @SdkInternal
    @Deprecated
    public void clearFilterRow() {
        this.filterRows = new ArrayList<FilterRow>();
    }

    public List<String> getSelectFields() {
        return this.selectFields;
    }

    public List<String> getSelectFieldsWithNotCompare() {
        return this.selectFieldsWithNotCompare;
    }

    public FilterObject() {
    }

    public FilterObject(MainEntityType dataType) {
        this(dataType, false);
    }

    public FilterObject(MainEntityType dataType, boolean isCheckInput) {
        this.dataType = dataType;
        this.isCheckInput = isCheckInput;
    }

    public void buildFilter() {
        this.buildFilter(true);
    }

    public void buildFilter(boolean returnSql) {
        FilterSqlBuilder filterSqlBuilder = new FilterSqlBuilder();
        filterSqlBuilder.setUserService(this.userService);
        this.inteService = (IInteService)ServiceFactory.getService(IInteService.class);
        this.filterResult = filterSqlBuilder.buildFilter(this, returnSql, false);
        this.qFilter = this.filterResult.getQFilter();
        this.filter = this.filterResult.getFilterGroup()[0];
        this.selectFields.clear();
        for (FilterRow filterRow : this.getFilterRows()) {
            String fieldName = filterRow.getFilterField().getFieldName();
            this.selectFields.add(fieldName);
            String operate = filterRow.getCompareType().getOperate();
            if (!filterRow.getCompareType().isNeedInput() || !"NOT IN".equalsIgnoreCase(operate) && !"<>".equalsIgnoreCase(operate) && !"NOT LIKE".equalsIgnoreCase(operate)) continue;
            this.selectFieldsWithNotCompare.add(fieldName);
        }
    }

    public String[] buildFilterScript() {
        FilterScriptBuilder scriptBuilder = new FilterScriptBuilder();
        scriptBuilder.setUserService(this.userService);
        this.inteService = (IInteService)ServiceFactory.getService(IInteService.class);
        return scriptBuilder.buildFilterScript(this);
    }

    @SdkInternal
    @Deprecated
    public void setSelectEntity(String entityKey) {
        this.filterFields.clear();
        if (StringUtils.isEmpty((CharSequence)entityKey)) {
            for (FilterField field : this.allFilterFields.values()) {
                this.filterFields.put(field.getFieldName(), field);
            }
        } else {
            for (FilterField field : this.allFilterFields.values()) {
                String key = String.format(",%s,", field.getEntityKey());
                if (!entityKey.equalsIgnoreCase(key)) continue;
                this.filterFields.put(field.getFieldName(), field);
            }
        }
    }
}

