/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.filter;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.CompareType;
import kd.bos.entity.filter.ConditionVariableContext;
import kd.bos.entity.filter.ConditionVariableFactory;
import kd.bos.entity.filter.FieldName;
import kd.bos.entity.filter.FilterObject;
import kd.bos.entity.filter.FilterRow;
import kd.bos.entity.filter.IConditionVariableAnalysis;
import kd.bos.entity.filter.KDTimeZone;
import kd.bos.entity.formula.MemberVarParser;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.ITimeService;
import kd.bos.service.IUserService;
import kd.bos.service.KDDateUtils;
import kd.bos.service.TimeService;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class FilterScriptBuilder {
    private static final String BOS_ENTITY_METADATA = "bos-entity-metadata";
    private static final String AND = " and ";
    private static final String NOT_IN = "NOT IN";
    private static final String FORMAT = "%s %s %s";
    private static final String FALSE = "false";
    private static final String FILTER_SCRIPT_BUILDER_2 = "FilterScriptBuilder_2";
    private static final String FILTER_SCRIPT_BUILDER_3 = "FilterScriptBuilder_3";
    private static final String TODAY_BEFORE = "TODAYBEFORE";
    private static final String TODAY_AFTER = "TODAYAFTER";
    private static final String ZERO_POINT_STRING = " 00:00:00";
    private static final String LAST_POINT_STRING = " 23:59:59";
    private static final String BETWEEN = "between";
    private static final String DATE_FORMAT_STR = "DATE(%s)";
    private static final String FORMAT1 = "%s >= %s and %s <= %s ";
    private static final String FORMAT2 = "%s >= %s and %s < %s ";
    private static final String SPAN_TYPE_SCRIPTBUILDER = "FilterScriptBuilder";
    private static final String SPAN_PARAM_FILTERROW = "filterRow";
    private static final String SPAN_PARAM_VALUE = "value";
    private static String marks = "'";
    private static final Log log = LogFactory.getLog(FilterScriptBuilder.class);
    ITimeService timeService;
    IUserService userService;
    FilterObject filterObject;

    public void setTimeService(ITimeService timeService) {
        this.timeService = timeService;
    }

    public void setUserService(IUserService userService) {
        this.userService = userService;
    }

    public String[] buildFilterScript(FilterObject filterObj) {
        this.filterObject = filterObj;
        int countOfBracket = 0;
        String script = "";
        String scriptDesc = "";
        int filterRowCount = this.filterObject.getFilterRows().size();
        for (int i = 0; i < filterRowCount; ++i) {
            FilterRow filterRow = this.filterObject.getFilterRows().get(i);
            filterRow.setRowIndex(i);
            if (filterRow.getFilterField() == null || StringUtils.isBlank((CharSequence)filterRow.getFilterField().getFieldName()) || (filterRow.getValue().size() == 0 || StringUtils.isBlank((CharSequence)filterRow.getValue().get(0))) && filterRow.getCompareType().isNeedInput()) continue;
            countOfBracket = this.checkBracket(countOfBracket, filterRow);
            String[] conditionResult = this.makeCondition(filterRow);
            script = String.format("%s %s", script, conditionResult[0]);
            scriptDesc = String.format("%s %s", scriptDesc, conditionResult[1]);
        }
        if (countOfBracket != 0) {
            throw new KDException(ResManager.loadKDString((String)"\u5de6\u62ec\u53f7\u4e0e\u53f3\u62ec\u53f7\u4e0d\u5339\u914d\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"FilterScriptBuilder_0", (String)BOS_ENTITY_METADATA, (Object[])new Object[0]));
        }
        script = this.removeEndsWith(script);
        scriptDesc = this.removeEndsWith(scriptDesc);
        if (StringUtils.isNotBlank((CharSequence)script)) {
            script = "( " + script + " )";
        }
        String[] scripts = new String[]{script, scriptDesc};
        return scripts;
    }

    private int checkBracket(int countOfBracket, FilterRow row) {
        if (StringUtils.isNotBlank((CharSequence)row.getLeftBracket())) {
            countOfBracket += row.getLeftBracket().replace(" ", "").length();
        }
        if (StringUtils.isNotBlank((CharSequence)row.getRightBracket())) {
            countOfBracket -= row.getRightBracket().replace(" ", "").length();
        }
        if (countOfBracket < 0) {
            KDException e = new KDException(BosErrorCode.filterSqlBuilder, new Object[]{ResManager.loadKDString((String)"\u5de6\u62ec\u53f7\u4e0e\u53f3\u62ec\u53f7\u4e0d\u5339\u914d\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"FilterScriptBuilder_0", (String)BOS_ENTITY_METADATA, (Object[])new Object[0])});
            HashMap<String, FilterRow> tags = new HashMap<String, FilterRow>(1);
            tags.put(SPAN_PARAM_FILTERROW, row);
            EntityTracer.throwException((String)SPAN_TYPE_SCRIPTBUILDER, (String)"checkBracket", null, (Throwable)e, tags);
            throw e;
        }
        return countOfBracket;
    }

    private String removeEndsWith(String script) {
        if ((script = script.trim()).endsWith("and")) {
            script = script.substring(0, script.length() - 3);
        }
        if (script.endsWith("NONE")) {
            script = script.substring(0, script.length() - 4);
        }
        if (script.endsWith("&&")) {
            script = script.substring(0, script.length() - 2);
        }
        if (script.endsWith("or")) {
            script = script.substring(0, script.length() - 2);
        }
        if (script.endsWith("||")) {
            script = script.substring(0, script.length() - 2);
        }
        script = script.trim();
        return script;
    }

    private String[] makeCondition(FilterRow filterRow) {
        String[] scripts = new String[]{"", ""};
        String script = "";
        String scriptDesc = "";
        if (this.isCompareConstValue(filterRow)) {
            String[] constValues = this.getConstValue(filterRow);
            script = constValues[0];
            scriptDesc = constValues[1];
        } else {
            switch (filterRow.getCompareType().getInputCtlType()) {
                case 0: {
                    String[] strings = this.getManuInputFilterString(filterRow);
                    script = strings[0];
                    scriptDesc = strings[1];
                    break;
                }
                case 1: {
                    String[] strings = this.getComboxFilterString(filterRow);
                    script = strings[0];
                    scriptDesc = strings[1];
                    break;
                }
            }
        }
        String logic = filterRow.getLogic().toString().trim().toUpperCase(Locale.ENGLISH);
        if (logic.equals("OR")) {
            logic = " or ";
        } else if (logic.equals("||")) {
            logic = " or ";
        } else if (logic.equals("|")) {
            logic = " or ";
        } else if (logic.equals("AND")) {
            logic = AND;
        } else if (logic.equals("&&")) {
            logic = AND;
        } else if (logic.equals("&")) {
            logic = AND;
        }
        if (StringUtils.isBlank((CharSequence)logic)) {
            logic = AND;
        }
        scripts[0] = String.format(" %s %s %s %s", filterRow.getLeftBracket(), script, filterRow.getRightBracket(), logic);
        scripts[1] = String.format(" %s %s %s %s", filterRow.getLeftBracket(), scriptDesc, filterRow.getRightBracket(), logic);
        return scripts;
    }

    private String[] getManuInputFilterString(FilterRow filterRow) {
        String[] scripts = new String[]{"", ""};
        String[] values = this.checkInputValue(filterRow);
        String value = values[0];
        String valueDesc = values[1];
        if (StringUtils.isBlank((CharSequence)value)) {
            return scripts;
        }
        String fieldName = filterRow.getFilterField().getFieldName();
        String fieldCaption = this.getFieldCaption(filterRow.getFilterField().getFieldName());
        String script = "";
        String operateStr = filterRow.getCompareType().getOperate();
        int fieldType = filterRow.getFilterField().getFieldType();
        script = FilterScriptBuilder.isNumberField(fieldType) ? ("IN".equals(operateStr) ? String.format("%s in %s", fieldName, value) : (NOT_IN.equals(operateStr) ? String.format("%s not in %s", fieldName, value) : String.format(FORMAT, fieldName, operateStr, value))) : (fieldType == 91 ? this.getDateFilterString(filterRow, fieldName, value) : (fieldType == 92 || fieldType == 93 ? this.getTimeFilterString(filterRow, fieldName, value) : ("IN".equals(operateStr) ? String.format("%s in %s", fieldName, value) : (operateStr.equalsIgnoreCase(NOT_IN) ? String.format("%s not in %s", fieldName, value) : (operateStr.equalsIgnoreCase("like") ? String.format("%s like %s", fieldName, value) : (operateStr.equalsIgnoreCase("not like") ? String.format("%s not like %s", fieldName, value) : String.format(FORMAT, fieldName, filterRow.getCompareType().getOperate(), value)))))));
        scripts[0] = script;
        scripts[1] = String.format(FORMAT, fieldCaption, filterRow.getCompareType().getName().toString(), valueDesc);
        return scripts;
    }

    public static boolean isNumberField(int fieldType) {
        return fieldType == -7 || fieldType == -5 || fieldType == 3 || fieldType == 6 || fieldType == 4 || fieldType == 2 || fieldType == 7 || fieldType == 5 || fieldType == -6 || fieldType == 8;
    }

    public static boolean isStringField(int fieldType) {
        return fieldType == 2004 || fieldType == 1 || fieldType == 2005 || fieldType == -16 || fieldType == -1 || fieldType == -15 || fieldType == 2011 || fieldType == -9 || fieldType == 12;
    }

    private String[] getComboxFilterString(FilterRow filterRow) {
        String[] scripts = new String[]{"", ""};
        String script = "";
        String scriptDesc = "";
        String value = filterRow.getValue().get(0);
        if (StringUtils.isBlank((CharSequence)value)) {
            KDException e = new KDException(String.format(ResManager.loadKDString((String)"\u7b2c %d \u884c\uff1a\u6bd4\u8f83\u503c\u4e0d\u80fd\u4e3a\u7a7a", (String)"FilterScriptBuilder_1", (String)BOS_ENTITY_METADATA, (Object[])new Object[0]), filterRow.getRowIndex() + 1));
            HashMap<String, FilterRow> tags = new HashMap<String, FilterRow>(1);
            tags.put(SPAN_PARAM_FILTERROW, filterRow);
            EntityTracer.throwException((String)SPAN_TYPE_SCRIPTBUILDER, (String)"getComboxFilterString", null, (Throwable)e, tags);
            throw e;
        }
        List<DynamicProperty> props = MemberVarParser.findPropertys(this.filterObject.getDataType(), filterRow.getFilterField().getFieldName(), true);
        DynamicProperty fieldProp = props.get(props.size() - 1);
        int fieldType = filterRow.getFilterField().getFieldType();
        if (FilterScriptBuilder.isNumberField(fieldType)) {
            script = String.format(FORMAT, filterRow.getFilterField().getFieldName(), filterRow.getCompareType().getOperate(), value);
        } else if (filterRow.getCompareType().getOperate().equalsIgnoreCase("StatusEqualto")) {
            script = String.format("%s = '%s'", filterRow.getFilterField().getFieldName(), value);
        } else if (filterRow.getCompareType().getOperate().equalsIgnoreCase("StatusUnequalto")) {
            script = String.format("%s != '%s'", filterRow.getFilterField().getFieldName(), value);
        } else if (filterRow.getCompareType().isFieldCompare()) {
            script = String.format(FORMAT, filterRow.getFilterField().getFieldName(), filterRow.getCompareType().getOperate(), value);
        } else if (fieldProp instanceof BooleanProp) {
            if ("IN".equalsIgnoreCase(filterRow.getCompareType().getOperate()) || NOT_IN.equalsIgnoreCase(filterRow.getCompareType().getOperate())) {
                StringBuilder builder = new StringBuilder();
                for (String rowValue : filterRow.getValue()) {
                    if (StringUtils.isBlank((CharSequence)rowValue)) {
                        KDException e = new KDException(String.format(ResManager.loadKDString((String)"\u7b2c %d \u884c\uff1a\u6bd4\u8f83\u503c\u4e0d\u80fd\u4e3a\u7a7a", (String)"FilterScriptBuilder_1", (String)BOS_ENTITY_METADATA, (Object[])new Object[0]), filterRow.getRowIndex() + 1));
                        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_SCRIPTBUILDER, (String)"getComboxFilterString");){
                            span.addLocaleTag(SPAN_PARAM_FILTERROW, (Object)filterRow);
                            span.throwException((Throwable)e);
                        }
                        throw e;
                    }
                    builder.append(Integer.valueOf(rowValue.trim()).compareTo(1) == 0 ? "true" : FALSE).append(",");
                }
                String v = builder.toString();
                script = String.format(FORMAT, filterRow.getFilterField().getFieldName(), filterRow.getCompareType().getOperate(), "(" + v.substring(0, v.length() - 1) + ")");
            } else {
                script = String.format(FORMAT, filterRow.getFilterField().getFieldName(), filterRow.getCompareType().getOperate(), Integer.valueOf(value.trim()).compareTo(1) == 0 ? "true" : FALSE);
            }
        } else if ("IN".equalsIgnoreCase(filterRow.getCompareType().getOperate()) || NOT_IN.equalsIgnoreCase(filterRow.getCompareType().getOperate())) {
            script = String.format("%s %s ('%s')", filterRow.getFilterField().getFieldName(), filterRow.getCompareType().getOperate(), StringUtils.join((Object[])filterRow.getValue().toArray(), (String)"','"));
        } else if ("LIKE".equalsIgnoreCase(filterRow.getCompareType().getOperate()) || "NOT LIKE".equalsIgnoreCase(filterRow.getCompareType().getOperate())) {
            for (int i = 0; i < filterRow.getValue().size(); ++i) {
                value = "lIKE".equals(filterRow.getCompareType().getOperate()) ? filterRow.getValue().get(i) + "%" : ("like".equals(filterRow.getCompareType().getOperate()) ? "%" + filterRow.getValue().get(i) : "%" + filterRow.getValue().get(i) + "%");
                script = script + String.format("%s %s ('%s')", filterRow.getFilterField().getFieldName(), filterRow.getCompareType().getOperate(), value);
                if (i == filterRow.getValue().size() - 1) continue;
                script = String.format("%s %s", script, AND);
            }
        } else {
            script = String.format("%s %s ('%s')", filterRow.getFilterField().getFieldName(), filterRow.getCompareType().getOperate(), value.trim());
        }
        String fieldCaption = this.getFieldCaption(filterRow.getFilterField().getFieldName());
        scriptDesc = "IN".equalsIgnoreCase(filterRow.getCompareType().getOperate()) || NOT_IN.equalsIgnoreCase(filterRow.getCompareType().getOperate()) ? String.format("%s %s (%s)", fieldCaption, filterRow.getCompareType().getName().toString(), this.getComboxItemCaption(filterRow, fieldProp)) : String.format(FORMAT, fieldCaption, filterRow.getCompareType().getName().toString(), this.getComboxItemCaption(filterRow, fieldProp));
        scripts[0] = script;
        scripts[1] = scriptDesc;
        return scripts;
    }

    private String getComboxItemCaption(FilterRow filterRow, DynamicProperty fieldProp) {
        ArrayList<String> captions = new ArrayList<String>(10);
        for (String itemValue : filterRow.getValue()) {
            String itemCaption = "";
            itemCaption = filterRow.getCompareType().isFieldCompare() ? this.getFieldCaption(itemValue) : (fieldProp instanceof ComboProp ? ((ComboProp)fieldProp).getItemByName(itemValue) : (fieldProp instanceof BooleanProp ? (Integer.valueOf(itemValue).compareTo(1) == 0 ? ResManager.loadKDString((String)"\u662f", (String)FILTER_SCRIPT_BUILDER_2, (String)BOS_ENTITY_METADATA, (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)FILTER_SCRIPT_BUILDER_3, (String)BOS_ENTITY_METADATA, (Object[])new Object[0])) : itemValue));
            captions.add(itemCaption);
        }
        return StringUtils.join((Object[])captions.toArray(), (String)",");
    }

    private List<DynamicProperty> findPropertys(MainEntityType mainType, String var) {
        ArrayList<DynamicProperty> props = new ArrayList<DynamicProperty>();
        String[] keys = var.split("\\.");
        EntityType parentType = mainType;
        for (int i = 0; i < keys.length; ++i) {
            DynamicProperty prop = (DynamicProperty)parentType.findProperty(keys[i]);
            if (prop == null && "id".equalsIgnoreCase(keys[i])) {
                prop = (DynamicProperty)parentType.getPrimaryKey();
            }
            if (prop == null) break;
            props.add(prop);
            if (prop instanceof EntryProp) {
                parentType = (EntityType)((EntryProp)prop).getItemType();
                continue;
            }
            if (!(prop instanceof BasedataProp)) break;
            parentType = (EntityType)((BasedataProp)prop).getComplexType();
        }
        if (props.size() < keys.length) {
            KDException e = new KDException(String.format(ResManager.loadKDString((String)"\u53d8\u91cf%s\u89e3\u6790\u5931\u8d25\uff0c\u5728\u5355\u636e\u4e0a\u627e\u4e0d\u5230", (String)"FilterScriptBuilder_4", (String)BOS_ENTITY_METADATA, (Object[])new Object[0]), var));
            HashMap<String, String> tags = new HashMap<String, String>(1);
            tags.put("var", var);
            EntityTracer.throwException((String)SPAN_TYPE_SCRIPTBUILDER, (String)"findPropertys", null, (Throwable)e, tags);
            throw e;
        }
        return props;
    }

    private String getFieldCaption(String fieldName) {
        String fieldCaption = "";
        if (StringUtils.isBlank((CharSequence)fieldName)) {
            return fieldCaption;
        }
        FieldName fieldNameObj = EntityTypeUtil.getORMFieldName(fieldName, this.filterObject.getDataType());
        fieldCaption = fieldNameObj == null || fieldNameObj.getFieldCaption() == null ? fieldName : fieldNameObj.getFieldCaption().toString();
        return fieldCaption;
    }

    private String[] checkInputValue(FilterRow filterRow) {
        String[] result = new String[2];
        String value = "";
        String valueDesc = "";
        if (filterRow.getValue().size() > 0) {
            value = filterRow.getValue().get(0);
        }
        valueDesc = value;
        if (StringUtils.isBlank((CharSequence)value)) {
            result[0] = value;
            result[1] = valueDesc;
            return result;
        }
        String strtmp = "";
        String operateStr = filterRow.getCompareType().getOperate().trim();
        int fieldType = filterRow.getFilterField().getFieldType();
        List<DynamicProperty> props = MemberVarParser.findPropertys(this.filterObject.getDataType(), filterRow.getFilterField().getFieldName(), true);
        DynamicProperty fieldProp = props.get(props.size() - 1);
        if (operateStr.equals("=") || operateStr.equals("==") || operateStr.equals("!=") || operateStr.equals("<>") || operateStr.equals("<=") || operateStr.equals("<") || operateStr.equals(">=") || operateStr.equals(">")) {
            if (fieldType == 3 || fieldType == 6 || fieldType == 2 || fieldType == 7) {
                value = value.trim();
                this.checkIsEmtry(filterRow);
                this.isNumeric(value, true);
                strtmp = this.getNumberValue(value);
            } else if (fieldType == -5 || fieldType == 4 || fieldType == 5) {
                value = value.trim();
                this.checkIsEmtry(filterRow);
                this.isInt(value, true);
                strtmp = this.getNumberValue(value);
            } else if (fieldType == -6) {
                value = value.trim();
                this.checkIsEmtry(filterRow);
                this.isUint(value, true);
                strtmp = value;
            } else if (fieldType == 91) {
                this.checkIsEmtry(filterRow);
                strtmp = this.checkInputDate(filterRow);
            } else if (fieldType == 92 || fieldType == 93) {
                this.checkIsEmtry(filterRow);
                strtmp = this.checkInputDateTime(filterRow);
            } else if (fieldType == -7) {
                this.checkIsEmtry(filterRow);
                strtmp = value;
            } else if (fieldType == 1) {
                if (fieldProp instanceof BooleanProp) {
                    if (StringUtils.equals((CharSequence)"1", (CharSequence)value)) {
                        value = "true";
                    } else if (StringUtils.equals((CharSequence)"0", (CharSequence)value)) {
                        value = FALSE;
                    }
                }
                strtmp = value;
                valueDesc = value.equals("true") ? ResManager.loadKDString((String)"\u662f", (String)FILTER_SCRIPT_BUILDER_2, (String)BOS_ENTITY_METADATA, (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)FILTER_SCRIPT_BUILDER_3, (String)BOS_ENTITY_METADATA, (Object[])new Object[0]);
            } else {
                if (value.endsWith("'")) {
                    value = value.substring(0, value.length() - 1);
                }
                if (value.startsWith("'")) {
                    value = value.substring(1);
                }
                value = value.replace("'", "\\'");
                strtmp = marks + value + marks;
            }
        } else if (operateStr.equalsIgnoreCase("LIKE") || operateStr.equalsIgnoreCase("NOT LIKE")) {
            strtmp = operateStr.equals("lIKE") ? value + "%" : (operateStr.equals("like") ? "%" + value : "%" + value + "%");
            strtmp = marks + strtmp + marks;
        } else if (operateStr.equalsIgnoreCase("IN") || operateStr.equalsIgnoreCase(NOT_IN)) {
            if (FilterScriptBuilder.isNumberField(fieldType)) {
                value = String.join((CharSequence)",", filterRow.getValue());
                strtmp = "(" + value + ")";
            } else {
                if (fieldProp instanceof BooleanProp) {
                    return this.boolValueConvert(filterRow.getValue());
                }
                value = String.join((CharSequence)(marks + "," + marks), filterRow.getValue());
                strtmp = "(" + marks + value + marks + ")";
            }
            valueDesc = strtmp;
        } else if (operateStr.equalsIgnoreCase("BETWEEN")) {
            String value1 = null;
            String value2 = null;
            if (fieldType == 91) {
                this.checkIsEmtry(filterRow);
                value1 = this.checkInputDate(filterRow, 0);
                value2 = this.checkInputDate(filterRow, 1);
            } else if (fieldType == 92 || fieldType == 93) {
                this.checkIsEmtry(filterRow);
                value1 = this.checkInputDateTime(filterRow, 0);
                value2 = this.checkInputDateTime(filterRow, 1);
            }
            strtmp = value1 + "," + value2;
        } else if (operateStr.equalsIgnoreCase("StatusAssistantEqualto")) {
            this.checkIsEmtry(filterRow);
            if (value.equalsIgnoreCase("True")) {
                value = "1";
                valueDesc = ResManager.loadKDString((String)"\u662f", (String)FILTER_SCRIPT_BUILDER_2, (String)BOS_ENTITY_METADATA, (Object[])new Object[0]);
            } else if (value.equalsIgnoreCase(FALSE)) {
                value = "0";
                valueDesc = ResManager.loadKDString((String)"\u5426", (String)FILTER_SCRIPT_BUILDER_3, (String)BOS_ENTITY_METADATA, (Object[])new Object[0]);
            }
            this.isInt(value, true);
            strtmp = value.trim();
        } else {
            strtmp = value;
        }
        result[0] = strtmp;
        result[1] = valueDesc;
        return result;
    }

    private String[] boolValueConvert(List<String> rowValue) {
        ArrayList<String> newValues = new ArrayList<String>(2);
        ArrayList<String> newValueDesc = new ArrayList<String>(2);
        for (String v : rowValue) {
            if ("1".equals(v)) {
                newValues.add("true");
                newValueDesc.add(ResManager.loadKDString((String)"\u662f", (String)FILTER_SCRIPT_BUILDER_2, (String)BOS_ENTITY_METADATA, (Object[])new Object[0]));
                continue;
            }
            if (!"0".equals(v)) continue;
            newValues.add(FALSE);
            newValueDesc.add(ResManager.loadKDString((String)"\u5426", (String)FILTER_SCRIPT_BUILDER_3, (String)BOS_ENTITY_METADATA, (Object[])new Object[0]));
        }
        String[] result = new String[2];
        String value = String.join((CharSequence)",", newValues);
        result[0] = "(" + value + ")";
        String descTmp = String.join((CharSequence)(marks + "," + marks), newValueDesc);
        result[1] = "(" + marks + descTmp + marks + ")";
        return result;
    }

    private boolean isCompareConstValue(FilterRow filterRow) {
        if (!filterRow.getCompareType().isNeedInput()) {
            return true;
        }
        if (StringUtils.isNotBlank((CharSequence)filterRow.getCompareType().getClassName())) {
            return true;
        }
        String compareValue = filterRow.getCompareType().getValue();
        return TODAY_BEFORE.equalsIgnoreCase(compareValue) || TODAY_AFTER.equalsIgnoreCase(compareValue);
    }

    private String[] getConstValue(FilterRow filterRow) {
        String[] scripts = new String[2];
        CompareType compareType = filterRow.getCompareType();
        String value = "";
        if (filterRow.getValue().size() > 0) {
            value = filterRow.getValue().get(0);
        }
        if (StringUtils.isNotBlank((CharSequence)value) && this.isNumeric(value, false)) {
            int val = 0;
            try {
                val = Integer.parseInt(filterRow.getValue().get(0));
            }
            catch (Exception e) {
                log.info(e.getMessage());
            }
            scripts = this.getConstValue(filterRow, val);
        } else {
            String compareValue = compareType.getValue().toUpperCase();
            if (compareValue.equalsIgnoreCase(TODAY_BEFORE) || compareValue.equalsIgnoreCase(TODAY_AFTER) || compareValue.equalsIgnoreCase("TODAYIN")) {
                KDException e = new KDException(BosErrorCode.filterSqlBuilder, new Object[]{String.format(ResManager.loadKDString((String)"\u7b2c %s \u884c\uff1a\u65e0\u6548\u7684\u8f93\u5165\u503c\uff0c\u8bf7\u8f93\u5165\u6574\u6570", (String)"FilterScriptBuilder_5", (String)BOS_ENTITY_METADATA, (Object[])new Object[0]), filterRow.getRowIndex() + 1)});
                HashMap<String, Object> tags = new HashMap<String, Object>(1);
                tags.put(SPAN_PARAM_FILTERROW, filterRow);
                tags.put("compareType", compareValue);
                EntityTracer.throwException((String)SPAN_TYPE_SCRIPTBUILDER, (String)"getConstValue", null, (Throwable)e, tags);
                throw e;
            }
            scripts = this.getConstValue(filterRow, 0);
        }
        return scripts;
    }

    private String[] getConstValue(FilterRow filterRow, int constantEnum) {
        String[] scripts = new String[2];
        String className = filterRow.getCompareType().getClassName();
        if (StringUtils.isNotBlank((CharSequence)className)) {
            ConditionVariableContext ctx = new ConditionVariableContext(this.filterObject, filterRow);
            ctx.setUserService(this.userService);
            if (this.timeService == null) {
                this.timeService = new TimeService();
            }
            ctx.setInteService(this.filterObject.getInteService());
            ctx.setConstantValue(constantEnum);
            ctx.setParam(false);
            IConditionVariableAnalysis variableAnalysis = ConditionVariableFactory.getSingleInstance().getOrRegisterVariableInstance(className);
            variableAnalysis.getScriptFilter(ctx);
            String script = ctx.getScript();
            String scriptDesc = ctx.getFilterDesc();
            scripts[0] = script;
            scripts[1] = scriptDesc;
            return scripts;
        }
        KDException e = new KDException(BosErrorCode.filterSqlBuilder, new Object[]{String.format(ResManager.loadKDString((String)"\u65e0\u6cd5\u89e3\u6790\u53d8\u91cf\u7684\u503c:%s", (String)"FilterScriptBuilder_6", (String)BOS_ENTITY_METADATA, (Object[])new Object[0]), filterRow.getCompareType().getValue().toUpperCase())});
        HashMap<String, Object> tags = new HashMap<String, Object>(3);
        tags.put(SPAN_PARAM_FILTERROW, filterRow);
        tags.put("constantEnum", constantEnum);
        tags.put("className", className);
        EntityTracer.throwException((String)SPAN_TYPE_SCRIPTBUILDER, (String)"getConstValue", null, (Throwable)e, tags);
        throw e;
    }

    private void checkIsEmtry(FilterRow filterRow) {
        String value = filterRow.getValue().get(0);
        if (value.trim().length() == 0) {
            KDException e = new KDException(BosErrorCode.filterSqlBuilder, new Object[]{String.format(ResManager.loadKDString((String)"\u7b2c %s \u884c\uff1a\u672a\u8f93\u5165\u6bd4\u8f83\u503c", (String)"FilterScriptBuilder_7", (String)BOS_ENTITY_METADATA, (Object[])new Object[0]), filterRow.getRowIndex() + 1)});
            HashMap<String, Object> tags = new HashMap<String, Object>(2);
            tags.put(SPAN_PARAM_FILTERROW, filterRow);
            tags.put(SPAN_PARAM_VALUE, value);
            EntityTracer.throwException((String)SPAN_TYPE_SCRIPTBUILDER, (String)"checkIsEmtry", null, (Throwable)e, tags);
            throw e;
        }
    }

    private boolean isNumeric(String value, boolean bThrowErr) {
        Pattern pattern = Pattern.compile("^[+-]?\\d*[.]?\\d*$");
        Matcher matcher = pattern.matcher(value.trim());
        boolean isOk = matcher.matches();
        if (bThrowErr && !isOk) {
            KDException e = new KDException(BosErrorCode.filterSqlBuilder, new Object[]{ResManager.loadKDString((String)"\u65e0\u6548\u7684\u8f93\u5165\u503c", (String)"FilterScriptBuilder_8", (String)BOS_ENTITY_METADATA, (Object[])new Object[0])});
            HashMap<String, String> tags = new HashMap<String, String>(1);
            tags.put(SPAN_PARAM_VALUE, value);
            EntityTracer.throwException((String)SPAN_TYPE_SCRIPTBUILDER, (String)"isNumeric", null, (Throwable)e, tags);
            throw e;
        }
        return isOk;
    }

    private boolean isUint(String value, boolean bThrowErr) {
        Pattern pattern = Pattern.compile("^[1-9]\\d*$");
        Matcher matcher = pattern.matcher(value.trim());
        boolean isOk = matcher.matches();
        if (!isOk) {
            KDException e = new KDException(BosErrorCode.filterSqlBuilder, new Object[]{ResManager.loadKDString((String)"\u65e0\u6548\u7684\u8f93\u5165\u503c\uff0c\u8bf7\u8f93\u5165\u6b63\u6574\u6570", (String)"FilterScriptBuilder_9", (String)BOS_ENTITY_METADATA, (Object[])new Object[0])});
            try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_SCRIPTBUILDER, (String)"isUint");){
                span.addLocaleTag(SPAN_PARAM_VALUE, (Object)value);
                span.throwException((Throwable)e);
            }
            throw e;
        }
        return isOk;
    }

    private boolean isInt(String value, boolean bThrowErr) {
        Pattern pattern = Pattern.compile("^[+-]?\\d*$");
        Matcher matcher = pattern.matcher(value.trim());
        boolean isOk = matcher.matches();
        if (!isOk) {
            KDException e = new KDException(BosErrorCode.filterSqlBuilder, new Object[]{ResManager.loadKDString((String)"\u65e0\u6548\u7684\u8f93\u5165\u503c\uff0c\u8bf7\u8f93\u5165\u6b63\u6574\u6570", (String)"FilterScriptBuilder_9", (String)BOS_ENTITY_METADATA, (Object[])new Object[0])});
            try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_SCRIPTBUILDER, (String)"isInt");){
                span.addLocaleTag(SPAN_PARAM_VALUE, (Object)value);
                span.throwException((Throwable)e);
            }
            throw e;
        }
        return isOk;
    }

    private boolean isTimeString(String value, boolean bThrowErr) {
        Pattern pattern = Pattern.compile("^((20|21|22|23|[0-1]?\\d):[0-5]?\\d:[0-5]?\\d)$");
        Matcher matcher = pattern.matcher(value.trim());
        boolean isOk = matcher.matches();
        if (!isOk) {
            KDException e = new KDException(BosErrorCode.filterSqlBuilder, new Object[]{ResManager.loadKDString((String)"\u65e0\u6548\u7684\u8f93\u5165\u503c\uff0c\u8bf7\u8f93\u5165\u65e5\u671f", (String)"FilterScriptBuilder_10", (String)BOS_ENTITY_METADATA, (Object[])new Object[0])});
            try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_SCRIPTBUILDER, (String)"isTimeString");){
                span.addLocaleTag(SPAN_PARAM_VALUE, (Object)value);
                span.throwException((Throwable)e);
            }
            throw e;
        }
        return isOk;
    }

    private boolean isDateTimeString(String sValue, boolean bThrowErr) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-M-d H:m:s");
        try {
            simpleDateFormat.parse(sValue);
        }
        catch (ParseException e) {
            if (bThrowErr) {
                KDException exp = new KDException((Throwable)e, BosErrorCode.filterSqlBuilder, new Object[]{ResManager.loadKDString((String)"\u65e0\u6548\u7684\u8f93\u5165\u503c\uff0c\u8bf7\u8f93\u5165\u65e5\u671f\uff0c\u683c\u5f0f\u5982\uff1a1999-12-25 10:30:30", (String)"FilterScriptBuilder_11", (String)BOS_ENTITY_METADATA, (Object[])new Object[0])});
                try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_SCRIPTBUILDER, (String)"isDateTimeString");){
                    span.addLocaleTag(SPAN_PARAM_VALUE, (Object)sValue);
                    span.throwException((Throwable)exp);
                }
                throw exp;
            }
            return false;
        }
        return true;
    }

    private boolean isDateString(String sValue, boolean bThrowErr) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-M-d");
        try {
            simpleDateFormat.parse(sValue);
        }
        catch (ParseException e) {
            if (bThrowErr) {
                KDException exp = new KDException((Throwable)e, BosErrorCode.filterSqlBuilder, new Object[]{ResManager.loadKDString((String)"\u65e0\u6548\u7684\u8f93\u5165\u503c\uff0c\u8bf7\u8f93\u5165\u65e5\u671f\uff0c\u683c\u5f0f\u5982\uff1a1999-12-25", (String)"FilterScriptBuilder_12", (String)BOS_ENTITY_METADATA, (Object[])new Object[0])});
                try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_SCRIPTBUILDER, (String)"isDateString");){
                    span.addLocaleTag(SPAN_PARAM_VALUE, (Object)sValue);
                    span.throwException((Throwable)exp);
                }
                throw exp;
            }
            return false;
        }
        return true;
    }

    private String checkInputDate(FilterRow filterRow) {
        return this.checkInputDate(filterRow, 0);
    }

    private String checkInputDate(FilterRow filterRow, int index) {
        String value;
        String compareValue = filterRow.getCompareType().getValue();
        String strtmp = value = filterRow.getValue().get(index).trim().split(" ")[0];
        if (compareValue.equalsIgnoreCase(TODAY_BEFORE) || compareValue.equalsIgnoreCase(TODAY_AFTER)) {
            this.isNumeric(value, true);
            strtmp = value;
        } else {
            this.isDateString(value, true);
            Date date = this.getDateByString(value);
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(date);
            GregorianCalendar maxCalendar = new GregorianCalendar();
            maxCalendar.setTime(KDTimeZone.minSystemDateTime);
            if (calendar.get(1) < maxCalendar.get(1)) {
                KDException e = new KDException(BosErrorCode.filterSqlBuilder, new Object[]{String.format(ResManager.loadKDString((String)"\u7b2c %s \u884c\uff1a\u65e0\u6548\u7684\u8f93\u5165\u503c\uff0c\u8f93\u5165\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e{1}\u5e74", (String)"FilterScriptBuilder_13", (String)BOS_ENTITY_METADATA, (Object[])new Object[0]), filterRow.getRowIndex(), maxCalendar.get(1))});
                try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_SCRIPTBUILDER, (String)"checkInputDate");){
                    span.addLocaleTag(SPAN_PARAM_FILTERROW, (Object)filterRow);
                    span.addLocaleTag("compareType", (Object)compareValue);
                    span.addLocaleTag(SPAN_PARAM_VALUE, (Object)value);
                    span.throwException((Throwable)e);
                }
                throw e;
            }
            String operateStr = filterRow.getCompareType().getOperate();
            if (operateStr.equals("=") || operateStr.equals("==")) {
                String beginTime = marks + value + ZERO_POINT_STRING + marks;
                String endTime = marks + value + LAST_POINT_STRING + marks;
                strtmp = beginTime + "," + endTime;
            } else if (operateStr.equals("!=") || operateStr.equals("<>")) {
                String beginTime = marks + value + ZERO_POINT_STRING + marks;
                String endTime = marks + value + LAST_POINT_STRING + marks;
                strtmp = beginTime + "," + endTime;
            } else {
                strtmp = operateStr.equals("<") ? marks + value + ZERO_POINT_STRING + marks : (operateStr.equals("<=") ? marks + value + LAST_POINT_STRING + marks : (operateStr.equals(">") ? marks + value + LAST_POINT_STRING + marks : (operateStr.equals(">=") ? marks + value + ZERO_POINT_STRING + marks : (operateStr.equalsIgnoreCase(BETWEEN) ? (index == 0 ? marks + value + ZERO_POINT_STRING + marks : marks + value + LAST_POINT_STRING + marks) : marks + value + ZERO_POINT_STRING + marks))));
            }
        }
        return strtmp;
    }

    private String getDateFilterString(FilterRow filterRow, String fieldName, String sValue) {
        String script = "";
        String[] values = sValue.split(",");
        String operateStr = filterRow.getCompareType().getOperate();
        if (operateStr.equals("=") || operateStr.equals("==")) {
            String beginTime = String.format(DATE_FORMAT_STR, values[0]);
            String endTime = String.format(DATE_FORMAT_STR, values[1]);
            script = String.format(FORMAT1, fieldName, beginTime, fieldName, endTime);
        } else if (operateStr.equals("!=") || operateStr.equals("<>")) {
            String beginTime = String.format(DATE_FORMAT_STR, values[0]);
            String endTime = String.format(DATE_FORMAT_STR, values[1]);
            script = String.format("%s < %s or %s > %s ", fieldName, beginTime, fieldName, endTime);
        } else if (operateStr.equals("<")) {
            String beginTime = String.format(DATE_FORMAT_STR, values[0]);
            script = String.format("%s < %s ", fieldName, beginTime);
        } else if (operateStr.equals("<=")) {
            String endTime = String.format(DATE_FORMAT_STR, values[0]);
            script = String.format("%s <= %s ", fieldName, endTime);
        } else if (operateStr.equals(">")) {
            String endTime = String.format(DATE_FORMAT_STR, values[0]);
            script = String.format("%s > %s ", fieldName, endTime);
        } else if (operateStr.equals(">=")) {
            String beginTime = String.format(DATE_FORMAT_STR, values[0]);
            script = String.format("%s >= %s ", fieldName, beginTime);
        } else if (operateStr.equalsIgnoreCase(BETWEEN)) {
            String beginTime = String.format(DATE_FORMAT_STR, values[0]);
            String endTime = String.format(DATE_FORMAT_STR, values[1]);
            script = String.format(FORMAT1, fieldName, beginTime, fieldName, endTime);
        } else {
            String time = String.format(DATE_FORMAT_STR, values[0]);
            script = String.format("%s %s %s ", fieldName, operateStr, time);
        }
        return script;
    }

    private String checkInputDateTime(FilterRow filterRow) {
        return this.checkInputDateTime(filterRow, 0);
    }

    private String checkInputDateTime(FilterRow filterRow, int index) {
        String value = filterRow.getValue().get(index).trim();
        this.isDateTimeString(value, true);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-M-d H:m:s");
        Date dateTime = null;
        try {
            dateTime = simpleDateFormat.parse(value);
        }
        catch (ParseException e) {
            KDException exp = new KDException((Throwable)e, BosErrorCode.filterSqlBuilder, new Object[]{ResManager.loadKDString((String)"\u65e0\u6548\u7684\u8f93\u5165\u503c\uff0c\u8bf7\u8f93\u5165\u65e5\u671f\uff0c\u683c\u5f0f\u5982\uff1a1999/12/25", (String)"FilterScriptBuilder_14", (String)BOS_ENTITY_METADATA, (Object[])new Object[0])});
            try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_SCRIPTBUILDER, (String)"checkInputDateTime");){
                span.addLocaleTag(SPAN_PARAM_FILTERROW, (Object)filterRow);
                span.addLocaleTag(SPAN_PARAM_VALUE, (Object)value);
                span.throwException((Throwable)exp);
            }
            throw exp;
        }
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(dateTime);
        GregorianCalendar maxCalendar = new GregorianCalendar();
        maxCalendar.setTime(KDTimeZone.minSystemDateTime);
        if (calendar.get(1) < maxCalendar.get(1)) {
            KDException exp = new KDException(BosErrorCode.filterSqlBuilder, new Object[]{String.format(ResManager.loadKDString((String)"\u7b2c %s \u884c\uff1a\u65e0\u6548\u7684\u8f93\u5165\u503c\uff0c\u8f93\u5165\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e{1}\u5e74", (String)"FilterScriptBuilder_13", (String)BOS_ENTITY_METADATA, (Object[])new Object[0]), filterRow.getRowIndex(), maxCalendar.get(1))});
            try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_SCRIPTBUILDER, (String)"checkInputDateTime");){
                span.addLocaleTag(SPAN_PARAM_FILTERROW, (Object)filterRow);
                span.addLocaleTag(SPAN_PARAM_VALUE, (Object)value);
                span.throwException((Throwable)exp);
            }
            throw exp;
        }
        String operateStr = filterRow.getCompareType().getOperate();
        if (operateStr.equals("=") || operateStr.equals("==")) {
            String beginTime = marks + simpleDateFormat.format(dateTime) + marks;
            String endTime = marks + simpleDateFormat.format(KDDateUtils.addSeconds((Date)dateTime, (int)1)) + marks;
            value = beginTime + "," + endTime;
        } else {
            value = operateStr.equalsIgnoreCase(BETWEEN) ? (index == 0 ? marks + simpleDateFormat.format(dateTime) + marks : marks + simpleDateFormat.format(KDDateUtils.addSeconds((Date)dateTime, (int)1)) + marks) : marks + simpleDateFormat.format(dateTime) + marks;
        }
        return value;
    }

    private String getTimeFilterString(FilterRow filterRow, String fieldName, String sValue) {
        String script;
        String operateStr = filterRow.getCompareType().getOperate();
        if (operateStr.trim().toLowerCase(Locale.ENGLISH).equals(BETWEEN)) {
            String[] times = sValue.split(",");
            String begenTime = String.format(DATE_FORMAT_STR, times[0]);
            String endTime = String.format(DATE_FORMAT_STR, times[1]);
            script = String.format(FORMAT2, fieldName, begenTime, fieldName, endTime);
        } else if (operateStr.equals("=") || operateStr.equals("==")) {
            String[] times = sValue.split(",");
            String beginTime = String.format(DATE_FORMAT_STR, times[0]);
            String endTime = String.format(DATE_FORMAT_STR, times[1]);
            script = String.format(FORMAT2, fieldName, beginTime, fieldName, endTime);
        } else {
            String time = String.format(DATE_FORMAT_STR, sValue);
            script = String.format(FORMAT, fieldName, filterRow.getCompareType().getOperate(), time);
        }
        return script;
    }

    private Date getDateByString(String v) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-M-d");
        Date date = null;
        try {
            date = simpleDateFormat.parse(v);
        }
        catch (ParseException e) {
            log.info(e.getMessage());
        }
        return date;
    }

    private String getNumberValue(String v) {
        if (v.length() < 19) {
            return v;
        }
        if (v.indexOf(".") >= 0) {
            return v;
        }
        try {
            long l = Long.parseLong(v);
            return v;
        }
        catch (NumberFormatException exp) {
            return String.format("NUMBER('%s')", v);
        }
    }
}

