/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.filter;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.filter.FilterObject;
import kd.bos.entity.filter.FilterResult;
import kd.bos.entity.filter.FilterRow;
import kd.bos.entity.filter.LogicOperate;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ITimeService;
import kd.bos.service.IUserService;
import org.jetbrains.annotations.NotNull;

public class FilterSqlBuilder {
    private static final String SPAN_TYPE_SCRIPTBUILDER = "FilterSqlBuilder";
    ITimeService timeService;
    IUserService userService;

    @Deprecated
    public void setTimeService(ITimeService timeService) {
        this.timeService = timeService;
    }

    public void setUserService(IUserService userService) {
        this.userService = userService;
    }

    private int countBracket(FilterRow row) {
        int count = 0;
        if (!StringUtils.isEmpty((CharSequence)row.getLeftBracket())) {
            count += row.getLeftBracket().replace(" ", "").length();
        }
        if (!StringUtils.isEmpty((CharSequence)row.getRightBracket())) {
            count -= row.getRightBracket().replace(" ", "").length();
        }
        return count;
    }

    private FilterResult makeCondition(FilterRow filterRow) {
        String[] strSql = new String[]{"", ""};
        FilterResult filterResult2 = filterRow.getFilterResult();
        if (StringUtils.isNotBlank((CharSequence)filterResult2.getFilterGroup()[0])) {
            strSql[0] = String.format(" %s %s %s %s", filterRow.getLeftBracket(), filterResult2.getFilterGroup()[0], filterRow.getRightBracket(), filterRow.getLogic().toString());
        }
        if (StringUtils.isNotBlank((CharSequence)filterResult2.getFilterGroup()[1])) {
            strSql[1] = String.format(" %s %s %s %s", filterRow.getLeftBracket(), filterResult2.getFilterGroup()[1], filterRow.getRightBracket(), filterRow.getLogic().getName());
        }
        FilterResult filterResult = new FilterResult(strSql, filterResult2.getQFilter(), filterResult2.getQFilters());
        filterResult.setEmpty(filterResult2.isEmpty());
        return filterResult;
    }

    private FilterResult getCondition(FilterRow filterRow, boolean returnSQL) {
        String[] strSql = new String[]{"", ""};
        FilterResult filterResult2 = this.makeCondition(filterRow);
        String[] conditionResult = filterResult2.getFilterGroup();
        if (returnSQL) {
            strSql[0] = conditionResult[0];
            strSql[1] = conditionResult[1];
        } else {
            strSql[0] = conditionResult[1];
            strSql[1] = conditionResult[1];
        }
        FilterResult filterResult = new FilterResult(strSql, filterResult2.getQFilter(), filterResult2.getQFilters());
        filterResult.setLogicOperate(filterRow.getLogic());
        filterResult.setCountOfBracket(this.countBracket(filterRow));
        filterResult.setEmpty(filterResult2.isEmpty());
        return filterResult;
    }

    private int popMinQueueFilterResult(Deque<FilterResult> orFilterResults, Deque<FilterRow> minQueue, Queue<FilterRow> queue, boolean returnSQL) {
        FilterResult andFilterResult = FilterSqlBuilder.createAndFilterResult();
        LinkedList<FilterRow> minStack = new LinkedList<FilterRow>();
        ArrayDeque<FilterResult> thisOrFilterResults = new ArrayDeque<FilterResult>();
        boolean isRerverseOrder = false;
        while (!minQueue.isEmpty()) {
            FilterRow filterRow = minQueue.peekLast();
            if (StringUtils.isNotEmpty((CharSequence)filterRow.getRightBracket()) || filterRow.getLogic() == LogicOperate.OR) {
                isRerverseOrder = true;
                andFilterResult = this.parseRightToLeft(minQueue, returnSQL, andFilterResult, minStack, thisOrFilterResults);
                continue;
            }
            andFilterResult = this.joinLeftFilterRows(minQueue, queue, returnSQL, andFilterResult, thisOrFilterResults, isRerverseOrder);
        }
        orFilterResults.add(this.pollOrFilterResults(thisOrFilterResults));
        return andFilterResult.getCountOfBracket();
    }

    @NotNull
    private static FilterResult createAndFilterResult() {
        FilterResult andFilterResult = new FilterResult(new String[]{"", ""}, null, new ArrayList<QFilter>());
        andFilterResult.setLogicOperate(LogicOperate.AND);
        return andFilterResult;
    }

    private FilterResult joinLeftFilterRows(Deque<FilterRow> minQueue, Queue<FilterRow> queue, boolean returnSQL, FilterResult andFilterResult, Deque<FilterResult> thisOrFilterResults, boolean isReverseOrder) {
        FilterResult thisAndFilterResult = andFilterResult;
        if (thisAndFilterResult.getCountOfBracket() > 0) {
            if (thisAndFilterResult.getCountOfBracket() > 0 && queue.isEmpty()) {
                throw new KDBizException(BosErrorCode.filterSqlBuilder, new Object[]{ResManager.loadKDString((String)"\u5de6\u62ec\u53f7\u4e0e\u53f3\u62ec\u53f7\u4e0d\u5339\u914d\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"FilterSqlBuilder_0", (String)"bos-entity-metadata", (Object[])new Object[0])});
            }
            while (thisAndFilterResult.getCountOfBracket() > 0 && !queue.isEmpty()) {
                FilterRow filterRow = queue.poll();
                FilterResult thisCondition = this.getCondition(filterRow, returnSQL);
                thisAndFilterResult = this.joinAndOrFilterResult(thisCondition, thisOrFilterResults, thisAndFilterResult, false);
            }
            thisAndFilterResult = this.appendLeftFilterResult0(thisAndFilterResult, thisOrFilterResults);
        } else if (thisAndFilterResult.getCountOfBracket() < 0) {
            FilterRow filterRow = minQueue.removeLast();
            FilterResult thisCondition = this.getCondition(filterRow, returnSQL);
            thisAndFilterResult = this.joinAndOrFilterResult(thisCondition, thisOrFilterResults, thisAndFilterResult, true);
            thisAndFilterResult = this.appendLeftFilterResult1(thisAndFilterResult, thisOrFilterResults);
        } else {
            thisAndFilterResult = this.parseBlanceFilterRows(minQueue, returnSQL, thisOrFilterResults, isReverseOrder, thisAndFilterResult);
        }
        return thisAndFilterResult;
    }

    private FilterResult parseBlanceFilterRows(Deque<FilterRow> minQueue, boolean returnSQL, Deque<FilterResult> thisOrFilterResults, boolean isReverseOrder, FilterResult andFilterResult) {
        FilterResult thisAndFilterResult = andFilterResult;
        while (thisAndFilterResult.getCountOfBracket() == 0 && !minQueue.isEmpty()) {
            FilterRow filterRow = isReverseOrder ? minQueue.removeLast() : minQueue.poll();
            FilterResult thisCondition = this.getCondition(filterRow, returnSQL);
            thisAndFilterResult = this.joinAndOrFilterResult(thisCondition, thisOrFilterResults, thisAndFilterResult, isReverseOrder);
        }
        if (!isReverseOrder) {
            thisAndFilterResult = this.appendLeftFilterResult0(thisAndFilterResult, thisOrFilterResults);
        } else {
            this.appendLeftFilterResult2(thisAndFilterResult, thisOrFilterResults);
        }
        return thisAndFilterResult;
    }

    private FilterResult parseRightToLeft(Deque<FilterRow> minQueue, boolean returnSQL, FilterResult andFilterResult, Deque<FilterRow> minStack, Deque<FilterResult> orFilterResults) {
        FilterResult thisAndFilterResult = andFilterResult;
        int countOfBracket = andFilterResult.getCountOfBracket();
        int minQueueCountOfBracket = 0;
        while (!minQueue.isEmpty()) {
            FilterRow filterRow = minQueue.removeLast();
            minStack.push(filterRow);
            if (((minQueueCountOfBracket += this.countBracket(filterRow)) != 0 || !StringUtils.isNotEmpty((CharSequence)filterRow.getLeftBracket())) && !minQueue.isEmpty()) continue;
            ArrayDeque<FilterResult> thisOrFilterResults = new ArrayDeque<FilterResult>();
            FilterRow preFilterRow = null;
            while (!minStack.isEmpty()) {
                filterRow = minStack.pop();
                FilterRow nextFilterRow = minStack.peek();
                FilterResult thisCondition = this.getCondition(filterRow, returnSQL);
                thisAndFilterResult = this.joinAndOrFilterResult(thisCondition, thisOrFilterResults, thisAndFilterResult, false);
                thisAndFilterResult = this.appendLeftFilterResult(thisAndFilterResult, orFilterResults, thisOrFilterResults, (countOfBracket += this.countBracket(filterRow)) == 0 || (preFilterRow == null || this.countBracket(filterRow) + this.countBracket(preFilterRow) == 0 || preFilterRow.getLogic() == LogicOperate.OR || StringUtils.isNotEmpty((CharSequence)preFilterRow.getRightBracket())) && StringUtils.isNotEmpty((CharSequence)filterRow.getRightBracket()) || nextFilterRow != null && StringUtils.isNotEmpty((CharSequence)nextFilterRow.getLeftBracket()));
                preFilterRow = filterRow;
                if (!minStack.isEmpty() || countOfBracket != 0) continue;
                FilterResult filterResult = this.joinOrQfilterResults(orFilterResults);
                orFilterResults.clear();
                orFilterResults.add(filterResult);
            }
            break block0;
        }
        return thisAndFilterResult;
    }

    private void appendLeftFilterResult2(FilterResult andFilterResult, Deque<FilterResult> thisOrFilterResults) {
        thisOrFilterResults.addFirst(andFilterResult);
        thisOrFilterResults.push(this.pollOrFilterResults(thisOrFilterResults));
    }

    private FilterResult appendLeftFilterResult1(FilterResult andFilterResult, Deque<FilterResult> thisOrFilterResults) {
        if (andFilterResult.getCountOfBracket() <= 0) {
            thisOrFilterResults.addFirst(andFilterResult);
            FilterResult joinPartFilterResults = this.joinPartFilterResults(thisOrFilterResults);
            joinPartFilterResults.setCountOfBracket(andFilterResult.getCountOfBracket());
            return joinPartFilterResults;
        }
        return andFilterResult;
    }

    private FilterResult appendLeftFilterResult0(FilterResult andFilterResult, Deque<FilterResult> thisOrFilterResults) {
        if (andFilterResult.getCountOfBracket() <= 0) {
            if (andFilterResult.isNotEmpty()) {
                thisOrFilterResults.add(andFilterResult);
            }
            FilterResult joinPartFilterResults = this.joinPartFilterResults(thisOrFilterResults);
            joinPartFilterResults.setCountOfBracket(andFilterResult.getCountOfBracket());
            return joinPartFilterResults;
        }
        return andFilterResult;
    }

    private FilterResult appendLeftFilterResult(FilterResult andFilterResult, Deque<FilterResult> orFilterResults, Deque<FilterResult> thisOrFilterResults, boolean isNeedCombineOr) {
        if (isNeedCombineOr) {
            if (andFilterResult.isNotEmpty()) {
                thisOrFilterResults.add(andFilterResult);
            }
            FilterResult filterResult = this.pollOrFilterResults(thisOrFilterResults);
            thisOrFilterResults.clear();
            FilterResult thisAndFilterResult = FilterSqlBuilder.createAndFilterResult();
            thisAndFilterResult.setCountOfBracket(andFilterResult.getCountOfBracket());
            orFilterResults.add(filterResult);
            return thisAndFilterResult;
        }
        return andFilterResult;
    }

    private FilterResult joinPartFilterResults(Deque<FilterResult> thisOrFilterResults) {
        FilterResult thisAndFilterResult = FilterSqlBuilder.createAndFilterResult();
        thisOrFilterResults.add(this.pollOrFilterResults(thisOrFilterResults));
        return thisAndFilterResult;
    }

    private FilterResult joinAndOrFilterResult(FilterResult filterResult, Deque<FilterResult> orFilterResults, FilterResult andFilterResult, boolean addFirst) {
        FilterResult thisAndFilterResult;
        if (filterResult.getLogicOperate() == LogicOperate.AND) {
            if (addFirst) {
                thisAndFilterResult = andFilterResult.combineResult(filterResult, andFilterResult.getLogicOperate());
                thisAndFilterResult.setLogicOperate(andFilterResult.getLogicOperate());
            } else {
                thisAndFilterResult = filterResult.combineResult(andFilterResult, filterResult.getLogicOperate());
                thisAndFilterResult.setLogicOperate(filterResult.getLogicOperate());
            }
            thisAndFilterResult.setCountOfBracket(andFilterResult.getCountOfBracket() + filterResult.getCountOfBracket());
        } else {
            thisAndFilterResult = filterResult.getLogicOperate() == LogicOperate.OR ? this.joinOrLogcOperateResult(filterResult, orFilterResults, andFilterResult, addFirst) : andFilterResult;
        }
        return thisAndFilterResult;
    }

    private FilterResult joinOrLogcOperateResult(FilterResult filterResult, Deque<FilterResult> orFilterResults, FilterResult andFilterResult, boolean addFirst) {
        FilterResult thisAndFilterResult;
        if (andFilterResult.isNotEmpty()) {
            if (addFirst) {
                orFilterResults.addFirst(andFilterResult);
                FilterResult pollOrFilterResults = this.pollOrFilterResults(orFilterResults);
                orFilterResults.clear();
                orFilterResults.add(filterResult);
                orFilterResults.add(pollOrFilterResults);
            } else {
                thisAndFilterResult = filterResult.combineResult(andFilterResult, andFilterResult.getLogicOperate());
                thisAndFilterResult.setLogicOperate(filterResult.getLogicOperate());
                orFilterResults.add(thisAndFilterResult);
            }
        } else if (addFirst) {
            orFilterResults.addFirst(filterResult);
        } else {
            orFilterResults.add(filterResult);
        }
        thisAndFilterResult = new FilterResult(new String[]{"", ""}, null, new ArrayList<QFilter>());
        thisAndFilterResult.setLogicOperate(LogicOperate.AND);
        thisAndFilterResult.setCountOfBracket(andFilterResult.getCountOfBracket() + filterResult.getCountOfBracket());
        return thisAndFilterResult;
    }

    private FilterResult popQueueFilterResult(Deque<FilterRow> queue, boolean returnSQL) {
        FilterRow filterRow;
        FilterResult andFilterResult = FilterSqlBuilder.createAndFilterResult();
        ArrayDeque<FilterResult> orFilterResults = new ArrayDeque<FilterResult>();
        ArrayDeque<FilterResult> thisOrFilterResults = new ArrayDeque<FilterResult>();
        ArrayDeque<FilterRow> minQueue = new ArrayDeque<FilterRow>(10);
        FilterSqlBuilder.createAndFilterResult();
        int countOfBracket = 0;
        int currentCountOfBracket = 0;
        while (!queue.isEmpty()) {
            filterRow = queue.poll();
            minQueue.add(filterRow);
            if (!((currentCountOfBracket += this.countBracket(filterRow)) != 0 || StringUtils.isEmpty((CharSequence)filterRow.getRightBracket()) && filterRow.getLogic() != LogicOperate.OR)) {
                if ((countOfBracket += this.popMinQueueFilterResult(thisOrFilterResults, minQueue, queue, returnSQL)) != 0) continue;
                orFilterResults.add(this.pollOrFilterResults(thisOrFilterResults));
                thisOrFilterResults.clear();
                continue;
            }
            if (StringUtils.isEmpty((CharSequence)filterRow.getRightBracket()) || currentCountOfBracket >= 0) continue;
            KDBizException e = new KDBizException(BosErrorCode.filterSqlBuilder, new Object[]{ResManager.loadKDString((String)"\u5de6\u62ec\u53f7\u4e0e\u53f3\u62ec\u53f7\u4e0d\u5339\u914d\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"FilterSqlBuilder_0", (String)"bos-entity-metadata", (Object[])new Object[0])});
            try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_SCRIPTBUILDER, (String)"popQueueFilterResult");){
                span.addLocaleTag("filterRow", (Object)filterRow);
                span.throwException((Throwable)e);
            }
            throw e;
        }
        if (!minQueue.isEmpty()) {
            countOfBracket += this.popMinQueueFilterResult(orFilterResults, minQueue, queue, returnSQL);
        }
        while (!queue.isEmpty()) {
            if (!StringUtils.isEmpty((CharSequence)queue.peek().getLeftBracket())) continue;
            filterRow = queue.poll();
            FilterResult thisCondition = this.getCondition(filterRow, returnSQL);
            countOfBracket += thisCondition.getCountOfBracket();
            andFilterResult = this.joinAndOrFilterResult(thisCondition, orFilterResults, andFilterResult, false);
        }
        if (countOfBracket != 0) {
            throw new KDBizException(BosErrorCode.filterSqlBuilder, new Object[]{ResManager.loadKDString((String)"\u5de6\u62ec\u53f7\u4e0e\u53f3\u62ec\u53f7\u4e0d\u5339\u914d\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"FilterSqlBuilder_0", (String)"bos-entity-metadata", (Object[])new Object[0])});
        }
        return this.joinOrQfilterResults(orFilterResults);
    }

    private FilterResult joinOrQfilterResults(Deque<FilterResult> orFilterResults) {
        FilterResult joinAndOrFilterResult = FilterSqlBuilder.createAndFilterResult();
        ArrayDeque<FilterResult> thisOrFilterResults = new ArrayDeque<FilterResult>();
        for (FilterResult orFilterResult : orFilterResults) {
            joinAndOrFilterResult = this.joinAndOrFilterResult(orFilterResult, thisOrFilterResults, joinAndOrFilterResult, false);
        }
        if (!joinAndOrFilterResult.isEmpty()) {
            thisOrFilterResults.add(joinAndOrFilterResult);
        }
        return this.pollOrFilterResults(thisOrFilterResults);
    }

    private FilterResult pollOrFilterResults(Deque<FilterResult> orFilterResults) {
        FilterResult filterResult2 = FilterSqlBuilder.createAndFilterResult();
        while (!orFilterResults.isEmpty()) {
            FilterResult fResult = orFilterResults.poll();
            filterResult2 = fResult.combineResult(filterResult2, filterResult2.getLogicOperate());
            filterResult2.setLogicOperate(fResult.getLogicOperate());
        }
        orFilterResults.clear();
        return filterResult2;
    }

    private FilterResult getFilterResult(List<FilterRow> filterRows, boolean returnSQL, boolean ignoreBlandValue) {
        ArrayDeque<FilterRow> queue = new ArrayDeque<FilterRow>(10);
        int i = 0;
        while (i < filterRows.size()) {
            FilterRow filterRow = filterRows.get(i);
            if (filterRow != null) {
                filterRow.setRowIndex(i);
            }
            if (filterRow == null || filterRow.getFilterField() == null || StringUtils.isEmpty((CharSequence)filterRow.getFilterField().getFieldName()) || ignoreBlandValue && filterRow.getValue().isEmpty() && filterRow.getCompareType().isNeedInput()) continue;
            queue.add(filterRow);
            ++i;
        }
        return this.popQueueFilterResult(queue, returnSQL);
    }

    private FilterResult buildFilter(List<FilterRow> filterRows, boolean returnSQL, boolean ignoreBlandValue) {
        FilterResult filterResult = this.getFilterResult(filterRows, returnSQL, ignoreBlandValue);
        String strFilter = filterResult.getFilterGroup()[0].trim();
        if (strFilter.endsWith("AND")) {
            strFilter = strFilter.substring(0, strFilter.length() - 3);
        }
        if (strFilter.endsWith(LogicOperate.AND.getName())) {
            strFilter = strFilter.substring(0, strFilter.length() - 2);
        }
        if (strFilter.endsWith(LogicOperate.OR.getName())) {
            strFilter = strFilter.substring(0, strFilter.length() - 2);
        }
        if (strFilter.endsWith("NONE")) {
            strFilter = strFilter.substring(0, strFilter.length() - 4);
        }
        if (strFilter.endsWith("&&")) {
            strFilter = strFilter.substring(0, strFilter.length() - 2);
        }
        if (strFilter.endsWith("OR")) {
            strFilter = strFilter.substring(0, strFilter.length() - 2);
        }
        if (strFilter.endsWith("||")) {
            strFilter = strFilter.substring(0, strFilter.length() - 2);
        }
        filterResult.getFilterGroup()[0] = strFilter;
        return filterResult;
    }

    private String trimAnd(boolean returnSQL, String filter) {
        String filterTmp = filter;
        if (filterTmp.startsWith(" AND")) {
            filterTmp = filterTmp.substring(5, filterTmp.length());
        }
        if (filterTmp.endsWith("AND ")) {
            filterTmp = filterTmp.substring(1, filterTmp.length() - 5);
        }
        if (returnSQL && StringUtils.isNotBlank((CharSequence)filterTmp)) {
            filterTmp = "( " + filterTmp + " )";
        }
        return filterTmp;
    }

    public FilterResult buildFilter(FilterObject filterObj, boolean returnSQL, boolean ignoreBlandValue) {
        String[] strSql = new String[]{"", ""};
        ArrayList<FilterRow> filterRows = new ArrayList<FilterRow>();
        filterRows.addAll(filterObj.getFilterRows());
        FilterResult filterResult2 = this.buildFilter(filterRows, returnSQL, ignoreBlandValue);
        strSql[0] = this.trimAnd(returnSQL, filterResult2.getFilterGroup()[0]);
        strSql[1] = this.trimAnd(returnSQL, filterResult2.getFilterGroup()[1]);
        FilterResult filterResult = new FilterResult(strSql, filterResult2.getQFilter(), filterResult2.getQFilters());
        filterResult.setEmpty(filterResult2.isEmpty());
        return filterResult;
    }
}

