/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.filter.constants;

import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.filter.ConditionVariableContext;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.filter.FilterScriptBuilder;
import kd.bos.entity.filter.IConditionVariableAnalysis;
import kd.bos.org.api.IOrgService;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.IUserService;
import kd.bos.service.ServiceFactory;

abstract class AbstractCurrentUserDeptAnalysis
implements IConditionVariableAnalysis {
    static final String entityID_user = "bos_user";
    static final String ENTRYENTITY_DPT_ID = "entryentity.dpt.id";

    AbstractCurrentUserDeptAnalysis() {
    }

    @Override
    public void getVariableFilter(ConditionVariableContext ctx) {
        String filter;
        FilterField filterField = AbstractCurrentUserDeptAnalysis.convertToId(ctx);
        List<Long> deptList = this.getDeptList();
        ctx.setQFilter(new QFilter(filterField.getFullFieldName(), ctx.getOperater(), deptList));
        String fieldName = filterField.getFieldName();
        if (ctx.isParam() && !deptList.isEmpty()) {
            SqlParameter sqlParam = new SqlParameter(fieldName, ctx.getColType(), (Object)deptList.get(0));
            ctx.getParam().add(sqlParam);
            filter = String.format("%s %s ?", fieldName, ctx.getOperater());
        } else {
            filter = String.format("%s %s %s", fieldName, ctx.getOperater(), deptList.toArray());
        }
        ctx.setFilter(filter);
    }

    private static FilterField convertToId(ConditionVariableContext ctx) {
        FilterField filterField = ctx.getFilterRow().getFilterField().convertToId();
        ctx.getFilterRow().setFilterField(filterField);
        return filterField;
    }

    abstract boolean isIncludeSubOrg();

    List<Long> getOrgsUserJoin() {
        ArrayList<Long> lstUsrDpts = new ArrayList<Long>();
        ORM orgORM = ORM.create();
        QFilter f1 = new QFilter("id", "=", (Object)RequestContext.get().getCurrUserId());
        try (DataSet ds = orgORM.queryDataSet(AbstractCurrentUserDeptAnalysis.class.getName(), entityID_user, ENTRYENTITY_DPT_ID, new QFilter[]{f1});){
            for (Row row : ds) {
                if (row.get(0) == null || row.getLong(ENTRYENTITY_DPT_ID) == null) continue;
                lstUsrDpts.add(row.getLong(ENTRYENTITY_DPT_ID));
            }
        }
        return lstUsrDpts;
    }

    List<Long> getCurrentUserDepts() {
        List<Long> userOrgList = this.getOrgsUserJoin();
        ArrayList<Long> deptIdList = new ArrayList<Long>(10);
        if (this.isIncludeSubOrg()) {
            IOrgService orgService = (IOrgService)ServiceFactory.getService(IOrgService.class);
            deptIdList.addAll(orgService.getAllSubordinateOrgs(Long.valueOf(1L), userOrgList, this.isIncludeSubOrg()));
        } else {
            deptIdList.addAll(userOrgList);
        }
        return deptIdList;
    }

    List<Long> getInchargeOrgs() {
        IUserService userService = (IUserService)ServiceFactory.getService(IUserService.class);
        return userService.getInchargeOrgs(RequestContext.get().getCurrUserId(), this.isIncludeSubOrg());
    }

    abstract List<Long> getDeptList();

    @Override
    public void getScriptFilter(ConditionVariableContext ctx) {
        FilterField filterField = AbstractCurrentUserDeptAnalysis.convertToId(ctx);
        String fieldName = filterField.getFieldName();
        List<Long> deptList = this.getDeptList();
        String script = String.format("%s %s ('%s')", fieldName, ctx.getOperater(), StringUtils.join((Object[])deptList.toArray(), (String)"','"));
        int fieldType = ctx.getColType();
        if (FilterScriptBuilder.isNumberField(fieldType)) {
            script = String.format("%s %s (%s)", fieldName, ctx.getOperater(), StringUtils.join((Object[])deptList.toArray(), (String)","));
        }
        ctx.setScript(script);
    }
}

