/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.filter.constants;

import kd.bos.entity.filter.ConditionVariableContext;
import kd.bos.entity.filter.FilterScriptBuilder;
import kd.bos.entity.filter.FilterUtil;
import kd.bos.entity.filter.IConditionVariableAnalysis;
import kd.bos.entity.property.IBasedataField;
import kd.bos.entity.property.LongProp;
import kd.bos.orm.query.QFilter;

public class IsNullAnalysis
implements IConditionVariableAnalysis {
    @Override
    public void getVariableFilter(ConditionVariableContext ctx) {
        int fieldType;
        ctx.setQFilter(QFilter.emptyOrNotExists((String)ctx.getFieldName()));
        if (ctx.getFilterRow().getFilterField().getLatestParent() instanceof IBasedataField && ctx.getFilterRow().getFilterField().getFieldProp() instanceof LongProp) {
            ctx.setQFilter(FilterUtil.decorateZero(ctx.getQFilter()));
        }
        if ((fieldType = ctx.getColType()) == -7 || fieldType == -5 || fieldType == 3 || fieldType == 6 || fieldType == 4 || fieldType == 2 || fieldType == 7 || fieldType == 5 || fieldType == -6) {
            ctx.setFilter(String.format("%1$s IS NULL OR %1$s = 0", ctx.getFieldName()));
            return;
        }
        ctx.setFilter(String.format("(%1$s ='' Or %1$s =' ' Or %1$s IS NULL)", ctx.getFieldName()));
    }

    @Override
    public void getScriptFilter(ConditionVariableContext ctx) {
        String script = String.format(" %s = NULL ", ctx.getFieldName());
        int fieldType = ctx.getColType();
        if (FilterScriptBuilder.isStringField(fieldType)) {
            script = String.format(" trim(EMPTY_TO_TEXT(%s, '')) = '' ", ctx.getFieldName());
        }
        ctx.setScript(script);
    }
}

