/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.flex;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityItemTypes;
import kd.bos.entity.FlexEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.flex.FlexEntityMetaUtils;
import kd.bos.entity.flex.FlexProperty;
import kd.bos.entity.property.BasedataProp;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.bos.orm.datamanager.DataManagerUtils;
import kd.bos.orm.datamanager.IDataManager;
import kd.bos.util.JSONUtils;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class FlexEntireData {
    private static final String BOS_ENTITY_METADATA = "bos-entity-metadata";
    private static Log log = LogFactory.getLog(FlexEntireData.class);
    private long id;
    List<FlexData> flexDatas;
    String strFlexData;

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
        if (this.flexDatas != null && !this.flexDatas.isEmpty()) {
            for (FlexData flexData : this.flexDatas) {
                flexData.setId(id);
            }
        }
    }

    public List<FlexData> getFlexDatas() {
        return this.flexDatas;
    }

    public void setSortedFlexDatas(List<FlexData> flexDatasSorted) {
        this.strFlexData = "";
        this.flexDatas = flexDatasSorted;
    }

    public void setFlexDatas(List<FlexData> flexDatas) {
        this.strFlexData = "";
        flexDatas.sort(new Comparator<FlexData>(){

            @Override
            public int compare(FlexData o1, FlexData o2) {
                return o1.getIndex() - o2.getIndex();
            }
        });
        this.flexDatas = flexDatas;
    }

    public void setFlexData(MainEntityType entityType, DynamicObject data) {
        this.flexDatas = new ArrayList<FlexData>();
        this.strFlexData = "";
        this.id = 0L;
        DataEntityPropertyCollection properties = entityType.getProperties();
        StringBuilder debugStr = new StringBuilder();
        if (FlexEntityMetaUtils.isOutLog()) {
            try {
                for (IDataEntityProperty prop1 : properties) {
                    String key1 = prop1.getName();
                    Object obj1 = prop1.getValue((Object)data);
                    debugStr.append("k:").append(key1).append(",v:").append(obj1);
                }
                debugStr.append(System.lineSeparator());
            }
            catch (Exception e) {
                debugStr.append("getdata error:").append(e.getMessage());
            }
        }
        for (IDataEntityProperty prop : properties) {
            FlexData flexData;
            String key = prop.getName();
            if ("id".equals(key)) {
                Object obj = prop.getValue((Object)data);
                if (obj == null) continue;
                this.setId((Long)obj);
                continue;
            }
            if (prop instanceof BasedataProp) continue;
            Object val = prop.getValue((Object)data);
            String subKey = key;
            if (key.endsWith("_id")) {
                String masterPropertyName;
                subKey = key.substring(0, key.length() - 3);
                BasedataEntityType bet = (BasedataEntityType)((BasedataProp)entityType.getProperty(subKey)).getComplexType();
                DynamicObject baseData = (DynamicObject)data.get(subKey);
                if (bet != null && bet.getMasteridType() != 0 && (masterPropertyName = bet.getMasteridPropName()) != null) {
                    if (baseData != null) {
                        val = baseData.get(masterPropertyName);
                        if (this.isEmpty(prop, val)) {
                            throw new KDBizException(BosErrorCode.nullError, new Object[]{String.format(ResManager.loadKDString((String)"%1$s\u57fa\u7840\u8d44\u6599%2$s\u5bf9\u5e94\u7684%3$s\u4e3a\u7a7a\u3002", (String)"FlexEntireData_4", (String)BOS_ENTITY_METADATA, (Object[])new Object[0]), bet.getName(), baseData.getPkValue().toString(), masterPropertyName)});
                        }
                    } else if (this.checkMasterID(subKey) && !this.isEmpty(prop, val)) {
                        DataEntityCacheManager cacheManager = new DataEntityCacheManager((IDataEntityType)bet);
                        Map cacheMap = cacheManager.get(new Object[]{val});
                        DynamicObject dataEntity = (DynamicObject)cacheMap.get(val);
                        if (dataEntity == null) {
                            dataEntity = this.getBaseData(val, bet);
                            if (dataEntity == null) {
                                throw new KDBizException(BosErrorCode.nullError, new Object[]{String.format(ResManager.loadKDString((String)"%1$s\u57fa\u7840\u8d44\u6599\u5bf9\u8c61\u4e3a\u7a7a,\u65e0\u6cd5\u83b7\u53d6%2$s\u503c\u3002", (String)"FlexEntireData_5", (String)BOS_ENTITY_METADATA, (Object[])new Object[0]), bet.getName(), masterPropertyName)});
                            }
                            cacheManager.put(new Object[]{dataEntity});
                        }
                        if (this.isEmpty(prop, val = dataEntity.get(masterPropertyName))) {
                            throw new KDBizException(BosErrorCode.nullError, new Object[]{String.format(ResManager.loadKDString((String)"%1$s\u57fa\u7840\u8d44\u6599\u5bf9\u8c61\u4e3a\u7a7a,\u65e0\u6cd5\u83b7\u53d6%2$s\u503c\u3002", (String)"FlexEntireData_5", (String)BOS_ENTITY_METADATA, (Object[])new Object[0]), bet.getName(), masterPropertyName)});
                        }
                    }
                }
                if (FlexEntityMetaUtils.isOutLog()) {
                    String k = subKey.split("__")[1];
                    FlexProperty flexProperty = FlexEntityMetaUtils.getFlexProperty(k);
                    String formNumber = flexProperty.getValueSource();
                    if ("2".equals(flexProperty.getValueType())) {
                        formNumber = "bos_assistantdata_detail";
                    }
                    if (Objects.nonNull((Object)bet) && Objects.nonNull(bet.getName()) && !bet.getName().equalsIgnoreCase(formNumber)) {
                        this.writeLog(formNumber, k, "", "bet.name:" + bet.getName());
                    }
                    if (val != null && StringUtils.isNotBlank((CharSequence)val.toString()) && !"0".endsWith(val.toString())) {
                        boolean isExists = true;
                        try {
                            isExists = ORM.create().exists(formNumber, val);
                            if (!isExists) {
                                String dataType = EntityItemTypes.toJsonString(data.getDataEntityType());
                                String entityTypeStr = EntityItemTypes.toJsonString((IDataEntityType)entityType);
                                Object obj = prop.getValue((Object)data);
                                debugStr.append("  ---- oldval:").append(obj.toString()).append(" newval:").append(val);
                                debugStr.append("      dataType:").append(dataType).append("    entitytype:").append(entityTypeStr).append(" ---- ");
                            }
                        }
                        catch (Exception e) {
                            log.error((Throwable)e);
                        }
                        if (Objects.nonNull((Object)bet) && !isExists && bet.getMasteridType() != 2) {
                            this.writeLog(formNumber, k, val.toString(), debugStr.toString());
                        }
                    }
                }
            }
            key = subKey.split("__")[1];
            FlexProperty flexProperty = null;
            if (entityType instanceof FlexEntityType) {
                List<FlexProperty> list = ((FlexEntityType)entityType).getFlexProperties();
                for (FlexProperty fp : list) {
                    if (!fp.getFlexField().equals(key)) continue;
                    flexProperty = fp;
                    break;
                }
            }
            if (flexProperty != null) {
                flexData = new FlexData(flexProperty, val);
            } else {
                flexData = new FlexData();
                flexData.setPropId(key);
                flexData.setValue(val);
            }
            if (prop.getPropertyType().equals(String.class)) {
                flexData.setDbType(FlexFieldDataType.STRING);
            } else {
                flexData.setDbType(FlexFieldDataType.LONG);
            }
            this.flexDatas.add(flexData);
        }
    }

    protected DynamicObject getBaseData(Object pkValue, BasedataEntityType bet) {
        IDataManager dataManager = DataManagerUtils.getDataManager((IDataEntityType)bet);
        return (DynamicObject)dataManager.read(pkValue);
    }

    protected boolean checkMasterID(String flexItem) {
        return true;
    }

    private boolean isEmpty(IDataEntityProperty prop, Object val) {
        return prop.getPropertyType().equals(String.class) && StringUtils.isBlank((Object)val) || !prop.getPropertyType().equals(String.class) && val.equals(0L);
    }

    private void writeLog(String number, String flexField, String pk, String msg) {
        StringBuilder sb = new StringBuilder();
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        sb.append("number:").append(number).append("  flexField:").append(flexField);
        sb.append("   pk:").append(pk).append("         msg:").append(msg).append("       stack:");
        for (StackTraceElement stackTraceElement : stackTrace) {
            String className = stackTraceElement.getClassName();
            String methodName = stackTraceElement.getMethodName();
            sb.append(className).append(",").append(methodName).append(System.lineSeparator());
        }
        String sql = "insert into T_LOG_DEPLOY_HIS (FID, FPACKAGEID, FTYPE, FCATEGORY, FVER, FCONTENT) values (?, ?, ?, ?, ?, ?)";
        Object[] params = new Object[]{DB.genGlobalLongId(), 1, "3", "a", "0", sb.toString()};
        try (TXHandle h = TX.required();){
            DB.execute((DBRoute)DBRoute.log, (String)sql, (Object[])params);
        }
        catch (Exception e) {
            log.error("log writing DB error", (Throwable)e);
        }
        throw new KDBizException(BosErrorCode.bOS, new Object[]{String.format(ResManager.loadKDString((String)"\u7ef4\u5ea6\u5c5e\u6027\u7684\u57fa\u7840\u8d44\u6599\u7c7b\u578b\u4e0e\u6570\u636e\u5bf9\u5e94\u7684\u57fa\u7840\u8d44\u6599\u7c7b\u578b\u4e0d\u5339\u914d\uff0c\u8bf7\u8054\u7cfb\u5f00\u53d1\u5546\u68c0\u67e5\u9519\u8bef\u3002%s", (String)"FlexEntireData_2", (String)BOS_ENTITY_METADATA, (Object[])new Object[0]), sb)});
    }

    public String concatFlexData() {
        if (StringUtils.isNotBlank((CharSequence)this.strFlexData)) {
            return this.strFlexData;
        }
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        boolean isEmpty = true;
        ArrayList<FlexProperty> flexProperties = new ArrayList<FlexProperty>();
        boolean duplicateKey = false;
        for (FlexData flexData : this.flexDatas) {
            if (!flexData.isNotEmpty()) continue;
            isEmpty = false;
            Object val = flexData.getValue();
            if (val == null) continue;
            if (map.containsKey(flexData.getPropId())) {
                duplicateKey = true;
            }
            map.put(flexData.getPropId(), val);
            if (!FlexEntityMetaUtils.isOutLog()) continue;
            flexProperties.add(FlexEntityMetaUtils.getFlexProperty(flexData.getPropId()));
        }
        if (duplicateKey) {
            StringBuilder val = new StringBuilder();
            val.append("Duplicate Key(FlexDatas value={");
            for (FlexData flexData : this.flexDatas) {
                val.append(flexData.getPropId()).append(":");
                val.append(flexData.getValue()).append(";");
            }
            val.append("})");
            throw new KDException(BosErrorCode.bOS, new Object[]{String.format(ResManager.loadKDString((String)"FlexData\u7c7b\u578b\u8f6c\u6362\u9519\u8bef\u3002\u9519\u8bef\u4fe1\u606f\uff1a%s", (String)"FlexEntireData_3", (String)BOS_ENTITY_METADATA, (Object[])new Object[0]), val)});
        }
        if (!isEmpty && FlexEntityMetaUtils.isOutLog()) {
            int index = 0;
            for (FlexProperty flexProperty : flexProperties) {
                if (flexProperty.getIndex() < index) {
                    StringBuilder sb = new StringBuilder();
                    StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
                    sb.setLength(0);
                    try {
                        sb.append("data:").append(JSONUtils.toString(map));
                    }
                    catch (IOException e) {
                        throw new KDException((Throwable)e, BosErrorCode.bOS, new Object[]{String.format(ResManager.loadKDString((String)"FlexData\u7c7b\u578b\u8f6c\u6362\u9519\u8bef\u3002\u9519\u8bef\u4fe1\u606f\uff1a%s", (String)"FlexEntireData_3", (String)BOS_ENTITY_METADATA, (Object[])new Object[0]), e.getMessage())});
                    }
                    sb.append("stack:");
                    for (StackTraceElement stackTraceElement : stackTrace) {
                        String className = stackTraceElement.getClassName();
                        String methodName = stackTraceElement.getMethodName();
                        sb.append("className = ").append(className).append(", methodName = ").append(methodName).append(System.lineSeparator());
                    }
                    FlexEntityMetaUtils.outLog("FlexEntireData", "concatFlexData", String.format("flex Error: index error. %s", sb.toString()));
                }
                index = flexProperty.getIndex();
            }
        }
        if (isEmpty) {
            this.strFlexData = "";
        } else {
            try {
                this.strFlexData = JSONUtils.toString(map);
            }
            catch (IOException e) {
                throw new KDException((Throwable)e, BosErrorCode.bOS, new Object[]{String.format(ResManager.loadKDString((String)"FlexData\u7c7b\u578b\u8f6c\u6362\u9519\u8bef\u3002\u9519\u8bef\u4fe1\u606f\uff1a%s", (String)"FlexEntireData_3", (String)BOS_ENTITY_METADATA, (Object[])new Object[0]), e.getMessage())});
            }
        }
        return this.strFlexData;
    }

    public Map<String, Object> getFlexValue() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (FlexData flexData : this.flexDatas) {
            map.put(flexData.getPropId(), flexData.getValue());
        }
        return map;
    }

    public static enum FlexFieldDataType {
        LONG,
        STRING;

    }

    public class FlexData {
        private long id;
        private int index;
        private String propId;
        private Object value;
        private FlexFieldDataType dbType;

        public long getId() {
            return this.id;
        }

        public void setId(long id) {
            this.id = id;
        }

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public String getPropId() {
            return this.propId;
        }

        @Deprecated
        public void setPropId(String propId) {
            this.setPropId1(propId);
        }

        private void setPropId1(String propId) {
            this.propId = propId;
            if (this.index == 0) {
                FlexProperty fp = FlexEntityMetaUtils.getFlexProperty(this.propId);
                this.index = fp.getIndex();
            }
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public FlexFieldDataType getDbType() {
            return this.dbType;
        }

        public void setDbType(FlexFieldDataType dbType) {
            this.dbType = dbType;
        }

        @Deprecated
        public FlexData() {
        }

        public FlexData(String propId, Object value) {
            this.setPropId1(propId);
            this.value = value;
        }

        public FlexData(FlexProperty flexProperty, Object value) {
            this.propId = flexProperty.getFlexField();
            this.index = flexProperty.getIndex();
            this.value = value;
        }

        public boolean isNotEmpty() {
            return this.dbType == FlexFieldDataType.LONG && !this.value.equals(0L) || this.dbType == FlexFieldDataType.STRING && !StringUtils.isEmpty((CharSequence)this.value.toString());
        }
    }
}

