/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.flex;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DataEntityTypeAttribute;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.flex.FlexBDValueCondition;
import kd.bos.entity.flex.FlexType;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
@DataEntityTypeAttribute(tableName="T_BAS_FLEX_PROPERTY", dbRouteKey="basedata")
public class FlexProperty
implements Serializable {
    private static final long serialVersionUID = 1597866794288216663L;
    private static final String DISP_PROP = "dispprop";
    private long id;
    private int propId;
    private int flexId;
    private long flexTypeId;
    private String number;
    private LocaleString name;
    private String glName;
    private String valueType;
    private String valueSource;
    private String flexField;
    private String dataType;
    private int datamaxlen;
    private int index;
    private FlexType flexType;
    private String assistantType;
    private long orgFunc;
    private String orgFuncNumber;
    private String status;
    private String enable;
    private String basedataValueCondition;
    private FlexBDValueCondition flexBDValueCondition;
    private String displayProp;

    @SimplePropertyAttribute(isPrimaryKey=true, alias="FENTRYID", dbType=-5)
    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public int getPropId() {
        return this.propId;
    }

    public void setPropId(int propId) {
        this.propId = propId;
    }

    @SimplePropertyAttribute(alias="FID", dbType=-5)
    public long getFlexTypeId() {
        return this.flexTypeId;
    }

    public void setFlexTypeId(long flexTypeId) {
        this.flexTypeId = flexTypeId;
    }

    @Deprecated
    public int getFlexId() {
        return (int)(this.flexTypeId >>> 32);
    }

    public void setFlexId(int flexId) {
        this.flexId = flexId;
    }

    @SimplePropertyAttribute(alias="FNUMBER", dbType=12)
    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    @SimplePropertyAttribute(alias="FNAME", dbType=12)
    public String getGLName() {
        if (StringUtils.isBlank((CharSequence)this.glName) && this.name != null) {
            return this.getName().getLocaleValue();
        }
        return this.glName;
    }

    public void setGLName(String glName) {
        this.glName = glName;
        if (this.name != null) {
            this.name.setLocaleValue(glName);
        }
    }

    @SimplePropertyAttribute(isDbIgnore=true)
    public LocaleString getName() {
        return this.name;
    }

    public void setName(LocaleString name) {
        this.name = name;
    }

    @SimplePropertyAttribute(alias="FVALUETYPE", dbType=12)
    public String getValueType() {
        return this.valueType;
    }

    public void setValueType(String valueType) {
        this.valueType = valueType;
    }

    @SimplePropertyAttribute(alias="FVALUESOURCE", dbType=12)
    public String getValueSource() {
        return this.valueSource;
    }

    public void setValueSource(String valueSource) {
        this.valueSource = valueSource;
    }

    @SimplePropertyAttribute(alias="FFLEXFIELD", dbType=12)
    public String getFlexField() {
        return this.flexField;
    }

    public void setFlexField(String flexField) {
        this.flexField = flexField;
    }

    @SimplePropertyAttribute(alias="FDATATYPE", dbType=12)
    public String getDataType() {
        return this.dataType;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    @SimplePropertyAttribute(alias="FINDEX", dbType=4)
    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public FlexType getFlexType() {
        return this.flexType;
    }

    public void setFlexType(FlexType flexType) {
        this.flexType = flexType;
    }

    @SimplePropertyAttribute(alias="FDATAMAXLEN", dbType=5)
    public int getDatamaxlen() {
        return this.datamaxlen;
    }

    public void setDatamaxlen(int datamaxlen) {
        this.datamaxlen = datamaxlen;
    }

    @SimplePropertyAttribute(alias="FASSISTANTTYPE", dbType=12)
    public String getAssistantType() {
        return this.assistantType;
    }

    public void setAssistantType(String assistantType) {
        this.assistantType = assistantType;
    }

    @SimplePropertyAttribute(alias="FSTATUS", dbType=12)
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    @SimplePropertyAttribute(alias="FENABLE", dbType=12)
    public String getEnable() {
        return this.enable;
    }

    public void setEnable(String enable) {
        this.enable = enable;
    }

    @SimplePropertyAttribute(alias="FORGFUNC", dbType=-5)
    public long getOrgFunc() {
        return this.orgFunc;
    }

    public void setOrgFunc(long orgFunc) {
        this.orgFunc = orgFunc;
    }

    @SimplePropertyAttribute(isDbIgnore=true)
    public String getOrgFuncNumber() {
        return this.orgFuncNumber;
    }

    public void setOrgFuncNumber(String orgFuncNumber) {
        this.orgFuncNumber = orgFuncNumber;
    }

    public <T> T getDataTypeObject() {
        if (StringUtils.isNotBlank((CharSequence)this.dataType)) {
            Map dataTypeObject = (Map)SerializationUtils.fromJsonString((String)this.dataType, HashMap.class);
            String type = (String)dataTypeObject.get("type");
            if ("decimal".equals(type)) {
                int precision = (Integer)dataTypeObject.get("precision");
                int scale = (Integer)dataTypeObject.get("scale");
                BigDecimal max = (BigDecimal)dataTypeObject.get("max");
                BigDecimal min = (BigDecimal)dataTypeObject.get("min");
                return (T)new FlexDecimal(type, precision, scale, max, min);
            }
            int length = 0;
            length = dataTypeObject.get("length") != null ? (Integer)dataTypeObject.get("length") : this.datamaxlen;
            return (T)new FlexVarchar(type, length);
        }
        return (T)new FlexVarchar("varchar", this.datamaxlen);
    }

    @SimplePropertyAttribute(alias="FFILTERCONDITION_TAG", dbType=12)
    public String getBasedataValueCondition() {
        return this.basedataValueCondition;
    }

    public void setBasedataValueCondition(String basedataValueCondition) {
        this.basedataValueCondition = basedataValueCondition;
        if (StringUtils.isNotBlank((CharSequence)basedataValueCondition)) {
            this.flexBDValueCondition = (FlexBDValueCondition)SerializationUtils.fromJsonString((String)this.basedataValueCondition, FlexBDValueCondition.class);
        }
    }

    public FlexBDValueCondition getFlexBDValueCondition() {
        return this.flexBDValueCondition;
    }

    @SimplePropertyAttribute(alias="FDISPROPS", dbType=12)
    public String getDisplayProp() {
        return this.displayProp;
    }

    public void setDisplayProp(String displayProp) {
        this.displayProp = displayProp;
    }

    public DisplayStyle getDisplayStyle() {
        return new DisplayStyle(this.displayProp);
    }

    public void setDisplayStyle(DisplayStyle displayStyle) {
        this.displayProp = displayStyle.toString();
    }

    public class FlexVarchar {
        private String type;
        private int length;

        public FlexVarchar(String type, int length) {
            this.type = type;
            this.length = length;
        }

        public String getType() {
            return this.type;
        }

        public int getLength() {
            return this.length;
        }
    }

    public class FlexDecimal {
        private String type;
        private int precision;
        private int scale;
        private BigDecimal max;
        private BigDecimal min;

        public FlexDecimal(String type, int precision, int scale, BigDecimal max, BigDecimal min) {
            this.type = type;
            this.precision = precision;
            this.scale = scale;
            this.max = max;
            this.min = min;
        }

        public String getType() {
            return this.type;
        }

        public int getPrecision() {
            return this.precision;
        }

        public int getScale() {
            return this.scale;
        }

        public BigDecimal getMax() {
            return this.max;
        }

        public BigDecimal getMin() {
            return this.min;
        }
    }

    public static enum DisplayProperty {
        Number("1"),
        Name("2"),
        NumberAndName("3"),
        LongNumber("4"),
        FullName("5"),
        NumberAndFullName("6"),
        SimpleName("7");

        private String intValue;

        private DisplayProperty(String value) {
            this.intValue = value;
        }

        public String getValue() {
            return this.intValue;
        }

        public static DisplayProperty forValue(String value) {
            switch (value) {
                case "1": {
                    return Number;
                }
                case "3": {
                    return NumberAndName;
                }
                case "4": {
                    return LongNumber;
                }
                case "5": {
                    return FullName;
                }
                case "6": {
                    return NumberAndFullName;
                }
                case "7": {
                    return SimpleName;
                }
            }
            return Name;
        }

        public String toString() {
            switch (this.intValue) {
                case "1": {
                    return "number";
                }
                case "3": {
                    return "number,name";
                }
                case "4": {
                    return "longNumber";
                }
                case "5": {
                    return "fullName";
                }
                case "6": {
                    return "number,fullName";
                }
                case "7": {
                    return "simplename";
                }
            }
            return "name";
        }
    }

    public class DisplayStyle {
        private String type = "1";
        private Map<String, Object> disp;

        public DisplayStyle(String dispStr) {
            if (StringUtils.isBlank((CharSequence)dispStr)) {
                this.disp = new HashMap<String, Object>();
                this.disp.put(FlexProperty.DISP_PROP, "2");
                return;
            }
            Map map = (Map)SerializationUtils.fromJsonString((String)dispStr, HashMap.class);
            this.type = (String)map.get("type");
            this.disp = (Map)map.get("disp");
        }

        public String getType() {
            return this.type;
        }

        public DisplayProperty getDisplayProperty() {
            if (this.disp.isEmpty()) {
                return DisplayProperty.Name;
            }
            return DisplayProperty.forValue((String)this.disp.get(FlexProperty.DISP_PROP));
        }

        public void setDisplayProperty(DisplayProperty val) {
            this.disp.put(FlexProperty.DISP_PROP, val.getValue());
        }

        public String toString() {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("type", this.type);
            map.put("disp", this.disp);
            return SerializationUtils.toJsonString(map);
        }
    }
}

