/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.format;

import java.io.Serializable;
import java.util.Locale;
import kd.bos.dataentity.utils.StringUtils;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class DateFormatObject
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -4404490428950094036L;
    private String dateFormat;
    private String timeArea;
    private String localeStr;
    private transient Locale locale = null;

    public DateFormatObject() {
    }

    public DateFormatObject(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public DateFormatObject(String dateFormat, String timeArea) {
        this.dateFormat = dateFormat;
        this.timeArea = timeArea;
    }

    public DateFormatObject(String dateFormat, String timeArea, String localeStr) {
        this.dateFormat = dateFormat;
        this.timeArea = timeArea;
        this.localeStr = localeStr;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public String getTimeArea() {
        return this.timeArea;
    }

    public void setTimeArea(String timeArea) {
        this.timeArea = timeArea;
    }

    public String getLocaleStr() {
        return this.localeStr;
    }

    public void setLocaleStr(String localeStr) {
        this.localeStr = localeStr;
        this.locale = null;
    }

    public Locale getLocale() {
        if (this.locale != null) {
            return this.locale;
        }
        if (StringUtils.isNotEmpty((CharSequence)this.getLocaleStr())) {
            String localeStr = this.getLocaleStr();
            if (localeStr.indexOf(95) != -1) {
                String[] localeArray = localeStr.split("_");
                this.locale = new Locale(localeArray[0], localeArray[1]);
            } else if (localeStr.indexOf(45) != -1) {
                String[] localeArray = localeStr.split("-");
                this.locale = new Locale(localeArray[0], localeArray[1]);
            }
        }
        return this.locale;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.dateFormat == null ? 0 : this.dateFormat.hashCode());
        result = 31 * result + (this.localeStr == null ? 0 : this.localeStr.hashCode());
        result = 31 * result + (this.timeArea == null ? 0 : this.timeArea.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DateFormatObject other = (DateFormatObject)obj;
        if (this.dateFormat == null ? other.dateFormat != null : !this.dateFormat.equals(other.dateFormat)) {
            return false;
        }
        if (this.localeStr == null ? other.localeStr != null : !this.localeStr.equals(other.localeStr)) {
            return false;
        }
        return !(this.timeArea == null ? other.timeArea != null : !this.timeArea.equals(other.timeArea));
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

