/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.format;

import java.util.Locale;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.format.AbstractFormat;
import kd.bos.entity.format.CurrencyFormat;
import kd.bos.entity.format.CurrencyFormatObject;
import kd.bos.entity.format.DateFormat;
import kd.bos.entity.format.DateFormatObject;
import kd.bos.entity.format.FormatObject;
import kd.bos.entity.format.FormatTypes;
import kd.bos.entity.format.IFormat;
import kd.bos.entity.format.NumberFormat;
import kd.bos.entity.format.NumberFormatObject;
import kd.bos.entity.format.TimeFormat;
import kd.bos.entity.format.TimeFormatObject;
import kd.bos.inte.api.IInteService;
import kd.bos.service.ServiceFactory;
import kd.sdk.annotation.SdkPublic;
import org.apache.commons.collections4.MapUtils;

@SdkPublic
public class FormatFactory {
    public static IFormat get(FormatTypes type) {
        AbstractFormat fmt = null;
        switch (type) {
            case Date: {
                fmt = new DateFormat();
                break;
            }
            case Time: {
                fmt = new TimeFormat();
                break;
            }
            case Currency: {
                fmt = new CurrencyFormat();
                break;
            }
            case Number: {
                fmt = new NumberFormat();
                break;
            }
        }
        return fmt;
    }

    public static FormatObject getFormat(Long userId) {
        IInteService inteService = (IInteService)ServiceFactory.getService(IInteService.class);
        Map fmt = inteService.getUserFormat(Long.valueOf(Long.parseLong(RequestContext.get().getUserId())));
        if (MapUtils.isEmpty((Map)fmt)) {
            return null;
        }
        return FormatFactory.getFormat(fmt);
    }

    private static FormatObject getFormat(Map<String, Object> userFormat) {
        String fmt;
        FormatObject result = new FormatObject();
        Map numberFormat = (Map)userFormat.get("numberFormat");
        Map timeFormat = (Map)userFormat.get("timeFormat");
        Map currencyFormat = (Map)userFormat.get("currencyFormat");
        Object localeObj = userFormat.get("locale");
        String locale = Locale.getDefault().toString();
        if (localeObj != null) {
            locale = (String)localeObj;
        }
        if (!numberFormat.isEmpty()) {
            fmt = SerializationUtils.toJsonString((Object)numberFormat);
            result.setNumberFormat((NumberFormatObject)SerializationUtils.fromJsonString((String)fmt, NumberFormatObject.class));
        }
        if (!timeFormat.isEmpty()) {
            fmt = SerializationUtils.toJsonString((Object)timeFormat);
            TimeFormatObject timeFormatObject = (TimeFormatObject)SerializationUtils.fromJsonString((String)fmt, TimeFormatObject.class);
            timeFormatObject.setLocaleStr(locale);
            result.setTimeFormat(timeFormatObject);
        }
        if (!currencyFormat.isEmpty()) {
            fmt = SerializationUtils.toJsonString((Object)currencyFormat);
            result.setCurrencyFormat((CurrencyFormatObject)SerializationUtils.fromJsonString((String)fmt, CurrencyFormatObject.class));
        }
        String dateFormat = userFormat.get("dateFormat").toString();
        DateFormatObject dateFormatObject = new DateFormatObject(dateFormat, "", locale);
        result.setDateFormat(dateFormatObject);
        return result;
    }
}

