/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.format;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.Format;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.format.AbstractFormat;
import kd.bos.entity.format.FormatObject;
import kd.bos.entity.format.NumberFormatObject;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.sdk.annotation.SdkPublic;
import org.apache.commons.lang3.StringUtils;

@SdkPublic
public class NumberFormat
extends AbstractFormat {
    private NumberFormatObject numberFormatObject;

    @Override
    public String formatZeroPos(String value, BigDecimal dValue, NumberFormatObject nfo) {
        float fValue = Math.abs(dValue.floatValue());
        if (fValue > 0.0f && fValue < 1.0f && "0".equals(nfo.getZeroShow())) {
            value = value.replaceAll(String.format("0\\%s", Character.valueOf(nfo.getDecimalPoint())), String.valueOf(nfo.getDecimalPoint()));
        }
        return value;
    }

    @Override
    <T> Format newFormat(T t) {
        NumberFormatObject cfo = (NumberFormatObject)t;
        DecimalFormat df = new DecimalFormat();
        df.setRoundingMode(RoundingMode.HALF_UP);
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        if (cfo.getNumSeparator() != ' ') {
            symbols.setGroupingSeparator(cfo.getNumSeparator() == 'b' ? (char)' ' : (char)cfo.getNumSeparator());
        }
        if (cfo.getDecimalPoint() != ' ') {
            symbols.setDecimalSeparator(cfo.getDecimalPoint());
        }
        int groupSepIndex = 3;
        if (!cfo.isGroupingUsed()) {
            df.setGroupingUsed(false);
        } else if (StringUtils.isNotBlank((CharSequence)cfo.getNumGroupFormat())) {
            groupSepIndex = cfo.getNumGroupFormat().lastIndexOf(44);
            if (groupSepIndex == -1) {
                df.setGroupingUsed(false);
            } else {
                int size = cfo.getNumGroupFormat().length() - groupSepIndex - 1;
                df.setGroupingSize(size);
            }
        } else {
            df.setGroupingSize(groupSepIndex);
        }
        df.setMinimumFractionDigits(cfo.getMinimumFractionDigits());
        if (cfo.getMaximumFractionDigits() > -1) {
            df.setMaximumFractionDigits(cfo.getMaximumFractionDigits());
        } else {
            df.setMaximumFractionDigits(cfo.getMinimumFractionDigits());
        }
        df.setDecimalFormatSymbols(symbols);
        this.setNegative(df, cfo.getNegativeFormat());
        return df;
    }

    @Override
    <T extends Cloneable> void cloneFormatObject(T t) {
        NumberFormatObject cfo = (NumberFormatObject)t;
        try {
            this.numberFormatObject = (NumberFormatObject)cfo.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new KDBizException((Throwable)e, new ErrorCode("CloneFailedException", e.getMessage()), new Object[0]);
        }
    }

    @Override
    <T extends Cloneable> boolean equalsFormatObject(T t) {
        return t.equals(this.numberFormatObject);
    }

    @Override
    public Format getFormat(FormatObject formatObject) {
        if (formatObject == null) {
            return null;
        }
        NumberFormatObject cfo = formatObject.getNumberFormat();
        if (cfo == null) {
            return null;
        }
        return super.getFormat(cfo);
    }

    protected void setNegative(DecimalFormat df, String negative) {
        if (StringUtils.isBlank((CharSequence)negative)) {
            return;
        }
        String[] symbols = negative.split(",");
        if (symbols.length > 0) {
            df.setNegativePrefix(symbols[0]);
            df.setNegativeSuffix(symbols.length == 1 ? "" : symbols[1]);
        }
    }

    @Override
    public Format getNumberFormat(String pattern, int minimumFractionDigits, int groupSize) {
        DecimalFormat format = null;
        String runPattern = StringUtils.isBlank((CharSequence)pattern) ? "0" : pattern;
        try {
            format = new DecimalFormat(runPattern);
        }
        catch (IllegalArgumentException e) {
            throw new KDBizException(this.buildIllegalPatternMsg(runPattern));
        }
        format.setRoundingMode(RoundingMode.HALF_UP);
        if (StringUtils.isBlank((CharSequence)pattern)) {
            format.setMinimumFractionDigits(minimumFractionDigits);
        }
        return format;
    }

    @Override
    public Format getNumberFormat(String pattern, int maximumFractionDigits, int minimumFractionDigits, int groupSize) {
        DecimalFormat format = null;
        String runPattern = StringUtils.isBlank((CharSequence)pattern) ? "0" : pattern;
        try {
            format = new DecimalFormat(runPattern);
        }
        catch (IllegalArgumentException e) {
            throw new KDBizException(this.buildIllegalPatternMsg(runPattern));
        }
        format.setRoundingMode(RoundingMode.HALF_UP);
        format.setMaximumFractionDigits(maximumFractionDigits);
        format.setMinimumFractionDigits(minimumFractionDigits);
        return format;
    }

    protected String buildIllegalPatternMsg(String pattern) {
        return String.format(ResManager.loadKDString((String)"\u683c\u5f0f\u5316\u5f02\u5e38\uff0c\u4e0d\u5408\u89c4\u7684\u683c\u5f0f\u5316\u5b57\u7b26\u4e32\uff1a%s", (String)"NumberFormat_0", (String)"bos-entity-metadata", (Object[])new Object[0]), pattern);
    }
}

