/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.format;

import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.format.AbstractFormat;
import kd.bos.entity.format.DateFormatObject;
import kd.bos.entity.format.FormatObject;
import kd.bos.entity.format.TimeFormatObject;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class TimeFormat
extends AbstractFormat {
    private TimeFormatObject timeFormatObject;
    private DateFormatObject dateFormat;

    public TimeFormat() {
        this.setLocalInstance(DateFormat.getTimeInstance());
    }

    @Override
    <T> Format newFormat(T t) {
        TimeFormatObject tfo = (TimeFormatObject)t;
        String fmtString = tfo.getTimeFormat();
        if (this.dateFormat != null) {
            fmtString = this.dateFormat.getDateFormat() + " " + fmtString;
        }
        SimpleDateFormat sdf = null;
        Locale locale = tfo.getLocale();
        sdf = locale != null ? (SimpleDateFormat)SimpleDateFormat.getTimeInstance(2, locale) : (SimpleDateFormat)SimpleDateFormat.getTimeInstance();
        if (locale != null && !sdf.getCalendar().getClass().isAssignableFrom(GregorianCalendar.class)) {
            GregorianCalendar calendar = (GregorianCalendar)new Calendar.Builder().setLocale(locale).setTimeZone(TimeZone.getDefault()).setCalendarType("gregory").setInstant(System.currentTimeMillis()).build();
            sdf.setCalendar(calendar);
        }
        try {
            sdf.applyPattern(fmtString);
        }
        catch (IllegalArgumentException e) {
            throw new KDException((Throwable)e, BosErrorCode.parse, new Object[]{String.format("Error:%s", e.getMessage())});
        }
        if (StringUtils.isNotEmpty((CharSequence)tfo.getTimeArea())) {
            sdf.setTimeZone(TimeZone.getTimeZone(tfo.getTimeArea()));
        }
        DateFormatSymbols symbols = sdf.getDateFormatSymbols();
        String[] ampms = new String[]{tfo.getAm(), tfo.getPm()};
        symbols.setAmPmStrings(ampms);
        sdf.setDateFormatSymbols(symbols);
        return sdf;
    }

    @Override
    <T extends Cloneable> void cloneFormatObject(T t) {
        TimeFormatObject tfo = (TimeFormatObject)t;
        try {
            this.timeFormatObject = (TimeFormatObject)tfo.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new KDBizException((Throwable)e, new ErrorCode("CloneFailedException", e.getMessage()), new Object[0]);
        }
    }

    @Override
    <T extends Cloneable> boolean equalsFormatObject(T t) {
        return t.equals(this.timeFormatObject);
    }

    @Override
    public Format getFormat(FormatObject formatObject) {
        if (formatObject == null) {
            return null;
        }
        TimeFormatObject tfo = formatObject.getTimeFormat();
        if (tfo == null) {
            return null;
        }
        this.dateFormat = formatObject.getDateFormat();
        return super.getFormat(tfo);
    }

    @Override
    public Format getDateTimeFormat(String pattern) {
        SimpleDateFormat fmt = null;
        if (this.isFastMode()) {
            fmt = (SimpleDateFormat)this.getLocalInstance();
            if (!StringUtils.equals((CharSequence)fmt.toPattern(), (CharSequence)pattern)) {
                fmt.applyPattern(pattern);
            }
        } else {
            fmt = new SimpleDateFormat(pattern);
        }
        return fmt;
    }
}

