/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.formula;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.formula.BOSExpression;
import kd.bos.entity.formula.BOSExpressionContext;
import kd.bos.entity.formula.ExpressionContext;
import kd.bos.entity.formula.ExpressionParameter;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.entity.formula.VarValueParser;
import kd.bos.entity.function.ExprFuncCreator;
import kd.bos.entity.function.FunctionManage;
import kd.bos.entity.function.UDFunctionVisitor;
import kd.bos.formula.FormulaEngine;
import kd.bos.formula.excel.Expr;
import kd.bos.formula.excel.UDFunction;
import kd.bos.formula.excel.Visitor;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class CalcExprParser {
    private static final String SPAN_TYPE_FORMULA = "formula";
    private static final String SPAN_NAME_GETEXPRESSIONVALUE = "CalcExprParser.getExpressionValue";
    private static final String SPAN_PARAM_EXPRESSION = "expression";
    private static final String SPAN_PARAM_CTX = "ctx";
    private static final String SPAN_PARAM_RESULT = "result";

    public static Object getExpressionValue(ExpressionParameter calcParameter) {
        if (StringUtils.isBlank((CharSequence)calcParameter.getExpression())) {
            return Boolean.TRUE;
        }
        RowDataModel rowModel = calcParameter.getRowModel();
        rowModel.setRowContext(calcParameter.getActiveRow(), calcParameter.getRowIndex());
        BOSExpressionContext expContext = new BOSExpressionContext(rowModel);
        FunctionManage funcLib = calcParameter.getFcunLib() == null ? FunctionManage.get() : calcParameter.getFcunLib();
        return CalcExprParser.getExpressionValue(calcParameter.getBOSExpression(), (ExpressionContext)expContext, funcLib);
    }

    public static Object getExpressionValue(String expression, ExpressionContext expContext, FunctionManage funcLib) {
        if (StringUtils.isBlank((CharSequence)expression)) {
            return null;
        }
        Expr expr = FormulaEngine.parseFormula((String)expression);
        Object[] vars = FormulaEngine.extractVariables((String)expression);
        Arrays.sort(vars);
        HashMap<Object, Object> ctx = new HashMap<Object, Object>(vars.length);
        for (int i = 0; i < vars.length; ++i) {
            Object var = vars[i];
            ctx.put(var, VarValueParser.getVarValue((String)var, expContext));
        }
        UDFunctionVisitor funVisitor = new UDFunctionVisitor();
        expr.accept((Visitor)funVisitor);
        HashSet<String> funcs = new HashSet<String>();
        funcs.addAll(funVisitor.getFuncNames());
        UDFunction[] functions = ExprFuncCreator.createUDFunctions(funcs, funcLib, expContext);
        try {
            Object result = FormulaEngine.execExcelFormula((Expr)expr, ctx, (UDFunction[])functions);
            if (EntityTracer.isRealtime()) {
                try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_FORMULA, (String)SPAN_NAME_GETEXPRESSIONVALUE);){
                    span.addTag(SPAN_PARAM_EXPRESSION, expression);
                    span.addLocaleTag(SPAN_PARAM_CTX, ctx);
                    span.addLocaleTag(SPAN_PARAM_RESULT, result);
                }
            }
            return result;
        }
        catch (RuntimeException e) {
            try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_FORMULA, (String)SPAN_NAME_GETEXPRESSIONVALUE);){
                span.addLocaleTag(SPAN_PARAM_EXPRESSION, (Object)expression);
                span.addLocaleTag(SPAN_PARAM_CTX, ctx);
                span.throwException((Throwable)e);
            }
            throw e;
        }
    }

    public static Object getExpressionValue(BOSExpression expression, ExpressionContext expContext, FunctionManage funcLib) {
        if (expression == null || expression.getExpr() == null) {
            return null;
        }
        Map<String, Object> ctx = VarValueParser.getVarValues(expression, expContext);
        UDFunction[] functions = ExprFuncCreator.createUDFunctions(expression.getFuncs(), funcLib, expContext);
        try {
            Object result = FormulaEngine.execExcelFormula((Expr)expression.getExpr(), ctx, (UDFunction[])functions);
            if (EntityTracer.isRealtime()) {
                try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_FORMULA, (String)SPAN_NAME_GETEXPRESSIONVALUE);){
                    span.addTag(SPAN_PARAM_EXPRESSION, expression.getExpression());
                    span.addLocaleTag(SPAN_PARAM_CTX, ctx);
                    span.addLocaleTag(SPAN_PARAM_RESULT, result);
                }
            }
            return result;
        }
        catch (RuntimeException e) {
            try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_FORMULA, (String)SPAN_NAME_GETEXPRESSIONVALUE);){
                span.addLocaleTag(SPAN_PARAM_EXPRESSION, (Object)expression);
                span.addLocaleTag(SPAN_PARAM_CTX, ctx);
                span.throwException((Throwable)e);
            }
            throw e;
        }
    }

    public static Object getModelValue(RowDataModel row, String var, int rowIndex) {
        if (var.contains(".")) {
            String[] flds = var.split("\\.");
            DynamicObject obj = (DynamicObject)row.get(flds[0], rowIndex);
            if (obj != null) {
                return obj.get(flds[1]);
            }
            return null;
        }
        return row.get(var, rowIndex);
    }

    public static String[] getExprVariables(String expression) {
        return FormulaEngine.extractVariables((String)expression);
    }
}

