/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.formula;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.formula.IRowHandler;
import kd.bos.entity.formula.UnKnownRowHandle;

class ChildRowHandle
extends UnKnownRowHandle {
    private List<DynamicProperty> childEntryProps = new ArrayList<DynamicProperty>();
    private IDataModel model;

    ChildRowHandle() {
    }

    public void setModel(IDataModel model) {
        this.model = model;
    }

    @Override
    public boolean isChildRows() {
        return true;
    }

    @Override
    public int getTargetRowIndex(Object targetRow, int activeRowIndex) {
        return 0;
    }

    public boolean searchChildEntitys(EntityType parent, EntityType child) {
        EntityType parentEntity;
        if (parent == null) {
            return false;
        }
        int topLevel = IRowHandler.getEntityLevel(parent);
        EntityType currentEntity = child;
        do {
            if ((parentEntity = (EntityType)currentEntity.getParent()) == null) {
                return false;
            }
            this.childEntryProps.add(parentEntity.getProperty(currentEntity.getName()));
        } while (IRowHandler.getEntityLevel(currentEntity = parentEntity) > topLevel);
        return currentEntity.getName().equalsIgnoreCase(parent.getName());
    }

    @Override
    public Object getTargetDataEntity(Object activeRow) {
        ArrayList<DynamicObject> allChildRows = new ArrayList<DynamicObject>();
        if (this.model != null) {
            if (this.targetEntity instanceof SubEntryType) {
                if (this.activeEntity instanceof EntryType) {
                    DynamicObjectCollection entryRows = this.model.getEntryEntity(this.targetEntity.getName());
                    allChildRows.addAll((Collection<DynamicObject>)entryRows);
                } else {
                    ExtendedDataEntity[] entryRows;
                    DynamicObject billFullData = this.model.getDataEntity(true);
                    ExtendedDataEntitySet entitySet = new ExtendedDataEntitySet();
                    entitySet.Parse(new DynamicObject[]{billFullData});
                    for (ExtendedDataEntity entryRow : entryRows = entitySet.FindByEntityKey(this.targetEntity.getName())) {
                        allChildRows.add(entryRow.getDataEntity());
                    }
                }
            } else {
                DynamicObjectCollection entryRows = this.model.getEntryEntity(this.targetEntity.getName());
                allChildRows.addAll((Collection<DynamicObject>)entryRows);
            }
        } else {
            List<DynamicObject> parentRows = new ArrayList<DynamicObject>(1);
            parentRows.add((DynamicObject)activeRow);
            for (int i = this.childEntryProps.size() - 1; i >= 0; --i) {
                parentRows = this.getChildRows(parentRows, this.childEntryProps.get(i));
            }
            allChildRows.addAll(parentRows);
        }
        return allChildRows;
    }

    private List<DynamicObject> getChildRows(List<DynamicObject> parentRows, DynamicProperty childEntityProp) {
        ArrayList<DynamicObject> childRows = new ArrayList<DynamicObject>();
        for (DynamicObject parentRow : parentRows) {
            if (this.model != null) {
                this.model.getDataEntity(true);
            }
            DynamicObjectCollection rows = (DynamicObjectCollection)childEntityProp.getValueFast((Object)parentRow);
            childRows.addAll((Collection<DynamicObject>)rows);
        }
        return childRows;
    }
}

