/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.formula;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.formula.IMemberValueHandler;
import kd.bos.entity.formula.IRowHandler;
import kd.bos.entity.formula.MemberValueHandler;
import kd.bos.entity.property.MulBasedataProp;

class MulBaseDataFieldValueHandler
extends MemberValueHandler {
    private List<DynamicProperty> refProps;
    private IMemberValueHandler valueHandler;
    private MulBasedataProp mulDBProp;

    public MulBaseDataFieldValueHandler(IDataModel model, IRowHandler rowHandler, DynamicProperty mulBDProp, List<DynamicProperty> refProps) {
        super(model, rowHandler, mulBDProp);
        this.refProps = refProps;
        this.mulDBProp = (MulBasedataProp)mulBDProp;
        this.buildRefRowHandler();
    }

    private void buildRefRowHandler() {
        if (this.refProps == null || this.refProps.isEmpty()) {
            return;
        }
        ArrayList<String> refPropNames = new ArrayList<String>(this.refProps.size());
        for (DynamicProperty refProp : this.refProps) {
            refPropNames.add(refProp.getName());
        }
        String var = StringUtils.join((Object[])refPropNames.toArray(), (String)".");
        MainEntityType dt = (MainEntityType)this.mulDBProp.getComplexType();
        this.valueHandler = IMemberValueHandler.create(null, dt, dt, var, new HashMap<EntityType, IRowHandler>(0));
    }

    @Override
    public Object getValue(Object activeRow) {
        Object superValue = super.getValue(activeRow);
        if (superValue == null) {
            return null;
        }
        if (this.valueHandler == null) {
            return superValue;
        }
        ArrayList<Object> values = new ArrayList<Object>();
        if (this.rowHandler.isChildRows()) {
            Object[] cols;
            for (Object col : cols = (Object[])superValue) {
                if (col == null) continue;
                DynamicObjectCollection mulBDCollection = (DynamicObjectCollection)col;
                this.getRefValue(mulBDCollection, values);
            }
            return values.toArray();
        }
        DynamicObjectCollection mulBDCollection = (DynamicObjectCollection)superValue;
        this.getRefValue(mulBDCollection, values);
        return values.toArray();
    }

    private void getRefValue(DynamicObjectCollection mulBDCollection, List<Object> values) {
        for (DynamicObject row : mulBDCollection) {
            DynamicObject refBDObj;
            if (row == null || (refBDObj = row.getDynamicObject((IDataEntityProperty)this.mulDBProp.getRefBaseProp())) == null) continue;
            Object value = this.valueHandler.getValue(refBDObj);
            if (value instanceof Object[]) {
                for (Object item : (Object[])value) {
                    values.add(item);
                }
                continue;
            }
            values.add(value);
        }
    }

    @Override
    public void setValue(Object activeRow, int activeRowIndex, Object value) {
        super.setValue(activeRow, activeRowIndex, value);
    }
}

