/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.formula;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.EntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.formula.IRowHandler;
import kd.bos.entity.formula.UnKnownRowHandle;

class ParentRowHandle
extends UnKnownRowHandle {
    private DynamicProperty targetEntryProp;
    private IDataModel model;

    ParentRowHandle() {
    }

    public void setModel(IDataModel model) {
        this.model = model;
    }

    @Override
    public void setTargetEntity(EntityType entityType) {
        super.setTargetEntity(entityType);
        IDataEntityType parentType = entityType.getParent();
        if (parentType != null) {
            this.targetEntryProp = (DynamicProperty)parentType.getProperties().get((Object)entityType.getName());
        }
    }

    public boolean isParent(EntityType parent, EntityType child) {
        EntityType parentEntity;
        if (parent == null) {
            return false;
        }
        EntityType currentEntity = child;
        int topLevel = IRowHandler.getEntityLevel(parent);
        do {
            if ((parentEntity = (EntityType)currentEntity.getParent()) != null) continue;
            return false;
        } while (IRowHandler.getEntityLevel(currentEntity = parentEntity) > topLevel);
        return currentEntity.getName().equalsIgnoreCase(parent.getName());
    }

    @Override
    public int getTargetRowIndex(Object targetRow, int activeRowIndex) {
        if (this.targetEntryProp == null) {
            return 0;
        }
        if (this.model != null) {
            return this.model.getEntryCurrentRowIndex(this.targetEntity.getName());
        }
        DynamicObject parent = (DynamicObject)((DynamicObject)targetRow).getParent();
        DynamicObjectCollection rows = (DynamicObjectCollection)this.targetEntryProp.getValue((Object)parent);
        return rows.indexOf(targetRow);
    }

    @Override
    public Object getTargetDataEntity(Object activeRow) {
        EntityType parentEntity;
        if (this.model != null) {
            if (this.targetEntity.getParent() == null) {
                return this.model.getDataEntity();
            }
            int rowIndex = this.model.getEntryCurrentRowIndex(this.targetEntity.getName());
            return this.model.getEntryRowEntity(this.targetEntity.getName(), rowIndex);
        }
        EntityType currentEntity = this.activeEntity;
        DynamicObject currentObject = (DynamicObject)activeRow;
        int targetEntityLevel = IRowHandler.getEntityLevel(this.targetEntity);
        do {
            if ((parentEntity = (EntityType)currentEntity.getParent()) == null) {
                return null;
            }
            currentObject = (DynamicObject)currentObject.getParent();
        } while (IRowHandler.getEntityLevel(currentEntity = parentEntity) > targetEntityLevel);
        return currentObject;
    }
}

