/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.function;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.trace.EntityTraceHint;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.function.BOSUDFunction;
import kd.bos.entity.function.FunctionType;
import kd.bos.entity.function.FunctionTypes;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class FunctionManage {
    private static final Log log = LogFactory.getLog(FunctionManage.class);
    private static Map<String, BOSUDFunction> cacheFuncExecuters = new HashMap<String, BOSUDFunction>(100);
    private static Set<String> errFuncExecuters = new HashSet<String>(10);
    private static Long errPrintTime;
    private Map<String, BOSUDFunction> funcMap = new HashMap<String, BOSUDFunction>();

    public static FunctionManage get() {
        try (EntityTraceSpan span = null;){
            if (EntityTracer.isRealtime()) {
                span = EntityTracer.create((String)"FunctionManage", (String)"get", (EntityTraceHint)EntityTraceHint.getHintDisLinkAPM());
            }
            FunctionTypes functionTypes = FunctionTypes.get();
            FunctionManage functionManage = FunctionManage.get(functionTypes);
            return functionManage;
        }
    }

    public static FunctionManage get(FunctionTypes functionTypes) {
        FunctionManage funcLib = new FunctionManage();
        for (FunctionType funcType : functionTypes.getFunctionTypes()) {
            if (!StringUtils.isNotBlank((CharSequence)funcType.getRunClass())) continue;
            BOSUDFunction func = null;
            if (cacheFuncExecuters.containsKey(funcType.getRunClass())) {
                func = cacheFuncExecuters.get(funcType.getRunClass());
            } else {
                func = FunctionManage.createFuncInstance(funcType.getRunClass());
                cacheFuncExecuters.put(funcType.getRunClass(), func);
            }
            if (func == null) continue;
            funcLib.addFunc(func.getName(), func);
        }
        return funcLib;
    }

    public Map<String, BOSUDFunction> getFuncMap() {
        return this.funcMap;
    }

    public void addFunc(String funcName, BOSUDFunction func) {
        this.funcMap.put(funcName, func);
    }

    public void addFuncs(Map<String, BOSUDFunction> funcs) {
        this.funcMap.putAll(funcs);
    }

    private static BOSUDFunction createFuncInstance(String funcRunClass) {
        try {
            return (BOSUDFunction)TypesContainer.createInstance((String)funcRunClass);
        }
        catch (Throwable exp) {
            if (errFuncExecuters.add(funcRunClass)) {
                log.error(exp);
            } else if (errPrintTime == null || Long.compare(errPrintTime + 3600000L, System.currentTimeMillis()) <= 0) {
                errPrintTime = System.currentTimeMillis();
                errFuncExecuters.clear();
                errFuncExecuters.add(funcRunClass);
                log.error(exp);
            }
            return null;
        }
    }
}

