/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.gray;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.framework.gray.GrayStrategy;
import kd.bos.instance.AppGroup;
import kd.bos.session.SystemPropertyUtils;
import kd.bos.util.ConfigurationChangeListener;
import kd.bos.util.ConfigurationUtil;

public class AppGroupUtils {
    private static boolean grayOutLogLoaded = false;
    private static boolean enableOutLog = false;
    private static String gray_out_log = "gray.outlog";

    public static String getAppGroupTableName(String appGroup, String tabName) {
        if (StringUtils.isBlank((CharSequence)appGroup) || "defaultGroup".equals(appGroup)) {
            return tabName;
        }
        return String.format("%s_%s", tabName, appGroup);
    }

    public static String getCurrentAppGroupTableName(String tabName) {
        String appGroup = AppGroupUtils.getCurrentAppGroup();
        if (StringUtils.isBlank((CharSequence)appGroup) || "defaultGroup".equals(appGroup)) {
            return tabName;
        }
        return String.format("%s_%s", tabName, appGroup);
    }

    public static String getCurrentAppGroup() {
        return AppGroup.getMetaLookupAppGroup();
    }

    public static boolean isGrayGroup() {
        String appGroup = AppGroupUtils.getCurrentAppGroup();
        return StringUtils.isNotBlank((CharSequence)appGroup) && !"defaultGroup".equals(appGroup);
    }

    public static List<String> getAppGroups(long userId) {
        ArrayList<String> list = new ArrayList<String>();
        Map map = GrayStrategy.getUserAppGroup((String)Long.toString(userId), (String)RequestContext.get().getAccountId());
        for (String group : map.values()) {
            if (list.contains(group)) continue;
            list.add(group);
        }
        return list;
    }

    public static boolean isGrayApp(long userId, String appId) {
        String appGroup = GrayStrategy.getAppGroup((String)appId);
        Map map = GrayStrategy.getUserAppGroup((String)Long.toString(userId), (String)RequestContext.get().getAccountId());
        for (String group : map.values()) {
            if (!group.equals(appGroup)) continue;
            return true;
        }
        return false;
    }

    public static boolean isOutLog() {
        String tenantId;
        if (!AppGroupUtils.isGrayGroup()) {
            return false;
        }
        if (!grayOutLogLoaded && StringUtils.isNotBlank((CharSequence)(tenantId = RequestContext.get().getTenantId()))) {
            enableOutLog = Boolean.parseBoolean(SystemPropertyUtils.getProptyByTenant((String)gray_out_log, (String)tenantId));
            grayOutLogLoaded = true;
        }
        return enableOutLog;
    }

    static {
        ConfigurationUtil.observeChange((String)gray_out_log, (ConfigurationChangeListener)new ConfigurationChangeListener(){

            public void onChange(Object key, Object newValue) {
                String tenantId = RequestContext.get().getTenantId();
                if (StringUtils.isNotBlank((CharSequence)tenantId)) {
                    enableOutLog = Boolean.parseBoolean(SystemPropertyUtils.getProptyByTenant((String)gray_out_log, (String)tenantId));
                }
            }
        });
    }
}

