/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.list.column;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.datamodel.FmtInfoUtils;
import kd.bos.entity.format.CurrencyFormatObject;
import kd.bos.entity.format.FormatFactory;
import kd.bos.entity.format.FormatObject;
import kd.bos.entity.format.FormatTypes;
import kd.bos.entity.format.IFormat;
import kd.bos.entity.list.column.NumberColumnDesc;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.PriceProp;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class AmountColumnDesc
extends NumberColumnDesc {
    private static final Log log = LogFactory.getLog(AmountColumnDesc.class);

    @Override
    protected IFormat getFormat() {
        if (this.format == null) {
            this.format = FormatFactory.get(FormatTypes.Currency);
        }
        return this.format;
    }

    public AmountColumnDesc(String key, AmountProp amountProp, IDataEntityProperty fieldProp) {
        super(key, (IDataEntityProperty)amountProp, fieldProp);
    }

    @Override
    public Object getValue(DynamicObject o) {
        return this.resolveFormat(o);
    }

    @Override
    protected boolean isZero(Object value) {
        if (value instanceof Long) {
            Long val = (Long)value;
            return new BigDecimal(val).compareTo(BigDecimal.ZERO) == 0;
        }
        if (value instanceof Integer) {
            Integer val = (Integer)value;
            return new BigDecimal(val).compareTo(BigDecimal.ZERO) == 0;
        }
        return ((BigDecimal)value).compareTo(BigDecimal.ZERO) == 0;
    }

    @Override
    protected void defaultFormat(Object value, Object[] results) {
        results[0] = value instanceof BigDecimal ? ((BigDecimal)value).toPlainString() : value.toString();
    }

    @Override
    public Object formatCell(DynamicObject dr, Object value, boolean forExport) {
        FormatObject formatObject;
        if (ObjectUtils.isEmpty((Object)value)) {
            return value;
        }
        String precisionField = "amtprecision";
        AmountProp prop = (AmountProp)this.getSrcFieldProp();
        String currencySymbols = "\u00a5";
        String currencyNumber = "CNY";
        int minimumFractionDigits = prop.getScale();
        if (prop instanceof PriceProp) {
            precisionField = "priceprecision";
            minimumFractionDigits = Integer.parseInt(String.valueOf(FmtInfoUtils.getMainCurrencyFmt().get("pp")));
        } else {
            minimumFractionDigits = Integer.parseInt(String.valueOf(FmtInfoUtils.getMainCurrencyFmt().get("ap")));
        }
        if (prop.getControlPropName() != null) {
            DynamicObject currency = null;
            IDataEntityType dt = prop.getParent();
            String objectKey = prop.getControlPropName();
            boolean found = false;
            int cycle = 1;
            while (dt != null && !found && cycle <= 10) {
                found = dt.getProperties().containsKey((Object)prop.getControlPropName());
                if (!found) {
                    dt = dt.getParent();
                    ++cycle;
                    continue;
                }
                if (dt instanceof SubEntryType) {
                    objectKey = dt.getParent().getName() + "." + dt.getName() + "." + prop.getControlPropName();
                    continue;
                }
                if (dt instanceof EntryType) {
                    objectKey = dt.getName() + "." + prop.getControlPropName();
                    continue;
                }
                objectKey = prop.getControlPropName();
            }
            if (found) {
                try {
                    currency = dr.getDynamicObject(objectKey);
                    if (currency != null) {
                        currencySymbols = currency.getString("sign");
                        currencyNumber = currency.getString("number");
                        minimumFractionDigits = currency.getInt(precisionField);
                    } else {
                        currencyNumber = " ";
                        currencySymbols = " ";
                    }
                }
                catch (KDException e) {
                    log.error("get unit precision error : " + e.getMessage());
                }
            }
        }
        boolean isreportColumn = false;
        Object columnType = this.getFormatParams().get("columntype");
        if (columnType != null && "report".equals(columnType.toString())) {
            isreportColumn = true;
        }
        boolean isShowTailzeroWithReport = true;
        Object noDisplayScaleZeroWithReport = this.getFormatParams().get("noDisplayScaleZeroWithReport");
        if (noDisplayScaleZeroWithReport != null) {
            isShowTailzeroWithReport = (Boolean)noDisplayScaleZeroWithReport == false;
        }
        boolean isMobListNoZero = false;
        if (this.isMobNoDisplayScaleZero()) {
            isMobListNoZero = true;
        }
        boolean showTailzero = true;
        if (!(this.getListUserOption() == null || this.getListUserOption().isShowZero() || isreportColumn || isMobListNoZero)) {
            showTailzero = false;
        }
        if (this.getListShowZeroConfig() != null && this.getListShowZeroConfig().isShowZeroSystem() && !isreportColumn && !isMobListNoZero && !this.isShowZeroBySystemParam()) {
            showTailzero = false;
        }
        if (isreportColumn && !isShowTailzeroWithReport) {
            showTailzero = false;
        }
        if (isreportColumn && !(formatObject = this.getUserFormatObject()).getNumberFormat().isShowZero()) {
            showTailzero = false;
        }
        if (isMobListNoZero) {
            showTailzero = false;
        }
        IFormat format = this.getFormat();
        FormatObject fo = this.getUserFormatObject();
        Object retValue = value;
        String fmt = this.getDisplayFormatString();
        if (value instanceof BigDecimal) {
            minimumFractionDigits = this.getFmtDecimalPrecision(fmt, showTailzero, (BigDecimal)value, minimumFractionDigits);
        } else if (!showTailzero) {
            minimumFractionDigits = ((BigDecimal)value).stripTrailingZeros().scale();
        }
        if (StringUtils.isNotBlank((CharSequence)fmt)) {
            return forExport ? this.buildExportValue(currencySymbols, minimumFractionDigits, value, fmt) : format.getCurrencyFormat(fmt, currencySymbols, minimumFractionDigits, minimumFractionDigits).format(value);
        }
        if (prop.isUseRegion() && fo != null) {
            CurrencyFormatObject cfo = fo.getCurrencyFormat();
            cfo.setCurrencySymbols(currencySymbols);
            cfo.setCurrencyNumber(currencyNumber);
            cfo.setMinimumFractionDigits(minimumFractionDigits);
            String result = format.getFormat(fo).format(retValue);
            return forExport ? this.buildExportValue(cfo.getCurrencySymbols(), cfo.getMinimumFractionDigits(), value, null) : format.formatZeroPos(result, (BigDecimal)retValue, cfo);
        }
        return value;
    }

    public Object formatCell(DynamicObject dr, Object value) {
        return this.formatCell(dr, value, false);
    }

    @Override
    protected boolean isShowZeroBySystemParam() {
        if (this.getListShowZeroConfig() != null) {
            if (AmountProp.class == this.getSrcFieldProp().getClass()) {
                return this.getListShowZeroConfig().isAmountFieldIsShowZero();
            }
            if (PriceProp.class == this.getSrcFieldProp().getClass()) {
                return this.getListShowZeroConfig().isPriceFieldIsShowZero();
            }
            return super.isShowZeroBySystemParam();
        }
        return super.isShowZeroBySystemParam();
    }
}

